Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$zones = Get-XAZone
foreach($zone in $zones)
{
	$unknownCount = 0
	$activeCount = 0
	$connectCount = 0
	$connectingCount = 0
	$shadowCount = 0
	$disconnectCount = 0
	$idleCount = 0 
	$listenCount = 0
	$resetCount = 0
	$downCount = 0
	$initCount = 0
	$staleCount = 0
	$servers = Get-XAServer -ZoneName $zone.ZoneName
	
	foreach($server in $servers)
	{
		$unknownCount = 0
		$activeCount = 0
		$connectCount = 0
		$connectingCount = 0
		$shadowCount = 0
		$disconnectCount = 0
		$idleCount = 0 
		$listenCount = 0
		$resetCount = 0
		$downCount = 0
		$initCount = 0
		$staleCount = 0

		$uniqueSessions = @()
		$sessions = Get-XaSession -ServerName $server.ServerName
		foreach($session in $sessions)
		{
			$s = $session.SessionName
			$id = $session.SessionId

			$sessionCheckString = $s + "@" + $id
			if ($uniqueSessions -contains $sessionCheckString)
			{
				continue
			}
			if($s.StartsWith("RDP") -or $s.StartsWith("Console"))
			{
				continue
			}
			$uniqueSessions += $sessionCheckString

			if($session.State -eq "Unknown")
			{
				$SessionState = "Unknown"
				$unknownCount = $unknownCount + 1
			}
			if($session.State -eq "Active" -and $session.SessionName.StartsWith("ICA-TCP#"))
			{
				$SessionState = "Active"
				$activeCount = $activeCount + 1
			}
			if($session.State -eq "Connected")
			{
				$SessionState = "Connected"
				$connectCount = $connectCount + 1
			}
			if($session.State -eq "Connecting")
			{
				$SessionState = "Connecting"
				$connectingCount = $connectingCount + 1
			}
			if($session.State -eq "Shadowing")
			{
				$SessionState = "Shadowing"
				$shadowCount = $shadowCount + 1
			}
			if($session.State -eq "Disconnected")
			{
				$SessionState = "Disconnected"
				$disconnectCount = $disconnectCount + 1
			}
			if($session.State -eq "Idle")
			{
				$SessionState = "Idle"
				$idleCount = $idleCount + 1
			}
			if($session.State -eq "Listening")
			{
				$SessionState = "Listening"
				$listenCount = $listenCount + 1
			}
			if($session.State -eq "Resetting")
			{
				$SessionState = "Resetting"
				$resetCount = $resetCount + 1
			}
			if($session.State -eq "Down")
			{
				$SessionState = "Down"
				$downCount = $downCount + 1
			}
			if($session.State -eq "Initializing")
			{
				$SessionState = "Init"
				$initCount = $initCount + 1
			}
			if($session.State -eq "Stale")
			{
				$SessionState = "Stale"
				$staleCount = $staleCount + 1
			}
		}

		$b = $zone.ZoneName -replace(" ","_")
		$tip = "-"
		$c = 0
		if($server.IPAddresses)
		{
			foreach($ip in $server.IPAddresses)
			{
				if($c -eq 0)
				{
					$tip = $ip
				}
				else
				{
					$tip = $tip + "," + $ip
				}
				$c = $c + 1
			}
		}
				
		$a =  $b + "   " + $server.ServerName +  "   " + $tip +"   " + $unknownCount +":"+$activeCount + ":" + $connectCount + ":" + $connectingCount + ":" + $shadowCount + ":" + $disconnectCount + ":" + $idleCount + ":" + $listenCount + ":" + $resetCount + ":" + $downCount + ":" + $initCount +":" + $staleCount
		Write-Host $a
    	}
}
Remove-PSSnapin Citrix.XenApp.Commands