$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}
$snapin = "Citrix.Common.GroupPolicy"
Add-PSSnapin $snapin -ea Stop
$types = @("Computer", "User")
$DriveName = "LocalFarmGpo"
$PolicyName = "*"
$FilterName = "*"
$FilterType = "*"

Function FilterString
{
	param([string] $value, [string[]] $wildcards)
	$wildcards | Where { $value -like $_ }
}

foreach($polType in $types)
{
	write-host("Type",$polType) -Separator "="
	write-host "--------------"
	$pols = @(Get-ChildItem "$($DriveName):\$polType" | Where-Object { FilterString $_.Name $PolicyName })
	foreach ($pol in $pols)
	{
		$Policy = $pol.Name
		foreach ($setting in @(Get-ChildItem "$($DriveName):\$poltype\$($pol.Name)\Settings" -Recurse |
		Where-Object { $_.State -ne $null }))
		{
			if($setting.State -ne "NotConfigured")
			{
				$path = $setting.PSPath.Substring($setting.PSPath.IndexOf("\Settings\")+10)
				$enabled = "enabled"
				if ($setting.Values -ne $null)
				{
					$value = ([array]($setting.Values))
				}
				if ($setting.Value -ne $null) 
				{
					$value = ([string]($setting.Value))
				}
				write-host($polType,$Policy,$path,$enabled,$value) -separator ";"
			}
		}
	}

	write-host "Filters"
	write-host "--------"
	$pols = @(Get-ChildItem "$($DriveName):\$poltype" | Where-Object { ($_.Name -ne "Unfiltered") -and (FilterString $_.Name $PolicyName) })
	foreach ($pol in $pols)
	{
		foreach ($filter in @(Get-ChildItem "$($DriveName):\$poltype\$($pol.Name)\Filters" -Recurse |
		Where-Object { ($_.FilterType -ne $null) -and (FilterString $_.Name $FilterName) -and (FilterString $_.FilterType $FilterType)}))
		{
			if($filter.FilterType -eq "AccessControl")
			{
				write-host($poltype,$pol.Name,$filter.Name, $filter.FilterType,$filter.Enabled,[string]($filter.Mode),$filter.FilterValue,$filter.ConnectionType,$filter.AccessGatewayFarm,$filter.AccessCondition) -Separator ";"
			}
			else
			{
				write-host($poltype,$pol.Name,$filter.Name, $filter.FilterType,$filter.Enabled,[string]($filter.Mode),$filter.FilterValue) -Separator ";"
			}
		}
	}
}
Write-Host "#EG_SCRIPT_DONE#"
