$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference="SilentlyContinue"
$ShortDatePattern = (Get-Culture).datetimeformat.ShortDatePattern
$LongTimePattern = (Get-Culture).datetimeformat.LongTimePattern
Write-Host "DateTime:$ShortDatePattern $LongTimePattern"

$CAName = (Get-ItemProperty -path 'HKLM:\SYSTEM\CurrentControlSet\Services\CertSvc\Configuration').Active
#Get-ADObject -SearchBase (Get-ADRootDSE).ConfigurationNamingContext -filter {objectclass -eq "pKICertificateTemplate"} -Properties "CN", "DisplayName", "msPKI-Cert-Template-OID" | %{ $templates.add($_."msPKI-Cert-Template-OID",$_."DisplayName") }
$Server = $env:computername + $("\$CAName")
$CaView = New-Object -Com CertificateAuthority.View.1
$CaView.OpenConnection($Server)
$NumberOfColumns=5
$CaView.SetResultColumnCount($NumberOfColumns)

$index0 = $CaView.GetColumnIndex($false, "Issued Common Name")
$index1 = $CaView.GetColumnIndex($false, "Certificate Expiration Date")
$index2 = $CaView.GetColumnIndex($false, "Certificate Template")
$index3 = $CaView.GetColumnIndex($false, "Request Disposition")
$index4 = $CaView.GetColumnIndex($false, "Requester Name")

$index0, $index1, $index2, $index3, $index4 | %{$CAView.SetResultColumn($_) }

$Rowobj= $CaView.OpenView()
while ($Rowobj.Next() -ne -1)
{
	$Cert = New-Object PsObject
	$ColObj = $RowObj.EnumCertViewColumn()
	[void]$ColObj.Next()
	do
	{
		if($ColObj.GetName() -eq "CommonName"){$commonName = $colObj.GetValue(1)}
		if($ColObj.GetName() -eq "NotAfter"){$certExpiry = $colObj.GetValue(1)}
		if($ColObj.GetName() -eq "CertificateTemplate"){$certTemplate = $colObj.GetValue(1)}
		if($ColObj.GetName() -eq "Request.Disposition"){$disposition = $colObj.GetValue(1)}
		if($ColObj.GetName() -eq "Request.RequesterName"){$requesterName = $colObj.GetValue(1)}
	}
	until ($ColObj.Next() -eq -1)
    
	Clear-Variable ColObj
	if ($disposition -eq 20)
	{
		Write-Host $commonName,$certExpiry,$certTemplate,$disposition,$requesterName -Separator "#~#"
	}
}

$RowObj.Reset()
$CaView = $null
[GC]::Collect() 



