$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}
Write-Host "Client Access Server - OWA Mailbox Policy"
Write-Host "------------------------------------------"

$OWAPolicies = Get-OWAMailboxPolicy 
foreach ($OWAPolicy in $OWAPolicies)
{
	Write-Host "Name: " $OWAPolicy.name
	Write-Host "OwaLightEnabled: " $OWAPolicy.OwaLightEnabled
	Write-Host "OwaPremiumEnabled: " $OWAPolicy.OwaPremiumEnabled
	Write-Host "CalendarEnabled: " $OWAPolicy.CalendarEnabled
	Write-Host "ContactsEnabled: " $OWAPolicy.ContactsEnabled
	Write-Host "TaskEnabled: " $OWAPolicy.TaskEnabled
	Write-Host "ExplicitLogonEnabled: " $OWAPolicy.ExplicitLogonEnabled
	Write-Host "GlobalAddressListEnabled: " $OWAPolicy.GlobalAddressListEnabled
	Write-Host "InstantMessagingEnabled: " $OWAPolicy.InstantMessagingEnabled
	Write-Host "RecoverDeletedItemsEnabled: " $OWAPolicy.RecoverDeletedItemsEnabled
	Write-Host "RemindersAndNotificationsEnabled: " $OWAPolicy.RemindersAndNotificationsEnabled
	Write-Host "SearchFoldersEnabled:  " $OWAPolicy.SearchFoldersEnabled
	Write-Host "SignaturesEnabled: " $OWAPolicy.SignaturesEnabled
	Write-Host "SpellCheckerEnabled: " $OWAPolicy.SpellCheckerEnabled
	Write-Host "AllowedFileTypes: " $OWAPolicy.AllowedFileTypes
	Write-Host "BlockedFileTypes: " $OWAPolicy.BlockedFileTypes
	Write-Host "DirectFileAccessOnPrivateComputersEnabled: " $OWAPolicy.DirectFileAccessOnPrivateComputersEnabled
	Write-host "ForceSaveFileTypes: " $OWAPolicy.ForceSaveFileTypes
	Write-Host "AllowedMimeTypes: " $OWAPolicy.AllowedMimeTypes
	Write-Host "BlockedMimeTypes: " $OWAPolicy.BlockedMimeTypes
	Write-Host "WebReadyFileTypes: " $OWAPolicy.WebReadyFileTypes
	Write-Host "WebReadyDocumentViewingOnPrivateComputersEnabled: " $OWAPolicy.WebReadyDocumentViewingOnPrivateComputersEnabled
	Write-Host "WebReadyMimeTypes: " $OWAPolicy.WebReadyMimeTypes
	
}

Write-Host "Client Access Server - ActiveSync Mailbox Policy"
Write-Host "----------------------------------------------------"

$ASPolicies = Get-ActiveSyncMailboxPolicy 

foreach ($ASPolicy in $ASPolicies)
{
	Write-Host "Name: " $ASPolicy.name
	Write-Host "AllowNonProvisionableDevices: " $ASPolicy.AllowNonProvisionableDevices
	Write-Host "AlphanumericDevicePasswordRequired: " $ASPolicy.AlphanumericDevicePasswordRequired
	Write-Host "AttachmentsEnabled: " $ASPolicy.AttachmentsEnabled
	Write-Host "DevicePasswordEnabled: " $ASPolicy.DevicePasswordEnabled
	Write-Host "PasswordRecoveryEnabled : " $ASPolicy.PasswordRecoveryEnabled 
	Write-Host "DevicePolicyRefreshInterval: " $ASPolicy.DevicePolicyRefreshInterval
	Write-Host "MaxInactivityTimeDeviceLock: " $ASPolicy.MaxInactivityTimeDeviceLock
	Write-Host "MaxAttachmentSize: " $ASPolicy.MaxAttachmentSize
	Write-Host "AllowStorageCard: " $ASPolicy.AllowStorageCard
	Write-Host "AllowCamera: " $ASPolicy.AllowCamera
	Write-Host "AllowUnsignedApplications:  " $ASPolicy.AllowUnsignedApplications
	Write-Host "AllowUnsignedInstallationPackages: " $ASPolicy.AllowUnsignedInstallationPackages
	Write-Host "AllowWiFi: " $ASPolicy.AllowWiFi
	Write-Host "AllowTextMessaging: " $ASPolicy.AllowTextMessaging
	Write-Host "AllowPOPIMAPEmail: " $ASPolicy.AllowPOPIMAPEmail
	Write-Host "RequireManualSyncWhenRoaming: " $ASPolicy.RequireManualSyncWhenRoaming
	Write-Host "AllowBrowser: " $ASPolicy.AllowBrowser
	Write-host "AllowDesktopSync: " $ASPolicy.AllowDesktopSync
	Write-Host "AllowInternetSharing: " $ASPolicy.AllowInternetSharing
	Write-Host "AllowBluetooth: " $ASPolicy.AllowBluetooth
	Write-Host "AllowHTMLEmail: " $ASPolicy.AllowHTMLEmail
	Write-Host "AllowRemoteDesktop: " $ASPolicy.AllowRemoteDesktop
	Write-Host "MinDevicePasswordComplexCharacters: " $ASPolicy.MinDevicePasswordComplexCharacters
	Write-Host "MaxEmailBodyTruncationSize: " $ASPolicy.MaxEmailBodyTruncationSize
	Write-Host "MaxEmailHTMLBodyTruncationSize: " $ASPolicy.MaxEmailHTMLBodyTruncationSize
	Write-Host "ApprovedApplicationList: " $ASPolicy.ApprovedApplicationList
	Write-Host "AllowExternalDeviceManagement: " $ASPolicy.AllowExternalDeviceManagement
	Write-host "MobileOTAUpdateMode: "  $ASPolicy.MobileOTAUpdateMode
	Write-Host "AllowMobileOTAUpdate: " $ASPolicy.AllowMobileOTAUpdate
	
	
}



Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010