$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#Get DB info
[STRING]$SQLInstance = get-wmiobject MSBTS_GroupSetting -namespace root\MicrosoftBizTalkServer | select-object -expand MgmtDbServerName
[STRING]$BizTalkManagementDb = get-wmiobject MSBTS_GroupSetting -namespace root\MicrosoftBizTalkServer | select-object -expand MgmtDbName
[STRING]$BizTalkGroup = "$SQLInstance" + ":" + "$BizTalkManagementDb"

#Get Counters: Check if there are any disable receive locations and stopped/unelisted send ports

[ARRAY]$SendPorts = get-wmiobject MSBTS_SendPort -namespace 'root\MicrosoftBizTalkServer'
$TotalSendPorts = $SendPorts.Count


[ARRAY]$ReceivedLocations = get-wmiobject MSBTS_ReceiveLocation -namespace 'root\MicrosoftBizTalkServer'
$TotalRecvLocations = $ReceivedLocations.Count

$title = "Send Ports"
if($TotalSendPorts -gt 0)
{
	
	Foreach ($SendPort in $SendPorts)
	{
		if ($SendPort.status -eq 2)
		{
			$SendPortStatus = "Stopped"
		}
		elseif ($SendPort.status -eq 1)
		{
			$SendPortStatus = "Unelisted"
		}
		elseif ($SendPort.status -eq 3)
		{
			$sendPortStatus = "Active"
		}
		write-host $title,$SendPort.Name,$SendPortStatus,$SendPort.PTAddress,$SendPort.PTTransportType -Separator "#~#"
	}
}

$title = "Receive Ports"
if($TotalRecvLocations -gt 0)
{
	Foreach ($ReceiveLocation in $ReceivedLocations)
	{
		write-host $title,$ReceiveLocation.AdapterName,$ReceiveLocation.name,$ReceiveLocation.IsDisabled,$ReceiveLocation.InboundTransportURL -Separator "#~#"
	}
}


