﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

if($args.count -ne 5)
{
    Write-host "Syntax: ADFSSynthentic.ps1 <ADFSServerURL> <RelayPartyApp> <UserName> <Password> <eGurkha_Install_Dir>"
    exit
}
[System.Net.ServicePointManager]::SecurityProtocol = [System.Net.SecurityProtocolType]::Tls12;
$ErrorActionPreference = "SilentlyContinue"
$ADFSBaseUri = $args[0] # "https://2K12R2-ADFS.EGIN.LOCAL"
$RelayPartyTrustIdentifier = $args[1] # "https://xendesk713.eginnovations.com"
$Username = $args[2] # "egin\xdadmin"
$Password = $args[3] # "abc123ABC"
$eGInstallDir = $args[4]
$OEPath = $eGInstallDir + "\lib\OE.exe"
$Password = & $OEPath $Password

$IgnoreCertificateErrors = $true
$ADFSTrustPath = 'adfs/services/trust/13'
$SecurityMode = 'TransportWithMessageCredential'
$MessageCredential = 'UserName'
$ADFSTrustEndpoint = 'usernamemixed'
$SAMLVersion = "2"

$Credential = New-Object System.Net.NetworkCredential -ArgumentList $Username,$Password,$Domain
Add-Type -AssemblyName 'System.ServiceModel, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089'
Add-Type -AssemblyName 'System.IdentityModel, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089'

$Binding = New-Object -TypeName System.ServiceModel.WS2007HttpBinding -ArgumentList ([System.ServiceModel.SecurityMode] $SecurityMode)
$Binding.Security.Message.EstablishSecurityContext = $false
$Binding.Security.Message.ClientCredentialType = $MessageCredential
$Binding.Security.Transport.ClientCredentialType = 'None'

$EP = New-Object -TypeName System.ServiceModel.EndpointAddress -ArgumentList ('{0}/{1}/{2}' -f $ADFSBaseUri,$ADFSTrustPath,$ADFSTrustEndpoint)

$WSTrustChannelFactory = New-Object -TypeName System.ServiceModel.Security.WSTrustChannelFactory -ArgumentList $Binding, $EP
$WSTrustChannelFactory.TrustVersion = [System.ServiceModel.Security.TrustVersion]::WSTrust13
$WSTrustChannelFactory.Credentials.Windows.ClientCredential = $Credential
$WSTrustChannelFactory.Credentials.UserName.UserName = $Credential.UserName
$WSTrustChannelFactory.Credentials.UserName.Password = $Credential.Password
$Channel = $WSTrustChannelFactory.CreateChannel()

$TokenType = @{
    SAML11 = 'urn:oasis:names:tc:SAML:1.0:assertion'
    SAML2 = 'urn:oasis:names:tc:SAML:2.0:assertion'
}

$RST = New-Object -TypeName System.IdentityModel.Protocols.WSTrust.RequestSecurityToken -Property @{
    RequestType   = [System.IdentityModel.Protocols.WSTrust.RequestTypes]::Issue
    AppliesTo     = $RelayPartyTrustIdentifier
    KeyType       = [System.IdentityModel.Protocols.WSTrust.KeyTypes]::Bearer
    TokenType     = if ($SAMLVersion -eq '2') {$TokenType.SAML2} else {$TokenType.SAML11}
}

$RSTR = New-Object -TypeName System.IdentityModel.Protocols.WSTrust.RequestSecurityTokenResponse


try {
    $OriginalCallback = [System.Net.ServicePointManager]::ServerCertificateValidationCallback
    if ($IgnoreCertificateErrors) {[System.Net.ServicePointManager]::ServerCertificateValidationCallback = {return $true}}
    $Token = $Channel.Issue($RST, [ref] $RSTR)
}
catch {
              Write-host $_.Exception
}
finally {
    [System.Net.ServicePointManager]::ServerCertificateValidationCallback = $OriginalCallback
              if($Channel)
              {
                             $Channel.Close()
              }
              
              if($WSTrustChannelFactory)
              {
                             $WSTrustChannelFactory.Close()
              }
              
}

$Token.TokenXml.OuterXml


