$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference="SilentlyContinue"
$AdfsCertificates = Get-AdfsCertificate -CertificateType "Token-signing"
if ($AdfsCertificates -ne $null)
{
	foreach ($cert in $AdfsCertificates)
	{
		if($cert.Certificate.NotAfter -ne $null -and $cert.Certificate.NotAfter -gt (Get-Date))
		{
			$Subject = $cert.Certificate.Subject
			$Issuer = $cert.Certificate.Issuer
			$Thumbprint = $cert.Certificate.Thumbprint
			$NotAfter = $cert.Certificate.NotAfter
			$Version = $cert.Certificate.Version
			$FriendlyName = $cert.Certificate.FriendlyName
			$RemainingExpiryDays = ($NotAfter).subtract([DateTime]::Now).days

			Write-Host($Subject,$Issuer,$Thumbprint,$NotAfter,$RemainingExpiryDays,$Version,$FriendlyName) -Separator "#~#"
		}
	}
}


