#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get the List of Trust information of Active Directory
.DESCRIPTION

			This Script is used collect the List of Trust information of Active Directory
			Measure are:
			1.Trust description,
			2.Trust creation time,
			3.Trust modified time,
			4.Trust type,
			5.Trust direction,
			6.Trust attributes

			
.INPUTS
			CONST_TEST_HDR and delimiter
.OUTPUTS
			Collect the Trust Measures of Active Directory in following format
            <TrustName><Delimiter><TrustDescription><Delimiter><TrustCreated><Delimiter>
            <TrustModified><Delimiter><TrustType><Delimiter><TrustDirection><Delimiter><TrustAttributes>
#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]
$global:delimiter = $args[2]


import-module ActiveDirectory

Clear-Host

#To get the List of Trust information of Active Directory

Function getADConfigTrustInfo
{

	[array] $ADDomainTrusts = Get-ADObject -Filter {ObjectClass -eq "trustedDomain"} -Properties *
	if($ADDomainTrusts)
	{
		$ADDomainTrustsCount = $ADDomainTrusts.Count
		ForEach ($Trust in $ADDomainTrusts)
		{
			$TrustName = $Trust.Name
			$TrustDescription = $Trust.Description
			$TrustCreated = $Trust.Created
			$TrustModified = $Trust.Modified
			$TrustDirectionNumber = $Trust.TrustDirection
			$TrustTypeNumber = $Trust.TrustType
			$TrustAttributesNumber = $Trust.TrustAttributes
				
			Switch ($TrustTypeNumber)
			{
				1 { $TrustType = "Downlevel (Windows NT domain external)" }
				2 { $TrustType = "Uplevel (Active Directory domain parent-child, root domain, shortcut, external, or forest)" }
				3 { $TrustType = "MIT (non-Windows) Kerberos version 5 realm" }
				4 { $TrustType = "DCE (DCE refers to Open Group Distributed Computing Environment specification. This trust type is mainly theoretical.)" }
			}
				
			IF (!$TrustType) 
			{ 
				$TrustType = $TrustTypeNumber 
			}
				
			Switch ($TrustAttributesNumber)
			{
				0X1 { $TrustAttributes = "Nontransitive" }
				0X2 { $TrustAttributes = "Uplevel clients only" }
				0X40000 { $TrustAttributes = "Tree parent" }
				0X80000 { $TrustAttributes = "Tree root" }
				64 { $TrustAttributes = "External" }
				68 { $TrustAttributes = "Quarantined Domain (External)" }
			}
				
			IF (!$TrustAttributes)
			{
				$TrustAttributes = $TrustAttributesNumber
			}
				
			Switch($TrustDirectionNumber)
			{
				1 { $TrustDirection = "Inbound (trusting domain)" }
				2 { $TrustDirection = "Outbound (trusted domain)" }
				3 { $TrustDirection = "Bidirectional" }
			}
				
			IF (!$TrustDirection)
			{
				$TrustDirection = $TrustDirectionNumber
			}
			Write-Host($TrustName,$TrustDescription,$TrustCreated,$TrustModified,$TrustType,$TrustDirection,$TrustAttributes) -Separator $global:delimiter
		}
	}
}

#Main Region Starts
try
{

   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------------------------"
     
    getADConfigTrustInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends

