$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Import-Module ADSync
$connectors = Get-ADSyncConnector
$ConnectorStatus = Get-ADSyncConnectorRunStatus
$connnectorName = $connectorstatus.ConnectorName
$ConnnectorRunstate = $ConnectorStatus.Runstate

Write-Host "Connector details"
Write-Host "-----------------"

if($connectors -ne $null)
{
	foreach($connector in $connectors)
	{
		$type = ""
		$status = "idle" # Status are Busy, Idle
		if($connnectorName -eq $connector.Name)
		{
			$status = $ConnnectorRunstate
		}
		$partition = $connector.Partitions[0].DN
		if($connector.ConnectorTypeName -eq "Extensible2")
		{
			$type = "Windows Azure Active Directory (Microsoft)"
		}
		elseif($connector.ConnectorTypeName -eq "AD")
		{
			$type = "Active Directory Domain Services"
		}
		Write-Host ($connector.Name, $connector.Identifier, $type, $connector.CreationTime,
			    $connector.LastModificationTime, $partition, $status) -Separator "#~#"
	}

	Write-Host "Synchornization Engine details"
	Write-Host "------------------------------"

	#https://docs.microsoft.com/en-us/previous-versions/windows/desktop/forefront-2010/ms696531(v=vs.100)

	foreach($connector in $connectors)
	{
		$presult = get-adsyncrunprofileresult | Where-Object{$_.ConnectorName -eq $connector.Name -and $_.RunProfileName -eq "Full Synchronization"} | select-object -First 1
		if($presult -ne $null)
		{
			$result = $presult.Result
			$sdate = $presult.Startdate
			$edate = $presult.Enddate
			$username = $presult.username
			$stepresult = Get-ADSyncRunStepResult -RunHistoryId $presult.RunHistoryId 
			$projections = -5
			$FilteredDisconnectors = -5
			$Disconnectors = -5
			$Joins = -5
			$ConnectorswithAttribute = -5
			$ConnectorswithoutAttribute = -5
			$DeletedConnectors = -5
			$FilteredConnectors = -5
			$MetaverseObjectDeletes = -5
			$outboundname = "-"
			$outboundvalue = "-"

			if($stepresult -ne $null)
			{
				$DisconnectorJoinedNoFlow = [int] $stepresult.DisconnectorJoinedNoFlow
				$DisconnectorJoinedFlow = [int] $stepresult.DisconnectorJoinedFlow
				$DisconnectorJoinedRemoveMv = [int] $stepresult.DisconnectorJoinedRemoveMv
				$FilteredDisconnectors = [int] $stepresult.DisconnectorFiltered
				$Disconnectors = [int] $stepresult.DisconnectorRemains
				$ConnectorFlowRemoveMv = [int] $stepresult.ConnectorFlowRemoveMv
				$ConnectorDeleteLeaveMv = [int] $stepresult.ConnectorDeleteLeaveMv
				$ConnectorFilteredRemoveMv = [int] $stepresult.ConnectorFilteredRemoveMv

				$projections = $DisconnectorJoinedNoFlow + $DisconnectorJoinedFlow + $DisconnectorJoinedRemoveMv
				$Joins = $DisconnectorJoinedNoFlow + $DisconnectorJoinedFlow + $DisconnectorJoinedRemoveMv
				$ConnectorswithAttribute = [int] $stepresult.ConnectorFlow + [int] $stepresult.DisconnectorProjectedFlow + $DisconnectorJoinedFlow + $ConnectorFlowRemoveMv
				$ConnectorswithoutAttribute = [int] $stepresult.ConnectorNoFlow + [int] $stepresult.DisconnectorProjectedNoFlow + $DisconnectorJoinedNoFlow 
				$FilteredConnectors = [int] $ConnectorFilteredRemoveMv + [int] $stepresult.ConnectorFilteredLeaveMv
				$DeletedConnectors = [int] $stepresult.ConnectorDeleteRemoveMv + $ConnectorDeleteLeaveMv
				$MetaverseObjectDeletes = [int] $stepresult.DisconnectorProjectedRemoveMv + $DisconnectorJoinedRemoveMv + $ConnectorFlowRemoveMv + $ConnectorDeleteLeaveMv + $ConnectorFilteredRemoveMv
			}

			if($stepresult -ne $null -and $stepresult.StepResult -eq "Success")
			{
				$sxml = [xml]$stepresult.FlowCountersXml
				$outboundname = $sxml."outbound-flow-counters"."ma"
				$outboundvalue = $sxml."outbound-flow-counters"."connector-flow"."#text"
			}

			Write-Host ($connector.Name, $result, $sdate, $edate, $username, $projections, $FilteredDisconnectors, $Disconnectors,
			$Joins, $ConnectorswithAttribute, $ConnectorswithoutAttribute, $FilteredConnectors,
			$DeletedConnectors, $MetaverseObjectDeletes, $outboundname, $outboundvalue) -Separator "#~#"
		}
	}
}


