$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$Global:ErrorActionPreference="SilentlyContinue"
$bInactiveMailboxUsage = "false"
$bIsOverWarningQuota = "false"
$pastDays = 1
if($args.count -ne 2)
{
	Write-Host("Please pass the password admin's role username and password as arguments")
	return
}
$username = $args[0] 
$pwd = $args[1]
$password = $args[1]  | ConvertTo-SecureString -asPlainText -Force 
$cred = New-Object System.Management.Automation.PSCredential($username,$password) # Encrypt creds for use 
# Report Root URL 
$D = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
Write-Host("MailboxActivityReport")
Write-Host("-----------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxActivityDaily?`$orderby=Date desc&`$top=1&`$format=json"
$entry = (Invoke-RestMethod -Credential $cred -Uri $url)
[System.GC]::GetTotalMemory($true) | out-null
#$Date = $entry.d.Date.ToString("yyyy-MM-dd") # don't enable this 
$TenantName = $entry.d.TenantName
$TotalNumberOfActiveMailboxes = $entry.d.TotalNumberOfActiveMailboxes
$AccountCreated = $entry.d.AccountCreated
$AccountDeleted = $entry.d.AccountDeleted
Write-Host($TotalNumberOfActiveMailboxes,$AccountCreated,$AccountDeleted) -Separator ";"


Write-Host("StateMailboxReport")
Write-Host("--------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/StaleMailbox?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$TenantName = $entry.TenantName
	$ActiveMailboxes = $entry.ActiveMailboxes
	$InactiveMailboxes31To60Days = $entry.InactiveMailboxes31To60Days
	$InactiveMailboxes61To90Days = $entry.InactiveMailboxes61To90Days
	$InactiveMailboxes91To1460Days = $entry.InactiveMailboxes91To1460Days
	Write-Host($ActiveMailboxes,$InactiveMailboxes31To60Days,$InactiveMailboxes61To90Days,$InactiveMailboxes91To1460Days) -Separator ";"
}

$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/StaleMailboxDetail?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	$LastLogin = $entry.LastLogin
	$DaysInactive = $entry.DaysInactive 
	Write-Host ($UserName,$WindowsLiveID,$LastLogin,$DaysInactive) -separator ";"
}

Write-Host("MailboxUsageReport")
Write-Host("----------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsage?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$TenantName = $entry.TenantName
	$TotalMailboxCount = $entry.TotalMailboxCount
	$TotalInactiveMailboxCount = $entry.TotalInactiveMailboxCount
	$MailboxesOverWarningSize = $entry.MailboxesOverWarningSize
	$MailboxesUsedLessthan25Percent = $entry.MailboxesUsedLessthan25Percent
	Write-Host($TotalMailboxCount,$TotalInactiveMailboxCount,$MailboxesOverWarningSize,$MailboxesUsedLessthan25Percent) -Separator ";"
}
Write-Host("MailboxUsageDetailReport")
Write-Host("--------------------------")
if($bIsOverWarningQuota -eq "true")
{
	$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsageDetail?`$filter=Date eq datetime'"+$D + "' and IsOverWarningQuota eq "+$bIsOverWarningQuota + "&`$format=json"
}
else
{
	$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailboxUsageDetail?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
}
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	$MailboxSize = $entry.MailboxSize
	$CurrentMailboxSize = $entry.CurrentMailboxSize
	$PercentUsed = $entry.PercentUsed
	$IsInactive = $entry.IsInactive
	$IssueWarningQuota = $entry.IssueWarningQuota
	$IsOverWarningQuota = $entry.IsOverWarningQuota
	Write-Host ($UserName,$WindowsLiveID,$MailboxSize,$CurrentMailboxSize,$PercentUsed,$IsInactive,$IssueWarningQuota,$IsOverWarningQuota) -separator ";"
}

Write-Host ("ConnectionbyClientTypeDaily")
Write-Host("--------------------------------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/ConnectionbyClientTypeDaily?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date
	$ClientType = $entry.ClientType
	$Count = $entry.Count
	$TenantName = $entry.TenantName
	Write-Host ($ClientType,$Count) -separator ";"
}
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/ConnectionbyClientTypeDetailDaily?`$filter=Date eq datetime'"+$D + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Date = $entry.Date
	$ClientType = $entry.ClientType
	$Count = $entry.Count
	$TenantName = $entry.TenantName
	$UserName = $entry.UserName
	$WindowsLiveID = $entry.WindowsLiveID
	Write-Host ($UserName,$WindowsLiveID,$ClientType,$Count) -separator ";"
}

Write-Host("MailTraffic send and receive")
Write-Host("--------------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTraffic?`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "'"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$Organization = $entry.Organization
	$Domain = $entry.Domain
	$Date = $entry.Date
	$EventType = $entry.EventType
	$Direction = $entry.Direction
	$Action = $entry.Action
	$MessageCount = $entry.MessageCount
	#Write-Host ($Organization,$Domain,$Date,$EventType,$Direction,$Action,$MessageCount) -separator ";"
	Write-Host ($Direction,$EventType,$MessageCount) -separator ";"
}

Write-Host("TopRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMailRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopSendersSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMailSender'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
[System.GC]::GetTotalMemory($true) | out-null
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopSpamRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopSpamRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("TopMalwareRecipientsSummary")
Write-Host("-----------------------------")
$sd = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT00:00:00')
$ed = (Get-Date).AddDays(-1).ToString('yyyy-MM-ddT23:59:59')
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/MailTrafficSummary?`$select=C1,C2&`$filter=StartDate eq datetime'"+$sd + "' and EndDate eq datetime'" + $ed + "' and Category eq 'TopMalwareRecipient'&`$top=10"+"&`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d
foreach($entry in $entries)
{
	$c1 = $entry.C1
	$c2 = $entry.C2
	Write-Host($c1,$c2) -Separator ";"

}

Write-Host("License Usage")
Write-Host("---------------")
$url = "https://reports.office365.com/ecp/reportingwebservice/reporting.svc/LicenseVsUsageSummary?`$format=json"
$entries = (Invoke-RestMethod -Credential $cred -Uri $url).d.results
foreach($entry in $entries)
{
	$Date = $entry.Date.ToString("yyyy-MM-dd")
	$Workload = $entry.Workload
	$TrailLicenses = $entry.TrialEntitlements
	$PaidLicenses = $entry.NonTrialEntitlements
	$ActiveUsers = $entry.ActiveUsers
	Write-Host($Workload,$TrailLicenses,$PaidLicenses,$ActiveUsers) -Separator ";"
}

Write-Host("Service Status Report")
Write-Host("-----------------------")
$json = (@{userName=$username;password=$pwd;} | convertto-json).tostring()
$cookie = (invoke-restmethod -contenttype "application/json" -method Post -uri "https://api.admin.microsoftonline.com/shdtenantcommunications.svc/Register" -body $json).RegistrationCookie
#preferredEventType -- "0" to represents a Service Incident, "1" to represent a Maintenance Event, and "2" to represent a Message Center communication 
$load = (@{lastCookie=$cookie;locale="en-US";preferredEventTypes=@(0);pastDays=$pastDays} | convertto-json).tostring()
$events = (invoke-restmethod -contenttype "application/json" -method Post -uri "https://api.admin.microsoftonline.com/shdtenantcommunications.svc/GetEvents" -body $load)
foreach($evnt in $events.events)
{
	$ID = $evnt.ID
	$Title = $evnt.Title
	$SVCNames = $evnt.AffectedServiceHealthStatus
	$Status = $evnt.Status
	$StrTime = $evnt.starttime
	$UpTime = $evnt.LastUpdatedTime
	foreach($SVCName in $SVCNames)
	{
		$features = $SVCName.ServiceFeatureStatus
		foreach($feature in $features)
		{
			Write-Host($SVCName.ServiceName+"\"+$feature.FeatureName+";"+$ID+";"+$Title+";"+$Status+";"+$StrTime+";"+$UpTime)
		}
	}
}
[System.GC]::GetTotalMemory($true) | out-null



# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUN9HLeOTRufeOJY1oAqa8VThM
# DmWgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFI5FMAVBk9GGPdEH
# 2jsF85Jfv2b6MA0GCSqGSIb3DQEBAQUABIICAA8wX4lK0liow+zhHMP3VXRjN3MY
# Hay9JZ1ara9/8vtRqVtAc+1cWvEYD/ewjaCV3+Oz0ETJSWQsGmlsY6kI/OEOIv65
# lMMnwN7A6aQG9sYhMkdykyXUYKFpfRVTmzFwJorPbYBwVn9gjoOsgjmGito15gK3
# EFU4zwKS3/YtHXqvJa4VsF2zEp8nRuh1cJYWn9idxiQzKMkLpevjbrdhWvCY6HQK
# Sih/Zf4a171uV4G0pmjueX8fjDSdiQJ2VnkGhjJJc4hmKLmN8MR1BLRW/2rKazXZ
# NOWZCS5ehQkrZTZNkHeC9LnVJYRK6BpRfC5sOgxbtRP8z8ZqudnMM0BSjT+RH07d
# VTLxHuhXxHHk/oC/lJfowXv4W15ludsPD9ULu4XCrV6NW/O4rlyIJc5ROYGJttzB
# 3TmobTU8Iu4E14p5WGvr3zOlJuxtsKoYrMM8rY2JPxm/ybZJz55P5rMouFTKdhqC
# W/SMDh0Ok+BezvvEkGNoRSNeT4QgH0Jx9quphqTp+VW1sDPMeam5aSluBHPyuY+g
# kHSoUbyxbNWDF60f9xc43GnPCumGIAR09lGxoX3mivax8BKO81s5Dkl9E505H3BT
# UFlvGPMpf+GpVb4qwNMWjWWUw5aFY6dbG/9GSYPf1rGOGIz6LpO+5Ac9KolhWJ9h
# kFKW/hXk/ka/fP8AoYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM2MjVaMC8GCSqGSIb3DQEJBDEiBCDWWYuOMMRgSLCVNQGkSA06BzBD
# AwbkXqkT7k5HNou2mzANBgkqhkiG9w0BAQEFAASCAQBmgGVmtVzDflso2PxXM0li
# xaNactO1Ou4xSLnd8sUO9scJLTxF1S+NHse6LsR0UP9VubL8WZRfGQSnvhkEU/wb
# GzuhKYExIeacM8WKAAfMiY3vAkY3KmIwd5ExWvFlf+KW1gQGHAsGK22GUG8+JSCU
# yEmo17nEdtE9hadSu7Me0boYlJ4m+eWnE7HcZH3CDSLinEnvpjq7r9DY5TWlahyr
# DFjnYkfSH2YAiD5JPBkuQuy84/OdttL4r3lTWNdrpiVkYeholzT047fcpfSj/3Q4
# On8NR7BVuRY/3mWIhkeUxXTsU1RCbTRi6o4r9COC8p/77vFMsTANbk/DU9fUp62/
# SIG # End signature block
