﻿##/*********************************************************************************************
##Author                :  Guravareddy T
##Purpose               : It is the base script for some SBO tests and it will get skype call sessions data of all users in the domain and save the data
##Created               :  11/08/2018
##Modified By		    :
##reference link        :(https://msconfiggallery.cloudapp.net/packages/CxdCallData/1.2.2.0/Content/CxdCallData.psm1)
                         #(https://gallery.technet.microsoft.com/Get-CSUserSessionDomains-c8b0257c)

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$egurkhaPath+'\lib\EGFileEncryption.psm1'
$egDatnKy=$egurkhaPath+'\lib\GetDatnKeyFiles.psm1'
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$prxycrdlsServer=($testargs[2]).ToString().Split("#")
$proxyUsr=$prxycrdlsServer[0]
$proxyPass=Eg-O365Dcr -EncStr $prxycrdlsServer[1]
$proxyserverip=$prxycrdlsServer[2]
$rNamefreq=$testargs[3]
$rptnamefrq=$rNamefreq.split('#')
$rName=$rptnamefrq[0]
$Testfreqency=$rptnamefrq[1]
$overrideUri=$testargs[4]
$rptPath='SBO\'+$rName

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
$wratSyallsessions=Eg-WriteFile -ComntRptPath $rptPath -FileName "Syallsessions" -keyFileName "kSyallsessions" -EgPath $egurkhaPath
$wratMycalFeedBack=Eg-WriteFile -ComntRptPath $rptPath -FileName "SyRatMycalFeedBack" -keyFileName "kSyRatMycalFeedBack" -EgPath $egurkhaPath
$wratSyVideoSes=Eg-WriteFile -ComntRptPath $rptPath -FileName "SyVideoSessions" -keyFileName "kSyVideoSessions" -EgPath $egurkhaPath
$wratSyAppshrngSes=Eg-WriteFile -ComntRptPath $rptPath -FileName "SyAppshrngSessions" -keyFileName "kSyAppshrngSessions" -EgPath $egurkhaPath
$wratSyalldomains=Eg-WriteFile -ComntRptPath $rptPath -FileName "Syalldomains" -keyFileName "kSyalldomains" -EgPath $egurkhaPath

$domins=New-Object System.Collections.ArrayList
$WriteLog=$true
$LogFile = $egurkhaPath+'/agent/SBO/'+$rName+"\sbousersesn.log"
$LogFile1 = $egurkhaPath+'/agent/SBO/'+$rName+"\sbousersesn1.log"
$isFrstTimLog=$true
function Get-CurrentLineNumber {
    $MyInvocation.ScriptLineNumber
}

Function Write-Log {
	Param ([string]$string)

	[string]$date = Get-Date -Format G
	
    if ($WriteLog) {
       ( "[" + $date + "] - [" +$rName+"] mTime -  " + $Testfreqency + " - " + $string ) | Out-File -FilePath $LogFile -Append } 

    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1
            }
        }
        $isFrstTimLog=$false
    }

}

function Get-CxdCallData{
    [cmdletbinding()]
        Param
        (
            [Parameter(Mandatory=$true)][int]$NumberOfMinutesToSearch,
            [Parameter(Mandatory=$false)][string]$rptPath,
            [Parameter(Mandatory=$false)][PSCredential]$Credential
        )

    begin {
        try{
            Set-WinRMNetworkDelayMS -value "60000" -WarningAction SilentlyContinue -ErrorAction SilentlyContinue -ErrorVariable WinRMError
        }catch{
            Write-log "[ERROR]Unable to set the WinRM Network Delay. This may be due to User Account Control settings. If you're not encountering timeouts you can safely ignore this warning, otherwise try running the script as an elevated user (Administrator)."
        }
    }

    process {
        $startTime = (Get-Date).AddMinutes(-$NumberOfMinutesToSearch) #note the .AddDays is subtracting the number of days to search
        $endTime = Get-Date
        $global:sessionStartTime = $null
        $numBuckets = 0
        $numUsers = 0
        $enabledUsers = $null
        $arrNotUsingSkype = $null

        if (!$Credential){
            $Credential = Get-Credential -Message "Authenticate to Skype for Business Online"
        }
        Write-Log '.................Strating the execution of the script..................'
        #create initial SFBO Connection
        Invoke-CxdSkypeOnlineConnection


        try{
            [array]$enabledUsers = ProcessSkypeOnlineUsers $rptPath
        }catch{
            Write-Log " [Error] Exception encounterd while getting users. Attempting to remove the PowerShell PSSession and will retry."
            Invoke-CxdSkypeOnlineConnection -RepairPSSession
            [array]$enabledUsers = ProcessSkypeOnlineUsers $rptPath
        }
        
        if (!$enabledUsers.Count){
            Write-Log  "We didn't find any users matching your query. Exiting..."
            Write-Log "Aborting the Script"
            break
        }

        $userTotal = $enabledUsers.Count
        $userBuckets = [math]::Ceiling($userTotal /10)
        $arrUserBuckets = @{}

        #create users and put them into buckets
        Write-Verbose -Message "Putting $($enabledUsers.Count) users into buckets..."
        $count = 0
        $enabledUsers | ForEach-Object {
            $arrUserBuckets[$count % $userBuckets] += @($_)
            $count++
        }
        Write-Log "Placed $($enabledUsers.Count) users into $($arrUserBuckets.Count) bucket(s)."
        $enabledUsers=$null
        #process all discovered users into buckets
        $arrUserBuckets | ProcessBuckets


    }
    end{
        Write-Log "Removing PowerShell Sessions......"
        Get-PSSession | Remove-PSSession
        Write-Log "Script completed Successfully"
    }   
}

function ProcessBuckets{
    [cmdletbinding()]
    Param(
        [Parameter(Mandatory=$true,ValueFromPipeline=$true)]$arrUserBuckets
    )
    begin{}
    process{
        foreach ($userItem in $arrUserBuckets.Values){
            #progress bar for total buckets
            $numBuckets++
            ProcessUsersInBuckets -userItem $userItem
        }
    }
    end{
    }   
}

function ProcessUsersInBuckets{
    [cmdletbinding()]
    Param(
        [Parameter(Mandatory=$false)]$userItem
    )
    begin{

        #before we process this bucket of users we need to check the global session timer to prevent access token expiration
        Invoke-CxdSkypeOnlineConnection
    }
    process{
        foreach($userI in $userItem){
            #set variables
            $userSession=$null
            $Sessions=$null
            $getUserSessionError = $null
            $sipAddress = $userI.SipAddress.Replace("sip:","")
            Try{
                [array]$userSession = ObtainUserSessionData -startTime $startTime -endTime $endTime -sipAddress $sipAddress
            }Catch{
                Write-Log "Unable to retrieve user session information. Attempting to repair the Skype Online connection and will try again."
                Invoke-CxdSkypeOnlineConnection -RepairPSSession
                [array]$userSession = ObtainUserSessionData -startTime $startTime -endTime $endTime -sipAddress $sipAddress
            }
             if ($userSession){
                $Sessions=$userSession | where-object {$_.FromUri -ne $_.ToUri}
                if($Sessions){
                    UsersDomains -userSession $Sessions
                    SeperateSessions -userSession $Sessions
                } 
            }
            $userSession=$null;$Sessions=$null

        }
    }
    end{
    }
            
}

function ObtainUserSessionData{
    [cmdletbinding()]
    Param(
        $startTime,
        $endTime,
        $sipAddress
    )

    begin {}
    process {
        $usrPath=$egurkhaPath+'\agent\'+$rptPath
        if(!(Test-Path -Path $usrPath )){
            $null=New-Item -ItemType directory -Path $usrPath
        }
        Try{
            $userSession=$null
            $Error.Clear()

           $ScriptBlock = {
                param($startTime,$endTime,$sipAddress)
                    Get-CsUserSession -StartTime $startTime -EndTime $endTime -User $sipAddress
                }
            [array]$userSession=invoke-command -scriptblock $ScriptBlock -ArgumentList $startTime,$endTime,$sipAddress -session (get-pssession)
           # [array]$userSession = Get-CsUserSession -StartTime $startTime -EndTime $endTime -User $sipAddress # -WarningAction SilentlyContinue -ErrorAction SilentlyContinue -ErrorVariable $userSessionError
           if($Error)
           {
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] "+$Error)
           # throw $_
           }
        }Catch{
             $ErrorMessage = $_.Exception.Message
             Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running Get-CsUserSession: "+$ErrorMessage)
             #there was an exception and the command did not execute
             #throw $_
        }Finally{
            if ($userSessionError){
                #the command executed but returned an error
                #throw $getUserSessionError
            }
        }

        #sort data by oldest to newest to check the array for the oldest call in preparation for recursion
        $userSession = $userSession | Sort-Object -Property EndTime

        #verify record count hasn't been exceeded and perform recursion if necessary to retrieve additional records
        if ($userSession.Count -ge 1000){
            $newStart = $userSession[-1].endTime
            Write-Information -Message "Found more than 1000 records for $sipAddress. Performing recursive query to obtain more data using revised start date of $newStart"
            $userSession += ObtainUserSessionData -startTime $newStart -endTime $endTime -sipAddress $sipAddress
        }   
    }
    end {
        return $userSession
    }
}

function SeperateSessions{
    [cmdletbinding()]
    Param(
        [Parameter()]$userSession
    )

    begin {}
    process {

            [array]$allsessions = $userSession | Where-Object {$_.MediaTypesDescription -like "*IM*" -or $_.MediaTypesDescription -eq ""}
            [array]$audioSessions = $userSession | Where-Object MediaTypesDescription -like "*Audio*"
            [array]$videosessions = $userSession | Where-Object MediaTypesDescription -like "*Video*"
            [array]$Appshrngsessions = $userSession | Where-Object MediaTypesDescription -like "*AppSharing*"
    }
    end {

        if ($allsessions){
            Export-CxdData -DataInput $allsessions -ReportType 'Syallsessions' -Append
        }
        if ($audioSessions){
            Export-CxdData -DataInput $audioSessions -ReportType 'SyRatMycalFeedBack' -Append
        }
        if ($videosessions){
            Export-CxdData -DataInput $videosessions -ReportType 'SyVideoSessions' -Append
        }
        if ($Appshrngsessions){
            Export-CxdData -DataInput $Appshrngsessions -ReportType 'SyAppshrngSessions' -Append
        }
        $allsessions=$null;$audioSessions=$null;$videosessions=$null;$Appshrngsessions=$null
    }
}

function UsersDomains{
    [cmdletbinding()]
    Param(
        [Parameter()]$userSession
    )

    begin {}
    process {
        [array]$allSessions = $userSession | Select-Object FromUri,ToUri
        if($allSessions){
            foreach($entry in $allSessions)
            {
                $domain=($entry.FromUri).split('@')[1].trim()
                if(!$domins.Contains($domain)) { $domins.Add($domain) }
                $domain=($entry.ToUri).split('@')[1].trim()
                if(!$domins.Contains($domain)){  $domins.Add($domain) }
            }

        }
    }
    end {
    }
}

function Export-CxdData{
    
    [cmdletbinding()]
    Param
    (
        [Parameter(mandatory=$true, valuefrompipeline=$false)][PSObject]$DataInput,
        [Parameter(mandatory=$true, valuefrompipeline=$false)][string]$ReportType,
        [Parameter(mandatory=$false, valuefrompipeline=$false)][switch]$Append
    )

    begin{}
    process{           
            switch($ReportType){ 
            
                'Syallsessions'{$dataInput | Export-Csv $wratSyallsessions[1] -Encoding $encTyp -NoTypeInformation -Append}               
                'SyRatMycalFeedBack'{$dataInput | Export-Csv $wratMycalFeedBack[1] -Encoding $encTyp -NoTypeInformation -Append}
                'SyVideoSessions'{$dataInput | Export-Csv $wratSyVideoSes[1] -Encoding $encTyp -NoTypeInformation -Append}
                'SyAppshrngSessions'{$dataInput | Export-Csv $wratSyAppshrngSes[1] -Encoding $encTyp -NoTypeInformation -Append}
                'Syalldomains'{$dataInput | Export-Csv $wratSyalldomains[1] -Encoding $encTyp -NoTypeInformation -Append}
                'CSOnlineUsr'{$dataInput | Export-Csv $wratCSOnlineUsr[1] -Encoding $encTyp -NoTypeInformation -Append}
            }
    }
    end{
        
    }

}

function Invoke-CxdSkypeOnlineConnection{
    [cmdletbinding()]
    Param
    (
    [Parameter(mandatory=$false, valuefrompipeline=$false)]
    [switch]$RepairPSSession
    )
    begin{}
    process{
        #calculate session timer to handle access token expiration
        if ($global:sessionStartTime){
            $global:sessionTotalTime = ((Get-Date) - $global:sessionStartTime)
        }

        #determine if Skype for Business PsSession is loaded in memory
        $sessionInfo = Get-PsSession

        #need to loop through each session a user might have opened previously
        foreach ($sessionItem in $sessionInfo){
            #check session timer to know if we need to break the connection in advance of a timeout. Break and make new after 40 minutes.
            if ($sessionItem.ComputerName.Contains(".online.") -and $sessionItem.State -eq "Opened" -and $global:sessionTotalTime.TotalSeconds -ge "2400"){
                Write-Log "The PowerShell session has been running for $($global:sessionTotalTime.TotalMinutes) minutes. We need to shut it down and create a new session due to the access token expiration at 60 minutes."
                $sessionItem | Remove-PSSession
                Start-Sleep -Seconds 2
                $SessionFound = $false
                $global:sessionTotalTime = $null #reset the timer
            }

            #try to repair PSSession
            if ($sessionItem.ComputerName.Contains(".online.") -and $sessionItem.State -ne "Opened" -and $RepairPSSession){
                Write-Verbose -Message "Attempting to repair broken PowerShell session to Skype for Business Online using cached credential."
                $sessionItem | Remove-PSSession
                Start-Sleep -Seconds 3
                $SessionFound = $false
                $global:sessionTotalTime = $null
            }elseif ($sessionItem.ComputerName.Contains(".online.") -and $sessionItem.State -eq "Opened"){
                $SessionFound = $true
            }
        }

        if (!$SessionFound){
            Write-Log "Creating new Skype Online PowerShell session..."
            try{
                 $sessionOption = New-PSSessionOption -SkipRevocationCheck 
	             if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	                 $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
	                 $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	                    #[System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred    
	                    #$prx=(netsh winhttp show proxy)[3].Split(":")
	                    #$proxyserverip=($prx[1]+':'+$prx[2]).Trim()
	                    $proxyserver='http://'+$proxyserverip
	                    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
	                    [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
	                    [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true	             
                 }
                 if($overrideUri -ne 'none'){
                    $lyncsession = New-CsOnlineSession -Credential $Credential -SessionOption $sessionOption –OverridePowershellUri $overrideUri # -WarningAction SilentlyContinue -ErrorAction SilentlyContinue -ErrorVariable $newOnlineSessionError 
                 }
                 else{ $lyncsession = New-CsOnlineSession -Credential $Credential -SessionOption $sessionOption }

                 Write-Log 'Session got created successfully.'

            }catch{
             $ErrorMessage = $_.Exception.Message
             Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while creating session: "+$ErrorMessage)         
             throw;
            }finally{
                if ($newOnlineSessionError){
                    throw $newOnlineSessionError
                }
            }
            Write-Verbose -Message "Importing remote PowerShell session..."
            $global:sessionStartTime = (Get-Date)
            Import-PSSession $lyncsession -AllowClobber | Out-Null
        }
    }
    end{}
}


function ProcessSkypeOnlineUsers{
    [cmdletbinding()]
    Param(
        [Parameter()]$reportingname
    )
    process{
            $allusers=""
            try{
                $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "CSOnlineUsr" -keyFileName "kCSOnlineUsr" -EgPath $egurkhaPath
                $datafile=$readfiles[1] -replace (".csv",".dat") 
                $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
                $allusers= import-csv $csvfile -Encoding $encTyp | Select-Object *
                write-log ('readed users csv file '+$readfiles[3])                                  			 			 					
                Remove-Item $csvfile
                $readtime = (Get-Item $readfiles[1]).LastWriteTime
    		    $readfiledif=(NEW-TIMESPAN –Start $readtime –End (Get-Date) | Select-Object TotalMinutes).TotalMinutes
                if($readfiledif -gt 1440)
                {
                   $allusers=""
                   write-log ' Readed CSOnlineUsr csv file is older..... so we are creating new file' 
                }
            }
            catch{
               write-log ' CSOnlineUsr csv file is not found going to creating the file'   
               $allusers=""
             }

            if($allusers)
            {  try{
                    write-log  "getting all users of Skype for Business Online from input CSV file"
                    $enabledUsers = $allusers | Select-Object Enabled,SipAddress | Where-Object {$_.Enabled -eq 'TRUE'}
                    return $enabledUsers
                  }
                  catch{
                        $ErrorMessage = $_.Exception.Message                   
                        Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Exception while reading the users from csv:"+$ErrorMessage)
                        return ""
                  }

            }else{
                $wratCSOnlineUsr=Eg-WriteFile -ComntRptPath $rptPath -FileName "CSOnlineUsr" -keyFileName "kCSOnlineUsr" -EgPath $egurkhaPath
                $allusers=Get-CSOnlineUser |Select-Object AcpInfo,AssignedPlan,DisplayName,RegistrarPool,SoftDeletionTimestamp,UserPrincipalName,WhenChanged,WhenCreated,Enabled,SipAddress
                Export-CxdData -DataInput $allusers -ReportType 'CSOnlineUsr' -Append
                $null=Protect-File  $wratCSOnlineUsr[1] -Algorithm AES -KeyAsPlainText $wratCSOnlineUsr[0] -RemoveSource 
                $enabledUsers = $allusers | Select-Object Enabled,SipAddress | Where-Object {$_.Enabled -eq '$True'}
                Return $enabledUsers
            }
    }
    end{}
}


function Set-WinRMNetworkDelayMS{

  param(
    [Parameter(Mandatory = $false)] [string] $value="30000"
  )

  $networkDelay = Get-Item WSMan:\localhost\Client\NetworkDelayms

  if($networkDelay -eq $null)
  {
    # If cannot get NetworkDelayms due to permission or other reason, just return.
    return
  }

  $oldValue = $networkDelay.Value
  $newValue = $value

  if($newValue -ne $oldValue)
  {
    Set-Item WSMan:\localhost\Client\NetworkDelayms $newValue

  }
}

try{

    Get-CxdCallData -NumberOfMinutesToSearch $Testfreqency -Credential $credential -rptPath $rptPath
    [System.GC]::GetTotalMemory($true) | out-null
}catch{
    $ErrorMessage = $_.Exception.Message
    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running Get-CsUserSession: "+$ErrorMessage)
    exit
}


$uPath=$egurkhaPath+'\agent\'+$rptPath

if($domins){
    foreach($domain in $domins){        
            $newObject = [PSCustomObject][ordered]@{
            domain=$domain
        }        
        Export-CxdData -DataInput $newObject -ReportType 'Syalldomains' -Append                  
        
    }
}

if(Test-Path $wratSyallsessions[1] -PathType Leaf){
    $null=Protect-File  $wratSyallsessions[1] -Algorithm AES -KeyAsPlainText $wratSyallsessions[0] -RemoveSource
}else{
    $temp=Split-Path $wratSyallsessions[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratMycalFeedBack[1] -PathType Leaf){
    $null=Protect-File  $wratMycalFeedBack[1] -Algorithm AES -KeyAsPlainText $wratMycalFeedBack[0] -RemoveSource
}else{
    $temp=Split-Path $wratMycalFeedBack[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratSyVideoSes[1] -PathType Leaf){
   $null=Protect-File  $wratSyVideoSes[1] -Algorithm AES -KeyAsPlainText $wratSyVideoSes[0] -RemoveSource 
}else{
    $temp=Split-Path $wratSyVideoSes[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratSyAppshrngSes[1] -PathType Leaf){
   $null=Protect-File  $wratSyAppshrngSes[1] -Algorithm AES -KeyAsPlainText $wratSyAppshrngSes[0] -RemoveSource 
}else{
    $temp=Split-Path $wratSyAppshrngSes[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

if(Test-Path $wratSyalldomains[1] -PathType Leaf){
   $null=Protect-File  $wratSyalldomains[1] -Algorithm AES -KeyAsPlainText $wratSyalldomains[0] -RemoveSource 
}else{
    $temp=Split-Path $wratSyalldomains[1] -leaf
    $temp='\k'+$temp.Replace('.csv','.dat')
    Remove-Item -Path $uPath$temp
}

$csvDir=$egInstallpath.Value+'/agent/'+$rptPath+'/'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'Syallsessions'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'SyRatMycalFeedBack'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'Syalldomains'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'SyVideoSessions'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'SyAppshrngSessions'
    Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'CSOnlineUsr'
    [System.GC]::GetTotalMemory($true) | out-null
    exit

# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUjDb4RAuJA4Bw1NNTXrfyvIzO
# nASgghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFDmFxt4bkBhVKIpu
# ToeDS4wIALZ2MA0GCSqGSIb3DQEBAQUABIICAIZZ0h6XNc1VVnuRkUNjT4eoIM7t
# /jfB+/oA7ZkW/C2ljVVF8O/TuRMHibPScx+jkRjQ+RIU0aayaqFld4cJjLLFbzur
# 4eQ/XT7Hd3Bt8bgOu1LlAia3MyUXlENyM8LPnsAYEmf1sGRwp8GoDnI14kNNlXfZ
# t6Wepsw5z3chvnKI6Uk9cWIQl9kJ4kWQ/7E2VMo/LaZhJpCHAQ2HZ3yUKm0+JG/A
# QKnP2kvuaU0ckzMepXx2a2ruQ+jegBifEV5atDbf/4w7DvLXjOfXYXjU3n6M++ry
# MpGb/WXEjpTWlIf+cXsDZsS89EiIfuGv4xhTG1hAJagMVvESCu93K87wZsyV3rCO
# y0rKneN0GS/Sq+TOG+UB7g41nmCExdt0TcaqbZWYhQBdNAgBOawSLnCUyS/0Ki6W
# iSXvcyeC/KX+mhwICPIHeUusfjgaWdGU6hBEzseRAyvaDjrxNJLLQhGVBCmHGtM/
# hapsFpB2u4DzibL73KZFs0LxBmrDdMlc/6CDFPNE9Larwjn1yugrrnpiq+z2V5Sq
# kTY6iy3Aw1x8+1m7WzlEYNui0w8KWJX96XeTzAas0xiSU3Ga6aj7l3NNUw8bvost
# As1yEwsYyxPR30b4XR6H58jFIFdF2/UfqDDS/xH3HWV/mjzkAieDwPfwpaHfMoJz
# RsPlpgNgoAZ6RHesoYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM2NTBaMC8GCSqGSIb3DQEJBDEiBCDo5xeWGiPCDrA6aSTQmG8m3d/I
# 6QTHgFa6O9gdbmx2djANBgkqhkiG9w0BAQEFAASCAQArRlvp46t1bwerpMw8dpHZ
# TLNgEgoz/k52XjEsi1Vh6QWJOjMabqbzrNPmYwPLMjQgH3SfjmNCCF+PvGO9/hv+
# QF9L3As42/DGpKivP8W2C7jlxv8oJlyHLqzZZbFMJkWF9lB54SR9T/DF2YzNpD9d
# TCB03JK+bxq5GEV7gguldI0XXxo4FLSwQuNyLlLgqLosWe2EK4dYI4hVZevTPIA+
# ijJq7aA3tDbwG6X1rIfRgP/cy/kbc+zOHbJHFGaR2vjJxptyS69SeCL+YadjrAfS
# XG/H46SRC9IWSsRFd3s6V6VOQj9a+L0OdTrfhG9DwinBpaZVy8uB0pg5sR/a4Hbx
# SIG # End signature block
