﻿##/******************************************************************************************
##Author                :     MohanRaj S
##Purpose               :     Display the License available in O365 and their License details
##Created               :     06/12/2017
##Modified By		    :     Prabaharan.T

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$reprt=$TestInputs[4]
$rptndfrqcy=$reprt.split('#')
$reportingNam=$rptndfrqcy[0]
$topN_dd=$rptndfrqcy[1]
$proxyserverip=($rptndfrqcy[2]).ToString().trim()
$tenantName=$TestInputs[5]

$MyDir=$egurkhaPath+'/agent/O365/'+$reportingNam+'/Debug'
if(!(Test-Path -Path $MyDir )){
    New-Item -ItemType directory -Path $MyDir
}
$WriteLog=$false
$LogFile = $MyDir+"\O365UserLog.log"
$LogFile1 = $MyDir+"\O365UserLog1.log"
$isFrstTimLog=$false

# Writes output to a log file with a time date stamp
Function Write-Log {
	Param ([string]$string)
	[string]$date = Get-Date -Format G
    if ($WriteLog) {
        ( "[" + $date + "] - [Debug] -" + $string ) | Out-File -FilePath $LogFile -Append } 
    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                } 
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }
}



if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
Try{

    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
    $encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
    $am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
    $pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp
     
    $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
    if(!$proxyserverip.Contains('none')){
        $proxyserver='http://'+$proxyserverip
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        }
     }

    if(!$tenantName -or $tenantName -eq 'none'){
    	Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]
    }
    $chkEnd=[datetime](Get-Date).AddDays(+6).ToUniversalTime()
    $chkStart=[datetime](Get-Date).AddDays(-1).ToUniversalTime()

    $dmnPwdExp=@{}
    $allowedcount = 0 
    $blockedcount = 0
    $TotalUsers = 0
    $licensecount = 0
    $enabledMFA = 0
    $disabledMFA = 0
    $enforcedMFA = 0
    $unlicensecount = 0
    $ExternalUsrCount=0
    $Passnevercount = 0
    $deletedcount = 0
    $nextexpiry = 0
    $rptPath='O365/'+$reportingNam
    #---------------START CMDLET------------------
    try{
        $readArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
            $unProtctMUsr=$readArr[1] -replace (".csv",".dat") 
            $musrPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
            $usersview= import-csv $musrPath -Encoding $encTyp
            Remove-Item $musrPath
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]
        }
    }
    catch{
        $errmsg=$_.Exception.Message
        Write-Error -Message $errmsg
    }
    [System.GC]::GetTotalMemory($true) | out-null

    #---------------START CMDLET------------------
    if(!$tenantName -or $tenantName -eq 'none'){
        try{
            $delUsrRArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolDelUsr" -keyFileName "kO365msolDelUsr" -EgPath $egurkhaPath
            if($delUsrRArr -ne $null -and [System.IO.File]::Exists($delUsrRArr[1]) -eq 'True'){
                $unProtctMDUsr=$delUsrRArr[1] -replace (".csv",".dat") 
                $mdelusrPath=Unprotect-File $unProtctMDUsr -Algorithm AES -KeyAsPlainText $delUsrRArr[0]	
                $deluser= import-csv $mdelusrPath -Encoding $encTyp
                Remove-Item $mdelusrPath
                Eg-DeleteFiles -FilePath $delUsrRArr[2] -Pattern 'O365msolDelUsr' -InputFile $delUsrRArr[3]
                Eg-DeleteFiles -FilePath $delUsrRArr[2] -Pattern 'kO365msolDelUsr' -InputFile $delUsrRArr[4]
            }
        }
        catch{
            $errmsg1=$_.Exception.Message
            Write-Host $errmsg1
        }
        [System.GC]::GetTotalMemory($true) | out-null
    }
    #---------------START CMDLET------------------
    try{
        $dmUsrRArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        if($dmUsrRArr -ne $null -and [System.IO.File]::Exists($dmUsrRArr[1]) -eq 'True'){
            $uPMDomUsr=$dmUsrRArr[1] -replace (".csv",".dat") 
            $mdomusrPath=Unprotect-File $uPMDomUsr -Algorithm AES -KeyAsPlainText $dmUsrRArr[0]	
            $domain= import-csv $mdomusrPath -Encoding $encTyp
            Remove-Item $mdomusrPath
            Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'O365msolDomUsr' -InputFile $dmUsrRArr[3]
            Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'kO365msolDomUsr' -InputFile $dmUsrRArr[4]
        }
    }
    catch{
        $errmsg2=$_.Exception.Message
        Write-Host $errmsg2
    }
    [System.GC]::GetTotalMemory($true) | out-null

    #---------------START CMDLET------------------
    if(!$tenantName -or $tenantName -eq 'none'){
        Try{
            $passPlcyWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath  
        
            foreach($dmn in $domain){
                $valid=((Get-MsolPasswordPolicy -domain $dmn.Name -ErrorAction SilentlyContinue))| Select-Object -Property @{Name='Domain';Expression={$dmn.Name}},ValidityPeriod #|Export-Csv -Append -LiteralPath $passPlcyWArr[1] #-Force
                if($valid -ne $null -and $valid -ne ''){
                    $valid|Export-Csv -Append -LiteralPath $passPlcyWArr[1] -Encoding $encTyp #-Force
                }
            }
            $null=Protect-File  $passPlcyWArr[1] -Algorithm AES -KeyAsPlainText $passPlcyWArr[0] -RemoveSource
            try{
                $passPlcyRArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath
                if($passPlcyRArr -ne $null -and [System.IO.File]::Exists($passPlcyRArr[1]) -eq 'True'){
                    $mpassPlcyUsr=$passPlcyRArr[1] -replace (".csv",".dat") 
                    $passPlcyPath=Unprotect-File $mpassPlcyUsr -Algorithm AES -KeyAsPlainText $passPlcyRArr[0]	
                    $msolPassword= import-csv $passPlcyPath -Encoding $encTyp
                    for($j=0; $j -lt $msolPassword.Length; $j++){
                        $Domain=$msolPassword[$j].Domain.toString()
                        [int]$ValidityPeriod=$msolPassword[$j].ValidityPeriod
                        $dmnPwdExp.Add($Domain,$ValidityPeriod)
                    }
                    Remove-Item $passPlcyPath
                    Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'O365msolpass' -InputFile $passPlcyRArr[3]
                    Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'kO365msolpass' -InputFile $passPlcyRArr[4]
                }
            }catch{
                $errmsg3=$_.Exception.Message
                Write-Host $errmsg3
            }  
        }Catch{
	        $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$rptPath+'\'
            $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kO365msolpass*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
            foreach($file in $fileRead){
                $fileName=([String]$file.Name).Trim()
                if([System.IO.File]::Exists(($egurkhaRprtPath+$fileName)) -eq 'True'){
                    Remove-Item $egurkhaRprtPath$fileName -Force
                }
            }
        }
        [System.GC]::GetTotalMemory($true) | out-null
        $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
        $DateFormat = $CultureDateTimeFormat.ShortDatePattern
        $TimeFormat = $CultureDateTimeFormat.LongTimePattern
        $DateTimeFormat = "$DateFormat $TimeFormat"
        $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt').Trim()
        if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
    }

    $TotalUsers=($usersview).Count
    $licensecount=($usersview|Where{$_.IsLicensed -eq $true}).Count
    $usersview=$usersview| Sort-Object UserPrincipalName 
    foreach($pwdexp in $usersview){
        if($pwdexp.PasswordNeverExpires -eq $true){
		if($Passnevercount -lt $topN_dd){
	            Write-Host 'Passnever~'$pwdexp.UserPrincipalName'~'$pwdexp.SignInName'~'$pwdexp.AccId'~'$pwdexp.IsLicensed'~'$pwdexp.UsageLocation'!@!'
		}		
	    $Passnevercount++
        }
        if($pwdexp.IsLicensed -ne $true){
			#Unlicensed internal users
            if(-not  $pwdexp.UserPrincipalName.Contains('#EXT#')){                
		        if($unlicensecount -lt $topN_dd){		       
			        Write-Host 'Unlicensed~'$pwdexp.UserPrincipalName'~'$pwdexp.DisplayName'~'"Unlicensed"'!@!'                    		        
                }
                $unlicensecount++
		    }           
			#Unlicensed external users
		    if($pwdexp.UserPrincipalName.Contains('#EXT#')){                   
               if($ExternalUsrCount -le $topN_dd){
			        Write-Host 'ExternalUsers~'$pwdexp.UserPrincipalName'~'$pwdexp.DisplayName'!@!'                    
               }
               $ExternalUsrCount++
		    }		    		    
        }
        if($pwdexp.BlockCredential -ne $true){
            $allowedcount++
        }else{
		if($blockedcount -lt $topN_dd){
	            Write-Host 'blocked~'$pwdexp.UserPrincipalName'~'$pwdexp.SignInName'~'$pwdexp.AccId'~'$pwdexp.IsLicensed'~'$pwdexp.UsageLocation'!@!'
		}
		
	    $blockedcount++
        }

        if(!$tenantName -or $tenantName -eq 'none'){
        #Mutli Factor Authenication
        if($pwdexp.MFAStatus -ne ''){
            if($pwdexp.MFAStatus -eq 'Enabled'){
                $enabledMFA++
                <#if($enabledMFA -le $showDD){
	                Write-Host 'MFAEnabled~'$pwdexp.UserPrincipalName'~!~'$pwdexp.SignInName'~!~-~!~'$pwdexp.UsageLocation'!@!'
		        }#>
            }
            elseif($pwdexp.MFAStatus -eq 'Enforced'){
                $enforcedMFA++
                <#if($enforcedMFA -le $showDD){
                    Write-Host 'MFAEnforced~'$pwdexp.UserPrincipalName'~!~'$pwdexp.SignInName'~!~-~!~'$pwdexp.UsageLocation'!@!'
                }#>
            }
		}
        else{
            $disabledMFA++
        }
        }else{
            $enabledMFA=-5
            $enforcedMFA=-5
            $disabledMFA=-5
	}
    }

    if(!$tenantName -or $tenantName -eq 'none'){
    foreach($deleteduser in $deluser){
	    if($deletedcount -lt $topN_dd){
	        Write-Host 'usersdeleted~'$deleteduser.UserPrincipalName'~'$deleteduser.SignInName'~'$deleteduser.AccId'~'$deleteduser.IsLicensed'~'$deleteduser.UsageLocation'!@!'
	    }
		
	$deletedcount++
        }
    }else{
        $deletedcount=-5
    }
    if(!$tenantName -or $tenantName -eq 'none'){
    $users = $usersview |  where { $_.PasswordNeverExpires -eq $false } 
    $nextexpiry=0
    foreach($user in $users){
        Try{
            $usrname = $user.UserPrincipalName
            $signname = $user.SignInName
            Write-Log($user.LastPasswordChangeTimestamp+ ' -- ' +$DateTimeFormat)
            $inpDatStr=([String]$user.LastPasswordChangeTimestamp).Trim()
            if($inpDatStr -ne $null -and $inpDatStr -ne ''){
                $passwordSetDate =Eg-ParseExact -dateStr $inpDatStr -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                $domainName= $usrname.substring($usrname.IndexOf('@')+1)
                [int]$maxPasswordAge=$dmnPwdExp[$domainName]
                Write-Log('domainName -->> '+$domainName+' -- '+$dmnPwdExp[$domainName])
                Write-Log('maxPasswordAge -->> '+$maxPasswordAge)
                #Try{
                    if($maxPasswordAge -ne 2147483647){
                        [DateTime] $expireson =$passwordSetDate.addDays($maxPasswordAge)
                        $expireson=$expireson.ToUniversalTime().Date
                        Write-Log('[chkStart&end&expireson] '+$chkStart+' -- '+$chkEnd+' -- '+$expireson)
	                    if((($chkStart.Date) -lt $expireson) -and (($chkEnd.Date) -gt $expireson)){
	                        $userlicAcc =  $user.AccId
	                        $userislic = $user.IsLicensed
	                        $usageloc = $user.UsageLocation
	                        if($usageloc -eq $null){
			                    $usageloc = "-"
	                        }
	                        if($userlicAcc -eq $null -or $userlicAcc -eq ''){
			                    $userlicAcc = "-"
	                        }
			                if($nextexpiry -lt $topN_dd){
		                        Write-Host 'userpassexpire~'$usrname'~'$signname'~'$expireson'~'$userlicAcc'~'$userislic'~'$usageloc'!@!'
                                Write-Log('userpassexpire~'+$usrname+'~'+$signname+'~'+$expireson+'~'+$userlicAcc+'~'+$userislic+'~'+$usageloc)
			                }								
                            $nextexpiry++
                        }
                    }
                #}Catch{}
            }
            }Catch{}
        }
    }
}
    Catch{            
	Write-Host "Error Occured in O365UserLog -- " $_.Exception.Message        
	}

write-host ''
Write-Host 'unlicecnt~'$unlicensecount'!@!'
Write-Host 'deletedcount~' $deletedcount'!@!'
Write-Host 'Pwdnvrcnt~'$Passnevercount'!@!'
Write-Host 'signcount~'$allowedcount'~'$blockedcount'!@!'
Write-Host $(If ($nextexpiry.Equals(0)) {"nextexpire~-5"} Else {'nextexpire~'+$nextexpiry})'!@!'
Write-Host 'TotalUsers~'$TotalUsers'!@!'
Write-Host 'licecnt~'$licensecount'!@!'
Write-Host 'EnabledMFA~'$enabledMFA'!@!'
Write-Host 'EnforcedMFA~'$enforcedMFA'!@!'
Write-Host 'DisabledMFA~'$disabledMFA'!@!'
Write-Host 'extUsrsCnt~'$ExternalUsrCount'!@!'
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUyVkKEu/fTDVt43jqxNDTaWm4
# pVKggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFPoz4+0R
# o/Czich+K4Tu4RiP5TD0MA0GCSqGSIb3DQEBAQUABIICAJiKGDbp4k5ntEdlaLOL
# 0lG3M/C7l83WJB1XjQ2Hc2Vg3p/hs5Vr5AmK7AtPOofsS8Z4YV19516SDa0Ee2ru
# oeZEvafkQOp/Cyjf1nhIaSmVHPY2w6RbmfJ3TeL4FtHlZJzqGRLPfObvqXFhYV+4
# GsVhHNJWr3nOfZa2bMeQNNwdMfUILPhPZOBf8Pc8jo3NvWPk+lJhQClIDTEeAKyH
# OI8jbBLxrFGgY2AR6RGrglqzXOG50uU7x6OQI1jc90Gmc7Xo9cByqVu7O97VHLoT
# 5XMSvDVxX7phsLzlcrXfKDumOyP0cdUSfvg3jLXUGrd7emcysm60jquyignnbfLC
# wUzGDwX5FBOOabgZI/3ilzQkXx3qtGJBvV8d0TyHh10ZLMhALwpyQx7kCRhexnLb
# tocD9Xxz5wYIw6yUj/7UMzUOa1i1sVvu6lqYmlLgLcmknxwJBPGaFTuFRtShgq8z
# jxAsKAjASrb5eV+0upxyjbBXOYjlZONBt0LzQwNqDpZfEz61nfbXUY5I6AgssKgq
# oAKmgbBsrH82NCas+VfXiYPCzS3eY1FyMtABwWyBDvZGlbiFvE6xY5cKH+CWKolB
# d07MZ90GqyTrBIbdpAnhmw3nPqEbVusQkYO9aYwqgQnv4TBUpYwtKSstk+ooRQFs
# gpJSfFW3nvw53uVKrwDFKHWSoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MTAw
# MlowLwYJKoZIhvcNAQkEMSIEIG91l7SPgifQFmA1FVHq/OdOLhnBB6ZzPYYXkHVw
# HsjWMA0GCSqGSIb3DQEBAQUABIICACSj/mQo/83v6dp2syHoK+VoJFXRv81QvvIH
# J/eUUcJkpXyrK98WZxETD+TarCWA4i+rA0/mY82YCYaS9JfgdHvXlHR2zzyjxJYo
# NpAJAzc8n363X9wIq2kjUvMFLNnZQb7umTrIX9fccCNqGyJdid0U8XkIjTMOXhaC
# IqBuHvV+iHCXXcxaM0Oy/MBuA8X410ErsacMR9qS7x3VOY6X4gAsoUyQhOFJtp7f
# E1Be+RphYIihlOG/Sz1x0qnly8hoDBKPyMJrd59bqPGyMaT0xxHLbaBftJEna7+g
# kbdeJB6KLCWfUodQfyW04dR6mxKwOLFRK253DjEDl529H4f288cQv3dDJiWBgVWv
# Ngbe3+aF4JNh4HGye7JG0BFXuTd3L4gn9ulslZ2dc/as0frlHP8cQswDEWQvlYkt
# dY+5qwQJGi8e886Z5B/oymOBlG4jjnbChUjr71DEZ0wvfZHDmuF8/dlIdmXNa8Me
# GcBsgPgCJh4KTW0QiqdSB9KKWKTqtrRA5To61VxDWgpPZR2GsstJsCA8174CMk9a
# Lmy/YpCL2W47m9Y/dIoo+l793OFmUtD9UQkXE4F2UuhgR1h6eUF0s3N+yR/w8kKf
# yNuuE6l/rSPPObryW7xo+K/FCgZGGpDvvzeGl4fiEquNg79mN5YsjPtX7+gySyEI
# z4lYIHzY
# SIG # End signature block
