﻿##/*****************************************************************************
##Author                :     MohanRaj S
##Purpose               :     Display the list of services and their operations
##Created               :     19/10/2017
##Modified By		    :     Prabaharan.T

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyserverip=$TestInputs[2]
$proxyUsr=$TestInputs[3]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[4]
$rpmea=$TestInputs[5]
$topN_DD=$TestInputs[6]

$rpArr=$rpmea.Split('#')
$reportingNam=$rpArr[0]
$meaperiod=$rpArr[1]
$allowLocalUsrAct=$rpArr[2]
$allowLocalUsr=$rpArr[3].Split(',')

$appDetails=$TestInputs[7]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
$sessionOption = New-PSSessionOption -SkipRevocationCheck
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
    }
}
if($appDetails -and $appDetails -ne 'none'){
    Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
}else{
    Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $cred -PSSessionOption $sessionOption -WarningAction SilentlyContinue
}
$rptPath='O365/'+$reportingNam
try{
    if((Get-PSSession).Availability -eq 'Available' -and (Get-PSSession).State -eq 'Opened'){
        $sysDat=(Get-Date).ToUniversalTime()
        $endDat=$sysDat.AddMinutes(-60)
        $startDat=$endDat.AddMinutes(-$meaperiod)
        $uniqwrkLoad=@{}
        $uniqUserClientIpwrkLoad=@{}
	$uniqClientIp=@{}
        Try{
            $writUsrAct = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365UsrAct" -keyFileName "kO365UsrAct" -EgPath $egurkhaPath
            $curResCnt=0
            while($true){
                $results=Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat -SessionId ua -SessionCommand ReturnLargeSet -ResultSize 5000 |Select-Object  CreationDate,AuditData
                $results | Export-Csv $writUsrAct[1] -Append -Encoding $encTyp
                $curResCnt=$curResCnt+($results.count)
                if(($curResCnt -eq 50000) -or ($results.count -lt 5000)){
                    break
                }
            }
            $null=Protect-File  $writUsrAct[1] -Algorithm AES -KeyAsPlainText $writUsrAct[0] -RemoveSource
        }Catch{
	          $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$rptPath+'\'
          $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kO365UsrAct*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
            foreach($file in $fileRead){
                    $fileName=([String]$file.Name).Trim()
                    if([System.IO.File]::Exists(($egurkhaRprtPath+$fileName)) -eq 'True'){
                        Remove-Item $egurkhaRprtPath$fileName -Force
                    }
            }
	    }
        try{
            $readUsrAct=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365UsrAct" -keyFileName "kO365UsrAct" -EgPath $egurkhaPath
            if($readUsrAct -ne $null -and [System.IO.File]::Exists($readUsrAct[1]) -eq 'True'){
                $unProtctUsrAct=$readUsrAct[1] -replace (".csv",".dat") 
                $usrActPath=Unprotect-File $unProtctUsrAct -Algorithm AES -KeyAsPlainText $readUsrAct[0]	
                $a= import-csv $usrActPath -Encoding $encTyp
                Remove-Item $usrActPath
                Eg-DeleteFiles -FilePath $readUsrAct[2] -Pattern 'O365UsrAct' -InputFile $readUsrAct[3]
                Eg-DeleteFiles -FilePath $readUsrAct[2] -Pattern 'kO365UsrAct' -InputFile $readUsrAct[4]
            }
            [System.GC]::GetTotalMemory($true) | out-null
        }
        catch{
            $errmsg=$_.Exception.Message
            Write-Error -Message $errmsg
        }
        $UniqueClientIp=@()
        $UniqueUserId=@()
        $ExcludeActv='FileAccessed','FileCheckedIn','FileCheckedOut','FileCopied','FileDeleted','FileDeletedFirstStageRecycleBin','FileDeletedSecondStageRecycleBin','FileCheckOutDiscarded','FileDownloaded','FileModified','FileMoved','FileRenamed','FileRestored','FileUploaded','PageViewed','Search-Mailbox','UserLoggedIn','UserLoginFailed'        
        foreach($b in $a){
            try{
                $activity = $b.AuditData | ConvertFrom-Json | select Workload,Operation,UserId,ClientIP
                if($activity -match '::1' -or $activity -match '<null>' -or $activity.UserId -eq 'Not Available'){
                   continue
                }
            }catch{
            }
            $entryflag=$true
            if($allowLocalUsrAct -eq $true){
                if($allowLocalUsr -contains($activity.UserId) -and $ExcludeActv -contains($activity.Operation)){
                    $entryflag=$true
                }
            }
            else{
                if($allowLocalUsr -contains($activity.UserId) -and $ExcludeActv -contains($activity.Operation)){
                    $entryflag=$false
                }
            }
            if($entryflag -and $activity -ne "" -and $activity -ne $null -and $activity.ClientIP -ne $null){
	    		if($activity.ClientIP -ne ""){
				    $ClientIp=$activity.ClientIP
			    }else{
				    continue
			    }

           		$charCount=( $ClientIp.ToCharArray() | Where-Object {$_ -eq ':'} | Measure-Object).Count 
			    if($charCount -eq 1){
			        $ClientIp=$activity.ClientIP.Split(':')[0]
			        $ClientIp=$ClientIp.Replace("[","").Replace("]","")
			    }
			    $ClientIp=$ClientIp.Trim()
			    $uniqwrkLoadkey  = $activity.Workload+'~'+$activity.Operation.Replace(" ","_")
			    $uniqClientIpkey = $activity.Workload+'~'+$ClientIp
			    $ClientIpInnerKey= $activity.UserId+'~'+$ClientIp+'~'+$activity.Operation.Replace(" ","_")
			    $uniqUserIdkey   = $activity.Workload+'~'+$activity.UserId
			    $userIdInnerKey  = $ClientIp+'~'+$activity.UserId+'~'+$activity.Operation.Replace(" ","_")
                if(-not $UniqueUserId.Contains($activity.UserId.ToLower())){
                    $UniqueUserId+=$activity.UserId.ToLower()
                }
                if(-not $UniqueClientIp.Contains($ClientIp)){
                    $UniqueClientIp+=$ClientIp
                }
			    # Total Operations
		
			    if($uniqwrkLoad.ContainsKey($uniqwrkLoadkey)){
			        $uniqwrkLoad[$uniqwrkLoadkey]=[int]$uniqwrkLoad[$uniqwrkLoadkey]+1
			    }else{
			        $uniqwrkLoad.Add($uniqwrkLoadkey,1) 
			    }

                if($uniqUserClientIpwrkLoad.ContainsKey($activity.Workload)){
                    $tmpArray=$uniqUserClientIpwrkLoad[$activity.Workload]
                    if(-not $tmpArray[0].Contains($activity.UserId)){
                        $tmpArray[0]+=" "+$activity.UserId
                    }
                    if(-not $tmpArray[1].Contains($ClientIp)){
                        $tmpArray[1]+=" "+$ClientIp
                    }
			    }else{
                    [String[]]$myArray =$activity.UserId,$ClientIp
			        $uniqUserClientIpwrkLoad.Add($activity.Workload,$myArray)
			    }

                

			    # Client Ip

			    if($uniqClientIp.ContainsKey($activity.Workload)){
			        $tmpht=$uniqClientIp[$activity.Workload]
			        if($tmpht.ContainsKey($userIdInnerKey)){
				    $tmpht[$userIdInnerKey]=[int]$tmpht[$userIdInnerKey]+1
			        }else{
				    $tmpht.Add($userIdInnerKey,1)
			        }
			    }
			    else{
			        $tmpuniqClientIp = @{}
			        $tmpuniqClientIp.Add($userIdInnerKey,1)
			        $uniqClientIp.Add($activity.Workload,$tmpuniqClientIp) 
			    }
            }
        }
    $totOpr=0
    foreach($key in $uniqwrkLoad.keys){
        Write-Host 'Audit~' $key '~' $uniqwrkLoad[$key]
        $totOpr+=$uniqwrkLoad[$key]
    }

    foreach($key in $uniqUserClientIpwrkLoad.keys){
        Write-Host 'UsersCount~' $key '~' ($uniqUserClientIpwrkLoad[$key][0].Split(" ").Length)'~' ($uniqUserClientIpwrkLoad[$key][1].Split(" ").Length)
    }

    Write-Host 'Summary~' $totOpr ~ $uniqwrkLoad.Count ~ ($UniqueUserId | select -unique).Count ~ ($UniqueClientIp| select -unique).Count
    foreach($key in $uniqClientIp.keys){
        $uniqInnerht=$uniqClientIp[$key]
        $ipList = New-Object Collections.Generic.List[String]
        $userList = New-Object Collections.Generic.List[String]
		$in =$uniqInnerht.keys | sort { $uniqInnerht.$_ } -des
		foreach($inky in $in) {
            if($ipList.Count -ge [int]$topN_DD -and $userList.Count -ge [int]$topN_DD) {
                break;
            }
            $tokens = $inky.Split('~')
            if($ipList -notcontains $tokens[0]) {
                $ipList.Add($tokens[0])
            }
            if($userList -notcontains $tokens[1]) {
                $userList.Add($tokens[1])
            }
            Write-host 'DDAudit~' $key '#' $inky  '['$uniqInnerht[$inky]']'
        }
    }
}
$getSession=Get-PSSession -ErrorAction SilentlyContinue
if($getSession -ne $null -and $getSession -ne ''){
	Disconnect-ExchangeOnline -Confirm:$false
}
}catch
{    
	Write-Host 'Exception Occured in O365 UserActivity - ' $_.Exception.Message 
}
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUTM2SRFuf2HevlZwAVzZCsbDV
# GFSggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFEwwvy9T
# NAlx9cYx43P7MwFkeFljMA0GCSqGSIb3DQEBAQUABIICAIFa03c5M7gvFEq99I4k
# 1IDMOaVuNWB3rrqoSAzyE7eWzAhSUoF07ZRfo8LkcMUYC/uS9tOobarLs2Is2ZeB
# fFQAaO5FbdaJpWry2iQV8zigbGSrMhCedmvmlRutP+mzIOuxnCt38pFmi34UhS1z
# V8ghA9G+e2OJeTXDDA5REwQ3/Pyt6rxu8c44Re9KuAV1HCy0nNfK1Xv6I02PvDuP
# f/R30qt/mUeq0Ejh8MbKTHOUb4vHXhLKn2MPJqfd0h8BZhOd9nk8sKE8VBACAdd5
# Drdlnx52xDcd9uR+beyxwy2pOIXcjv5FTuwHXSYNmzOmTCn3yBdoeX/tAWzUtvB7
# AykpX0EZZb1clvSKagSbKR/kdF3mLJVVq9gor1nFmOD+9EEuR6sI14E0zUMkPgho
# 5hOs1pDIFNUOte5vplQrpngQS2/ZyJ6m8wFApQOV2GaO73ZtGmVXsHYIyrrem3pi
# CX3mKSwSCR7vBjEBmI4HFwgS37H+PaqGHWzEXY9CRMXgKG6VoyGiyF0uq2pZDKf/
# 60Mo6KDkPh/0c05bv/cjnRSfzG0cOVQSHyyVMZ+y5/hcxTUe5ZxzqXJIBu18VQla
# WHqTa9IRvFV9tc0SMdJZAOAWsqlpIGX56ReCU4gjyllFL6xdqQEx54rg5PEFbkSw
# VW/zFgCYGXXRb+LHDQ6oFXKgoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MTAw
# MlowLwYJKoZIhvcNAQkEMSIEIKN72Uq0Y6zkpC3o7yf4EFYZpgK7fZ+PGr7dhNOf
# I2llMA0GCSqGSIb3DQEBAQUABIICAEMDWeYrdTcV+NOdIJETdk8cEHToQP1rnY83
# kY0nr8/8ZSObEglnP/O2Wa/FEODyawdVYvB7FHenUHdXuvTZ7T04dGDgub6PgSI8
# FVTjCQOg1aczxHd4quIqZUyriOgLdF7AP/Twr9tx3iTUUsBsUEvaGJN7ES4F3OZy
# O2HFPZK4ihTShI47Qpift77PZrUpTOdAQWO3y+AdT/4/0f1/5IKoFVl8wSVhGiWG
# 8e4IPtLSjwJVkQNuhv5ijTePW7+BlK1Ws84mJkA1kNp5Z/eacCXdmFCeOgwC07Bd
# zvXsV12uChFkUTcaNiC8z5Dj3XOGEdtMWfUbnq14x2HPhuSUtJem+mtUhAZONzBb
# THQHJXOrPxBcjdF+6QWRpO4ssL0whHm0rWYuyECg05COs3+HlH++YqQYPM2XsOLX
# Kt3YfuIRNJueXDZ+NeaWbm38YzfRfKL0ZMBDvv4bzEUSgEI9xYGZqojamtaJBaxl
# mlM/c2qPYePdprbRtcApUnCg+iw8TUMoNUkt2GIV8Q1RUDCCUhP0y5BdgU2isdc+
# mlphf/TrUoA7D2qIOb6LGxGoop7iwJstn7DC6pjIJY/btxLsgIlQJQLIk9dU5IrX
# 6EpPhl8BnkChVMRIN2/8z6wadjmTF1+iIR+E7/k6frPPRS7dYwBFMeOinkfJjHi7
# 9kBgwBPM
# SIG # End signature block
