﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$certDir=$egurkhaPath+'\agent\O365\AppInfo'
if(!(Test-Path -Path $certDir)){
    $null=New-Item -ItemType directory -Path $certDir
}
$logFile=$certDir+'\O365_AppPrerequisites.log'

$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
if($chkWinrm -notmatch 'Basic=true'){
    Write-Host 'WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE...' -ForegroundColor Red
    O365-WriteLog -writString ("WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE..."+$chkWinrm) -LogPath $logFile -ReportingName 'ERROR'
    exit
}

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
$msGrphAppName=''
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('Graph_APP_Name')){
            $msGrphAppName=$line.Replace('Graph_APP_Name=','')
            break;
        }  
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExist=$true
    }
}

$code = @"
[DllImport("user32.dll", CharSet = CharSet.Unicode)]
public static extern IntPtr SendMessage(IntPtr hWnd, 
    int msg, IntPtr wParam, string lParam);  
public const int EM_SETCUEBANER = 0x1501;
"@
$Win32Helpers = Add-Type -MemberDefinition $code -Name "Win32Helpers" -PassThru
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")

$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button

$pfxDtlsLbl=New-Object System.Windows.Forms.Label
$mfGrpLbl=New-Object System.Windows.Forms.Label
$mfGrpTxtBx=New-Object System.Windows.Forms.TextBox
$mfMemLbl=New-Object System.Windows.Forms.Label
$mfMemTxtBx=New-Object System.Windows.Forms.TextBox
$grphTntLbl=New-Object System.Windows.Forms.Label
$grphTntTxtBx=New-Object System.Windows.Forms.TextBox
$grphAppNamLbl=New-Object System.Windows.Forms.Label
$grphAppNamTxtBx=New-Object System.Windows.Forms.TextBox

$prxyDtlsLbl=New-Object System.Windows.Forms.Label
$prxyHostLbl=New-Object System.Windows.Forms.Label
$prxyPortLbl=New-Object System.Windows.Forms.Label
$prxyUsrLbl=New-Object System.Windows.Forms.Label
$prxyPassLbl=New-Object System.Windows.Forms.Label
$prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
$prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
$prxyPassTxtBx=New-Object System.Windows.Forms.TextBox

$formsize = 320

$form.Controls.Add($mfGrpLbl)
$form.Controls.Add($mfGrpTxtBx)
$form.Controls.Add($mfMemLbl)
$form.Controls.Add($mfMemTxtBx)
$form.Controls.Add($grphTntLbl)
$form.Controls.Add($grphTntTxtBx)
$form.Controls.Add($grphAppNamLbl)
$form.Controls.Add($grphAppNamTxtBx)

$form.Controls.Add($prxyDtlsLbl)
$form.Controls.Add($prxyHostLbl)
$form.Controls.Add($prxyHostTxtBx)
$form.Controls.Add($prxyPortLbl)
$form.Controls.Add($prxyPortTxtBx)
$form.Controls.Add($prxyUsrLbl)
$form.Controls.Add($prxyUsrTxtBx)
$form.Controls.Add($prxyPassLbl)
$form.Controls.Add($prxyPassTxtBx)

$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "390 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'O365 Limiting Access To Mail Flow Users'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

$mfGrpLbl.Location="38,15"
$mfGrpLbl.Anchor="Bottom, Left"
$mfGrpLbl.Text="&Group Name"
$mfGrpLbl.Size="115,20"
$mfGrpTxtBx.Location="152,15"
$mfGrpTxtBx.Name="grpNam"
$mfGrpTxtBx.Size="200,20"
$mfGrpTxtBx.Text=""

$mfMemLbl.Location="38,45"
$mfMemLbl.Anchor="Bottom, Left"
$mfMemLbl.Text="&Group Member(s)"
$mfMemLbl.Size="115,20"
$mfMemTxtBx.Location="152,45"
$mfMemTxtBx.Name="memNam"
$mfMemTxtBx.Size="200,20"
$mfMemTxtBx.Text=""
$mfMemTxtBx.add_HandleCreated({
    $Win32Helpers::SendMessage($mfMemTxtBx.Handle,$Win32Helpers::EM_SETCUEBANER,[IntPtr]0, "abc@domain.com,xyz@domain.com")
})

$grphTntLbl.Location="38,75"
$grphTntLbl.Anchor="Bottom, Left"
$grphTntLbl.Text="&Tenant Name"
$grphTntLbl.Size="115,20"
$grphTntTxtBx.Location="152,75"
$grphTntTxtBx.Name="tntNam"
$grphTntTxtBx.Size="200,20"
$grphTntTxtBx.Text=""

$grphAppNamLbl.Location="38,105"
$grphAppNamLbl.Anchor="Bottom, Left"
$grphAppNamLbl.Text="&MsGraph App Name"
$grphAppNamLbl.Size="115,20"
$grphAppNamTxtBx.Location="152,105"
$grphAppNamTxtBx.Name="appNam"
$grphAppNamTxtBx.Size="200,20"
$grphAppNamTxtBx.Text=$msGrphAppName

$prxyDtlsLbl.Location="38,140"
$prxyDtlsLbl.Anchor="Bottom, Left"
$prxyDtlsLbl.Text="&Proxy Details :"
$prxyDtlsLbl.Size="100,20"
$prxyHostLbl.Location="68,165"
$prxyHostLbl.Anchor="Bottom, Left"
$prxyHostLbl.Text="&Host IP"
$prxyHostLbl.Size="80,20"
$prxyHostTxtBx.Location="152,165"
$prxyHostTxtBx.Name="ProxyHost"
$prxyHostTxtBx.Size="120,20"
$prxyHostTxtBx.Text="none"
$prxyPortLbl.Location="275,165"
$prxyPortLbl.Anchor="Bottom, Left"
$prxyPortLbl.Text="&Port"
$prxyPortLbl.Size="25,20"
$prxyPortTxtBx.Location="300,165"
$prxyPortTxtBx.Name="Port"
$prxyPortTxtBx.Size="50,20"
$prxyPortTxtBx.Text="none"
$prxyUsrLbl.Location="68,190"
$prxyUsrLbl.Anchor="Bottom, Left"
$prxyUsrLbl.Text="&Username"
$prxyUsrLbl.Size="80,20"
$prxyUsrTxtBx.Location="152,190"
$prxyUsrTxtBx.Name="ProxyUser"
$prxyUsrTxtBx.Size="200,20"
$prxyUsrTxtBx.Text="none"
$prxyPassLbl.Location="68,220"
$prxyPassLbl.Anchor="Bottom, Left"
$prxyPassLbl.Text="&Password"
$prxyPassLbl.Size="80,20"
$prxyPassTxtBx.Location="152,220"
$prxyPassTxtBx.Name="ProxyPass"
$prxyPassTxtBx.Size="200,20"
$prxyPassTxtBx.Text="none"
$prxyPassTxtBx.PasswordChar='*'


$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "150, 264"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'
$frmDialog=$form.ShowDialog()

if($frmDialog -eq 'OK' ){
    $mfGrpName=$mfGrpTxtBx.Text
    $mfGrpMembersStr=$mfMemTxtBx.Text
    $mfTntName=$grphTntTxtBx.Text
    $mfMsGrphNam=$grphAppNamTxtBx.Text
    $proxyHost=$prxyHostTxtBx.Text
    $proxyPort=$prxyPortTxtBx.Text
    $proxyUsr=$prxyUsrTxtBx.Text
    $proxyPass=$prxyPassTxtBx.Text
    if($mfGrpName -eq "" -or $mfGrpMembersStr -eq '' -or $proxyHost -eq '' -or $proxyPort -eq '' -or $proxyUsr -eq '' -or $proxyPass -eq ''){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red
        exit
    }
}else{
    Write-Host 'Exiting...'
    exit
}

$grphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $grphDir)){
    Write-Host 'MSGraph folder is not available!'
    exit
}

O365-WriteLog -writString  "---------------------------------------------------------------" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString "" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString  "     ******** O365 Limiting Access to MailFlow users execution started ***********   " -LogPath $logFile -ReportingName 'INFO'
Write-Host "     ******** O365 Limiting Access to MailFlow users execution started ***********   "

$sessionOption = New-PSSessionOption -SkipRevocationCheck
$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType IEConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
    }
}

Connect-ExchangeOnline -PSSessionOption $sessionOption

$isRunNewDist=$false
$existGrpMemStr=''
$mfGrpMembers=@()
$PolicyGrpId=''
Try{
    $existGrpMem=Get-DistributionGroupMember -Identity $mfGrpName -ErrorAction Stop |select * 
    foreach($emem in $existGrpMem){
        $existGrpMemStr+='~'+$emem.PrimarySmtpAddress
    }
    Write-Host "$mfGrpName - Group exists!" -ForegroundColor Green
    O365-WriteLog -writString  "$mfGrpName - Group exists!" -LogPath $logFile -ReportingName 'INFO'
    $mfGrpMembersArr=$mfGrpMembersStr.Split(',')
    foreach($mem in $mfGrpMembersArr){
        if($existGrpMemStr -notmatch $mem){  
            $mfGrpMembers+=$mem
        }
    }
    if($mfGrpMembers.Count -gt 0){
        foreach($grpmem in $mfGrpMembers){
            Add-DistributionGroupMember -Identity $mfGrpName -Member $grpmem
            Write-Host "$mfGrpMembers - member(s) is added to $mfGrpName" -ForegroundColor Green
            O365-WriteLog -writString  "$mfGrpMembers - member(s) is added to $mfGrpName" -LogPath $logFile -ReportingName 'INFO'
        }
    }else{
        Write-Host "$mfGrpMembers - member(s) already available in $mfGrpName" -ForegroundColor Green
        O365-WriteLog -writString  "$mfGrpMembers - member(s) already available in $mfGrpName" -LogPath $logFile -ReportingName 'INFO'
    }
}Catch{
    $msg=$_.Exception.Message
    $errStr="`'$mfGrpName`' couldn't be found"
    if($msg -match $errStr){
        Write-host "Mail-enabled Security Group not found" -ForegroundColor Red
        $isRunNewDist=$true
    }else{
        exit
    }
}

if($isRunNewDist){
    Write-Host "$mfGrpName - Group creation started"
    O365-WriteLog -writString  "$mfGrpName - Group creation started" -LogPath $logFile -ReportingName 'INFO'

    $mfGrpMembers=$mfGrpMembersStr.Split(',')
    Try{
        $newGrp= New-DistributionGroup -Name $mfGrpName -Alias $mfGrpName -Type "Security" -Members $mfGrpMembers
        if($newGrp.Name -eq $mfGrpName){
            Write-Host "$mfGrpName - Group created" -ForegroundColor Green
            O365-WriteLog -writString  "$mfGrpName - Group created" -LogPath $logFile -ReportingName 'INFO'
            $PolicyGrpId=$newGrp.PrimarySmtpAddress
        }
    }Catch{
        Write-host "[Group Creation] Exception Occurred - $message." -ForegroundColor Red
        O365-WriteLog -writString  "[Group Creation] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }
}

$mfAppId=''
$keyPath=$grphDir+'\GraphDetailsKey.dat'
$unProtFile=$grphDir+'\GraphDetails.dat'
if(Test-Path $unProtFile -PathType Leaf){
    $unProtPath=$grphDir+'\GraphDetails.dat'
    $kvalue=Get-Content -Path $keyPath
    Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
}
$grphDtlPath=$grphDir+'\GraphDetails.txt'
if(Test-Path $grphDtlPath -PathType Leaf){
    $lines=Get-Content -Path $grphDtlPath
    Remove-Item $grphDtlPath
    $isAppIdExist=$false
    $chkNam=('['+$mfMsGrphNam+'-'+$mfTntName).Trim()
    foreach($line in $lines){
        if($isAppIdExist){
            if($line.StartsWith('client_id')){
                $mfAppId=$line.Replace('client_id~','').Trim()
                break;
            }
        }
        if($line.StartsWith($chkNam)){
            $isAppIdExist=$true
        }
    }
}
if($mfGrpMembers.Count -eq 0){
    $mfGrpMembers=$mfGrpMembersStr.Split(',')
}
$identity=[String]$mfGrpMembers[0]

Start-Sleep -Seconds 10

if($mfAppId -ne ''){
    if($PolicyGrpId -ne ''){
        Try{
            $appPolicy=New-ApplicationAccessPolicy -AppId $mfAppId -PolicyScopeGroupId $PolicyGrpId -AccessRight 'RestrictAccess' -Description "Restrict this app to mailflow users"
            if($appPolicy.AppId -eq $mfAppId){
                Write-Host "New Application Access Policy is created for app ($mfAppId)..." -ForegroundColor Green
                O365-WriteLog -writString  "New Application Access Policy is created for app ($mfAppId)..." -LogPath $logFile -ReportingName 'INFO'
            }
        }
        Catch{
            Write-host "[New-ApplicationAccessPolicy] Exception Occurred - $message." -ForegroundColor Red
            O365-WriteLog -writString  "[New-ApplicationAccessPolicy] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
        }
    }
    else{
        Write-Host "PolicyGroupId is empty and Group exists..." -ForegroundColor Red
        O365-WriteLog -writString  "PolicyGroupId is empty and Group exists..." -LogPath $logFile -ReportingName 'INFO'
    }
    Start-Sleep -Seconds 5
    Try{
        $tstAppPolicy=Test-ApplicationAccessPolicy -Identity $identity -AppId $mfAppId
        if($tstAppPolicy.AppId -eq $mfAppId){
            Write-Host "New Application Access Policy is verified successfully" -ForegroundColor Green
            O365-WriteLog -writString  "New Application Access Policy is verified successfully" -LogPath $logFile -ReportingName 'INFO'
        }
    }Catch{
        Write-host "[Test-ApplicationAccessPolicy] Exception Occurred - $message." -ForegroundColor Red
        O365-WriteLog -writString  "[Test-ApplicationAccessPolicy] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }
}else{
    Write-Host "MsGraph Application not found" -ForegroundColor Red
    O365-WriteLog -writString  "MsGraph Application not found" -LogPath $logFile -ReportingName 'INFO'
}

$getSession=Get-PSSession -ErrorAction SilentlyContinue
if($getSession -ne $null -and $getSession -ne ''){
	Disconnect-ExchangeOnline -Confirm:$false
}

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

O365-WriteLog -writString  "     ******** O365 Limiting Access to MailFlow users execution ended ***********   " -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString  "---------------------------------------------------------------" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString "" -LogPath $logFile -ReportingName 'INFO'
# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUv/PAUuSfMhfch2ArN6wmsDEw
# N6qggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFH61q4mk
# bukZp9+e2AphS3LchNJDMA0GCSqGSIb3DQEBAQUABIICAEjU/y1L45m5h/9RVUK2
# uFz1lPcacDSkR/V/gU2REtEBarmcGgpTwOy3em50z7lvyaTO/zlSsLfX/WEhrCCC
# p2t+2nODZnx/thhvOpBv1lxzPrND7q7+drhxSD2h5gteahf1Gk0kX08TVzDYchlz
# NWEfOt8enluuBEyv/CryAt4vi3KKqdVRnZ6XwDBihDqeHBXu3zHBGxjo2S8OPGv4
# N2sWFDFavlbdnQqH4yr8wYpPB988op8RDKL4UWZyJlAH8zdjZb+JvIzW32AH/8g7
# 3Dv2x1qhc5iCy2qvP4meO0vvsAqwhIiCJxPv5/USAkIUY9o3pzoeHA90xyqVJnxd
# cMaAKkNKhwpdAWqmGBeELPopjTFjF6RDecLX57L277qE+uPh4omD/tC9Be4u4vLL
# UdUNHsBXZh3qCJmcjb7uNrFbnUdgc6bU7gjzR4p+HmNCUbArIk1CxLZZJGTWuf+N
# GaKzcnSlrVV9PhxySwEEKGed5DmedSLmTyvZMilrvnQ1ZpDCSJeGoWNNVaFeqDg+
# +uGoBdHU1p5MKYZTcp1seQXbogcRiZU9gpbkjMSBmdnJ29VuygwYW3ZM71KoNZV5
# kax4FDDiKoi9lIjiIprzFJoAkZlYuF+ySS6W+sLDMbKdecIViGIL9PW+MpJ6xn0Z
# hqRP/pvV9JyPD+TVJaLaHzdYoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkwNTA4NTI1
# M1owLwYJKoZIhvcNAQkEMSIEIHW7i3W3aB+gp4kgtGSxkY++cbvJxv1qHfF/oGtK
# tHZAMA0GCSqGSIb3DQEBAQUABIICAIhVNWv74l0oGTnmXtnKfNZv6SOeUliDX0/N
# VQbIMJ1fxx/UjEqBhd1dGgr9GNTzXTzuMh49rxzE/6p4HjDzhHw+uQCtsJJXHPLu
# pjPSRbtyAc8u+SjqPdLcey0ETy8O25FyHJaNVXlOHYfBuXTwxL+9vkqOGM6pAy9u
# IPER057EyRnBq/qfMu10DcDWwuyvQyC+j4k8Ru9WidJZ9nsH6hQl+JMTzq3fWDLW
# S2zCAzo1dpqAvP8vqZVc1rxInHw5j9D4u2q/wrA4lCLXYXWZxUSrXKfEMd4ySHl2
# w2rhGdpI+nfbyg+rsOSjw/jxaNlQR6Uq/PbdlVNbspgXJxiqHO5sq1k+fGyzU9eX
# hhvm/GToPEx08JpjjHe+Ef0GyNYUjaENOawbBbzhu44nRiSD+OdhtDDYPXMnhojK
# 20zSFTWVBrhwkeuIWc1UWkkfYRoK8awjdo7/SQgyyIMZAp670bhIxrgw7ECWIua4
# ToXXeEDbKgqoc7Uo+dSTL+ioGNDu1C9mYAXVgDkCLNxgOaicabNfBZcCD1Q6ZvQ+
# JWT5/kZkXWeiPpz0l8IwOODSEJP43mlEwQAP5ziV3bCHfY9aoZb2xC6+ujFR+r9u
# +Z5ArrAcBAgr29uqCUZv2SCVN7pEfx5NKOBNq5DrWbMZOMSBdgCPSUZG4n6BtSjg
# G7pzE2JC
# SIG # End signature block
