﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

Function GetRequiredPermissions($requiredDelegatedPermissions, $requiredApplicationPermissions, $reqsp) {
    $sp = $reqsp
    $appid = $sp.AppId
    $requiredAccess = New-Object Microsoft.Open.AzureAD.Model.RequiredResourceAccess
    $requiredAccess.ResourceAppId = $appid
    $requiredAccess.ResourceAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.ResourceAccess]
    if ($requiredDelegatedPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.Oauth2Permissions -requiredAccesses $requiredDelegatedPermissions -permissionType "Scope"
    } 
    if ($requiredApplicationPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.AppRoles -requiredAccesses $requiredApplicationPermissions -permissionType "Role"
    }
    return $requiredAccess
}

Function AddResourcePermission($requiredAccess, $exposedPermissions, $requiredAccesses, $permissionType) {
    foreach ($permission in $requiredAccesses) {
        $reqPermission = $null
        $reqPermission = $exposedPermissions | Where-Object {$_.Value -contains $permission.Value}
        $resourceAccess = New-Object Microsoft.Open.AzureAD.Model.ResourceAccess
        $resourceAccess.Type = $permissionType
        $resourceAccess.Id = $reqPermission.Id    
        $requiredAccess.ResourceAccess.Add($resourceAccess)
    }
}


$certDir=$egurkhaPath+'\agent\O365\AppInfo'
if(!(Test-Path -Path $certDir)){
    $null=New-Item -ItemType directory -Path $certDir
}

$grphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $grphDir)){
    $null=New-Item -ItemType directory -Path $grphDir
}
$logFile=$grphDir+'\O365_GraphApi.log'


$tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
$iniContent=get-content -Path $tstIniPath
$lineStr=''
$isReadStrt=$false
$isMASupport=$false
foreach($line in $iniContent){
    if($isReadStrt -and $line.StartsWith('Modern_Auth_Supported=')){
        if($line -match 'true'){
            $isMASupport=$true
            $isReadStrt=$false
        }
    }
    if($line.StartsWith('[Modern_Auth_Support')){
        $isReadStrt=$true
    }
}

if($isMASupport){
    $certBasedRes=[system.windows.forms.messagebox]::show(("Connect to O365 using `"Modern Authentication`"?" -join "`n"),"O365 Graph API",'YesNo')
}else{
    $certBasedRes='No'
}


######***GUI****#######
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()

   $form = New-Object System.Windows.Forms.Form
    $buttonOK = New-Object System.Windows.Forms.Button
    $textbox1=New-Object System.Windows.Forms.TextBox
    $label1=New-Object System.Windows.Forms.Label
    $textbox2=New-Object System.Windows.Forms.TextBox
    $label2=New-Object System.Windows.Forms.Label

    $textbox3=New-Object System.Windows.Forms.TextBox
    $label3=New-Object System.Windows.Forms.Label
    $textbox4=New-Object System.Windows.Forms.TextBox
    $label4=New-Object System.Windows.Forms.Label
    $label5=New-Object System.Windows.Forms.Label

    $O365DtlsLbl=New-Object System.Windows.Forms.Label
    $O365UsrLbl=New-Object System.Windows.Forms.Label
    $O365UsrTxtBx=New-Object System.Windows.Forms.TextBox
    $O365PassLbl=New-Object System.Windows.Forms.Label
    $O365PassTxtBx=New-Object System.Windows.Forms.TextBox
    
    $totalvalues = ($onames.count)
    $formsize = 270 + (30 * $totalvalues)
    $flowlayoutsize = 10 + (30 * $totalvalues)
    $buttonplacement = 210 + (30 * $totalvalues)

    $form.Controls.Add($O365DtlsLbl)
    $form.Controls.Add($O365UsrLbl)
    $form.Controls.Add($O365UsrTxtBx)
    $form.Controls.Add($O365PassLbl)
    $form.Controls.Add($O365PassTxtBx)
    $form.Controls.Add($label5)
    $form.Controls.Add($label1)
    $form.Controls.Add($textbox1)
    $form.Controls.Add($label2)
    $form.Controls.Add($textbox2)
    $form.Controls.Add($label3)
    $form.Controls.Add($textbox3)
    $form.Controls.Add($label4)
    $form.Controls.Add($textbox4)
    $form.Controls.Add($buttonOK)
    $form.AcceptButton = $buttonOK
    $form.AutoScaleDimensions = '8, 17'
    $form.AutoScaleMode = 'Font'
    $form.ClientSize = "380 , $formsize"
    $form.FormBorderStyle = 'FixedDialog'
    $form.Margin = '5, 5, 5, 5'
    $form.MaximizeBox = $False
    $form.MinimizeBox = $False
    $form.Name = 'form1'
    $form.StartPosition = 'CenterScreen'
    $form.Text = 'O365 Graph API'
    $form.add_Load($($form_Load))

    $O365DtlsLbl.Location="38,15"
    $O365DtlsLbl.Anchor="Bottom, Left"
    $O365DtlsLbl.Text="&O365 Details :"
    $O365DtlsLbl.Size="100,20"

    $O365UsrLbl.Location="38,38"
    $O365UsrLbl.Anchor="Bottom, Left"
    $O365UsrLbl.Text="&Username"
    $O365UsrLbl.Size="60,20"

    $O365UsrTxtBx.Location="105,38"
    $O365UsrTxtBx.Name="O365User"
    $O365UsrTxtBx.Size="200,20"
    $O365UsrTxtBx.Text="none"

    $O365PassLbl.Location="38,67"
    $O365PassLbl.Anchor="Bottom, Left"
    $O365PassLbl.Text="&Password"
    $O365PassLbl.Size="60,20"

    $O365PassTxtBx.Location="105,67"
    $O365PassTxtBx.Name="O365Pass"
    $O365PassTxtBx.Size="200,20"
    $O365PassTxtBx.Text="none"
    $O365PassTxtBx.PasswordChar='*'

    if($certBasedRes -eq 'Yes'){
        $O365DtlsLbl.Enabled=$false
        $O365UsrLbl.Enabled=$false
        $O365UsrTxtBx.Enabled=$false
        $O365PassLbl.Enabled=$false
        $O365PassTxtBx.Enabled=$false
    }else{
        $O365DtlsLbl.Enabled=$true
        $O365UsrLbl.Enabled=$true
        $O365UsrTxtBx.Enabled=$true
        $O365PassLbl.Enabled=$true
        $O365PassTxtBx.Enabled=$true
    }

    $label5.Location="38,95"
    $label5.Anchor="Bottom, Left"
    $label5.Text="&Proxy Details :"
    $label5.Size="100,20"

    $label1.Location="38,118"
    $label1.Anchor="Bottom, Left"
    $label1.Text="&Host IP"
    $label1.Size="60,20"

    $textbox1.Location="105,118"
    $textbox1.Name="ProxyHost"
    $textbox1.Size="120,20"
    $textbox1.Text="none"

    $label2.Location="228,118"
    $label2.Anchor="Bottom, Left"
    $label2.Text="&Port"
    $label2.Size="25,20"

    $textbox2.Location="255,118"
    $textbox2.Name="Port"
    $textbox2.Size="50,20"
    $textbox2.Text="none"

    $label3.Location="38,145"
    $label3.Anchor="Bottom, Left"
    $label3.Text="&Username"
    $label3.Size="60,20"

    $textbox3.Location="105,145"
    $textbox3.Name="ProxyUser"
    $textbox3.Size="200,20"
    $textbox3.Text="none"

    $label4.Location="38,171"
    $label4.Anchor="Bottom, Left"
    $label4.Text="&Password"
    $label4.Size="60,20"

    $textbox4.Location="105,171"
    $textbox4.Name="ProxyPass"
    $textbox4.Size="200,20"
    $textbox4.Text="none"
    $textbox4.PasswordChar='*'

    $buttonOK.Anchor = 'Bottom, Right'
    $buttonOK.DialogResult = 'OK'
    $buttonOK.Location = "150, $buttonplacement"
    $buttonOK.Margin = '4, 4, 4, 4'
    $buttonOK.Name = 'buttonOK'
    $buttonOK.Size = '100, 30'
    $buttonOK.TabIndex = 0
    $buttonOK.Text = '&OK'

    $frmDialog=$form.ShowDialog()
######### END ###########
if($frmDialog -eq 'OK'){
    $userName=$O365UsrTxtBx.Text
    $password=$O365PassTxtBx.Text
    $proxyHost=$textbox1.Text
    $proxyPort=$textbox2.Text
    $proxyUsr=$textbox3.Text
    $proxyPass=$textbox4.Text
    $proxyServer='none'
    
    if($proxyHost -eq "" -or $proxyPort -eq "" -or $proxyUsr -eq "" -or $proxyPass -eq ""){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
        O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
        exit
    }
    if($certBasedRes -eq 'No' -and ($userName -eq 'none' -or $password -eq 'none' -or $userName -eq '' -or $password -eq '')){
        Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
        O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
        exit
    }
}
else{
    Write-Host 'Exiting...'
    exit
}

$edTim1=Get-Date
O365-WriteLog -writString "O365GraphAPI started at $edTim1" -LogPath $logFile -ReportingName 'INFO'

$proxyserverip=$proxyHost+':'+$proxyPort
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

if($certBasedRes -eq 'Yes'){
    $azureAD=Connect-AzureAD
    $iniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
    $orgNam=$iniDomainDtls.Name
    $tenantId=$azureAD.TenantId
}else{
    $cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','O365China')
    $com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','O365Default')
    $de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','O365GermanyCloud')
    $us=@('USGovernment','None','O365USGovDoD')
    $azureCloud=$userName.Substring($userName.LastIndexOf('.')+1) 
    $azureCloudArr=@()
    if($azureCloud -eq 'com'){$azureCloudArr=$com}
    elseif($azureCloud -eq 'cn'){$azureCloudArr=$cn}
    elseif($azureCloud -eq 'de'){$azureCloudArr=$de}
    elseif($azureCloud -eq 'us'){$azureCloudArr=$us}  
    else{$azureCloudArr=$com}

    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAd  -AzureEnvironment $azureCloudArr[0] -Credential $credential

    $iniDomainDtls=Get-AzureADDomain | Where-Object{$_.IsInitial -eq 'True'} | select *
    $orgNam=$iniDomainDtls.Name
    $tenantId=$azureAD.TenantId
}

#######
$graphAppStr=''
$chkGrphDir=$egurkhaPath+'\agent\O365\MsGraph'
if(Test-Path -Path $chkGrphDir){
    $chkKeyPath=$chkGrphDir+'\GraphDetailsKey.dat'
    $chkGrphDatFile=$chkGrphDir+'\GraphDetails.dat'
    if(Test-Path -Path $chkGrphDatFile -PathType Leaf){
        $kvalue=Get-Content -Path $chkKeyPath
        Unprotect-File $chkGrphDatFile -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        $grphDtlTxtFile=$chkGrphDir+'\GraphDetails.txt'
        if(Test-Path $grphDtlTxtFile -PathType Leaf){
            $txtLines=Get-Content -Path $grphDtlTxtFile
            foreach($txtLine in $txtLines){
                $chkEndsWith=$orgNam+']'
                if($txtLine.EndsWith($chkEndsWith)){
                    $graphAppStr=([String]$txtLine.Split('-')[0]).Replace('[','').Trim()
                }
            }
            Remove-Item -Path $grphDtlTxtFile
        }
    }
}
if($graphAppStr -ne ''){
    $chkConfigFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
    $chkLines=get-content -Path $chkConfigFile
    $isChkExist=$false
    $FileModified = @()
    foreach ($line in $chkLines){
        if($isChkExist -and $line.StartsWith('Graph_APP_Name')){
            $FileModified +=('Graph_APP_Name='+$graphAppStr)
            continue
        }
        if($line.StartsWith('[O365EnableCertBasedAuthentication')){
            $isChkExist=$true
        }
        $FileModified += $line
    }
    $FileModified | Out-File $chkConfigFile
}
########

$grph_AppName=''
$grph_srchStrArr=@()
$grph_reqPermissionArr=@()
$apiHash=@{}
$permissionHash=@{}
$azureEnv=''

$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
$isO365MailSR='false'
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('Monitor_O365_Mail_Sender_Receiver')){
           $isO365MailSR=$line.Replace('Monitor_O365_Mail_Sender_Receiver=','')
        }
        if($line.StartsWith('O365_MailFlow_Graph_Permissions') -and $isO365MailSR -eq 'true'){
            $o365MailSRPer=$line.Replace('O365_MailFlow_Graph_Permissions=','')
            $o365MailSRPer=$o365MailSRPer.Split('~')
            foreach($reqPerSRArr in $o365MailSRPer){
                $grph_reqPermissionArr+=$reqPerSRArr
            }
        }
        if($line.StartsWith('Graph_APP_Name')){
            $grph_AppName=$line.Replace('Graph_APP_Name=','')
        }
        if($line.StartsWith('Graph_APIs')){
            $apiStr=$line.Replace('Graph_APIs=','')
            $apiStr=$apiStr.Split('~')
            foreach($apiArr in $apiStr){
                $grph_srchStrArr+=$apiArr
            }
        }
        if($line.StartsWith('Graph_Permissions')){
            $reqPerStr=$line.Replace('Graph_Permissions=','')
            $reqPerStr=$reqPerStr.Split('~')
            foreach($reqPerArr in $reqPerStr){
                $grph_reqPermissionArr+=$reqPerArr
            }  
        }
        if($line.StartsWith('AAD_Env')){
           $azureEnv=$line.Replace('AAD_Env=','')
           break;
        }
        
    }
    if($line.StartsWith('[O365EnableCertBasedAuthentication')){
        $isExist=$true
    }
}

$apiHash.Add($grph_AppName,$grph_srchStrArr)
$permissionHash.Add($grph_AppName,$grph_reqPermissionArr)

foreach($appName in $apiHash.Keys){

    $srchStrArr=$apiHash[$appName]
    $reqPermissionArr=$permissionHash[$appName]

    $existingapp = $null
    $existingapp = get-azureadapplication -Filter "DisplayName eq '$appName'"
    if ($existingapp) {
        Write-host "Existing AzureAD application Removed"
        O365-WriteLog -writString  "Existing AzureAD application Removed" -LogPath $logFile -ReportingName 'INFO'
        Remove-Azureadapplication -ObjectId $existingApp.objectId
    }

    $spArr=[System.Collections.ArrayList]@()
    $requiredResourcesAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.RequiredResourceAccess]
    foreach($str in $srchStrArr){
        $srchStr=$str -split('#')
        $appArray = [System.Collections.ArrayList]@()
        $delArray = [System.Collections.ArrayList]@()
        $svcPrincipal=Get-AzureADServicePrincipal -SearchString $srchStr[1] | Where-Object {$_.DisplayName -eq $srchStr[1]}

        $spArr.Add($svcPrincipal)
        for($i=0;$i -lt $reqPermissionArr.Length;$i++ ){
            if($reqPermissionArr[$i].StartsWith($srchStr[0])){
                $grStr=$srchStr[0].ToString().Length
                $tmpnam=$srchStr[0]
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('App')){
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $appArray.Add($displayNam) 
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('Del')){     
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $delArray.Add($displayNam)
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                $appValue=$svcPrincipal.AppRoles | Where-Object{$_.DisplayName -in $appArray}
                $delValue=$svcPrincipal.Oauth2Permissions | Where-Object{$_.AdminConsentDisplayName -in $delArray}
                $azureAppPermissions = GetRequiredPermissions -reqsp $svcPrincipal -requiredApplicationPermissions $appValue -requiredDelegatedPermissions $delValue
                $requiredResourcesAccess.Add($azureAppPermissions)
            }
        }
    }
    $startDate = (Get-Date)
    $endDate = $startDate.AddYears(2)
    $KeyDesc='SecreteG'
    Try{
        $aadApplication = New-AzureADApplication -DisplayName $appName -RequiredResourceAccess $requiredResourcesAccess
        Write-host "New AzureAD application created"
        O365-WriteLog -writString  "New AzureAD application created" -LogPath $logFile -ReportingName 'INFO'

        $tmpCreVal=New-AzureADApplicationPasswordCredential -ObjectId $aadApplication.ObjectId -StartDate $startDate -EndDate $endDate -CustomKeyIdentifier $KeyDesc
        Write-host "Secret key generated"
        O365-WriteLog -writString  "Secret key generated" -LogPath $logFile -ReportingName 'INFO'

        $servicePrincipal = New-AzureADServicePrincipal -AppId $aadApplication.AppId      
        foreach ($app in $requiredResourcesAccess){   
            $reqAppSP = $spArr | Where-Object {$_.appid -contains $app.ResourceAppId}  
            foreach ($resource in $app.ResourceAccess) {
                if ($resource.Type -match "Role") {
                    New-AzureADServiceAppRoleAssignment -ObjectId $serviceprincipal.ObjectId -PrincipalId $serviceprincipal.ObjectId -ResourceId $reqAppSP.ObjectId -Id $resource.Id
                }
            }      
        }
        Write-host "permissions are configured to App.."
        O365-WriteLog -writString  "permissions are configured to App.." -LogPath $logFile -ReportingName 'INFO'
        Get-AzureADOAuth2PermissionGrant -All $true
        Write-host "Admin consent granted to permissions"
        O365-WriteLog -writString  "Admin consent granted to permissions" -LogPath $logFile -ReportingName 'INFO'
    }
    Catch{
        $message= $_.Exception.Message + $_.ScriptStackTrace 
        Write-host "[App Permissions] Exception Occurred - $message."
        O365-WriteLog -writString  "[App Permissions] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
    }

    $appId=$aadApplication.AppId

    $client_secret=$tmpCreVal.Value
    $authority = "https://login.microsoftonline.com/"
    $resource = "https://graph.microsoft.com"
    Try{
        $grphDir=$egurkhaPath+'\agent\O365\MsGraph'
        $keyPath=$grphDir+'\GraphDetailsKey.dat'
        $unProtFile=$grphDir+'\GraphDetails.dat'
        if(Test-Path $unProtFile -PathType Leaf){
            $unProtPath=$grphDir+'\GraphDetails.dat'
            $kvalue=Get-Content -Path $keyPath
            Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
        }
        $grphDtlPath=$grphDir+'\GraphDetails.txt'
        if(Test-Path $grphDtlPath -PathType Leaf){
            $lines=Get-Content -Path $grphDtlPath
            $wpath1=$grphDir+'\GraphDetails1.txt'  
            $orgChk='-'+$orgNam
            $isExist=$False
            for($i=0;$i -lt $lines.Length;$i++){
                if($lines[$i] -match $orgChk){
                    $isExist=$true
                    $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                    $null='client_id~'+$appId| Add-Content $wpath1 -PassThru
                    $null='client_secret~'+$client_secret| Add-Content $wpath1 -PassThru
                    $null='TenantName~'+$orgNam| Add-Content $wpath1 -PassThru
                    $null='Authority~'+$authority| Add-Content $wpath1 -PassThru
                    $null='Resource~'+$resource| Add-Content $wpath1 -PassThru
                    $null='TenantId~'+$tenantId| Add-Content $wpath1 -PassThru
                    ""| Add-Content $wpath1
                    $i=$i+7
                    continue
                }
                Add-Content -Path $wpath1 -Value $lines[$i]
            }
            if(!$isExist){
                $null='['+$appName+'-'+$orgNam+']'| Add-Content $wpath1 -PassThru
                $null='client_id~'+$appId| Add-Content $wpath1 -PassThru
                $null='client_secret~'+$client_secret| Add-Content $wpath1 -PassThru
                $null='TenantName~'+$orgNam| Add-Content $wpath1 -PassThru
                $null='Authority~'+$authority| Add-Content $wpath1 -PassThru
                $null='Resource~'+$resource| Add-Content $wpath1 -PassThru
                $null='TenantId~'+$tenantId| Add-Content $wpath1 -PassThru
                ""| Add-Content $wpath1
            }
            Remove-Item $grphDtlPath
            if(Test-Path $wpath1 -PathType Leaf){
                Rename-Item $wpath1 'GraphDetails.txt'
            } 
        }else{
            $null='['+$appName+'-'+$orgNam+']'| Add-Content $grphDtlPath
            $null='client_id~'+$appId| Add-Content $grphDtlPath
            $null='client_secret~'+$client_secret| Add-Content $grphDtlPath
            $null='TenantName~'+$orgNam| Add-Content $grphDtlPath
            $null='Authority~'+$authority| Add-Content $grphDtlPath
            $null='Resource~'+$resource| Add-Content $grphDtlPath
            $null='TenantId~'+$tenantId| Add-Content $grphDtlPath
            ""| Add-Content $grphDtlPath
        }

        $key=Get-CryptoKey -FileDir $grphDir -FileName '\GraphDetailsKey.dat'
        $null=Protect-File $grphDtlPath -Algorithm AES -KeyAsPlainText $key -RemoveSource
    }
    Catch{
        $message= $_.Exception.Message + $_.ScriptStackTrace 
        Write-host "Exception Occurred in Graph API writing file - $message."
        O365-WriteLog -writString  "Exception Occurred in Graph API writing file - $message." -LogPath $logFile -ReportingName 'ERROR'
    }
}

Disconnect-AzureAD

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

$edTim2=Get-Date
O365-WriteLog -writString "O365GraphAPI ended at $edTim2" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'

# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUcDOpHkDTBW8mgD7h3y9bAW7v
# xAqggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFNF5ZDz+
# dj0fRX7Na5Sa3zhxpKYmMA0GCSqGSIb3DQEBAQUABIICACNQrGYPFweeGG7uvO2H
# 1PMKXy2wKJZ7/V5j0d4J8IklB5aDSyELfw37uDBiu3aX/gNRZ+TOB/od3kvEvvx7
# 0yXjN83CFnnQAHObK591H9Zho+Cu2kPnbkhD8CkbExXdBEBr2rBpNnccbz9PUFTp
# t6x31lt0vKVvGcJ3/dPW1DP+aDpCC3qRD4nafwldnDmJ00919qxN4fZB2P+yRizs
# eBLdxrP2tC6ATAooeLc4wBpq/fXacP2Izol5ewK8zobtxOdp6TTpcZRfQuGNYtI3
# 8753XeU5CWKKNTVWj9fLfvqmNQmrfBeFVT3n+QhZZQVeloUqH2KApZUkMo1lsQjn
# P75I68NU9CqPMmKfUG7V5mal3Wp5gmL0WbjwVpFU+G1mrdRoRoKW46eir5FicAjc
# 8Mx7rA1ladjnOBVrVf1tN28gPuuaG+UCbBCT6FFx71+2OyEwaxHAJDFIFxGWFgmN
# LFugUhAg+JQ6vk6WJVCQXiPAauFtZPkf5TNpE3owklYwxYJh3m4F9ZGBDVorybeh
# Sh6UYutwJLV0+wJUZac4QYZShaNdpVUcIkvBMCKTl2oDCWgeaRMEMj2HVo37LmmE
# c0BMKLfOq+qVbHVHufF4291p+8oCG/l2LMMQZ6N2InVej7S+TP+orZM6KHDDTc00
# T39Ex4NFDc7AHEngW3Tm4SJRoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkwNTA4NTI1
# M1owLwYJKoZIhvcNAQkEMSIEIHVjmEozuVgpJPX+687ZYGIv2ljFRVkW8473/oh0
# aDULMA0GCSqGSIb3DQEBAQUABIICAEVnFwaKkY59e4XOo1Yc3pNZ/YZSEGq1YzZO
# o1fFDGQnCCWliovqjljI4QQdHSFl38GrcjND8Pzc5FVoxF/W7PYtTaxms4Ef6zZE
# LYtP+ePCivv1adX+FQHKj048ByhG3fIVa4G0vVt5QKW7LBGpXQXUBfGW/z+5vM1J
# 77CMrmRFiHtCetj7JpSHNV8IxarIcofPEiz0N46tQL60eJKCLcg75bn86/jkC+7g
# A0VVFLLYrMvmuhRdPBF2cRZcKfzkZBiXbeK4WJzsIXF8a3x3hCxpQ0lUc+a2ME24
# nzGdAT0g1SzlaIU0ZJuZdUPczSAKD84qKWoaisQ75QEcTh7Z3ViC6XEyfIcqpUzX
# vElRCpda4tU5pkdbG+30mT1BYr3dw2Q/Bpz2cBVQCmG0N9LOAoKoMIOwDfgCHPja
# ot7Pq61BbCcvhyNo9+xQV+9mWgPArtN92MysvpudOKTr9fNDVOZr/knSO0Rn0fK+
# 3/f1gotjzvAuyMX7rovuLfMlX2sKBvQFinE9Ra6JkHfso3QE+oh5TgdZe3vhezZv
# 4M4DQIvJycDAPLpJoP5/1QiKz1JIXQhUUr9gcldzeZpdQCOwPq5xP+nHG/fHnFk8
# L2WGJMjoEgiCFhV2+FLyLiMnkaf3lauZUghwldXs432pOf1kL/i7WvJD/ytN3Psh
# X4p4UlCT
# SIG # End signature block
