﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$egurkhaPath+"\lib\EGFileEncryption.psm1"
$egDatnKy=$egurkhaPath+'\lib\GetDatnKeyFiles.psm1'
Import-Module $egEncryPath,$egDatnKy

#<#
$TestInputs=$args
$proxyUsr=$TestInputs[0]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[1]
$DateProxyhostRepName=($TestInputs[2]).ToString().Split("#")
$readingDateUserdetails=[datetime]($DateProxyhostRepName[0].Trim())
$readingDateUserCounts=[datetime]($DateProxyhostRepName[1].Trim())
$proxyserverip=($DateProxyhostRepName[2]).ToString().trim()
$reportingname=($DateProxyhostRepName[3]).ToString().trim()
$fetchDomains=$TestInputs[3]
$graphDtls=$TestInputs[4]
#>

$graphDtlsArr=$graphDtls.ToString() -split '~!~'
$appId=$graphDtlsArr[0]
$appSecret=$graphDtlsArr[1]
$authString=$graphDtlsArr[2]
$resource=$graphDtlsArr[3]


$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$teamChatMsgs=0
$prvtChatMsgs=0
$calls=0
$meetings=0
$otheract=0
$rptPath=$egurkhaPath+'\agent\MTM\'+$reportingname
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath       
    )

    Process
    {
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($Resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $query = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$query = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url
        $query=$query.Replace('ï»¿','')
        $query=$query.Replace(' ','')
        $resultarray = ConvertFrom-Csv -InputObject $query
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json

        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){   
            $reports.Usage[$i] |Export-Csv $filePath -Encoding $encTyp -Append -NoTypeInformation -Force
        } 
    }
}

$path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $path
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$usrActUsrDt = $rptPath+'\MTMUsrActUsrDetils'+$timenow+'.csv'

$diffence=(NEW-TIMESPAN –Start $readingDateUserdetails –End (Get-Date) | Select-Object Days).Days
$TeamsUsg=@()
try{
    $notFirsttime = $false
    while($diffence -gt 1)
    {
        if($notFirsttime){ $readingDateUserdetails=$readingDateUserdetails.AddDays(1) }
        $actualdate=$readingDateUserdetails.tostring(“yyyy-MM-dd”)
        $actualdate
        $notFirsttime = $true
        try{
            $UserActivitiesUrl ="https://graph.microsoft.com/v1.0/reports/getTeamsUserActivityUserDetail(date=$actualdate)"    #(period='D7')"
            Eg-InvokeUrl -Url $UserActivitiesUrl -filePath $usrActUsrDt
            if([System.IO.File]::Exists($usrActUsrDt) -eq 'True'){
                $tmUsagDomain=import-csv $usrActUsrDt -Encoding $encTyp | where-object { $_.LastActivityDate -and $_.UserPrincipalName -notlike '*unknown*'}| Select-Object * 
                foreach($obj in $tmUsagDomain){
                    $curDomain=([String]$obj.UserPrincipalName).Trim().Split('@')[1]
                    if($curDomain -ne $null -and $curDomain -ne '' -and $fetchDomains -match $curDomain){
                        $TeamsUsg+=$obj;
                    }
                }
                Write-Host 'ReadedDate of user actvities Date#'$actualdate
            }
            break

        }catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-Error  -Message "error while getting the user activities details on $actualdate  $message " 
            Write-Host 'thereIs No user actvities on Data#'$actualdate
        }  

        $diffence=$diffence-1
    }

}catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-Error -Message "File not found. The $reportingname location does not contain UserActivity report $message "
}
[System.GC]::GetTotalMemory($true) | out-null

if($TeamsUsg -ne $null -and $TeamsUsg -ne ''){
    $UnqUsrtotalchatmsgcnt=($TeamsUsg | Measure-Object "TeamChatMessageCount" -Sum | select Sum).Sum
    if(!$UnqUsrtotalchatmsgcnt){$UnqUsrtotalchatmsgcnt=0}
    $UnqUsrtotalPrivtechatmsgcnt=($TeamsUsg | Measure-Object "PrivateChatMessageCount" -Sum | select Sum).Sum
    $UnqUsrtotalCallcnt=($TeamsUsg | Measure-Object "CallCount" -Sum | select Sum).Sum
    $UnqUsrtotalMeetingscnt=($TeamsUsg | Measure-Object "MeetingCount" -Sum | select Sum).Sum
    $UnqUsrtotlotherActUsrs=($TeamsUsg | where-object { $_.HasOtherAction -eq 'Yes' }).count


    $top10chatmsgUsrs=$TeamsUsg | Where-Object { $_.TeamChatMessageCount -gt 0 } |Sort-Object  { $_.TeamChatMessageCount -as [int] } -Descending | select -First 10
    foreach($chatusrs in $top10chatmsgUsrs)
    {
        $asigndPrdts=([String]$chatusrs.AssignedProducts).Trim()
        if($asigndPrdts.Length -gt 1999){
            $asigndPrdts=$asigndPrdts.Substring(0,1995)+'...'
        }
        Write-Host 'top10chatmsgusrs#' $chatusrs.UserPrincipalName ~!~ $chatusrs.LastActivityDate ~!~ $chatusrs.TeamChatMessageCount ~!~ $chatusrs.PrivateChatMessageCount ~!~ $chatusrs.CallCount ~!~ $chatusrs.MeetingCount ~!~ $chatusrs.HasOtherAction ~!~ $chatusrs.IsDeleted ~!~ $chatusrs.DeletedDate ~!~ $asigndPrdts
    }
    $top10chatmsgUsrs=$null

    $top10PrivtechatmsgUsrs=$TeamsUsg | Where-Object { $_.PrivateChatMessageCount -gt 0 } | Sort-Object  { $_.PrivateChatMessageCount -as [int] } -Descending | select -First 10

    foreach($chatusrs in $top10PrivtechatmsgUsrs)
    {
        $asigndPrdts=([String]$chatusrs.AssignedProducts).Trim()
        if($asigndPrdts.Length -gt 1999){
            $asigndPrdts=$asigndPrdts.Substring(0,1995)+'...'
        }
        Write-Host 'top10privatechatusrs#' $chatusrs.UserPrincipalName ~!~ $chatusrs.LastActivityDate ~!~ $chatusrs.TeamChatMessageCount ~!~ $chatusrs.PrivateChatMessageCount ~!~ $chatusrs.CallCount ~!~ $chatusrs.MeetingCount ~!~ $chatusrs.HasOtherAction ~!~ $chatusrs.IsDeleted ~!~ $chatusrs.DeletedDate ~!~ $asigndPrdts
    }
    $top10PrivtechatmsgUsrs=$null

    $top10CallcntUsrs=$TeamsUsg | Where-Object { $_.CallCount -gt 0 }  | Sort-Object  { $_.CallCount -as [int] } -Descending | select -First 10
    foreach($chatusrs in $top10CallcntUsrs)
    {
        $asigndPrdts=([String]$chatusrs.AssignedProducts).Trim()
        if($asigndPrdts.Length -gt 1999){
            $asigndPrdts=$asigndPrdts.Substring(0,1995)+'...'
        }
        Write-Host 'top10callcntusrs#' $chatusrs.UserPrincipalName ~!~ $chatusrs.LastActivityDate ~!~ $chatusrs.TeamChatMessageCount ~!~ $chatusrs.PrivateChatMessageCount ~!~ $chatusrs.CallCount ~!~ $chatusrs.MeetingCount ~!~ $chatusrs.HasOtherAction ~!~ $chatusrs.IsDeleted ~!~ $chatusrs.DeletedDate ~!~ $asigndPrdts
    }
    $top10CallcntUsrs=$null

    $top10MeetingscntUsrs=$TeamsUsg | Where-Object { $_.MeetingCount -gt 0 }  | Sort-Object  { $_.MeetingCount -as [int] } -Descending | select -First 10

    foreach($chatusrs in $top10MeetingscntUsrs)
    {
        $asigndPrdts=([String]$chatusrs.AssignedProducts).Trim()
        if($asigndPrdts.Length -gt 1999){
            $asigndPrdts=$asigndPrdts.Substring(0,1995)+'...'
        }
        Write-Host 'top10meetingsusrs#' $chatusrs.UserPrincipalName ~!~ $chatusrs.LastActivityDate ~!~ $chatusrs.TeamChatMessageCount ~!~ $chatusrs.PrivateChatMessageCount ~!~ $chatusrs.CallCount ~!~ $chatusrs.MeetingCount ~!~ $chatusrs.HasOtherAction ~!~ $chatusrs.IsDeleted ~!~ $chatusrs.DeletedDate ~!~ $asigndPrdts
    }
}

<#
$usrActUsrcunts = $rptPath+'\MTMUsrActUserCounts'+$timenow+'.csv'
$UserActiUsrCntsUrl ="https://graph.microsoft.com/v1.0/reports/getTeamsUserActivityUserCounts(period='D7')"  
Eg-InvokeUrl -Url $UserActiUsrCntsUrl -filePath $usrActUsrcunts
$diffence1=(NEW-TIMESPAN –Start $readingDateUserCounts –End (Get-Date) | Select-Object Days).Days


try{
    $totalTeamsActSumry= import-csv $usrActUsrcunts -Encoding $encTyp | Select-Object *  | Sort-Object { $_.ReportDate -as [datetime] } # -Descending | select -First 1

    $notFirsttime = $false
    while($diffence1 -gt 1)
    {
        if($notFirsttime){ $readingDateUserCounts=$readingDateUserCounts.AddDays(1) }
        $actualdate=$readingDateUserCounts.tostring(“yyyy-MM-dd”)
        $notFirsttime = $true
        $TeamsActSumry =$totalTeamsActSumry | Where-Object { ($_.ReportDate) -eq $actualdate }
        if($TeamsActSumry)
        {
            Write-Host 'ReadedDate of usercounts Date#'$actualdate
            break
        }

        else
        {
            Write-Host 'thereIs No usercounts on Data#'$actualdate
        }
        $diffence1=$diffence1-1
    }

}catch{
    $_.Exception
    Write-Error -Message "File not found. The $reportingname location does not contain deviceusage report"
}


if($TeamsActSumry){

    $teamChatMsgs=$TeamsActSumry.TeamChatMessages
    $prvtChatMsgs=$TeamsActSumry.PrivateChatMessages
    $calls=$TeamsActSumry.Calls
    $meetings=$TeamsActSumry.Meetings
    $otheract=$TeamsActSumry.OtherActions
}
#>

if($TeamsUsg){
    Write-Host '#measures' '-5' ~ '-5' ~ '-5' ~ '-5' ~ '-5' ~ $UnqUsrtotalchatmsgcnt ~ $UnqUsrtotalPrivtechatmsgcnt ~ $UnqUsrtotalCallcnt ~ $UnqUsrtotalMeetingscnt ~ $UnqUsrtotlotherActUsrs
    #Write-Host '#measures' $teamChatMsgs ~ $prvtChatMsgs ~ $calls ~ $meetings ~ $otheract ~ $UnqUsrtotalchatmsgcnt ~ $UnqUsrtotalPrivtechatmsgcnt ~ $UnqUsrtotalCallcnt ~ $UnqUsrtotalMeetingscnt ~ $UnqUsrtotlotherActUsrs
}
$csvDir=$rptPath+'/'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'MTMUsrActUsrDetils'
#Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'MTMUsrActUserCounts'
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUtCk0UM3uKTAj7U9fYKA+9T2r
# ZIuggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFAsDwMc3s+pRLQtG
# WkJLkqLevBQmMA0GCSqGSIb3DQEBAQUABIICAAAxii884jb4nc6jV5gUTCBVWe9W
# tJO0o5eUbCTVyRba8M5MDMZx01y5l24+h/c25mSE9Vd6X9OG1rV6FihIl3K3Rxqf
# kpb1z+rckLQq7usc1m/wj8T0U+PvWVt+TKvUzGJ7B6bXyGpn3Cz7hvEP5UWCOvjM
# /Ze8pF1Oyx4OKF7F7TfmpSGhlTG8kO5536UGV3lkbmz/Dr9L+rtxu9sCUSbI87Vq
# KZ+aHaMx+tJ7naDLmDZ/1zzp9JBOD12vxUR5htJB0yEKrYiqRRJr1wwTKZuwX/XB
# 5J6JrAeE1sB5/4H03qlyMuwv5onLGi4pV0HvFqOEvR7VN4rZkJVcDpMCPWjAYPQF
# VEKDEsGgf/jYGa4oLiuv0xG91Rh1bRmrSDWLiNmv1QwQRTdZJf3fvyYDTrNTY5ui
# qdW/aCe/IOtnVJL9a9eMlay2x+nN8Tc3M4SIILQxT2hWR/oWy3z/Yh69wXi/kBEu
# zlM+a3vwFdW5xrZkV23Yldj0ZaFnWsfl6aW6+GxqYFYye0eIg0yD4470uZw0+kba
# jiAqQtLCXAOWfmy2jXoV6Km6ZdhGdI1mJky/LEStuxB1swG9Zqhm9Uvwu+yh8e0T
# /VGm1HpCuCSBb5XE0mxKXP88QRcMHSkXtubcIcj70BcPDAG5z3QAjGer4oQountc
# cEJDJg9FwtHfwXQ7oYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMTAxMTE0MzcwNVowLwYJ
# KoZIhvcNAQkEMSIEIFWLx6nO1gtkBc6NESU8y2ZEepZLyrhKMvlNj7oY69k/MA0G
# CSqGSIb3DQEBAQUABIICAJNYvtiLbtl8X5R837obyPksCd8MVooMv5zM2OzLn4LC
# krFaOdmDHunxrjEV4kIy/O1bTYaaLZQ0TDilLziguZ9hsFomzKGYg64Tm/yOnsAW
# YypDaaui8gKCVGiKVsl1gtKrE2iRDos1bOtndNav/gmqDtntc0KlcgSbvb/mRe8Y
# zQ8PbC+KoVGmOiL5Jw5+qb9utEIGWBvFmmK9/EJiFyHhyoQmVbQWRofa+kJtqfPy
# D7CiJtKdJ9YbSlhcECmFDJ8EnXYH92s1AGk21XzAQNAZpH9Y4+XC8YOrgq+iPs9D
# aSPLjfCYsE7ITRZyoZzhOQQIL34YUwnmmGFlVSklmc20w2TmdZl4/pHtU01oS/M/
# vyyOxbP2Wup49Qajp/dPoMC4dBdi1OIordkPbyIcXOWLbmUkcaaWzynXv/5MPZX+
# iEVt/zgPnQ1vJZRpnL/ZEVLFq3uVaHbDEavPCs4qQUW6Ka7J74TItBBjixsylj1u
# wOH0OjUB9k4Tt1wgx05mSJcaPz1AtLdWwrixj21jNEFkwGKBka+tdL6sx4yDOIIt
# mtOeiwowbRKHgQEkVOK4vaxFWxbO+iDeOO6zHfpSCdNd82XaNgdKL4y7RcegGQuD
# nh6H1etMJ6MdjMP1M3bokx+IAfeQSGGTV3lYNTd2nGqN7oN5Nh0nYRDQUvlHG0m4
# SIG # End signature block
