﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rName=$testargs[4]
$graphDetails=$testargs[5]
$appDetails=$testargs[6]

if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$RprtNameAndmTime=$rName.split("#")
$reportingname=$RprtNameAndmTime[0]
$mTime=$RprtNameAndmTime[1]
$prxyHostNport=$RprtNameAndmTime[2]
$proxyserverip='http://'+$prxyHostNport

#-----------------------------
$domainSpecific=$false
if($reportingname -match '_exd'){
    $domainSpecific=$true
    $alldomainnames=@()
    $dhash=@{}
    $dmnshash=Eg-O635Domains -username $userName -password $Password -rptNam $reportingname -proxyserverip $proxyserverip -proxyUsr $proxyUsr -proxyPass $proxyPass -appDetails $appDetails
    $arr=$dmnshash[$reportingname].split('~')
    $dhash.Add('SupersetName',$arr[1])
    $dhash.Add($arr[0],$reportingname)
    $reportingname=$dhash['SupersetName']
    foreach($h in $dhash.Keys){
        if($h -ne 'SupersetName'){
            $alldomainnames+=$h
        }
    }
    $DS_mxbx_Key='';$DS_mxbx_fpth='';$DS_mxbx_nam='';
    $DS_csmx_Key='';$DS_csmx_fpth='';$DS_csmx_nam='';
    $DS_rcpm_Key='';$DS_rcpm_fpth='';$DS_rcpm_nam='';
    $DS_rptmx_Key='';$DS_rptmx_fpth='';$DS_rptmx_nam='';
    $DS_stsmx_Key='';$DS_stsmx_fpth='';$DS_stsmx_nam='';
}
$rptPath='EXO/'+$reportingname
$chkwritPath=$egurkhaPath+'/agent/'+$rptPath
if($domainSpecific){ 
    $isWrite=Check-WriteFile -rptPath $chkwritPath -srchWrd 'EXOMailnDevices' -mTimInMin $mTime
}
$isProceed=$false
if($isWrite){
    $isProceed=$true
}elseif($domainSpecific -eq $false){
    $isProceed=$true
}else{
    $isProceed=$false
}
#--------------------------------
$servicSpecific=$false
if($reportingname -match '_exs'){
    $servicSpecific=$true
}
#--------------------------------

if($isProceed){
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')

    $ManualThrottle=0
    [double]$ActiveThrottle=.25
    $ResetSeconds=900

    $WriteLog=$true
    $LogFile = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mail.log"
    $LogFile1 = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mail1.log"
    $isFrstTimLog=$true

    # Writes output to a log file with a time date stamp
    Function Write-Log {
	    Param ([string]$string)
	    [string]$date = Get-Date -Format G
        if ($WriteLog) {
           ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append } 
        if($isFrstTimLog){     
            if ($WriteLog -eq $true){ #if flag is true 
                if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                    if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                        Remove-Item $LogFile1 
                    } 
                    Rename-Item $LogFile $LogFile1 
                }
            }
            $isFrstTimLog=$false
        }
    }

    Function Start-SleepWithProgress {
	    Param([int]$sleeptime)
	    For ($i=0;$i -le $sleeptime;$i++){
		    $timeleft = ($sleeptime - $i);
		    Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		    start-sleep 1
	    }
	    Write-Progress -Completed -Activity "Sleeping"
    }

    Function New-CleanO365Session {
        $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
        $i = 0
	    while (($Credential -eq $Null) -and ($i -lt 5)){
		    $script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		    $i++
	    }
	    if ($Credential -eq $null){
		    Write-log ("[ "+$(Get-CurrentLineNumber) +" ] "+"[Error] - Failed to get credentials")
		    Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	    }
	    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+"Removing all PS Sessions")
        $getSession=Get-PSSession -ErrorAction SilentlyContinue
        if($getSession -ne $null -and $getSession -ne ''){
	        Disconnect-ExchangeOnline -Confirm:$false
        }
	    [System.GC]::Collect()
	    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Sleeping 15 seconds for Session Tear Down")
	    Start-SleepWithProgress -SleepTime 15
	    $Error.Clear()
	
	    # Create the session
	    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Creating new PS Session")
	    $sessionOption = New-PSSessionOption -SkipRevocationCheck
        if(!$proxyserverip.ToString().ToLower().Contains('none')){
            [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserverip)
	        if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
                [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
                [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	            $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	        }
        }

	    # Check for an error while creating the session
	    if ($Error.Count -gt 0){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Error while setting up session")
		    $ErrorCount++
		    if ($ErrorCount -gt 3){
			    $deleky=0
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Failed to setup session after multiple tries")
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Aborting Script")
                try{
                    if(Test-Path -path $global:writeTmpCsv){
                        Write-Log "Converting tmpmailboxstats to dat file due to unavailability of session"
                        $null=Protect-File  $global:writeTmpCsv -Algorithm AES -KeyAsPlainText $global:WriteTmpKey -RemoveSource
                    }
                }catch{
                    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "File stats cannot be converted to dat while aborting the script")
                }
			    exit
		    }
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Sleeping 60s so that issue can potentially be resolved")
		    Start-SleepWithProgress -sleeptime 60
		    New-CleanO365Session
	    }
	    else {
		    $ErrorCount = 0
	    }	
	    # Connect the ExchangeOnline
        if($appDetails -and $appDetails -ne 'none'){
            Connect-ExchangeOnline -CertificateThumbPrint $thumbPrint -AppID $clientId -Organization $tenantName -PSSessionOption $sessionOption -ShowBanner:$false -WarningAction SilentlyContinue
        }else{
            Connect-ExchangeOnline  -ExchangeEnvironmentName $azureEnvArr[4] -ConnectionUri $azureEnvArr[1] -Credential $Credential -PSSessionOption $sessionOption
	    }
	    # Set the Start time for the current session
	    Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
    }

    Function Test-O365Session {
	    $ObjectTime = Get-Date
	    $SessionInfo = $null
	    $SessionInfo = Get-PSSession
	    if ($SessionInfo -eq $null) { 
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - No Session Found")
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Recreating Session")
		    New-CleanO365Session
	    }	
	    elseif ($SessionInfo.State -ne "Opened"){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Session not in Open State")
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ $SessionInfo | fl | Out-String )
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Recreating Session")
		    New-CleanO365Session
	    }
	    elseif (($ObjectTime - $SessionStartTime).totalseconds -gt $ResetSeconds){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Session Has been active for greater than " + $ResetSeconds + " seconds" )
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Rebuilding Connection")
		    [int]$DelayinSeconds = ((($ResetSeconds * $ActiveThrottle) / 2) - 15)
		    if ($DelayinSeconds -gt 0){
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Sleeping " + $DelayinSeconds + " addtional seconds to allow throttle recovery")
			    Start-SleepWithProgress -SleepTime $DelayinSeconds
		    }
		    else{
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Active Delay calculated to be " + ($DelayinSeconds + 15) + " seconds no addtional delay needed")
		    }
		    New-CleanO365Session
	    }
	    else{
		    #Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "the session "+ $SessionInfo +" state is "+$SessionInfo.State)
	    }
	    if ($ManualThrottle -gt 0){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Sleeping " + $ManualThrottle + " milliseconds")
		    Start-Sleep -Milliseconds $ManualThrottle
	    }
    }

    Function Get-EstimatedTimeToCompletion {
	    param([int]$ProcessedCount)
	    $ProcessedCount++
	    if (($ProcessedCount % 100) -eq 0){
		    $CurrentDate = Get-Date
		    $AveragePerObject = (((($CurrentDate) - $ScriptStartTime).totalseconds) / $ProcessedCount)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Total Number of Objects:     " + $ObjectCount)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Number of Objects processed: " + $ProcessedCount)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Average seconds per object:  " + $AveragePerObject)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Estimated completion time:   " + $CurrentDate.addseconds((($ObjectCount - $ProcessedCount) * $AveragePerObject)))
	    }
	    return $ProcessedCount
    }

    function Get-CurrentLineNumber {
        $MyInvocation.ScriptLineNumber
    }

    $rptPath='EXO/'+$reportingname
    $MyDir=$egurkhaPath+'/agent/EXO/'+$reportingname
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
    $isErrorOccur= $false
    Set-StrictMode -Version 2
    $ErrorCount = 0
    $TotMailbxcnt=""

    if(!$servicSpecific){
        try{
            try{
                $typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
                Add-Type -Path $typePath
                $mailboxStats = Eg-WriteFile -ComntRptPath $rptPath -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
                $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
                $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
                $context = $authContext.AcquireTokenAsync($resource, $creds).Result
                $authCode=$context.CreateAuthorizationHeader()
                $header = @{
                    'Authorization'=$authCode
                }
                $Url="https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')"
                $queryRes = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
                #$queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri "https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')"
                $queryRes=$queryRes.Replace('ï»¿','')
                $queryRes=$queryRes.Replace('(Byte)','')
                $queryRes=$queryRes.Replace(' ','')
                $resultarray = ConvertFrom-Csv -InputObject $queryRes
                foreach($rs in $resultarray){
                    $rs | Export-Csv $mailboxStats[1] -Encoding $encTyp -Append -Force
                }
                #$resultarray | ForEach-Object{$_ | Export-Csv $mailboxStats[1] -Append}
                [System.GC]::GetTotalMemory($true) | out-null
            }
            catch{
                Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error occured in graphapi - mailboxStats ")
                $isErrorOccur =$true
            }
            if($isErrorOccur -eq $true){ #-or (Get-Item $mailboxStats[1]).length -le 2kb
                Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error while fetching mailboxStats. Deleting the incomplete dat file")
                Remove-Item $mailboxStats[1]
            }else{   
                $DS_stsmx_Key=$mailboxStats[0];$DS_stsmx_fpth=$mailboxStats[1];$DS_stsmx_nam=$mailboxStats[2];
                $null=Protect-File $mailboxStats[1] -Algorithm AES -KeyAsPlainText $mailboxStats[0] -RemoveSource
            }
        }Catch{ 
                $ErrorMessage = $_.Exception.Message
                Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running mailbox/device statistics : "+$ErrorMessage)       
        }
    }

    if(!$servicSpecific){
        $Error.Clear()
        try{
            New-CleanO365Session
            $Mailboxes = Eg-WriteFile -ComntRptPath $rptPath -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
            Write-Host $Mailboxes[1]
            $results=invoke-command -scriptblock {Get-EXOMailbox -PropertySets All -resultsize unlimited |
                select-object -property Displayname, PrimarySMTPAddress, Identity, WasInactiveMailbox, SKUAssigned,
                RecipientTypeDetails, LitigationHoldEnabled, DeliverToMailboxAndForward, InPlaceHolds, UserPrincipalName,ArchiveStatus,Name,ArchiveName,ArchiveState,ArchiveQuota,ArchiveWarningQuota,
                ForwardingSmtpAddress, ServerName, Database, Location, Datacenter, AuditAdmin,GrantSendOnBehalfTo,IssueWarningQuota,ProhibitSendQuota,ProhibitSendReceiveQuota,IsInactiveMailbox, WhenChanged, WhenCreated, WhenSoftDeleted
            }
            $results | ?{$_.SKUAssigned -eq $true} | export-csv $Mailboxes[1] -Encoding $encTyp
            [System.GC]::GetTotalMemory($true) | out-null
        }
        Catch{
            $ErrorMessage = $_.Exception.Message 
            $isErrorOccur=$true      
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ " ErrorMessage while running Mailbox : "+$ErrorMessage)  
            Write-Log $Error
            $TotMailbxcnt=""
        } 
        if($isErrorOccur -eq $true -or  (Get-Item $Mailboxes[1]).length -le 2kb){ 
            Remove-Item $Mailboxes[1] 
        }
        else{
            $DS_mxbx_Key=$Mailboxes[0];$DS_mxbx_fpth=$Mailboxes[1];$DS_mxbx_nam=$Mailboxes[2];  
            $TotMailbxcnt = import-csv  $Mailboxes[1] -Encoding $encTyp
            $null=Protect-File  $Mailboxes[1] -Algorithm AES -KeyAsPlainText $Mailboxes[0] -RemoveSource
        }

        $Error.Clear()
        try{
            Test-O365Session
            $casMailboxes = Eg-WriteFile -ComntRptPath $rptPath -FileName "casmailboxes" -keyFileName "Kcasmailboxes" -EgPath $egurkhaPath
            invoke-command -scriptblock {Get-EXOCasMailbox -PropertySets All -resultsize unlimited  | select-object ActiveSyncEnabled,Name ,Displayname, Guid, PrimarySMTPAddress
            } | export-csv $casMailboxes[1] -Encoding $encTyp
            [System.GC]::GetTotalMemory($true) | out-null
        }Catch{
            $ErrorMessage = $_.Exception.Message
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running CASMailbox : "+$ErrorMessage)  
            $isErrorOccur=$true
        } 

        if($isErrorOccur -eq $true){ #-or (Get-Item $casMailboxes[1]).length -le 2kb
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Deleted File Error in excuting the CASMailbox ")
            Remove-Item $casMailboxes[1]
        }
        else{
            $DS_csmx_Key=$casMailboxes[0];$DS_csmx_fpth=$casMailboxes[1];$DS_csmx_nam=$casMailboxes[2];
            $null=Protect-File  $casMailboxes[1] -Algorithm AES -KeyAsPlainText $casMailboxes[0] -RemoveSource
        }
    }

    if(!$servicSpecific){
        $Error.Clear()
        try{
            Test-O365Session
            $RecipntPerm = Eg-WriteFile -ComntRptPath $rptPath -FileName "RecipntPerm" -keyFileName "kRecipntPerm" -EgPath $egurkhaPath
	        if($TotMailbxcnt -ne $null -and $TotMailbxcnt -ne ''){
		        $UserMailbox=$TotMailbxcnt|?{$_.RecipientTypeDetails -eq 'UserMailbox'}
		        #$UserMailbox| Get-EXORecipientPermission -Identity {$_.PrimarySmtpAddress}  -ResultSize Unlimited  | ? {$_.Trustee -ne "NT AUTHORITY\SELF" -and $_.Trustee -ne "NULL SID"} | Export-Csv $RecipntPerm[1]
                $recipPerms=Get-EXORecipientPermission  -ResultSize Unlimited  | ? {$_.Trustee -ne "NT AUTHORITY\SELF" -and $_.Trustee -ne "NULL SID"}
                foreach($user in $UserMailbox){
                    $recipPerms |?{$_.Identity -eq $user.Identity} |Export-Csv $RecipntPerm[1] -Encoding $encTyp -Append
                }
                [System.GC]::GetTotalMemory($true) | out-null	        
            }
        }
        Catch{
            $ErrorMessage = $_.Exception.Message
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running RecipientPermission : "+$ErrorMessage)  
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true) { # -and (Get-Item $RecipntPerm[1]).length -le 2kb){
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error in excuting the RecipientPermission cmdlet")
	        Write-Log $Error
            Remove-Item $RecipntPerm[1]
        }else{
            $DS_rcpm_Key=$RecipntPerm[0];$DS_rcpm_fpth=$RecipntPerm[1];$DS_rcpm_nam=$RecipntPerm[2];
            $null=Protect-File  $RecipntPerm[1] -Algorithm AES -KeyAsPlainText $RecipntPerm[0] -RemoveSource   
        }
    }

    if(!$servicSpecific){
        $Error.Clear()
        try{
            Test-O365Session
            $debugCnt=0;
            $Recpnt = Eg-WriteFile -ComntRptPath $rptPath -FileName "recipients" -keyFileName "krecipients" -EgPath $egurkhaPath
            #<#
            $recpRdPath=$egurkhaPath+'\agent\config\eg_tests.ini'
            $recpTypDtlsStr=''
            $isGetCntnt=$false
            $cntnts=Get-Content -Path $recpRdPath
            foreach($cntnt in $cntnts){
                if($isGetCntnt){
                    if($cntnt.StartsWith('RecipientTypes')){
                        $recpStr=$cntnt.ToString()
                        $recpTypDtlsStr=($recpStr.Split('=')[1])
                        break
                    }  
                }
                if($cntnt.StartsWith('[EXORecipientTypes')){
                    $isGetCntnt=$true  
                }
            }
            $recpTypDtlsArr=$recpTypDtlsStr.Split(',')
            #>
            if($recpTypDtlsStr -eq '' -or $recpTypDtlsStr -eq $null){
                $recpTypDtlsArr=@('DynamicDistributionGroup','MailContact','MailNonUniversalGroup','MailUniversalDistributionGroup','MailUniversalSecurityGroup','MailUser','PublicFolder','UserMailbox')
            }
            foreach($recptype in $recpTypDtlsArr){
                $measure=Get-EXORecipient  -ResultSize Unlimited -RecipientType $recptype | measure
                $RecpTypCnt=$measure.Count
		        if($RecpTypCnt -gt 0){
			        [pscustomobject]@{
			            'RecipientTypeDetails'=$recptype
			            'Count'=$RecpTypCnt
			        }| Export-Csv -Path $Recpnt[1] -Encoding $encTyp -Append
		        }
            }
            [System.GC]::GetTotalMemory($true) | out-null

        }Catch{
            $ErrorMessage = $_.Exception.Message
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running Recipient : "+$ErrorMessage)  
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true ){ #-or (Get-Item $Recpnt[1]).length -le 2kb
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error in excuting the Recipient ")
            Remove-Item $Recpnt[1]
        }else{
            $DS_rptmx_Key=$Recpnt[0];$DS_rptmx_fpth=$Recpnt[1];$DS_rptmx_nam=$Recpnt[2];
            $null=Protect-File  $Recpnt[1] -Algorithm AES -KeyAsPlainText $Recpnt[0] -RemoveSource       
        }
    }
    
    if(!$domainSpecific){
        $Error.Clear()
        $isErrorOccur=$false
        try{
        $DeviceStats = Eg-WriteFile -ComntRptPath $rptPath -FileName "devicestats" -keyFileName "kdevicestats" -EgPath $egurkhaPath
	    Test-O365Session
        Invoke-Command  -ScriptBlock { 
                    Get-MobileDevice -ResultSize Unlimited | 
                    select-Object WhenChangedUTC,DeviceType, DeviceUserAgent, DeviceOS, DeviceOSLanguage, Identity, ClientType }| Export-CSV -LiteralPath $DeviceStats[1] -Encoding $encTyp
        [System.GC]::GetTotalMemory($true) | out-null
        }catch{
            $isErrorOccur =$true
	    }
        if($isErrorOccur -eq $true){ #-or (Get-Item $DeviceStats[1]).length -le 2kb
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error while fetching mobiledevices. Deleting the incomplete dat file")
            Remove-Item $DeviceStats[1]
        }else{
            $null=Protect-File  $DeviceStats[1] -Algorithm AES -KeyAsPlainText $DeviceStats[0] -RemoveSource 
        }
    }
    Write-Log "Script Complete Destroying PS Sessions"
    $getSession=Get-PSSession -ErrorAction SilentlyContinue
    if($getSession -ne $null -and $getSession -ne ''){
        Disconnect-ExchangeOnline -Confirm:$false
    }
}

if($domainSpecific -and $servicSpecific -eq $false){  
    #------------- 1.For Domain Specific - mailbox ---------------------- 
    if($DS_mxbx_fpth -ne ''){
        $mxbxFilePth=$DS_mxbx_fpth -replace (".csv",".dat")   
        if((Get-Item -Path $mxbxFilePth).Length -gt 2KB){
            $null=Unprotect-File $mxbxFilePth -Algorithm AES -KeyAsPlainText $DS_mxbx_Key
            $mailbxs= import-csv $DS_mxbx_fpth -Encoding $encTyp
            $nam=$DS_mxbx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$nam
                foreach($tmpRes in $mailbxs){
                    $chkAddres='';$addrs=$tmpRes.PrimarySmtpAddress
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }   
                    #if($tmpRes.PrimarySmtpAddress -match $domain -and $tmpRes.SKUAssigned -eq $true){   
                    if($domain -match $chkAddres -and $tmpRes.SKUAssigned -eq $true){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Encoding $encTyp -Append
                    }
                }
                if($isAddContent){
                    $knam=$nam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_mxbx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_mxbx_Key -RemoveSource
                }
            }
        }
    }

    #------------- 2.Domain Specific - casmailboxes ----------------------
    if($DS_csmx_fpth -ne ''){   
        $csmxFilePth=$DS_csmx_fpth -replace (".csv",".dat")
        if((Get-Item -Path $csmxFilePth).Length -gt 2KB){
            $null=Unprotect-File $csmxFilePth -Algorithm AES -KeyAsPlainText $DS_csmx_Key
            $csmailbxs= import-csv $DS_csmx_fpth -Encoding $encTyp
            $csnam=$DS_csmx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$csnam
                foreach($tmpRes in $csmailbxs){
                    $chkAddres='';$addrs=$tmpRes.PrimarySMTPAddress
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.PrimarySMTPAddress -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Encoding $encTyp -Append
                    }
                }
                if($isAddContent){
                    $knam=$csnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_csmx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_csmx_Key -RemoveSource
                }
            }
        }
    }


    #$DS_rcpm_Key=$RecipntPerm[0];$DS_rcpm_fpth=$RecipntPerm[1];$DS_rcpm_nam=$RecipntPerm[2];
     #------------- 3.Domain Specific - recipient Permissions ----------------------
    if($DS_rcpm_fpth -ne ''){  
        $rpcmTFilePth=$DS_rcpm_fpth -replace (".csv",".dat")
        if((Get-Item -Path $rpcmTFilePth).Length -gt 2KB){
            $null=Unprotect-File $rpcmTFilePth -Algorithm AES -KeyAsPlainText $DS_rcpm_Key
            $rcpts= import-csv $DS_rcpm_fpth -Encoding $encTyp
            $rpnam=$DS_rcpm_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$rpnam
                foreach($tmpRes in $rcpts){ 
                    $chkAddres='';$addrs=$tmpRes.Trustee
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.PrimarySMTPAddress -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Encoding $encTyp -Append
                    }
                }
                if($isAddContent){
                    $knam=$rpnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_rcpm_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_rcpm_Key -RemoveSource
                }
            }
        }
    }
        
    #------------- 4.Domain Specific - recipients ----------------------
    if($DS_rptmx_fpth -ne ''){  
        $rptmxFilePth=$DS_rptmx_fpth -replace (".csv",".dat")
        #if((Get-Item -Path $rptmxFilePth).Length -gt 2KB){
            $null=Unprotect-File $rptmxFilePth -Algorithm AES -KeyAsPlainText $DS_rptmx_Key
            $rcpts= import-csv $DS_rptmx_fpth -Encoding $encTyp
            $rpnam=$DS_rptmx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$rpnam
                foreach($tmpRes in $rcpts){
                    $chkAddres='';$addrs=$tmpRes.PrimarySMTPAddress
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.PrimarySMTPAddress -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Encoding $encTyp -Append
                    }
                }
                if($isAddContent){
                    $knam=$rpnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_rptmx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_rptmx_Key -RemoveSource
                }
            }
        #}
    }

    #------------- 5.For Domain Specific - statsmailbox ----------------------
    if($DS_stsmx_fpth -ne ''){
        $stsmxFilePth=$DS_stsmx_fpth -replace (".csv",".dat")
        if((Get-Item -Path $stsmxFilePth).Length -gt 2KB){
            $null=Unprotect-File $stsmxFilePth -Algorithm AES -KeyAsPlainText $DS_stsmx_Key
            $dstat= import-csv $DS_stsmx_fpth -Encoding $encTyp
            $dsnam=$DS_stsmx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$dsnam
                foreach($tmpRes in $dstat){
                    $chkAddres='';$addrs=$tmpRes.UserPrincipalName
                    if($addrs.Contains('@')){
                        $chkAddres=$addrs.Split('@')[1]
                    }
                    #if($tmpRes.UserPrincipalName -match $domain){
                    if($domain -match $chkAddres){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Encoding $encTyp -Append
                    }
                }
                if($isAddContent){
                    $knam=$dsnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_stsmx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_stsmx_Key -RemoveSource
                }
            }
        }
    }
}

$csvDir=$egurkhaPath+'/agent/EXO/'+$reportingname+'/'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'mailbox'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'casmailboxes'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'RecipntPerm'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'recipients'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'statsmailbox'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'devicestats'
# SIG # Begin signature block
# MIIldgYJKoZIhvcNAQcCoIIlZzCCJWMCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUyJnGsKaHohzShmI5ugG7eW7x
# nF2ggh6cMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFsTCC
# BJmgAwIBAgIQASQK+x44C4oW8UtxnfTTwDANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwNjA5MDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBXjCCAVowDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsGAQUF
# BwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMG
# CCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwIAYDVR0g
# BBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEBDAUAA4IBAQCa
# FgKlAe+B+w20WLJ4ragjGdlzN9pgnlHXy/gvQLmjH3xATjM+kDzniQF1hehiex1W
# 4HG63l7GN7x5XGIATfhJelFNBjLzxdIAKicg6okuFTngLD74dXwsgkFhNQ8j0O01
# ldKIlSlDy+CmWBB8U46fRckgNxTA7Rm6fnc50lSWx6YR3zQz9nVSQkscnY2W1ZVs
# RxIUJF8mQfoaRr3esOWRRwOsGAjLy9tmiX8rnGW/vjdOvi3znUrDzMxHXsiVla3R
# y7sqBiD5P3LqNutFcpJ6KXsUAzz7TdZIcXoQEYoIdM1sGwRc0oqVA3ZRUFPWLvdK
# RsOuECxxTLCHtic3RGBEMIIGMzCCBRugAwIBAgIQCJp0nrgtw+wn6mXq2/g1MTAN
# BgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQg
# SW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
# dCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4XDTIxMDUyNTAwMDAw
# MFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBK
# ZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMs
# IEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMuMIICIjANBgkqhkiG
# 9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7JDxOs7sySHvaQ3wGR
# 2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJIk0AZXDTMvXr/mEvm
# KxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+f9I4EgTo9OcdVeIN
# XhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuKifgxL2i8d5FDzkhZ
# SZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZyyaRURtlx11pYfJ/K
# NYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgRADe3/k0NtiVwJIo0
# ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yKf4kpRFmClYfK5Lst
# GQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3VhN+aV56kR/efo8e
# D81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRvIID/l+yDJogDBpae
# 3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug3F2CVJpNbzb1HmAH
# 6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4KTAg7ROmGkwdLhmXo
# PCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsqCqOl6nEDwGD5LfZl
# dQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAOBgNVHQ8BAf8EBAMC
# B4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1oDOgMYYvaHR0cDov
# L2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmwwNaAzoDGG
# L2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3Js
# MEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAC
# hkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
# ZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
# AAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuChsgkv1PmQpgfypxC
# 3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5NAxDGuIczAIeXOc5k
# RRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9ndCmGSsqcxjG2ud8O6
# Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKRLAUu6IgD6WJKMVfZ
# XWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwoevxbIWh0SenZOUrA
# q9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQICEAc2N7ckVHzYR6z9
# KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERp
# Z2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMY
# RGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3MDMy
# MjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRp
# bWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMaG
# NQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjzaPp9
# 85yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3EF3+r
# GSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYncfGpX
# evA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7LeSn3O9TkSZ+8OpWNs
# 5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROpVymW
# Jy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP29p7mO1vsgd4iFNmC
# KseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjFKfPKqpZzQmiftkaz
# nTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0UfM2
# SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpYPtMDiP6zj9NeS3YS
# UZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ14mCjWAkB
# KAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGjggFdMIIBWTASBgNV
# HRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57IbzAf
# BgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMCAYYw
# EwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0MEMG
# A1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG
# /WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAYLhBN
# E88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb122H+oQgJTQxZ822
# EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequFzUNf7WC2
# qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQsl3p/yhUifDVinF2
# ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7+6ad
# cq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJD5TN
# OXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvkOHOr
# pgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJGnXUs
# HicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimGsJig
# K+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInwAM1dwvnQI38AC+R2
# AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d2zc4
# GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhNhpedMA0GCSqGSIb3
# DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7
# MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1l
# U3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
# CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG0Rp
# Z2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx5DxArvurxON4XX5c
# Nur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJx
# bKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIjQVr4YNNlLD5+
# Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJHGVvimC6P0Mo//8Zn
# zzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz4Di9or16
# cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vICNEyu4P6IzzZ/9KM
# u/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03ShL7BU
# dsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2xwafEDsTvQD4ZOgLU
# MalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
# CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2QT3nr6caKMmtYbCg
# QRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGj
# ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8E
# DDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
# HwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYEFI1kt4kh
# /lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3Rh
# bXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRw
# Oi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRz
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1l
# U3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
# 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4qOVo5TtiEWaW8G5iq
# 6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJ
# T4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8y/pc9+RTv24KfH7X
# 3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEip
# tucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSiZZQR+24y8fW7
# OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp43UZ3Lht6wDOK+Eoo
# jBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q+A8GQp3f
# BmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVrNQ6F1uAszOAMJLh8
# UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/Tf8u+
# wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdjOEcXW28T2moQbh9J
# t0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmlu
# ZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIB
# DDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFHbzYPoMzfSOyklAn7ZG0Ly+
# df+TMA0GCSqGSIb3DQEBAQUABIICALuc3hGlfWoPvPLRk5YgWmi/6vH69lTLnrQ0
# ML64M7jsA7fQcdA+lrD6frhH6GIqAEQAXs0NmclCrwUm7Bxz6BBNrI3icMe9bEeC
# 5H9EylrN+LJImvV9yM97Fzv9L1cdZLDsE/prRKCwLLWMN9ndsUXGZsDPJu/uF0YY
# sVltHjMyDDUzAv4YoX9d5VSXUs4CPd4RyGZn5PbrWy5aJgHQW3Ws6NGW83mqzWZS
# ZLA5kbZbc5+M24BwZgiWaZM6Ydha9SFevRz5USNofnb/A/gpEAXyYZYGsy6dBPWK
# s6eK+AH9pI3bbsrpStDGe7U8s8hZx49vyz4PFCndv2ZOYtqHzJzYS9E0zyt9a9mm
# 8plfWajlJdciSdzMBDdhV4cNj0rkQWgBir34rQVLTsqPm6ZqMMRk2GFJiTIiTyfm
# UPOEWx+SwGs78N9qj+ueIY6Hi0a8tbSl6d7BBmLRYOHMAEE8DH1hQY3iAe4V1axZ
# Cif7C0FiFB7qtizguNwvOqLRxnISd6Yn9ipN1jwNa5ZO+IsmyRDt1XzvBdHkt/jL
# 67jn5MiTL7V2VlvDncflToJygL6cUHiuNlXhxPYX0YW0yAkPWbz2M38dSjzkwayH
# muS0x8rDvzyB0WwR16lxUAlH4Z0LXHilrOjSNzecX0RQy4xYsqyrxIxwTght1P0X
# 13lZfRXPoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQCnpK
# iJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJAzELBgkq
# hkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDcxMTEzMTA1MVowLwYJKoZIhvcN
# AQkEMSIEICgBi/VMgb6pyIrplQ06z/MM4yiCSRgMdbJ4pUCQWqfoMA0GCSqGSIb3
# DQEBAQUABIICAG6Etxko1UDBNmEpch6pAfa68rbWrtfiCGYcds2SGle5kyAAYhhO
# 56dG82Yx9X4+Wjg8E6BP/iZTaCCQTjxpqsWnqB2plJiJi6a2pf1qTrZbkmSv7O+8
# FkUSfykn41tTuVU4kyD07LT1oygToEPCjc0QyhPM9Jh0Lh9KBD6+YIv0p9iBu+L4
# wGyDpync/onlEe90wYeq/zmBaTwK/4NOALflYI7SchYlvohy6cEr6ZNt/mo477Lo
# OkJwpishLXoGlJSJfiFbaucaQI4IBp/fO42pVFMxGckW7HzC+JcUQSNvlRqZiYwJ
# +of0ANmgJz7wDuUgMsV3tD95QgjRjFfElUB9MPdT2U/EjLggCPHZXoQwR3CVxKW0
# gKT/znlqP6EgS5ZC6mFWfgLwnAlsuJAFMs50R8ckxCCD/qVxUK+zGtGofCH1TUEw
# he+1Ue0zkAGS0Dwk05SyO9OBSZVSbNJmH81hGHd3S1Y7lQ3FDAtPKOmviEGj4TaC
# HwEZpKpiMxP41OYdlM19OJHSfNkUQBS7ZyrTybbXR9qc5Js1GKWrhb0H1byzfqnO
# AHDZOupgSSKNj3k7pPEF3Gm5m+/TZl6wiB4hq4YyLGDK0tF+A53MP9Q67c4KoXcL
# QjQ1IQqp2XVLjuirvWDTzmGgLVQT0FSUWLWZqOl4KQjOvE7segBaQW5B
# SIG # End signature block
