﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
#<#
$TestInputs=$args
$reportingname='EXO/'+$TestInputs[0]
$userName=$TestInputs[1]
$Password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxyids=$TestInputs[3]
$days=$TestInputs[4]
$rptTopNDD=[int]$TestInputs[5]
$appDetails=$TestInputs[6]
#>

$prxyusrpwd=$proxyids.split("#")
$alldays=$days.split("#")
$proxyUsr=$prxyusrpwd[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyusrpwd[1]
$activeDays=$alldays[0]
$InactiveDays=$alldays[1]
$PassExpDays=$alldays[2]
$ExcludingNames=$alldays[3]
$proxyserverip=($alldays[4]).ToString().trim()

if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}
if($appDetails -and $appDetails -ne 'none'){
    $null=Connect-AzureAD -CertificateThumbprint $thumbPrint -ApplicationId $clientId -TenantId $tenantName
}else{
    Connect-MsolService  -Credential $cred -AzureEnvironment $azureEnvArr[0]
}

$readfiles=0
$readfiles1=0
$readfiles2=0
$readfiles3=0
$dmnPwdExp=@{}

try{  
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $measureterms= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}

try{
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "casmailboxes" -keyFileName "kcasmailboxes" -EgPath $egurkhaPath
    if($readfiles1 -ne $null -and [System.IO.File]::Exists($readfiles1[1]) -eq 'True'){
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]	
        $DDD= import-csv $csvfile1 -Encoding $encTyp
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'casmailboxes' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kcasmailboxes' -InputFile $readfiles1[4]
    }
}
catch{
    $errmsg1=$_.Exception.Message
    Write-Error -Message $errmsg1
}
[System.GC]::GetTotalMemory($true) | out-null

try{
    $readfiles2=Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
    if($readfiles2 -ne $null -and [System.IO.File]::Exists($readfiles2[1]) -eq 'True'){
        $datafile2=$readfiles2[1] -replace (".csv",".dat") 
        $csvfile2=Unprotect-File $datafile2 -Algorithm AES -KeyAsPlainText $readfiles2[0]	
        $mailboxstatistics= import-csv $csvfile2 -Encoding $encTyp
        Remove-Item $csvfile2
        Eg-DeleteFiles -FilePath $readfiles2[2] -Pattern 'statsMailbox' -InputFile $readfiles2[3]
        Eg-DeleteFiles -FilePath $readfiles2[2] -Pattern 'kstatsMailbox' -InputFile $readfiles2[4]
	    $mailStats=$mailboxstatistics | select -First 1
    }
	#$isPreviousScript=[bool]($mailStats.PSobject.Properties.name -match "PrimarySmtpAddress")
}
catch{
    $errmsg2=$_.Exception.Message
    Write-Error -Message $errmsg2
}
[System.GC]::GetTotalMemory($true) | out-null

try{
    $readfiles3=Eg-ReadFile -ComntRptPath $reportingname -FileName "RecipntPerm" -keyFileName "kRecipntPerm" -EgPath $egurkhaPath
    if($readfiles3 -ne $null -and [System.IO.File]::Exists($readfiles3[1]) -eq 'True'){
        $datafile3=$readfiles3[1] -replace (".csv",".dat") 
        $csvfile3=Unprotect-File $datafile3 -Algorithm AES -KeyAsPlainText $readfiles3[0]	
        $ReciPrmterm= import-csv $csvfile3 -Encoding $encTyp
        Remove-Item $csvfile3
        Eg-DeleteFiles -FilePath $readfiles3[2] -Pattern 'RecipntPerm' -InputFile $readfiles3[3]
        Eg-DeleteFiles -FilePath $readfiles3[2] -Pattern 'kRecipntPerm' -InputFile $readfiles3[4]
    }
}
catch{
    $errmsg3=$_.Exception.Message
    Write-Error -Message $errmsg3
}
[System.GC]::GetTotalMemory($true) | out-null

Try{
    if($appDetails -and $appDetails -ne 'none'){
        $dmUsrWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        Get-AzureADDomain | select * |Export-Csv $dmUsrWArr[1] -Encoding $encTyp
        $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
    }else{
        $dmUsrWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        Get-MSOLDomain | select * |Export-Csv $dmUsrWArr[1] -Encoding $encTyp
        $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
    }
}Catch{}
try{
    $dmUsrRArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
    if($dmUsrRArr -ne $null -and [System.IO.File]::Exists($dmUsrRArr[1]) -eq 'True'){
        $uPMDomUsr=$dmUsrRArr[1] -replace (".csv",".dat") 
        $mdomusrPath=Unprotect-File $uPMDomUsr -Algorithm AES -KeyAsPlainText $dmUsrRArr[0]	
        $domain= import-csv $mdomusrPath -Encoding $encTyp
        Remove-Item $mdomusrPath
        Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'O365msolDomUsr' -InputFile $dmUsrRArr[3]
        Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'kO365msolDomUsr' -InputFile $dmUsrRArr[4]
    }
    [System.GC]::GetTotalMemory($true) | out-null
}
catch{
    $errmsg_dmUsr=$_.Exception.Message
	Write-Error -Message $errmsg_dmUsr
}
Try{
	if(!$appDetails -or $appDetails -eq 'none'){
        $passPlcyWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath   
	    foreach($dmn in $domain){
	        $valid=((Get-MsolPasswordPolicy -domain $dmn.Name -ErrorAction SilentlyContinue))| Select-Object -Property @{Name='Domain';Expression={$dmn.Name}},ValidityPeriod
	        if($valid -ne $null -and $valid -ne ''){
		        $valid|Export-Csv -Append -LiteralPath $passPlcyWArr[1] -Encoding $encTyp #-Force
	        }
	    }
	    $null=Protect-File  $passPlcyWArr[1] -Algorithm AES -KeyAsPlainText $passPlcyWArr[0] -RemoveSource
        try{
            $passPlcyRArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath
            if($passPlcyRArr -ne $null -and [System.IO.File]::Exists($passPlcyRArr[1]) -eq 'True'){
                $mpassPlcyUsr=$passPlcyRArr[1] -replace (".csv",".dat") 
                $passPlcyPath=Unprotect-File $mpassPlcyUsr -Algorithm AES -KeyAsPlainText $passPlcyRArr[0]	
                $msolPassword= import-csv $passPlcyPath -Encoding $encTyp
                for($j=0; $j -lt $msolPassword.Length; $j++){
                    $Domain=$msolPassword[$j].Domain.toString()
                    [int]$ValidityPeriod=$msolPassword[$j].ValidityPeriod
                    $dmnPwdExp.Add($Domain,$ValidityPeriod)
                }
                Remove-Item $passPlcyPath
                Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'O365msolpass' -InputFile $passPlcyRArr[3]
                Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'kO365msolpass' -InputFile $passPlcyRArr[4]
            }
        }
        catch{
            $errmsg_passPlcy=$_.Exception.Message
			Write-Error -Message $errmsg_passPlcy
        }
   }
}Catch{
    $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$rptPath+'\'
    $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kO365msolpass*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
    foreach($file in $fileRead){
        $fileName=([String]$file.Name).Trim()
        $chkfil=$egurkhaRprtPath+$fileName
        if([System.IO.File]::Exists($chkfil) -eq 'True'){
            Remove-Item $egurkhaRprtPath$fileName -Force
        }
    }
}
[System.GC]::GetTotalMemory($true) | out-null
    Try{
        if($appDetails -and $appDetails -ne 'none'){
            $writArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
            Get-AzureADUser -All $True| select * |Export-Csv $writArr[1] -Encoding $encTyp
            $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
        }else{
            $writArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
            Get-MsolUser -All| select * |Export-Csv $writArr[1] -Encoding $encTyp
            $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
        }
    }Catch{}

    try{
        $readArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
            $unProtctMUsr=$readArr[1] -replace (".csv",".dat") 
            $musrPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
            $usersview= import-csv $musrPath -Encoding $encTyp
            Remove-Item $musrPath
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
            Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]
        }
    }
    catch{
        $errmsg4=$_.Exception.Message
        Write-Error -Message $errmsg4
    }
    if($readfiles -ne $null){
        Write-Host 'ReadFile:'$readfiles[3]','$readfiles1[3] ','$readfiles2[3] ','$readfiles3[3] ','$readArr[3] ','$dmUsrRArr[3]
    }
	$sysDat=Get-Date
    if($appDetails -and $appDetails -ne 'none'){
	    $MsolRole = Get-AzureADDirectoryRole
    }else{
        $MsolRole = Get-MsolRole
    }
	foreach($roles in $MsolRole){
        if($appDetails -and $appDetails -ne 'none'){
            $rolemember=Get-AzureADDirectoryRoleMember -ObjectId $roles.ObjectId |Where{$_.ObjectType -eq 'User'}|select DisplayName
        }else{
	        $rolemember=Get-MsolRoleMember -RoleObjectId $roles.ObjectId |Where{$_.RoleMemberType -eq 'User'}|select DisplayName
        }
        if($rolemember -ne $null){
		    foreach($rolemembers in $rolemember ){  
                if($appDetails -and $appDetails -ne 'none'){
                    $rolesName=[String]$roles.DisplayName
                }else{
				    $rolesName=[String]$roles.Name
                }
				if($rolesName.Length -gt 200){            
					$rolesName=$rolesName.Substring(0,199)+"..."
				}
                Write-Host 'DDAdminUsers' $rolemembers.DisplayName '!' $rolesName 
		    }
	    }
	} 
    [System.GC]::GetTotalMemory($true) | out-null

    $actSync=0
	$actNonSync=0
	$ExcludingNames=$ExcludingNames.Replace("_"," ")
	$ExcludingName=$ExcludingNames.split('|')
	$DDD=$DDD |where {$ExcludingName -notcontains $_.DisplayName} | Sort-Object DisplayName 

    $CultureDateTimeFormat1 = (Get-Culture).DateTimeFormat
    $DateFormat1 = $CultureDateTimeFormat1.ShortDatePattern
    $TimeFormat1 = $CultureDateTimeFormat1.LongTimePattern
    $DateTimeFormat1 = "$DateFormat1 $TimeFormat1"
    
    $culture = Get-Culture
    $culture.DateTimeFormat.ShortDatePattern = 'yyyy-MM-dd'
    Set-Culture $culture
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"
    $hrfrmt=((Get-Date).ToUniversalTime()).ToString('tt')
    if($hrfrmt -eq $null -or $hrfrmt -eq ''){$hrfrmt='none'}
    <#
    if($isPreviousScript){
	    foreach($Measures in $DDD){
            try{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.PrimarySmtpAddress -eq $Measures.PrimarySmtpAddress} | select LastLogonTime
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }catch{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.PrimarySmtpAddress -eq $Measures.PrimarySmtpAddress} | select LastLogonTime
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)	            
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }
        }
        $lastsyncUsers=$mailboxstatistics | Sort-Object { $_.LastLogonTime -as [DateTime] } -Descending | select -First 10
        foreach($topActiveUsers in  $lastsyncUsers  ){
            $usrLogonDat = [DateTime]::ParseExact($topActiveUsers.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            Write-Host DDActiveSyncUsers $topActiveUsers.PrimarySmtpAddress ~!~ $usrLogonDat
        }
    }
    #>
    #else{
	    foreach($Measures in $DDD){
            try{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.UserPrincipalName -eq $Measures.PrimarySmtpAddress} | select LastActivityDate
                    $lstActDat=([String]$LastLogonTime.LastActivityDate).Trim()
                    if($lstActDat -ne $null -and $lstActDat -ne ''){
                        if($lstActDat.Length -gt 11){
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }else{
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }
                        #$usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
	                    Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		            }
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }catch{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.UserPrincipalName -eq $Measures.PrimarySmtpAddress} | select LastActivityDate
                    $lstActDat=([String]$LastLogonTime.LastActivityDate).Trim()
                    if($lstActDat -ne $null -and $lstActDat -ne ''){
                        if($lstActDat.Length -gt 11){
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }else{
                            $usrLogonDat=Eg-ParseExact -dateStr $lstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                        }
                        #$usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)	            
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		}
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }
        }
        $lastsyncUsers=$mailboxstatistics | Sort-Object { $_.LastActivityDate -as [DateTime] } -Descending | select -First $rptTopNDD
        foreach($topActiveUsers in  $lastsyncUsers  ){
            $topLstActDat=([String]$topActiveUsers.LastActivityDate).Trim()
            if($topLstActDat -ne $null -and $topLstActDat -ne ''){
                if($topLstActDat.Length -gt 11){
                    $usrLogonDat=Eg-ParseExact -dateStr $topLstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }else{
                    $usrLogonDat=Eg-ParseExact -dateStr $topLstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                }
                #$usrLogonDat = [DateTime]::ParseExact($topActiveUsers.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
                Write-Host DDActiveSyncUsers $topActiveUsers.UserPrincipalName ~!~ $usrLogonDat
	}
            }  
    #}
	Write-Host  SyncUsers$actSync'#'$actNonSync
    $ReciPrmterm=$ReciPrmterm | Sort-Object Identity
    foreach($mm in $ReciPrmterm){
	    if($mm -ne $null){
		    $Trustee=[String]$mm.Trustee;$identy=[String]$mm.Identity;$accCntrlTyp=[String]$mm.AccessControlType;$isInherited=[String]$mm.IsInherited;
            $inheritancTyp=[String]$mm.InheritanceType;$isVal=[String]$mm.IsValid;
            if($Trustee.Length -gt 200){ $Trustee=($Trustee.Substring(0,199))+"..." }
            if($identy.Length -gt 200){ $identy=($identy.Substring(0,199))+"..." }
            if($accCntrlTyp.Length -gt 200){ $accCntrlTyp=($accCntrlTyp.Substring(0,199))+"..." }
            if($isInherited.Length -gt 200){ $isInherited=($isInherited.Substring(0,199))+"..." }
            if($inheritancTyp.Length -gt 200){ $inheritancTyp=($inheritancTyp.Substring(0,199))+"..." }
            if($isVal.Length -gt 200){ $isVal=($isVal.Substring(0,199))+"..." }	
            $ddStr='SendAs '+$identy+'~!~'+$Trustee+'~!~'+$accCntrlTyp+'~!~'+$isInherited+'~!~'+$inheritancTyp+'~!~'+$isVal
	        write-host $ddStr
	    }
	}

	$SendOnBehalf=$measureterms |  Where-Object {$_.GrantSendOnBehalfTo -ne ''} | select DisplayName,Alias,UserPrincipalName,PrimarySmtpAddress,GrantSendOnBehalfTo,Identity | Sort-Object Identity
	foreach($mailbox in $SendOnBehalf){	
		$GrantSendOnBehalfTo=[String]$mailbox.GrantSendOnBehalfTo
        if($GrantSendOnBehalfTo.Length -gt 200){
            $GrantSendOnBehalfTo=$GrantSendOnBehalfTo.Substring(0,199)
		    $GrantSendOnBehalfTo=$GrantSendOnBehalfTo+"..."
        }
        $PrimarySmtpAddress=[String]$mailbox.PrimarySmtpAddress
        if($PrimarySmtpAddress.Length -gt 200){
            $PrimarySmtpAddress=$PrimarySmtpAddress.Substring(0,199)
		    $PrimarySmtpAddress=$PrimarySmtpAddress+"..."
        }
		Write-Host SendOnBehalf  $mailbox.DisplayName'~!~'$mailbox.UserPrincipalName'~!~'$PrimarySmtpAddress '~!~'$GrantSendOnBehalfTo'~!~-~!~-'
	}

	$Activecount=0 
	$InActivecount=0
	$neverlogcount=0
    <#
	if($isPreviousScript){
	    Foreach ($mailboxstat in $mailboxstatistics) {           
	        if($mailboxstat.LastLogonTime -eq $null -or $mailboxstat.LastLogonTime -eq "" ){
		        if($mailboxstat.DisplayName -ne "Discovery Search Mailbox"){
		            Write-Host "NeverLoggedIn~"$mailboxstat.PrimarySmtpAddress'~!~-~!~-~!~-~!~-~!~-'
		            $neverlogcount++
		        }
	        }
	        else{
	            #[datetime]$usrLogonDat=$mailboxstat.LastLogonTime
                $usrLogonDat = [DateTime]::ParseExact($mailboxstat.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
		        if($usrLogonDat -gt  $sysDat.AddDays(-$activeDays)){
				    #Write-Host "Active users~"$mailboxstat.PrimarySmtpAddress'~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		            $Activecount++
			    }
			    elseif($usrLogonDat -lt $sysDat.AddDays(-$InactiveDays)){
				    Write-Host "Inactive users~"$mailboxstat.PrimarySmtpAddress'~!~'$usrLogonDat'~!~-~!~-~!~-~!~-'
		            $InActivecount++
			    }
	        }
	    }
    }
    #>
    #else{
        Foreach ($mailboxstat in $mailboxstatistics){           
	        if($mailboxstat.LastActivityDate -eq $null -or $mailboxstat.LastActivityDate -eq "" ){
		        if($mailboxstat.DisplayName -ne "Discovery Search Mailbox"){  
                    if($neverlogcount -lt $rptTopNDD){
		                Write-Host "NeverLoggedIn~"$mailboxstat.UserPrincipalName'~!~-~!~-~!~-~!~-~!~-'
                    }
		            $neverlogcount++
		        }
	        }
	        else{
                $mbLstActDat=([String]$mailboxstat.LastActivityDate).Trim()
                if($mbLstActDat -ne $null -and $mbLstActDat -ne ''){
                    if($mbLstActDat.Length -gt 11){
                        $usrLogonDat=Eg-ParseExact -dateStr $mbLstActDat -DateTimeFormat $DateTimeFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                    }else{
                        $usrLogonDat=Eg-ParseExact -dateStr $mbLstActDat -DateTimeFormat $DateFormat -TimeFormat $TimeFormat -HourFrmt $hrfrmt
                    } 
                #$usrLogonDat = [DateTime]::ParseExact($mailboxstat.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
		        if ($usrLogonDat -gt  $sysDat.AddDays(-$activeDays)){
		            $Activecount++
			    }
			    elseif($usrLogonDat -lt $sysDat.AddDays(-$InactiveDays)){
				    Write-Host "Inactive users~"$mailboxstat.UserPrincipalName'~!~'$usrLogonDat'~!~-~!~-~!~-~!~-'
		            $InActivecount++
			    }
			}
	        }
	    }
    #}
    <#
    $cultureDTFrmt1 = Get-Culture
    $cultureDTFrmt1.DateTimeFormat.ShortDatePattern = 'M/d/yyyy'
    $cultureDTFrmt1.DateTimeFormat.LongTimePattern='h:mm:ss tt'
    Set-Culture $cultureDTFrmt1
    #>
    
    
	$users = $usersview |  where { $_.PasswordNeverExpires -eq $false } 
	$chkEnd=[datetime](Get-Date).AddDays(+$PassExpDays).ToUniversalTime()
	$chkStart=[datetime](Get-Date).ToUniversalTime()
	foreach($user in $users){
        $usrname = $user.UserPrincipalName
        $signname = $user.SignInName
        #[datetime]$passwordSetDate = $user.LastPasswordChangeTimestamp
        $usrPassChangTim=([String]$user.LastPasswordChangeTimestamp).Trim()
	    if($usrPassChangTim -ne $null -and $usrPassChangTim -ne ''){
            if($usrPassChangTim.Length -gt 11){
                $passwordSetDate=Eg-ParseExact -dateStr $usrPassChangTim -DateTimeFormat $DateTimeFormat1 -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }else{
                $passwordSetDate=Eg-ParseExact -dateStr $usrPassChangTim -DateTimeFormat $DateFormat1 -TimeFormat $TimeFormat -HourFrmt $hrfrmt
            }    
        #$passwordSetDate = [DateTime]::ParseExact($user.LastPasswordChangeTimestamp,$DateTimeFormat1,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        $domainName= $usrname.substring($usrname.IndexOf('@')+1)
        [int]$maxPasswordAge=$dmnPwdExp[$domainName]
        try{
	        $expireson = $passwordSetDate.addDays($maxPasswordAge)
            if(($chkStart -le $expireson) -and ($chkEnd -ge $expireson)){
                $userlicAcc =  $user.Licenses.AccountSKUID
                if($userlicAcc -eq $null){
                    $userlicAcc = "-"
                }
                $userislic = $user.IsLicensed
                $usageloc = $user.UsageLocation
                if($usageloc -eq $null){
                    $usageloc = "-"
                }
                Write-Host 'userpassexpire~'$usrname'~!~'$signname'~!~'$expireson'~!~'$userlicAcc'~!~'$userislic'~!~'$usageloc
            }
        }
        catch{}
    }
}
Write-Host 'UsersCount~'$Activecount'~'$InActivecount'~'$neverlogcount
[System.GC]::GetTotalMemory($true) | out-null

# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUuJtR0Q3Ux5Sl37KXdWlr/ISQ
# W9eggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFAlMRNP+
# sOqw0nh7Sot4bgUBOAEsMA0GCSqGSIb3DQEBAQUABIICAHnD3g9PmERJfccq5ZD1
# wVFYo5nKHFLeyQd8RCzvvQeBK7NsmULdLj/0w1NLe3jEf02XEoi92xYad0M4Ev46
# x5EwP8aOfM7Z4ataUwzLeSgzvDl8J9M57C4bHmVzyWNAIElGEzjVMixf+AvBfU0e
# HwpDNCcwlHUQXQfzaKg+BcLxXrNnTwjp/2yZ1S2Ii4Z9mPYrJ8IPK9OODgLaOeOE
# legomfQw6z6Pq4A5mfW/jkxApUeQezUJJSpkdYPr2BLI+ViZgnWf5WCDeYrpuKsZ
# YeFeVM/VBJnzJ/Qo+DVFZfLXeydgie4QsJ+1vYb8dD6bxGNeJlbPJzKIG/FE1wpP
# SDF02ibO0CXdb6+lMcxXfGI2ha7TLrZPVYxUpwL8cSLneubiaXK4i16g0FcC9kBy
# wDDaU4HaAK5ta3d7InF83SUwmqKQaM9diKYZJDJRD2vKx5GU2kRri4gfnfGN6AEN
# Wh03nFt5F62zWzCtOIhygfny91v1+evBzvpv5LOnu0jw1zaubS1/aR39puGH6HtT
# OjquN1LI5qvZgPVGDFlGNUxRhKZApBw1XU2lT91mQlKwm9AT/0nwuY+YKMmrQk1H
# BLaQL6CELwvda/u1Rl3T2H5BupnMbrZYG31txRPbnPcD6q2XwiNiyezTDV092RYI
# Uvq+xmdPV6P/tci4QJqRT9LGoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MDk0
# NFowLwYJKoZIhvcNAQkEMSIEILWvLPIRf264pbXKzRUqxkcbhGX0EjoS0FZkRaVP
# l1zqMA0GCSqGSIb3DQEBAQUABIICAApJM0xMqVYRCO3f1qd//WbSwfY9uezQVTtd
# KjXDkjVo2ZeQBAzy3jWlovqs48P57RZqIMeDCzPoc6NEKO90ry8wUB+mvRzv0pLE
# 8QcHaiukMNe7bkmuhsMPS3nZF22V23M3PmSFj8hijjimkroOMUB46hvpRIJt7lV/
# sug0EiVmAGTF5O/kwH7Sako7cD5htK07Pf/XaxwpMJXDM+OQ5hG72m6O3+BHTLJi
# JgPR+k2TCeMJ7vJpHUXHIjprCw8fm2FHYBGdp9aW1/BDMSd3lwfuj+DyjJ5FGc1q
# pnnXuhaoP4rflifnyProp/PFQX1dDYpf/xXSjP/n2CTJu/S1vRoDNOyVgqRxd2Tv
# y6Q4TytdnqI2NAYA/UEnMdN0L9uQ2V9RT4ZYJE+OPg8JVjp5A6Uuyy0cQq3AHYP9
# 2cPteZmhUpAC0Jdurs3AD221J5B1gldQt2rySZUsUPf4Cf1zMJuvHI9ODDhjPp+Z
# mU0daYSIyqv0g/O647JJ9kpl+2XOfS1FR4Ly+YzuYNSx76p74gvvcXh1kAMD8t7Q
# g0VOwgllfQcq9q0J2FMtugpj35Ns0wCn6Y1OPEgGgADCsFYasTCt71PoPm9WLwJf
# vJif3i2gUVAA8O2Z0+Y8/omsA/mkuJsntDtzrh/WkIZbTAIF0PaEmmeky8drWQVA
# BsQ0pdUT
# SIG # End signature block
