﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()

function IsFileExists
{
    param(
        [Parameter(Mandatory=$true, Position=0)]
        [string] $fileName
    )
    process {
        $tempName = $fileName.Substring(0, $fileName.lastIndexOf('.csv'))
        $tempName = $tempName+'1.csv'
        If (Test-Path $tempName) {
            Remove-Item -Path $tempName -Force
        }
        If (Test-Path $fileName) {
            Get-ChildItem $fileName | Rename-Item -NewName {$_.Name -replace ".csv", "1.csv"}
        }
    }
}

function WriteToCSV
{
    Param
    (
         [Parameter(Mandatory=$true, Position=0)]
         [string] $fileName,
         [Parameter(Mandatory=$true, Position=1)]
         [Object[]]$data
    )
    process {
        If (Test-Path $fileName) {
            $dtls=Get-Content -Path $fileName
            $rows = $dtls.Length-1
            if($rows -lt 50000){
                $data | Export-Csv -Path $fileName -NoTypeInformation -Append
            }
            <#else{
                IsFileExists -fileName $fileName
                $data | Export-Csv -Path $fileName -NoTypeInformation
            }#>
        }else{
            $data | Export-Csv -Path $fileName -NoTypeInformation
        }
    }
}
clear
$InputDays=$args
$USER_INPUT=$InputDays[0]
$tFreq = [int]$InputDays[1]
$dFreq = [int]$InputDays[2]
$Test_Freq=(Get-Date).AddMinutes(-$tFreq)
$Dormant_Freq=(Get-Date).AddDays(-$dFreq)
$rptNam= $InputDays[3]
$writecsv= $InputDays[4]
$rptTopNDD= [int]$InputDays[5]
# Start-SPAssignment –Global
$ListNotAccess=""
$NoSitesCoAvailable=""
# Initializing the total variables 
$FileSize = @{}
$FileTypeCount = @{}
$FileSpecificCount = @{}
$TotalSiteCount=0
$TotalListCount = 0
$TotalDocLibraryCount = 0
$TotalDocCount = 0
$TotalUserCount = 0
$TotalSCCount = 0
$TotalVerCount =0 
$TotalDocSize = 0
$TotAvgDocPerDocLibrary=0
$TotalAttachments=0 
$TotalSiteCollSize=0
$TotalSiteSize = 0;
$SiteSize = 0
$TotalDormCount = 0
$TotalRecUpdCount = 0
$TotalRecAddCount = 0

$webs=$null;
$web="";
$file="";

$rootPath=$egurkhaPath +'\agent\SP\'+$rptNam+'\'
if(!(Test-Path -Path $rootPath )){
    $null=New-Item -ItemType directory -Path $rootPath
}

$RecAddedFileName=$rootPath+'Recently Added Files.csv'
$RecUpdatedFileName=$rootPath+'Recently Updated Files.csv'
$DormantFileName=$rootPath+'Dormant Files.csv'

if($writecsv){
    IsFileExists -fileName $RecAddedFileName
    IsFileExists -fileName $RecUpdatedFileName
    IsFileExists -fileName $DormantFileName
}

$webApp = Get-SPWebApplication;

foreach($webs in $webApp)
{
    try{
        # Initialize all variables to 0 at the start of the loop 
        $SiteCount=0
        $ListCount=0;
        $DocLibraryCount=0
        $DocCount=0 
        $UserCount=0
        $SCCount=0
        $VerCount =0 
        $DocSize=0
        $AvgDocPerDocLibrary=0
        $AvgSizeofDocument=0
        $SCSize=0 
        $ContentDBCount=0
        $AttachmentCount=0
        $SiteCount=0
        $wa = $webs.url
        $run=0
        
        $WebAppContentDB = $webs.ContentDatabases
        $WebAppConentDBName=""
    
        foreach($cd in $WebAppContentDB){
            $WebAppConentDBName = $WebAppConentDBName + $cd.Name + "~"
        }
	
        $ContentDBCount =$webs.ContentDatabases.Count             # Get the count of content databases associated to this web application
        $SCCount=$webs.Sites.Count                                # Get the count of site collections in a web application

        Write-Host 'Web application --->>> '$webs.Name 'Site collection -->>>> ' $webs.Sites 'SCCount ---->>>> ' $SCCount   
        try{
            $usr= $webs.Policies | select UserName,DisplayName #| Where-Object { (!($_.UserName -like "*AUTHORITY*")) -and 	(!($_.DisplayName -like "Search Crawling Account")) }
                
            foreach($us in $usr){
                $UserCount=$UserCount+1
            }
        }
        catch{
            $ErrorMessage = $_.Exception.Message
            write-host "catch block >>>> usr= webs.Policies >>>>> ErrorMessage :: " $ErrorMessage -ForegroundColor Red
        }

        $SPSCs = get-spsite -limit all -WebApplication $wa 
   
        foreach ($SPSC in $SPSCs){
            $SPSCURL = $SPSC.url
	        $SCSize = $SCSize + ($SPSC.Usage.Storage)/1MB;  # Get size of site collection 

            $allWebs = $SPSC.allwebs    # Get the count of sites in a web application 

             if($allWebs.Count -gt 0){
                $run=1
                $SiteCount = $SiteCount + $allWebs.count
            
                foreach ($spweb in $allWebs){
                    $listColl = $spweb.Lists
                    foreach ($list in $listColl){                
                        if($list.BaseType -eq "GenericList" -and  $list.BaseTemplate -eq "GenericList")   {  # Process only list types
    	                    $ItemsColl = $list.Items
    	                    if ($ItemsColl -ne $null){
        	                    foreach ($item in $ItemsColl){
			                        $AttachmentCollection = $item.Attachments
			                        $folder = $spweb.GetFolder($attachmentCollection.UrlPrefix);
			                        foreach ($file in $folder.Files){
			                            $AttachmentCount++;                            # Get the attachment count
			                        }
    		                    }
    	                    }
                        }
                        elseif($list.BaseType -ne "DocumentLibrary" -and  $list.BaseTemplate -ne "DocumentLibrary"){  
                            $ListCount++;
                        } 
                        if($List -ne $null){
                            if($List.GetType().Name -eq "SPDocumentLibrary" -and -not $List.Hidden){
    	                        $ItemsColl = $List.Items
                                $DocLibraryCount++;	                        
    
    	                        if ($ItemsColl -ne $null){
                                    Try{
    		                            foreach ($item in $ItemsColl){
        
                                        #Write-Host 'SpDocuments -- item -- ' $item.File
    			                           

                                            $fileName=($item.File.Name).ToString()
                                            $extentions=$fileName.Split(".")
                                            if($extentions -ne $null -and $extentions -ne ''){
                                                $idx=[int]$extentions.Count
                                                $extention=$extentions[$idx-1]
                                                if( $extention -notcontains "aspx" -and $extention -ne $null -and $extention -ne ''){
                                                    $DocCount =$DocCount + 1;                          # Get the documents count
                                                    $DocSize = $DocSize + ($item.File).length/1MB      # Get the document size 
                                                    $VerCount = $VerCount + $item.File.Versions.Count  # Get the versions count  

                                                    $fileSizeByte = ($item.File).length
                                                    $fileSizeMB=$fileSizeByte/1048576
                                                    $fileSizeMB=[Math]::Round(($fileSizeMB),2)
                                                    if($FileSize.ContainsKey($extention)){
                                                        $integer=$FileSize.Get_Item($extention)
                                                        $SizeCount = $integer -as [int]
                                                        $SizeCount =$SizeCount+$fileSizeMB
                                                        $FileSize.Set_Item($extention, $SizeCount)
                                                        $Counts=$FileTypeCount.Get_Item($extention)
                                                        $c = $Counts -as [int]
                                                        $c = $c+1
                                                        $FileTypeCount.Set_Item($extention, $c)
                                                    }
                                                    else{
                                                        $FileSize.Add($extention, $fileSizeMB)
                                                        $newTypeCount=1
                                                        $FileTypeCount.Add($extention, $newTypeCount)
                                                    }
                                                                         
                                                    if($item.File.TimeCreated -ge $Test_Freq){
                                                        $TotalRecAddCount = $TotalRecAddCount + 1;
                                                        $tempData= $item.File | Select-Object -Property Name, DocumentLibrary, Web, Url, ServerRelativeUrl, ParentFolder, Title, Author, ModifiedBy, TimeCreated, TimeLastModified, Length, UniqueId
                                                        $tempStr = $tempData | ForEach-Object { 'SPDocAndPages~REC ADDED~' + $_.Name + '~!~' + $_.DocumentLibrary + '~!~' + $_.Web + '~!~' + $_.Url + '~!~' + $_.ServerRelativeUrl + '~!~' + $_.ParentFolder + '~!~' + $_.Title + '~!~' + $_.Author + '~!~' + $_.ModifiedBy + '~!~' + $_.TimeCreated + '~!~' + $_.TimeLastModified + '~!~' + $_.Length + '~!~' + $_.UniqueId }
                                                        if($TotalRecAddCount -le $rptTopNDD){
                                                            Write-Host $tempStr
                                                        }
                                                        if($writecsv){
                                                            WriteToCSV -fileName $RecAddedFileName -data $tempData    
                                                        }
                                                    }

                                                    if($item.File.TimeLastModified -ge $Test_Freq -and $item.File.TimeCreated -ne $item.File.TimeLastModified){
                                                        $TotalRecUpdCount = $TotalRecUpdCount + 1;
                                                        $tempData= $item.File | Select-Object -Property Name, DocumentLibrary, Web, Url, ServerRelativeUrl, ParentFolder, Title, Author, ModifiedBy, TimeCreated, TimeLastModified, Length, UniqueId
                                                        $tempStr = $tempData | ForEach-Object { 'SPDocAndPages~REC UPDATED~' + $_.Name + '~!~' + $_.DocumentLibrary + '~!~' + $_.Web + '~!~' + $_.Url + '~!~' + $_.ServerRelativeUrl + '~!~' + $_.ParentFolder + '~!~' + $_.Title + '~!~' + $_.Author + '~!~' + $_.ModifiedBy + '~!~' + $_.TimeCreated + '~!~' + $_.TimeLastModified + '~!~' + $_.Length + '~!~' + $_.UniqueId }
                                                        if($TotalRecUpdCount -le $rptTopNDD){
                                                            Write-Host $tempStr
                                                        }
                                                        if($writecsv){
                                                            WriteToCSV -fileName $RecUpdatedFileName -data $tempData    
                                                        }
                                                    }

                                                    if($item.File.TimeCreated -le $Dormant_Freq){
                                                        $TotalDormCount = $TotalDormCount + 1;
                                                        $tempData= $item.File | Select-Object -Property Name, DocumentLibrary, Web, Url, ServerRelativeUrl, ParentFolder, Title, Author, ModifiedBy, TimeCreated, TimeLastModified, Length, UniqueId
                                                        $tempStr = $tempData | ForEach-Object { 'SPDocAndPages~IN_ACTIVE~' + $_.Name + '~!~' + $_.DocumentLibrary + '~!~' + $_.Web + '~!~' + $_.Url + '~!~' + $_.ServerRelativeUrl + '~!~' + $_.ParentFolder + '~!~' + $_.Title + '~!~' + $_.Author + '~!~' + $_.ModifiedBy + '~!~' + $_.TimeCreated + '~!~' + $_.TimeLastModified + '~!~' + $_.Length + '~!~' + $_.UniqueId }
                                                        if($TotalDormCount -le $rptTopNDD){
                                                            Write-Host $tempStr
                                                        }
                                                        if($writecsv){
                                                            WriteToCSV -fileName $DormantFileName -data $tempData
                                                        }
                                                    }
                                                } 
                                            }                                     
    		                            }
                                    }Catch{
                                        Write-Host "catch block >>> Error Occured while processing file types and document counts >>>>> " $_.Exception.Message
                                    }
    	                        }
                            }
                        }
                    }

                }
                if($spweb -ne $null){
                    $spweb.dispose()
                }
            Write-Host 'Documents --->>> ' $DocLibraryCount ' -- ' $DocCount ' -- ' $DocSize ' -- ' $VerCount

            #Below function is to return the Size of the Site and it's Sub-sites in MB.
            function GetWebSizes ($StartWeb){
                $web = Get-SPWeb $StartWeb
                [long]$total = 0
                $total += GetWebSize -Web $web
                $total += GetSubWebSizes -Web $web
                $totalInMb = ($total/1024)/1024
                $totalInMb = "{0:N4}" -f $totalInMb
                $web.Dispose()
                $totalInMb = [Math]::Round($totalInMb,4)
                #write-host $StartWeb "which is" $totalInMb "MB"
                return $totalInMb
            }

            #Below function is to get the Size of the Site.
            function GetWebSize ($Web){
    	        [long]$subtotal = 0
    	        foreach ($folder in $Web.Folders){
    		        $subtotal += GetFolderSize -Folder $folder
    	        }
                return $subtotal
            }

            #Below function is to get the Size of the SubSites under the site.
            function GetSubWebSizes ($Web){
                [long]$subtotal = 0
    	        foreach ($subweb in $Web.GetSubwebsForCurrentUser()){
    		        [long]$webtotal = 0
    		        foreach ($folder in $subweb.Folders){
                       $webtotal += GetFolderSize -Folder $folder
    		        }
    		        $subtotal += $webtotal
    		        $subtotal += GetSubWebSizes -Web $subweb
    	        }
                return $subtotal
            }

            #Below function to Get the Folder size of the SubWebSizes.
            function GetFolderSize ($Folder){
                [long]$folderSize = 0  
                foreach ($file in $Folder.Files){
    		        $folderSize += $file.Length;
    	        }
                foreach ($fd in $Folder.SubFolders){
    		        $folderSize += GetFolderSize -Folder $fd
    	        }
                return $folderSize
            }

            try{
                if($SPSCURL -ne $null){
                    $SiteSize += GetWebSizes -StartWeb $SPSCURL
                }
            }catch{
                Write-Host "catch block >>> Error Occured while assigning site size >>>>> " $_.Exception.Message

            }
        }
    }


    # Calculate the Average Document per document library and average document size 
    try { $AvgDocPerDocLibrary = $DocCount/$DocLibraryCount } catch { $AvgDocPerDocLibrary=0 }
    try { $AvgSizeofDocument = $DocSize / $DocCount  } catch { $AvgSizeofDocument=0  }

    # Get the Totals 
    $TotalListCount = $TotalListCount + $ListCount        
    $TotalDocLibraryCount =$TotalDocLibraryCount + $DocLibraryCount
    $TotalDocCount = $TotalDocCount + $DocCount
    $TotalUserCount = $TotalUserCount + $UserCount
    $TotalSCCount = $TotalSCCount + $SCCount
    $TotalSiteCount = $TotalSiteCount + $SiteCount
    $TotalDocSize = $TotalDocSize + $DocSize 
    $TotalAttachments = $TotalAttachments + $AttachmentCount
    $TotalSiteCollSize=$TotalSiteCollSize + $SCSize
    $TotalVerCount =$TotalVerCount+$VerCount;
    $TotalSiteSize = $TotalSiteSize +$SiteSize;

    # Rounding the values to 4 decimals 
    $SCSize=[Math]::Round($SCSize,4) 
    $DocSize=[Math]::Round($DocSize,4) 
    $AvgDocPerDocLibrary=[Math]::Round($AvgDocPerDocLibrary,4)


#    if($run -eq 1){
        Write-Host  "$($webs.Name)|$ListCount|$DocLibraryCount|$DocCount|$UserCount|$SCCount|$SiteCount|$DocSize|$VerCount|$AvgDocPerDocLibrary|$AttachmentCount|$SCSize|$ContentDBCount|$WebAppConentDBName"
 #   }
    if(($run -eq 0) -and ($SCCount -gt 0)){
        Write-Host 'inside SCCount -gt 0'
        if($ListNotAccess.Length -le 0){
            $ListNotAccess=$webs.Name
        }
        else{
            $ListNotAccess=$ListNotAccess+" ,"+$webs.Name
        }
    }
    elseif(($SCCount -eq 0)){
        Write-Host 'inside SCCount -eq 0'
        if($NoSitesCoAvailable.Length -le 0){
            $NoSitesCoAvailable=$webs.Name
        }
        else{
            $NoSitesCoAvailable=$NoSitesCoAvailable+" ,"+$webs.Name
        }
    }
    $UserCount=$null;
}#end of try
    finally{

        try
        {
            if($SPSC -ne $null)
            {
                $SPSC.Dispose();
            }
        }
        catch
        {
             $ErrorMessage = $_.Exception.Message
             write-host "catch block >>> foreach(webs in webApp) ErrorMessage ::" $ErrorMessage -ForegroundColor Red
        }

    }
}# end of loop

# Rounding the Total values to 4 decimals 
if($TotalDocCount -ne 0){
    $TotAvgDocPerDocLibrary = [Math]::Round($TotalDocCount/$TotalDocLibraryCount,4) 
}
$TotalDocSize = [Math]::Round($TotalDocSize,4) 
$TotalSiteCollSize = [Math]::Round($TotalSiteCollSize,4)

Write-host  "Total $TotalListCount|$TotalDocLibraryCount|$TotalDocCount|$TotalUserCount|$TotalSCCount|$TotalSiteCount|$TotalDocSize|$TotalVerCount|$TotAvgDocPerDocLibrary|$TotalAttachments|$TotalSiteCollSize|$SiteSize|$TotalRecAddCount|$TotalRecUpdCount|$TotalDormCount"

if($ListNotAccess.Length -gt 0){
    Write-Host "User := " $USER_INPUT " does not have required access to the following web application(s) - " $ListNotAccess
}

if($NoSitesCoAvailable.Length -gt 0){
    Write-Host "User := " $USER_INPUT " No SiteCollection(s) for the following web application(s) - " $NoSitesCoAvailable
}

$TotalFilesSize=0
          
foreach ($h in $FileTypeCount.GetEnumerator()){
    $fileType=$h.Name
    $FileCount=$h.Value
    $Size=$FileSize.Get_Item($fileType)
    $TotalFilesSize=$TotalFilesSize+$Size

    Write-Host 'FileTypeTest~' $("."+$fileType) '~' $FileCount '~' $Size
}

write-host "FileSizeMB~"$TotalFilesSize
# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUYLvV5NTl16WERy+TGDFsiKTr
# XYegghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFOUcb0lqU3IQRiHm
# LE9l9D+AT1hjMA0GCSqGSIb3DQEBAQUABIICAA5lKOamIcHj5QYtgSo7Xy84TEo8
# ze6/2OhfIzyTHM7Bj54oFIbd044hRgEszi/+JEc243XK1QoMqYLinZHZmxsq45fj
# OcAFkl/UJrc4MeKXujc2fnXjDnIegU/H3Z1UU51zmvZLX1mumsiU+tPOtYMNNDjY
# koCNsc1TlOQj5UPExTHQAabxJrNT/svKHhbTo8SGXeeLijj9i5buHqqzFdR0eOTt
# POeOKJXdQ0A0UIs+SbjpzGWSHfdF23GJIgWx1n8QNsFjqREG0gou+Urm/BDeXWov
# DC5GgS51zi2jbUiqGcoWrCxdOLqz3FLoLx36niKKjs4dVLUNwOWtgUrraUlWPo7r
# 7fkcuyfzlmZXKrfcMLrG0hnTiXNfNihIExtJ4kJ7G95jrM+ElAPFP7lHptcwpfvf
# QfHjuACpWjY2k3HarV5fcfS49kcefFP3hPY2TthKGMKaI0xdWAtE3xTm1gfhFYZ8
# pV875iAcojPiEgOUeBehp5w244zNr/DyV7MSyhH9FcB8GoY5dASqNy19W5/4YuRD
# uy4mBpVi2amoGq71n2OakdkeiJnHRlFFHbsRADOm5e2LMu/8jY8cB8xtthHZD6xD
# 6++lV8JRtiVwmiZQHSKbhrNzFvPEoRslRKBM67Y5hgw1nChv30CibwtdSsiCQyz7
# yXWR0sjKmyxmfW7noYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM1NDhaMC8GCSqGSIb3DQEJBDEiBCDB+C8jNaV5SPjlAdsfLkFefNwC
# w/DO4keWMpwyOjlEbzANBgkqhkiG9w0BAQEFAASCAQAYXNPgMI7Qg23JGmw++Qdu
# S1ZAbvJK0Py/NI9XLC22hEYi9FYL4PvlR6XggTGbW2gkhrwLzaQ2KGITMfA3b4mp
# musVTDLbX3ZLYbUFzhT00zQaQl7eQkdT5qoVKpZvKDgkjds3Zy8TG0BhbuPElzil
# 5mll7KWDTNS0/EqDlYyWBHXIrzbCCWaljNUNcBxC5T1I5FtqGk2qd9ca9ddP1RYD
# lkqUmu2f2+2VQ/XuEAEz3OUsJxIBP1JWtQErLC+7luEB6MwnpiOaO5Cvv3sQUP0O
# ZDM6sio8YGLHpqzq4HhBu60cn+zc6g4+lVdnVm3FWFBrpVDlj7SucKD4jSCZq69r
# SIG # End signature block
