$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

import-module Lync

$Global:ErrorActionPreference="SilentlyContinue"
if($args.count -ne 5)
{
	Write-Host("Please provide <user1> <pwd1> <user2> <pwd2> <sitename> as arguments")
	return
}
$user1 = $args[0]
$pass1 = $args[1] | ConvertTo-SecureString -asPlainText -Force 
$cred1 = New-Object System.Management.Automation.PSCredential($user1,$pass1)
$sipuser1 = get-csuser -Identity $user1 
 
$user2 = $args[2]
$pass2 = $args[3] | ConvertTo-SecureString -asPlainText -Force 
$cred2 = New-Object System.Management.Automation.PSCredential($user2,$pass2)
$sipuser2 = get-csuser -Identity $user2 

$sitename = $args[4]
$SelectedSiteIdentity = "Site:" + $sitename
$Pools = Get-CsPool | where {$_.Site -eq $SelectedSiteIdentity} | Where {$_.Services -like ("*Registrar*")}
$fqdn = $Pools[0].Fqdn

Write-host "Started Test-CsAVConference"
$CsAVConference = Test-CsAVConference -TargetFqdn $fqdn -SenderSipAddress $sipuser1.SipAddress -SenderCredential $cred1 -ReceiverSipAddress $sipuser2.SipAddress -ReceiverCredential $cred2
if($CsAVConference.Result -eq "Success")
{
	Write-Host("Test-CsAVConference:100")
	Write-Host("Test-CsAVConference:"+$CsAVConference.Latency) 
}
else
{
	Write-Host("Test-CsAVConference:0")
	Write-Host("Test-CsAVConference:-5")
	Write-Host("Test-CsAVConference:"+$CsAVConference.Error)
}
Write-host "Ended Test-CsAVConference"
Write-host ""

Write-host "Started Test-CsAddressBookService"
$Addressbookservice = Test-CSAddressbookService -TargetFQDN $fqdn -UserCredential $cred1 -UserSipAddress $sipuser1.SipAddress
if($Addressbookservice.Result -eq "Success")
{
	Write-Host("Test-CsAddressbookservice:100")
	Write-Host("Test-CsAddressbookservice:"+$Addressbookservice.Latency) 
}
else
{
	Write-Host("Test-CsAddressbookservice:0")
	Write-Host("Test-CsAddressbookservice:-5")
	Write-Host("Test-CsAddressbookservice:"+$Addressbookservice.Error)
}
Write-host "Ended Test-CsAddressbookservice"
Write-host ""

Write-host "Started Test-CsAddressBookWebQuery"
$AddressbookWebQuery = Test-CSAddressBookWebQuery -TargetFQDN $fqdn -UserCredential $cred1 -UserSipAddress $sipuser1.SipAddress
if($AddressbookWebQuery.Result -eq "Success")
{
	Write-Host("Test-CsAddressbookWebQuery:100")
	Write-Host("Test-CsAddressbookWebQuery:"+$AddressbookWebQuery.Latency) 
}
else
{
	Write-Host("Test-CsAddressbookWebQuery:0")
	Write-Host("Test-CsAddressbookWebQuery:-5")
	Write-Host("Test-CsAddressbookWebQuery:"+$AddressbookWebQuery.Error)
}
Write-host "Ended Test-CsAddressbookWebQuery"
Write-host ""

Write-host "Started Test-CsASConference"
$CsASConference = Test-CsASConference -TargetFQDN $fqdn -SenderSipAddress $sipuser1.SipAddress -SenderCredential $cred1 -ReceiverSipAddress $sipuser2.SipAddress -ReceiverCredential $cred2
if($CsASConference.Result -eq "Success")
{
	Write-Host("Test-CsASConference:100")
	Write-Host("Test-CsASConference:"+$CsASConference.Latency) 
}
else
{
	Write-Host("Test-CsASConference:0")
	Write-Host("Test-CsASConference:-5")
	Write-Host("Test-CsASConference:"+$CsASConference.Error)
}
Write-host "Ended Test-CsASConference"
Write-host ""

Write-host "Started Test-CsClientAuthentication"
$ClientAuthentication = Test-CsClientAuthentication -TargetFQDN $fqdn -UserCredential $cred1 -UserSipAddress $sipuser1.SipAddress
if($ClientAuthentication.Result -eq "Success")
{
	Write-Host("Test-CsClientAuthentication:100")
	Write-Host("Test-CsClientAuthentication:"+$ClientAuthentication.Latency) 
}
else
{
	Write-Host("Test-CsClientAuthentication:0")
	Write-Host("Test-CsClientAuthentication:-5")
	Write-Host("Test-CsClientAuthentication:"+$ClientAuthentication.Error)
}
Write-host "Ended Test-CsClientAuthentication"
Write-host ""

Write-host "Started Test-CsDataConference"
$CsDataConference = Test-CsDataConference -TargetFQDN $fqdn -SenderSipAddress $sipuser1.SipAddress -SenderCredential $cred1 -ReceiverSipAddress $sipuser2.SipAddress -ReceiverCredential $cred2
if($CsDataConference.Result -eq "Success")
{
	Write-Host("Test-CsDataConference:100")
	Write-Host("Test-CsDataConference:"+$CsDataConference.Latency) 
}
else
{
	Write-Host("Test-CsDataConference:0")
	Write-Host("Test-CsDataConference:-5")
	Write-Host("Test-CsDataConference:"+$CsDataConference.Error)
}
Write-host "Ended Test-CsDataConference"
Write-host ""

Write-host "Started Test-CsIm"
$CsIm = Test-CsIm -TargetFQDN $fqdn -SenderSipAddress $sipuser1.SipAddress -SenderCredential $cred1 -ReceiverSipAddress $sipuser2.SipAddress -ReceiverCredential $cred2
if($CsIm.Result -eq "Success")
{
	Write-Host("Test-CsIm:100")
	Write-Host("Test-CsIm:"+$CsIm.Latency) 
}
else
{
	Write-Host("Test-CsIm:0")
	Write-Host("Test-CsIm:-5")
	Write-Host("Test-CsIm:"+$CsIm.Error)
}
Write-host "Ended Test-CsIm"
Write-Host ""

Write-host "Started Test-CsPresence"
$CsPresence = Test-CsPresence -TargetFQDN $fqdn -SenderSipAddress $sipuser1.SipAddress -SenderCredential $cred1 -ReceiverSipAddress $sipuser2.SipAddress -ReceiverCredential $cred2
if($CsPresence.Result -eq "Success")
{
	Write-Host("Test-CsPresence:100")
	Write-Host("Test-CsPresence:"+$CsPresence.Latency) 
}
else
{
	Write-Host("Test-CsPresence:0")
	Write-Host("Test-CsPresence:-5")
	Write-Host("Test-CsPresence:"+$CsPresence.Error)
}
Write-host "Ended Test-CsPresence"
Write-host ""

Write-host "Started Test-CsRegistration"
$CsRegistration = Test-CsRegistration -TargetFQDN $fqdn -UserCredential $cred1 -UserSipAddress $sipuser1.SipAddress
if($CsRegistration.Result -eq "Success")
{
	Write-Host("Test-CsRegistration:100")
	Write-Host("Test-CsRegistration:"+$CsRegistration.Latency) 
}
else
{
	Write-Host("Test-CsRegistration:0")
	Write-Host("Test-CsRegistration:-5")
	Write-Host("Test-CsRegistration:"+$CsRegistration.Error)
}
Write-host "Ended Test-CsRegistration"
Write-host ""

Write-host "Started Test-CsUcwaConference"
$CsUcwaConference = Test-CsUcwaConference -TargetFQDN $fqdn -OrganizerSipAddress $sipuser1.SipAddress -OrganizerCredential $cred1 -ParticipantSipAddress $sipuser2.SipAddress -ParticipantCredential $cred2
if($CsUcwaConference.Result -eq "Success")
{
	Write-Host("Test-CsUcwaConference:100")
	Write-Host("Test-CsUcwaConference:"+$CsUcwaConference.Latency) 
}
else
{
	Write-Host("Test-CsUcwaConference:0")
	Write-Host("Test-CsUcwaConference:-5")
	Write-Host("Test-CsUcwaConference:"+$CsUcwaConference.Error)
}
Write-host "Ended Test-CsUcwaConference"
Write-host ""

Write-host "Started Test-CsWebApp "
$CsWebApp  = Test-CsWebApp -TargetFQDN $fqdn -UserSipAddress $sipuser1.SipAddress -UserCredential $cred1 -User2SipAddress $sipuser2.SipAddress -User2Credential $cred2
if($CsWebApp.Result -eq "Success")
{
	Write-Host("Test-CsWebApp:100")
	Write-Host("Test-CsWebApp:"+$CsWebApp.Latency) 
}
else
{
	Write-Host("Test-CsWebApp:0")
	Write-Host("Test-CsWebApp:-5")
	Write-Host("Test-CsWebApp:"+$CsWebApp.Error)
}
Write-host "Ended Test-CsWebApp "
Write-host ""

Write-host "Started Test-CsWebScheduler"
$CsWebScheduler = Test-CsWebScheduler -TargetFQDN $fqdn -UserCredential $cred1 -UserSipAddress $sipuser1.SipAddress
if($CsWebScheduler.Result -eq "Success")
{
	Write-Host("Test-CsWebScheduler:100")
	Write-Host("Test-CsWebScheduler:"+$CsWebScheduler.Latency) 
}
else
{
	Write-Host("Test-CsWebScheduler:0")
	Write-Host("Test-CsWebScheduler:-5")
	Write-Host("Test-CsWebScheduler:"+$CsWebScheduler.Error)
}
Write-host "Ended Test-CsWebScheduler"
Write-host ""


