$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
#Add-PSSnapin "Microsoft.SystemCenter.VirtualMachineManager"

#$$snapinModule = Get-PSSnapin -Registered -Name "Microsoft.SystemCenter.VirtualMachineManager" -ErrorAction SilentlyContinue
#$snapinFile = $snapinModule.ModuleName
#Import-Module -name $snapinFile 

Write-Host "SCVMHostGroup"
Write-Host "-------------"
$SCVMHostGroups = Get-SCVMHostGroup -VMMServer localhost
if ($SCVMHostGroups -ne $null)
{
	foreach ($SCVMHostGroup in $SCVMHostGroups)
	{
		Write-Host ($SCVMHostGroup.ID,$SCVMHostGroup.Name,$SCVMHostGroup.Path) -Separator "#~#"
	}
}

Write-Host "SCVMHostCluster"
Write-Host "---------------"
$SCVMHostClusters = Get-SCVMHostCluster -VMMServer localhost
if ($SCVMHostClusters -ne $null)
{
	foreach ($SCVMHostCluster in $SCVMHostClusters)
	{
		$AllNodes = ""
		$Nodes = $SCVMHostCluster.Nodes
		if ($Nodes -ne $null)
		{
			foreach ($Node in $Nodes)
			{
				if ($AllNodes.length -eq 0)
				{
					$AllNodes = $Node.ToString()
				}
				else
				{
					$AllNodes = $AllNodes + "," + $Node.ToString()
				}
			}
		}

		if ($AllNodes -eq $null -or $AllNodes.length -eq 0)
		{
			$AllNodes = "-"
		}

		$VMwareResourcePool = $SCVMHostCluster.VMwareResourcePool
		if ($VMwareResourcePool -eq $null -or $VMwareResourcePool.length -eq 0)
		{
			$VMwareResourcePool = "-"
		}

		$IPAddresses = ""
		$IPAddress = $SCVMHostCluster.IPAddresses
		if ($IPAddress -ne $null)
		{
			foreach ($IPAddr in $IPAddress)
			{
				if ($IPAddresses.length -eq 0)
				{
					$IPAddresses = $IPAddr.IPAddressToString
				}
				else
				{
					$IPAddresses = $IPAddresses + "," + $IPAddr.IPAddressToString
				}
			}
		}
		if ($IPAddresses -eq $null -or $IPAddresses.length -eq 0)
		{
			$IPAddresses = "-"
		}
		Write-Host ($SCVMHostCluster.ID,$SCVMHostCluster.Name,$SCVMHostCluster.ClusterName,$SCVMHostCluster.DomainName,$SCVMHostCluster.HostGroup,$SCVMHostCluster.ClusterReserve,
		$SCVMHostCluster.ClusterReserveState,$SCVMHostCluster.IsVMwareHAEnabled,$SCVMHostCluster.IsVMwareDrsEnabled,$SCVMHostCluster.AvailableStorageNode,
		$VMwareResourcePool,$SCVMHostCluster.VirtualizationPlatform,$AllNodes,$IPAddresses,$SCVMHostCluster.HostGroupID) -Separator "#~#"
	}
}

Write-Host "SCVMHost"
Write-Host "--------"
$SCVMHosts = Get-SCVMHost -VMMServer localhost
if ($SCVMHosts -ne $null)
{
	foreach ($SCVMHost in $SCVMHosts)
	{
		$AllVMs = ""
		$VMs = $SCVMHost.VMs
		if ($VMs -ne $null)
		{
			foreach ($VM in $VMs)
			{
				if ($AllVMs.Length -eq 0)
				{
					$AllVMs = $VM.ToString()
				}
				else
				{
					$AllVMs = $AllVMs + "," + $VM.ToString()
				}
			}
		}

	Write-Host($SCVMHost.ID,$SCVMHost.Name,$SCVMHost.ComputerName,$SCVMHost.FullyQualifiedDomainName,$SCVMHost.OperatingSystem,$SCVMHost.OperatingSystemVersion,$SCVMHost.VMHostGroup,
		$SCVMHost.HostCluster,$SCVMHost.VirtualizationPlatform,$SCVMHost.IsRemoteFXRoleInstalled,$SCVMHost.IsCPUSLAT,$SCVMHost.IsNumaSpanningEnabled,$SCVMHost.HyperVState,
		$SCVMHost.HyperVVersionState,$SCVMHost.VirtualServerState,$SCVMHost.OverallState,$SCVMHost.CommunicationState,$SCVMHost.ClusterNodeStatus,$SCVMHost.MaintenanceHost,$SCVMHost.AvailableForPlacement,
		$SCVMHost.PhysicalCPUCount,$SCVMHost.CoresPerCPU,$SCVMHost.LogicalProcessorCount,$SCVMHost.CpuUtilization,$SCVMHost.CPUPercentageReserve,$SCVMHost.TotalMemory,$SCVMHost.AvailableMemory,
		$SCVMHost.MemoryReserveMB,$SCVMHost.MaximumMemoryPerVM,$SCVMHost.MinimumMemoryPerVM,$SCVMHost.SuggestedMaximumMemoryPerVM,$SCVMHost.RemoteStorageTotalCapacity,
		$SCVMHost.RemoteStorageAvailableCapacity,$SCVMHost.LocalStorageTotalCapacity,$SCVMHost.LocalStorageAvailableCapacity,$SCVMHost.TotalStorageCapacity,
		$SCVMHost.AvailableStorageCapacity,$SCVMHost.UsedStorageCapacity,$SCVMHost.DiskSpaceReserveMB,$SCVMHost.MaxDiskIOReservation,$SCVMHost.NetworkPercentageReserve,
		$SCVMHost.SupportsLiveMigration,$SCVMHost.EnableLiveMigration,$SCVMHost.LiveMigrationMaximum,$SCVMHost.LiveStorageMigrationMaximum,$SCVMHost.UseAnyMigrationSubnet,
		$SCVMHost.MostRecentTaskUIState,$AllVMs) -Separator "#~#"
	}
}

Write-Host "SCVMs"
Write-Host "------"
$SCVMs = Get-SCVirtualMachine -VMMServer localhost
if ($SCVMs -ne $null)
{
	foreach ($VM in $SCVMs)
	{
		Write-Host($VM.ID,$VM.Name,$VM.Status,$VM.HostName,$VM.MarkedAsTemplate,$VM.Accessibility,$VM.VirtualMachineState,$VM.TotalSize,
		$VM.MemoryAssignedMB,$VM.MemoryAvailablePercentage,$VM.DynamicMemoryDemandMB,$VM.IsOrphaned,$VM.HasSharedStorage,
		$VM.DiskIO,$VM.NetworkUtilization,$VM.CPUUtilization,$VM.PerfCPUUtilization,$VM.PerfMemory,$VM.PerfDiskBytesRead,
		$VM.PerfDiskBytesWrite,$VM.PerfNetworkBytesRead,$VM.PerfNetworkBytesWrite,$VM.VirtualizationPlatform,$VM.Memory,
		$VM.MostRecentTaskUIState,$VM.IsUndergoingLiveMigration,$VM.IsRecoveryVM,$VM.IsPrimaryVM,$VM.IsTestReplicaVM,
		$VM.IsDREnabled,$VM.LiveCloningEnabled) -Separator "#~#"
	}
}

Write-Host "SCVMM MAC Address Pool"
Write-Host "----------------------"
$SCVMMACAddPools = Get-SCMACAddressPool -VMMServer localhost
if ($SCVMMACAddPools -ne $null)
{
	foreach ($MACAddress in $SCVMMACAddPools)
	{
		$AssignedHostGroups = ""
		$SupportedVP = ""

		$HostGroups = $MACAddress.HostGroups
		if($HostGroups -ne $null -and $HostGroups.Length -gt 0)
		{
			foreach ($HostGroup in $HostGroups)
			{
				if ($AssignedHostGroups.Length -eq 0)
				{
					$AssignedHostGroups = $HostGroup.ToString()
				}
				else
				{
					$AssignedHostGroups = $AssignedHostGroups + "," + $HostGroup.ToString()
				}
			}
		}

		$SupportedVPs = $MACAddress.SupportedVirtualizationPlatforms
		if($SupportedVPs -ne $null -and $SupportedVPs.Length -gt 0)
		{
			foreach ($VirtualizationPlatform in $SupportedVPs)
			{
				if ($SupportedVP.Length -eq 0)
				{
					$SupportedVP = $VirtualizationPlatform.ToString()
				}
				else
				{
					$SupportedVP = $SupportedVP + "," + $VirtualizationPlatform.ToString()
				}
			}
		}

		Write-Host($MACAddress.ID, $MACAddress.Name, $MACAddress.AvailableAddresses,
		$MACAddress.UnassignedAddresses, $MACAddress.TotalAddresses, $AssignedHostGroups, $SupportedVP,
		$MACAddress.IsViewOnly, $MACAddress.MarkedForDeletion, $MACAddress.IsFullyCached) -Separator "#~#"
	}
}

Write-Host "SCVMM Logical Network"
Write-Host "----------------------"
$SCVMLogicalNetwork = Get-SCLogicalNetwork -VMMServer localhost
if($SCVMLogicalNetwork -ne $null)
{
	foreach ($HostLogicalNetwork in $SCVMLogicalNetwork)
	{
		Write-Host($HostLogicalNetwork.Name, $HostLogicalNetwork.NetworkVirtualizationEnabled,
		$HostLogicalNetwork.UseGRE, $HostLogicalNetwork.IsPVLAN,$HostLogicalNetwork.ServerConnection,
		$HostLogicalNetwork.MarkedForDeletion,$HostLogicalNetwork.IsFullyCached,$HostLogicalNetwork.ConfigurationProvider) -Separator "#~#"
	}
}

Write-Host "SCVMM Virtual Networks"
Write-Host "----------------------"
$SCVMVirtualNetwork = Get-SCVMNetwork
if($SCVMVirtualNetwork -ne $null)
{
	foreach ($HostVmNetwork in $SCVMVirtualNetwork)
	{
		Write-Host($HostVmNetwork.Name,$HostVmNetwork.LogicalNetwork, $HostVmNetwork.IsolationType,$HostVmNetwork.IsPrivateVlan,
		$HostVmNetwork.Accessibility,$HostVmNetwork.Enabled) -Separator "#~#"
	}
}

Write-Host "SCVMM Host Network Adapter"
Write-Host "--------------------------"
$SCVMHostNetworkAdapters = Get-SCVMHostNetworkAdapter -VMMServer localhost
if($SCVMHostNetworkAdapters -ne $null)
{
	foreach ($HostNetworkAdapter in $SCVMHostNetworkAdapters)
	{
		$LogicalNetwork = ""
		$LogicalNetworks = $HostNetworkAdapter.LogicalNetworks
		if($SupportedVPs -ne $null -and $SupportedVPs.Length -gt 0)
		{
			foreach ($logicalNtw in $LogicalNetworks)
			{
				if ($LogicalNetwork.Length -eq 0)
				{
					$LogicalNetwork = $logicalNtw.ToString()
				}
				else
				{
					$LogicalNetwork = $LogicalNetwork + "," + $logicalNtw.ToString()
				}
			}
		}

		Write-Host($HostNetworkAdapter.Name, $HostNetworkAdapter.VMHost, $LogicalNetwork,
		$HostNetworkAdapter.VirtualNetwork, $HostNetworkAdapter.NetworkLocation, $HostNetworkAdapter.ConnectionState) -Separator "#~#"
	}
}

Write-Host "SCVMM Load Balancer"
Write-Host "-------------------"
$SCVMLoadBalancer = Get-SCLoadBalancer -VMMServer localhost
if($SCVMLoadBalancer -ne $null)
{
	foreach ($HostLoadBalancer in $SCVMLoadBalancer)
	{
		Write-Host($HostLoadBalancer.Name, $HostLoadBalancer.Manufacturer,
		$HostLoadBalancer.Model, $HostLoadBalancer.Version,$HostLoadBalancer.ID, $HostLoadBalancer.IsMicrosoftNlb,
		$HostLoadBalancer.HostGroups,$HostLoadBalancer.ConfigurationProvider) -Separator "#~#"
	}
}

Write-Host "SCVMM Configuration Provider"
Write-Host "----------------------------"
$SCVMConfigProvider = Get-SCConfigurationProvider
if($SCVMLoadBalancer -ne $null)
{
	foreach ($HostConfigProvider in $SCVMConfigProvider)
	{
		Write-Host($HostConfigProvider.Name, $HostConfigProvider.Type,
		$HostConfigProvider.LatestVersion, $HostConfigProvider.PublishDate,$HostConfigProvider.Manufacturer,
		$HostConfigProvider.Model,$HostConfigProvider.ID) -Separator "#~#"
	}
}

Write-Host "SCVMM Port Profile"
Write-Host "-------------------"
$SCVMPortProfile =Get-SCVirtualNetworkAdapterNativePortProfile -VMMServer localhost
if($SCVMPortProfile -ne $null)
{
	foreach ($HostPortProfile in $SCVMPortProfile)
	{
		Write-Host($HostPortProfile.Name, $HostPortProfile.AllowTeaming,
		$HostPortProfile.AllowMacAddressSpoofing, $HostPortProfile.AllowIeeePriorityTagging, $HostPortProfile.EnableDhcpGuard,
		$HostPortProfile.EnableGuestIPNetworkVirtualizationUpdates,$HostPortProfile.EnableRouterGuard, $HostPortProfile.EnableVmq,
		$HostPortProfile.EnableIPsecOffload,$HostPortProfile.EnableIov) -Separator "#~#"
	}
}

#Remove-PSSnapin "Microsoft.SystemCenter.VirtualMachineManager"





