﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-pssnapin Citrix.*
$dgGroups = $args[0]
if($args.count -eq 0) {$dgGroups = "none"}
$deliveryGroups = $dgGroups -split "," 
$MaxRecordCount = 250
$incre = 0

Function CheckUnregistered()
{
    param([string] $deliveryGroupName)
    $allUnregisteredVMs = @()
    do 
    {
        if($deliveryGroupName -like "*none*")
        {
            $unregisteredVMs = @(Get-BrokerMachine -RegistrationState Unregistered -MaxRecordCount $MaxRecordCount | select-object machinename, desktopgroupname, PowerState, IsPhysical)
        }
        else {
            $unregisteredVMs = @(Get-BrokerMachine -DesktopGroupName $deliveryGroupName -RegistrationState Unregistered  -MaxRecordCount $MaxRecordCount | select-object machinename, desktopgroupname, PowerState, IsPhysical)
        }
        if($unregisteredVMs.count -gt 0)
        {
            $allUnregisteredVMs += $unregisteredVMs
        }
    } while ($unregisteredVMs.count -ge $MaxRecordCount) 
    if($allUnregisteredVMs)
    {     
	if($global:incre -le 1)
	{  	
       	    Write-Host "Machinename;Delivery group;PowerState;IsPhysical"       
	}
        foreach($item in $allUnregisteredVMs)
        {
	   $global:incre++
 	    #Write-Host $global:incre
            write-Host "$($item.machinename);$($item.DesktopGroupName);$($item.PowerState);$($item.IsPhysical)"
        }
    }		   
}


foreach($dgname in $deliveryGroups)
{
    CheckUnregistered -deliveryGroupName $dgname
}
if($global:incre -le 1)
{
   Write-Host “All the powered-on VMs are registered succcessfully!”
}

Remove-pssnapin citrix.*