$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

<# 
.SYNOPSIS
    Disable XenApp Logon to the selected server. This state only persists to the next reboot.
.PARAMETER ServerName
   The name of the server being disabled - automatically provided by eG
#>

$ErrorActionPreference = "Stop"
$computer = $env:COMPUTERNAME
Try
{
    Add-PsSnapin Citrix.XenApp.Commands
}
Catch
{
    Write-Error "Unable to load the snapin"
    Exit 1
}

Try
{
    Disable-XAServerLogOn -ServerName $computer
}
Catch
{
    Write-Error "Error in executing Disable-XAServerLogon Cmdlet"
    Exit 1
}
Write-Host "Logins disabled on $computer" 
