$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix*

$MonitorDataStore = Get-MonitorDataStore
if ($MonitorDataStore -ne $null)
{
	foreach ($Store in $MonitorDataStore)
	{
		Write-Host("MonitorDataStore",$Store.DataStore,$Store.Status,$Store.DatabaseType,$Store.Provider,
			    $Store.SchemaName,$Store.ConnectionString) -Separator "#"
	}
} 

$LogDataStore = Get-LogDataStore
if ($LogDataStore -ne $null)
{
	foreach ($Store in $LogDataStore)
	{
		Write-Host("LogDataStore",$Store.DataStore,$Store.Status,$Store.DatabaseType,$Store.Provider,
			    $Store.SchemaName,$Store.ConnectionString) -Separator "#"
	}
} 

Remove-PSSnapin Citrix*

