$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ServerName = $args[0]

$version = Get-ExchangeServer -Identity $ServerName | Select-Object AdminDisplayVersion
if($version.admindisplayversion.major)
{
	$ServerVersion = $version.admindisplayversion.major
}

if ([int]$ServerVersion -gt 8)
{
	foreach ($objItem in Get-MailboxDatabase -server $ServerName -Status)
	{
		$whiteSpace = [decimal] ($objItem.AvailableNewMailboxSpace.ToBytes())
		$edbfilepath = $objItem.edbfilepath
		$path = $objItem.EdbFilePath.DriveName.Remove(1).ToString() + ":"+ $objItem.EdbFilePath.PathName.Remove(0,2)
		$dbsize = Get-ChildItem $path
		$mailboxpath = $objItem.Name
		$size = get-wmiobject -computername $ServerName win32_logicaldisk |where-object {$_.deviceid -eq $objItem.EdbFilePath.DriveName} |select-object deviceID, Freespace, Size
		$freespace = $size.freespace
		$total = $size.size
		$PercentFree = $freespace / $total *100
		$mailboxcount = Get-MailboxStatistics -database "$mailboxpath" |Where {$_.DisconnectDate -eq $null -and $_.ObjectClass -eq 'Mailbox'} |measure-object 
		$disconnectedmailboxcount = Get-MailboxStatistics -database "$mailboxpath" |Where {$_.DisconnectDate -ne $null} |measure-object 
	
		Write-Host "Database : " $objItem.Identity
		Write-Host "EDB Path : " $path 
		Write-Host "Total drive Size : " $total
		Write-Host "Free Space in drive :" $freespace
		Write-Host "Percent Disk Free in drive: " $percentfree
		Write-Host "White Space :" $whiteSpace
		Write-Host "Total Free space in drive :" $($freespace + $whiteSpace)
		$TotalPercent = ($freespace + $whiteSpace) / $total *100
		Write-Host "Total Percent Free in drive :" $TotalPercent
	}
}

