﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
$tstInputs=$args
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
if($tstInputs.Length -eq 2){   
    $arg1='-jar '+$egurkhaPath+'\lib\GetCont.jar'
    $val=$egurkhaPath+'\lib\'+$tstInputs[0]+$tstInputs[1]+'_GetCont.log'
    $strVal=$arg1+' '+$tstInputs
    $fpath=$egurkhaPath+'\JRE\bin\java.exe'
    $null=Start-Process -FilePath $fpath -ArgumentList $strVal -RedirectStandardOutput $val -Wait -PassThru
}
elseif($tstInputs.Length -eq 1){
    Try{
        $removPath=$egurkhaPath+'\lib\'+$tstInputs[0]+$tstInputs[1]+'_GetCont.log'
        Remove-Item -Path $removPath -ErrorAction SilentlyContinue
    }Catch{}
}else{
    Try{
        $removPath=$egurkhaPath+'\lib\'+'*GetCont.log'
        Get-ChildItem -Path $removPath -Force | Remove-Item -Force
    }Catch{}
}
