$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Citrix.XenApp.Commands
$Global:ErrorActionPreference="SilentlyContinue"
$hostname = $env:COMPUTERNAME
$sessions = Get-XASession -ServerName $hostname

foreach($session in $sessions)
{
	$clientName = $session.ClientName
	$sessionName = $session.SessionName
	if($clientName -and $sessionName)
	{
		$accountName = $session.AccountName
		$displayName = $clientName + "=" + $sessionName + ":" + $accountName
		Write-Host($displayName)
	}
}

Remove-PSSnapin Citrix.XenApp.Commands

