Add-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010
$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Write-Host "Active Directory Information"
Write-Host "------------------------------"

$SRVSettings = Get-ADServerSettings
if ($SRVSettings.ViewEntireForest -eq "False")
{
	Set-ADServerSettings -ViewEntireForest $true
}

Write-Host "AD Sites"
Write-Host "-----------"
$adsiteall = Get-ADSite
foreach($ADSite in $ADSiteAll)
{
	Write-Host "SiteName: " $adsite.Name
	Write-Host "HubSiteEnabled: " $adsite.HubSiteEnabled
	Write-Host "PartnerID: " $adsite.PartnerID
	Write-Host "MinorPartnerID: " $adsite.MinorPartnerID
	Write-Host
}

Write-Host "AD SiteLinks"
Write-Host "---------------"
$adsitelinkall = Get-ADSitelink
foreach($ADSitelink in $ADSitelinkAll)
{
	Write-Host "SiteLinkName: " $adsitelink.Name
	Write-Host "ADCost: " $adsitelink.ADCost
	Write-Host "MaxMessageSize: " $adsitelink.MaxMessageSize
	Write-Host "Sites: " $adsitelink.Sites
	Write-Host
}

Write-Host
Write-Host "Viewing SPN Information"
Write-Host "--------------------------"

$AllSrvs = Get-Exchangeserver | Where-Object{$_.ServerRole -ne "Edge"}
foreach ($AllSrv in $AllSrvs)
{
	$SetSPNs = SetSPN -l $AllSrv
	Foreach ($SetSPN in $SetSPNs)
	{
		if ($SetSPN -ne $null)
		{
			Write-Host $($SetSPN)
		}
		else
		{
			Write-Host "Could not find account $($AllSrv)"
		}
	}
	Write-Host 
}

Write-Host
Write-Host "Viewing Duplicate SPN Information"
Write-Host "-------------------------------------"
$SetSPNDs = SetSPN -X
Foreach ($SetSPND in $SetSPNDs)
{
	Write-Host $($SetSPND)
	
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.E2010







