﻿#$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
#$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
<# 
This script can be called in two ways - one is by passing arguments from SaaS manager, another is thorugh manually. if u dont pass any arguments to script, it will open a input window. 
#>
clear
$Error.clear()
#$args=@('monitoring@365rpt.onmicrosoft.com','abc123ABC','none','none','none','none','BoxManual_30','eGservicmon256','eGservicmon@2019')
$TestInputs=$args
if($TestInputs.Count -ne 0){
    $AdminuserName=$TestInputs[0]
    $password=$TestInputs[1]
    $proxyHost=$TestInputs[2]
    $proxyPort=$TestInputs[3]
    $proxyUsr=$TestInputs[4]
    $proxyPass=$TestInputs[5]
    $nickNam=$TestInputs[6]
    $monitorUser=$TestInputs[7]
    $monitorPassword=$TestInputs[8]

    if($monitorUser -eq 'none'){
        $monitorUser='eGservicmon'
        $monitorPassword='eGservicmon@2019'
    }  
}else{
    $nickNam='none'
}
$grp="eGMonitoring-role"
$runningManually=$true
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$chkDir=$egurkhaPath+'\agent'
if((Test-Path -Path $chkDir)){
    $runningManually=$False
}

function validateBoxesAndCombos(){
     $checkPassword=$mntrPassTxtBx.Text
     if(!($checkPassword.length -gt 8) -and !($checkPassword –cmatch '[^a-zA-Z0-9]') -and !($checkPassword -cmatch " "))
     {
       $result = [System.Windows.Forms.MessageBox]::Show('Please provide strong password', 'Alert', 'OK', 'Warning')
     }
}

$writGDir=$egurkhaPath+'\agent\O365\MsGraph'
if(!(Test-Path -Path $writGDir)){
    $null=New-Item -ItemType directory -Path $writGDir
}

if($runningManually){
    # Write Output in file
    $driveRoot=''
    $drives=Get-PSDrive
    foreach($drive in $drives){
        if(($drive.Name).ToLower() -eq 'c'){
            $driveRoot=$drive.Root
            break;
        }elseif(($drive.Name).ToLower() -eq 'd'){
            $driveRoot=$drive.Root
            break;
        }elseif(($drive.Name).ToLower() -eq 'e'){
            $driveRoot=$drive.Root
            break;
        }
    }
    $fileDir=$driveRoot+'egurkha'
    if(!(Test-Path -Path $fileDir)){
        $null=New-Item -ItemType directory -Path $fileDir
    }
    #$filePath=$fileDir+'\O365Dtls.txt'
    #if(!(Test-Path -Path $filePath -PathType Leaf)){
    #    $null=New-Item -ItemType File -Path $filePath 
    #}
    #Write-Host 'OutFile writing path -- '$filePath

    #LOGFILE
    $logFile=$fileDir+'\O365.log'
}
else{
    $egEncryPath=$egurkhaPath+"\lib\EGFileEncryption.psm1"
    Import-Module $egEncryPath

    $writDir=$egurkhaPath+'\agent\O365'
    
    if(!(Test-Path -Path $writDir)){
        $null=New-Item -ItemType directory -Path $writDir
    }
    $logFile=$writDir+'\O365_prerequisites.log'
}

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

$chkWinrm=([String](& cmd /c "`"winrm get winrm/config/client/auth`"")).Trim().Replace(' ','')
if($chkWinrm -notmatch 'Basic=true'){
    Write-Host 'WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE...' -ForegroundColor Red
    O365-WriteLog -writString ("WINRM BASIC AUTHENTICATION IS NOT ENABLED. PLEASE ENABLE..."+$chkWinrm) -LogPath $logFile -ReportingName 'ERROR'
    exit
}

$isRunGraphOnly=$false
$ismbroleOnly=$False
$ismbroleUser=''
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") 
[void] [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms")
if($TestInputs.Count -eq 0){
     ######***GUI  form ****#######
    $form = New-Object System.Windows.Forms.Form
    $flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
    $buttonOK = New-Object System.Windows.Forms.Button

    $O365DtlsLbl=New-Object System.Windows.Forms.Label
    $O365UsrLbl=New-Object System.Windows.Forms.Label
    $O365PassLbl=New-Object System.Windows.Forms.Label
    $O365UsrTxtBx=New-Object System.Windows.Forms.TextBox
    $O365PassTxtBx=New-Object System.Windows.Forms.TextBox 
    
    $prxyDtlsLbl=New-Object System.Windows.Forms.Label
    $prxyHostLbl=New-Object System.Windows.Forms.Label
    $prxyPortLbl=New-Object System.Windows.Forms.Label
    $prxyUsrLbl=New-Object System.Windows.Forms.Label
    $prxyPassLbl=New-Object System.Windows.Forms.Label
    $prxyHostTxtBx=New-Object System.Windows.Forms.TextBox
    $prxyPortTxtBx=New-Object System.Windows.Forms.TextBox
    $prxyUsrTxtBx=New-Object System.Windows.Forms.TextBox
    $prxyPassTxtBx=New-Object System.Windows.Forms.TextBox
    
    $grphAPIChkbx= New-object System.Windows.Forms.CheckBox
    $mbrolChkbx=New-object System.Windows.Forms.CheckBox
    $mbrolTxtBx=New-Object System.Windows.Forms.TextBox
      
    $monitorlabel=New-Object System.Windows.Forms.Label
    $RadioButton1 = New-Object System.Windows.Forms.RadioButton
    $RadioButton2 = New-Object System.Windows.Forms.RadioButton
    $mntrUsrLbl=New-Object System.Windows.Forms.Label
    $mntrUsrTxtBx=New-Object System.Windows.Forms.TextBox    
    $mntrPassLbl=New-Object System.Windows.Forms.Label
    $mntrPassTxtBx=New-Object System.Windows.Forms.TextBox
    $mntrRoleLbl=New-Object System.Windows.Forms.Label
    $mntrRoleTxtBx=New-Object System.Windows.Forms.TextBox

    $infoLabel=New-Object System.Windows.Forms.Label
    $infoLabel1=New-Object System.Windows.Forms.Label
    $infoLabel2=New-Object System.Windows.Forms.Label
  
    $formsize = 502
    $form.Controls.Add($O365DtlsLbl)
    $form.Controls.Add($O365UsrLbl)
    $form.Controls.Add($O365UsrTxtBx)
    $form.Controls.Add($O365PassLbl)
    $form.Controls.Add($O365PassTxtBx)

    $form.Controls.Add($prxyDtlsLbl)
    $form.Controls.Add($prxyHostLbl)
    $form.Controls.Add($prxyHostTxtBx)
    $form.Controls.Add($prxyPortLbl)
    $form.Controls.Add($prxyPortTxtBx)
    $form.Controls.Add($prxyUsrLbl)
    $form.Controls.Add($prxyUsrTxtBx)
    $form.Controls.Add($prxyPassLbl)
    $form.Controls.Add($prxyPassTxtBx)

    $form.Controls.Add($grphAPIChkbx)
    $form.Controls.Add($mbrolChkbx)
    $form.Controls.Add($mbrolTxtBx)

    $form.Controls.Add($RadioButton1)
    $form.Controls.Add($RadioButton2)

    $form.Controls.Add($monitorlabel)
    $form.Controls.Add($mntrUsrLbl)
    $form.Controls.Add($mntrUsrTxtBx)
    $form.Controls.Add($mntrPassLbl)
    $form.Controls.Add($mntrPassTxtBx)
    $form.Controls.Add($mntrRoleLbl)
    $form.Controls.Add($mntrRoleTxtBx)

    $form.Controls.Add($infoLabel)
    $form.Controls.Add($infoLabel1)

    $form.Controls.Add($buttonOK)

    $form.AcceptButton = $buttonOK
    $form.AutoScaleDimensions = '8, 17'
    $form.AutoScaleMode = 'Font'
    $form.ClientSize = "428 , $formsize"
    $form.FormBorderStyle = 'FixedDialog'
    $form.Margin = '5, 5, 5, 5'
    $form.MaximizeBox = $False
    $form.MinimizeBox = $False
    $form.Name = 'form1'
    $form.StartPosition = 'CenterScreen'
    $form.Text = 'O365 Set Roles and Permissions'
    $form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

    $O365DtlsLbl.Location="38,15"
    $O365DtlsLbl.Anchor="Bottom, Left"
    $O365DtlsLbl.Text="&Global Admin Credentails (Only non MFA):"
    $O365DtlsLbl.Size="230,20"
    $O365UsrLbl.Location="58,38"
    $O365UsrLbl.Anchor="Bottom, Left"
    $O365UsrLbl.Text="&Username"
    $O365UsrLbl.Size="115,20"
    $O365UsrTxtBx.Location="175,38"
    $O365UsrTxtBx.Name="O365User"
    $O365UsrTxtBx.Size="200,20"
    $O365UsrTxtBx.Text=""
    $O365PassLbl.Location="58,67"
    $O365PassLbl.Anchor="Bottom, Left"
    $O365PassLbl.Text="&Password"
    $O365PassLbl.Size="115,20"
    $O365PassTxtBx.Location="175,67"
    $O365PassTxtBx.Name="O365Pass"
    $O365PassTxtBx.Size="200,20"
    $O365PassTxtBx.Text=""
    $O365PassTxtBx.PasswordChar='*'

    $prxyDtlsLbl.Location="38,95"
    $prxyDtlsLbl.Anchor="Bottom, Left"
    $prxyDtlsLbl.Text="&Proxy Details :"
    $prxyDtlsLbl.Size="100,20"
    $prxyHostLbl.Location="58,118"
    $prxyHostLbl.Anchor="Bottom, Left"
    $prxyHostLbl.Text="&Host IP"
    $prxyHostLbl.Size="115,20"
    $prxyHostTxtBx.Location="175,118"
    $prxyHostTxtBx.Name="ProxyHost"
    $prxyHostTxtBx.Size="120,20"
    $prxyHostTxtBx.Text="none"
    $prxyPortLbl.Location="298,119"
    $prxyPortLbl.Anchor="Bottom, Left"
    $prxyPortLbl.Text="&Port"
    $prxyPortLbl.Size="25,20"
    $prxyPortTxtBx.Location="325,118"
    $prxyPortTxtBx.Name="Port"
    $prxyPortTxtBx.Size="50,20"
    $prxyPortTxtBx.Text="none"
    $prxyUsrLbl.Location="58,145"
    $prxyUsrLbl.Anchor="Bottom, Left"
    $prxyUsrLbl.Text="&Username"
    $prxyUsrLbl.Size="115,20"
    $prxyUsrTxtBx.Location="175,145"
    $prxyUsrTxtBx.Name="ProxyUser"
    $prxyUsrTxtBx.Size="200,20"
    $prxyUsrTxtBx.Text="none"
    $prxyPassLbl.Location="58,173"
    $prxyPassLbl.Anchor="Bottom, Left"
    $prxyPassLbl.Text="&Password"
    $prxyPassLbl.Size="115,20"
    $prxyPassTxtBx.Location="175,173"
    $prxyPassTxtBx.Name="ProxyPass"
    $prxyPassTxtBx.Size="200,20"
    $prxyPassTxtBx.Text="none"
    $prxyPassTxtBx.PasswordChar='*'

    $grphAPIChkbx.Location="38,205"
    $grphAPIChkbx.Text="Create ONLY MS Graph App"
    $grphAPIChkbx.Size="200,20"
    $grphAPIChkbx.Add_CheckStateChanged({  
        if($grphAPIChkbx.Checked -eq $False){
            $mbrolChkbx.Enabled=$true
            $monitorlabel.Enabled = $true
            $RadioButton1.Enabled = $true
            $RadioButton2.Enabled = $true
            $mntrUsrLbl.Enabled = $true       
            $mntrUsrTxtBx.Enabled = $true
            $mntrPassLbl.Enabled = $true
            $mntrPassTxtBx.Enabled = $true
            $mntrRoleLbl.Enabled = $true
            $mntrRoleTxtBx.Enabled = $true
            $infoLabel.Enabled = $true
            $infoLabel1.Enabled = $true

        }else{
            $mbrolChkbx.Enabled=$False
            $monitorlabel.Enabled = $False
            $RadioButton1.Enabled = $False
            $RadioButton2.Enabled = $False
            $mntrUsrLbl.Enabled = $False       
            $mntrUsrTxtBx.Enabled = $False
            $mntrPassLbl.Enabled = $False
            $mntrPassTxtBx.Enabled = $False
            $mntrRoleLbl.Enabled = $False
            $mntrRoleTxtBx.Enabled = $False
            $infoLabel.Enabled = $False
            $infoLabel1.Enabled = $False
        }
    })


    $mbrolChkbx.Location="38,235"
    $mbrolChkbx.Text="Assign Mailbox Import Export role to user"
    $mbrolChkbx.Size="230,20"
    $mbrolTxtBx.Location="55,258"
    $mbrolTxtBx.Name="mbRoleTxt"
    $mbrolTxtBx.Size="320,20"
    $mbrolTxtBx.Text=""
    $mbrolTxtBx.Enabled=$false
    $mbrolChkbx.Add_CheckStateChanged({  
        if($mbrolChkbx.Checked -eq $False){
            $grphAPIChkbx.Enabled=$true
            $mbrolTxtBx.Enabled=$false
            $monitorlabel.Enabled = $true
            $RadioButton1.Enabled = $true
            $RadioButton2.Enabled = $true
            $mntrUsrLbl.Enabled = $true       
            $mntrUsrTxtBx.Enabled = $true
            $mntrPassLbl.Enabled = $true
            $mntrPassTxtBx.Enabled = $true
            $mntrRoleLbl.Enabled = $true
            $mntrRoleTxtBx.Enabled = $true
            $infoLabel.Enabled = $true
            $infoLabel1.Enabled = $true

        }else{
            $grphAPIChkbx.Enabled=$False
            $mbrolTxtBx.Enabled=$true
            $monitorlabel.Enabled = $False
            $RadioButton1.Enabled = $False
            $RadioButton2.Enabled = $False
            $mntrUsrLbl.Enabled = $False       
            $mntrUsrTxtBx.Enabled = $False
            $mntrPassLbl.Enabled = $False
            $mntrPassTxtBx.Enabled = $False
            $mntrRoleLbl.Enabled = $False
            $mntrRoleTxtBx.Enabled = $False
            $infoLabel.Enabled = $False
            $infoLabel1.Enabled = $False
        }
    })

    $monitorlabel.Location="38,285"  
    $monitorlabel.Anchor="Bottom, Left"
    $monitorlabel.Text="&eG Monitor User Credentails:"
    $monitorlabel.Size="200,20"

    $RadioButton1.Location ="58,305"
    $RadioButton1.Size ="115,20"
    $RadioButton1.Checked = $true
    $RadioButton1.text = "New User"
    $RadioButton2.Location ="175,305"
    $RadioButton2.Size ="115,20"
    $RadioButton2.Checked = $false
    $RadioButton2.text = "Existing User"

    $RadioButton1.Add_Click({
        $mntrPassLbl.Enabled=$true
        $mntrPassTxtBx.Enabled=$true
        $mntrUsrTxtBx.Text="eGmonitor"
        $infoLabel.Location="58,416"
        $infoLabel.Anchor="Bottom, Left"
        $infoLabel.Text="&*"
        $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
        $infoLabel.Size="17,10"
        $infoLabel.ForeColor='Red'
        $infoLabel1.Location="72,416"
        $infoLabel1.Anchor="Bottom, Left"
        $infoLabel1.Text="&New user and MSGraph App will be created with the required roles/permissions"#
        $infoLabel1.Size="375,25"
        $infoLabel1.ForeColor='blue'
    })
    $RadioButton2.Add_Click({
        $mntrPassLbl.Enabled=$false
        $mntrPassTxtBx.Enabled=$false
        $mntrUsrTxtBx.Text=""
        $infoLabel.Location="58,416"
        $infoLabel.Anchor="Bottom, Left"
        $infoLabel.Text="&*"
        $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
        $infoLabel.Size="17,10"
        $infoLabel.ForeColor='Red'
        $infoLabel1.Location="72,416"
        $infoLabel1.Anchor="Bottom, Left"
        $infoLabel1.Text="&Existing user and MSGraph App will be provided the required roles/permissions"
        $infoLabel1.Size="375,25"
        $infoLabel1.ForeColor='blue'
    })

    $mntrUsrLbl.Location="58,334"  
    $mntrUsrLbl.Anchor="Bottom, Left"
    $mntrUsrLbl.Text="&Monitoring User:"
    $mntrUsrLbl.Size="115,20"
    $mntrUsrTxtBx.Location="175,334"  
    $mntrUsrTxtBx.Name="monitorUser"
    $mntrUsrTxtBx.Size="200,20"
    $mntrUsrTxtBx.Text="eGmonitor"
    $mntrPassLbl.Location="58,361" 
    $mntrPassLbl.Anchor="Bottom, Left"
    $mntrPassLbl.Text="&Monitoring Password:"
    $mntrPassLbl.Size="115,20"
    $mntrPassTxtBx.Location="175,361"
    $mntrPassTxtBx.Name="monitorPassword"
    $mntrPassTxtBx.Size="200,20"
    $mntrPassTxtBx.Text=""
    $mntrPassTxtBx.PasswordChar='*'
    $mntrPassTxtBx.MaxLength = 16
    $mntrPassTxtBx.Add_Leave({validateBoxesAndCombos})
    $mntrRoleLbl.Location="58,388" 
    $mntrRoleLbl.Anchor="Bottom, Left"
    $mntrRoleLbl.Text="&Monitoring Rolename:"
    $mntrRoleLbl.Size="115,20"
    $mntrRoleTxtBx.Location="175,388"   
    $mntrRoleTxtBx.Name="monitorUser"
    $mntrRoleTxtBx.Size="200,20"
    $mntrRoleTxtBx.Text="eGMonitoring-role"

    $infoLabel.Location="58,416"
    $infoLabel.Anchor="Bottom, Left"
    $infoLabel.Text="&*"
    $infoLabel.Font=New-Object System.Drawing.Font("Lucida Console",13,[System.Drawing.FontStyle]::Regular)
    $infoLabel.Size="17,10"
    $infoLabel.ForeColor='Red'
    $infoLabel1.Location="72,416"
    $infoLabel1.Anchor="Bottom, Left"
    $infoLabel1.Text="&New user and MSGraph App will be created with the required roles/permissions"
    $infoLabel1.Size="375,25"
    $infoLabel1.ForeColor='blue'
    
    $buttonOK.Anchor = 'Bottom, Right'
    $buttonOK.DialogResult = 'OK'
    $buttonOK.Location = "175, 456"
    $buttonOK.Margin = '4, 4, 4, 4'
    $buttonOK.Name = 'buttonOK'
    $buttonOK.Size = '100, 30'
    $buttonOK.TabIndex = 0
    $buttonOK.Text = '&OK'
    $frmDialog=$form.ShowDialog()

    if($frmDialog -eq 'OK' ){
        $proxyHost=$prxyHostTxtBx.Text
        $proxyPort=$prxyPortTxtBx.Text
        $proxyUsr=$prxyUsrTxtBx.Text
        $proxyPass=$prxyPassTxtBx.Text
        $AdminuserName=$O365UsrTxtBx.Text
        $password=$O365PassTxtBx.Text
        $monitorUser=$mntrUsrTxtBx.Text
        $monitorPassword=$mntrPassTxtBx.Text
        $grp=$mntrRoleTxtBx.Text

        if($grphAPIChkbx.Checked -eq $true){
            $isRunGraphOnly=$true
        }

        if($mbrolChkbx.Checked -eq $true){
            $ismbroleOnly=$true
            $ismbroleUser=$mbrolTxtBx.Text
        }

        if($proxyHost -eq "" -or $proxyport -eq "" -or $proxyUsr -eq "" -or $AdminuserName -eq "" -or $password -eq "" )
        {
            Write-Host "Re-run the script with all the inputs." -ForegroundColor Red 
            O365-WriteLog -writString  "Re-run the script with all the inputs." -LogPath $logFile -ReportingName 'ERROR'
            Exit
        }
    }
    else{
        Write-Host 'Exiting...'
        #O365-WriteLog -writString "Exiting..." -LogPath $logFile -ReportingName 'ClOSE'
        exit
    }
}


Function GetRequiredPermissions($requiredDelegatedPermissions, $requiredApplicationPermissions, $reqsp) {
    $sp = $reqsp
    $appid = $sp.AppId
    $requiredAccess = New-Object Microsoft.Open.AzureAD.Model.RequiredResourceAccess
    $requiredAccess.ResourceAppId = $appid
    $requiredAccess.ResourceAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.ResourceAccess]
    if ($requiredDelegatedPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.Oauth2Permissions -requiredAccesses $requiredDelegatedPermissions -permissionType "Scope"
    } 
    if ($requiredApplicationPermissions) {
        AddResourcePermission $requiredAccess -exposedPermissions $sp.AppRoles -requiredAccesses $requiredApplicationPermissions -permissionType "Role"
    }
    return $requiredAccess
}
function O365-Enc(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$str
    )
    Process
    {
        $j=124;
        $eStr=[System.Text.Encoding]::UTF8
        $byt=$eStr.GetBytes($str)
        $bytArr=@()
        for($i=0;$i -lt $byt.count ;$i++){  
            $k=$j-$byt[$i]+$i*3
            $bt=[System.BitConverter]::GetBytes($k)
            $bytArr+=$bt[0]
        }
        $encStr=''
        for($i=$bytArr.count;$i -ge 0 ;$i--){
            $encStr+=$bytArr[$i]
            if($bytArr[$i] -ne 0){
                $encStr+=':'
            }
        }
        $encStr=$encStr.Substring(1,$encStr.Length-2)
        return $encStr
    }
}
$mn=O365-Enc -str $monitorUser

Function AddResourcePermission($requiredAccess, $exposedPermissions, $requiredAccesses, $permissionType) {
    foreach ($permission in $requiredAccesses) {
        $reqPermission = $null
        $reqPermission = $exposedPermissions | Where-Object {$_.Value -contains $permission.Value}
        #Write-Host "Collected information for $($reqPermission.Value) of type $permissionType" -ForegroundColor Green
        $resourceAccess = New-Object Microsoft.Open.AzureAD.Model.ResourceAccess
        $resourceAccess.Type = $permissionType
        $resourceAccess.Id = $reqPermission.Id    
        $requiredAccess.ResourceAccess.Add($resourceAccess)
    }
}

clear

#INPUT - for user-roles and  role-group and role-group roles 
$assgingUserRoles="Global Reader","Service Support Administrator","SharePoint Administrator","Teams Administrator"
$roleslist="View-Only Audit Logs","Mailbox Import Export","Mail Recipients","View-Only Recipients"   #,"View-Only Recipients"

#INPUT - for graph api
$applicationName='eGMsGraphRpt'
$KeyDesc='SecreteG'
#$identyUri='https://eGMsGraphRpt.com'
$srchStrArr=@()
$reqPermissionArr=@()
$configFile=$egurkhaPath+'\agent\config\O365UserRolesAndPermissions.ini'
$lines=get-content -Path $configFile
$isExist=$false
foreach($line in $lines){  
    if($isExist){
        if($line.StartsWith('APIs')){
            $apiStr=$line.Replace('APIs=','')
            $apiStr=$apiStr.Split('~')
            foreach($apiArr in $apiStr){
                $srchStrArr+=$apiArr
            }
        }
        if($line.StartsWith('Permissions')){
            $reqPerStr=$line.Replace('Permissions=','')
            $reqPerStr=$reqPerStr.Split('~')
            foreach($reqPerArr in $reqPerStr){
                $reqPermissionArr+=$reqPerArr
            }
            break;
        }  
    }
    if($line.StartsWith('[O365SetRolesAndpermissions')){
        $isExist=$true
    }
}

$m=O365-Enc -str $AdminuserName
$stTim3=Get-Date
O365-WriteLog -writString "******************************************** O365SetRolesAndpermissions ********************************************" -LogPath $logFile -ReportingName 'Script'
O365-WriteLog -writString "O365SetRolesAndpermissions started at $stTim3" -LogPath $logFile -ReportingName 'INFO'
#O365-WriteLog -writString  "OutFile writing path is $filePath" -LogPath $logFile -ReportingName 'INFO'



$cn=@('AzureChinaCloud','https://partner.outlook.cn/PowerShell','O365China')
$com=@('AzureCloud','https://outlook.office365.com/powershell-liveid/','O365Default')
$de=@('AzureGermanyCloud','https://outlook.office.de/powershell-liveid/','O365GermanyCloud')
$us=@('USGovernment','None','O365USGovDoD')
$s=O365-Enc -str $password
$azureCloud=$AdminuserName.Substring($AdminuserName.LastIndexOf('.')+1) 
$azureCloudArr=@()
if($monitorPassword -ne $null -and $monitorPassword -ne ''){
    $pn=O365-Enc -str $monitorPassword
}
if($azureCloud -eq 'com'){$azureCloudArr=$com}
elseif($azureCloud -eq 'cn'){$azureCloudArr=$cn}
elseif($azureCloud -eq 'de'){$azureCloudArr=$de}
elseif($azureCloud -eq 'us'){$azureCloudArr=$us}  
else{$azureCloudArr=$com}

$proxyserverip=$proxyHost+':'+$proxyPort
$y=$m+':991:'+$s
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred =New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

# 1.Installation - AzureAD,MSOnline
$insMod=@()
$installedModule=Get-InstalledModule | Where-Object{$_.Name -in @('AzureAD','MSOnline')} | Sort-Object -Property Name
if($installedModule.Count -ne 0){
    if($installedModule.Count -eq 1 ){
        if($installedModule[0].Name -eq 'AzureAD'){
            write-host 'Azure AD module is already installed'
            O365-WriteLog -writString "Azure AD module is already installed" -LogPath $logFile -ReportingName 'INFO'
            $insMod+='MSOnline'
        }else{
            write-host 'MSOnline module is already installed'
            O365-WriteLog -writString "MSOnline module is already installed" -LogPath $logFile -ReportingName 'INFO'
            $insMod+='AzureAD'
        }
    }else{
        write-host 'AzureAD and MSOnline modules are already installed'
        O365-WriteLog -writString "AzureAD and MSOnline modules are already installed" -LogPath $logFile -ReportingName 'INFO'
    }
}else{
    $insMod+='MSOnline'
    $insMod+='AzureAD'
}
$i=$b+'~'+$y
if($insMod.Count -ne 0){
    Set-PSRepository -Name PSGallery -InstallationPolicy Trusted
    foreach($ins in $insMod){
        if($proxyHost -ne 'none'){
            if($proxyUsr -ne 'none'){
                Install-Module $ins -Scope AllUsers -AllowClobber -Force -Proxy $proxyserver -ProxyCredential $proxyCred
            }else{
                Install-Module $ins -Scope AllUsers -AllowClobber -Force -Proxy $proxyserver
            }
        }else{
            Install-Module $ins -Scope AllUsers -AllowClobber -Force
        }
    }
}

$isGAdmin=$false
$c=$i+$a
$domain=''
$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $AdminuserName, $(convertto-securestring $password -asplaintext -force)
try{
    Import-Module MsOnline
    Connect-MsolService -Credential $credential -AzureEnvironment $azureCloudArr[0] 
    
    $chkGAdmin=Get-MsolRoleMember -RoleObjectId $(Get-MsolRole -RoleName "Company Administrator").ObjectId -ErrorAction SilentlyContinue |Select-Object -Property EmailAddress
    write-host $chkGAdmin[0]
    
    if($runningManually){
        O365-WriteLog -writString "Checking the permissions of the user provided. $c" -LogPath $logFile -ReportingName 'Info'
    }else{
        $timenow = [int][double]::Parse((Get-Date -UFormat %s)) 
        if($nickNam-ne $null -and $nickNam -ne 'none' -and $nickNam -ne ''){
            $adminWritDir=$egurkhaPath+'\agent\O365\'+$nickNam
            if(!(Test-Path -Path $adminWritDir)){
                $null=New-Item -ItemType directory -Path $adminWritDir
            }
        }else{
            $adminWritDir=$egurkhaPath+'\agent\O365\MsGraph'
        }
        Get-ChildItem -Path $adminWritDir |Where-Object {$_.Name -like 'KeGServic*.dat' -or $_.Name -like 'eGServic*.dat'}|ForEach-Object{
            $rmvFile=$adminWritDir+'\'+$_.Name
            Remove-Item -Path $rmvFile -Force
        }
        $adminKeyFileNam='\KeGServic'+$timenow+'.dat'
        $adminWritPath=$adminWritDir+'\eGServic'+$timenow+'.txt'
        $null=$c | Add-Content $adminWritPath
        $ADkey=Get-CryptoKey -FileDir $adminWritDir -FileName $adminKeyFileNam
        $null=Protect-File $adminWritPath -Algorithm AES -KeyAsPlainText $ADkey -RemoveSource      
    }
    foreach($GA in $chkGAdmin){
        if($GA.EmailAddress -eq $AdminuserName){
            $isGAdmin=$true
            $measure=Get-MsolDomain |select Name,IsInitial
            if($measure){
                $azureEnv= $measure|where{$_.IsInitial -eq $true}|select Name
                $domain=$azureEnv.Name
                if($monitorUser.Contains('@')){
                    $userdomain=$monitorUser.Split('@')[1].trim()
                    if(!$measure.PSobject.Properties.Name -contains $userdomain)
                    {
                        Write-Error "Given user $monitorUser domain does not exist in the tenant"
                        O365-WriteLog -writString "Given user $monitorUser domain does not exist in the tenant" -LogPath $logFile -ReportingName 'ERROR'
                        exit
                    }
                 }
                 else{
                    $monitorUser=$monitorUser+'@'+$domain
                 }
                $domainNam=$domain.Substring(0,$domain.IndexOf('.')).trim()
            }
            else{
                Write-Error "Intial domain is not found "
                O365-WriteLog -writString "Intial domain is not found " -LogPath $logFile -ReportingName 'ERROR'
                O365-WriteLog -writString "Re-run the script and give admin user along with domain name (Ex:- abc@eg.com)" -LogPath $logFile -ReportingName 'INFO'
                exit  
            }
            break;
        }
    }
}Catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-Host $message
    O365-WriteLog -writString "Error while checking provided user having global admin role  $message " -LogPath $logFile -ReportingName 'Exception'
    $isGAdmin=$false
}

$replyUrl='https://'+$domainNam+'-my.sharepoint.com/'
if($isGAdmin){
if($ismbroleOnly -eq $False){
    if($isRunGraphOnly -eq $False){  
        #for session
        try{
            Write-host "Creating new session..."
            O365-WriteLog -writString "Creating new session..." -LogPath $logFile -ReportingName 'INFO'
            $sessionOption = New-PSSessionOption -SkipRevocationCheck
            if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
                [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
                [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
                $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
            }
            Connect-ExchangeOnline  -ExchangeEnvironmentName $azureCloudArr[2] -ConnectionUri $azureCloudArr[1] -Credential $credential -PSSessionOption $sessionOption	-WarningAction SilentlyContinue -InformationAction SilentlyContinue -ShowBanner:$false
        }catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-Error "Error while creating session -> $message "
            O365-WriteLog -writString "Error while creating session is -> $message " -LogPath $logFile -ReportingName 'EXCEPTION'
            O365-WriteLog -writString "Exiting the script execution please check prerequsities and admin user credentials" -LogPath $logFile -ReportingName 'INFO'
            exit
        }

        Try{
            Enable-OrganizationCustomization -EA SilentlyContinue
        }Catch{}

        #2.USER CREATION, SETTING ROLES AND PERMISSIONS
        #creating user
        $user=$monitorUser
        $userlicence=$false
        $displayname=$user.Split('@')[0]
        $userprincipleName=$user
        $userprincipleName=$userprincipleName.ToString().trim()
        $UsageLocation=(Get-MsolUser -UserPrincipalName $AdminuserName | select UsageLocation).UsageLocation
        $userdetais=Get-MsolUser -UserPrincipalName $userprincipleName -ErrorAction SilentlyContinue | select * 
        if(!$userdetais){
            if($monitorPassword){
                Write-host "Checking user credentials..."
                O365-WriteLog -writString  "Checking user credentials..." -LogPath $logFile -ReportingName 'INFO'
                #Write-host "User $userprincipleName does not exist, so creating user..."
                #O365-WriteLog -writString  "User $userprincipleName does not exist, so creating user..." -LogPath $logFile -ReportingName 'INFO'
                $userdetais=New-MsolUser -UserPrincipalName $userprincipleName -Password $monitorPassword -DisplayName $displayname -FirstName $displayname -UsageLocation $UsageLocation -ForceChangePassword $false
                if($userdetais){
                    Write-host "    user $userprincipleName  is created without licence!" -ForegroundColor Green
                    O365-WriteLog -writString  "User $userprincipleName  created without licence!" -LogPath $logFile -ReportingName 'INFO'
                }
            }else{
                Write-error  "User $userprincipleName User does not exist or password is not provided in console. Re-run the script with right inputs."
                O365-WriteLog -writString  "User $userprincipleName User does not exist or password is not provided in console. Re-run the script with right inputs." -LogPath $logFile -ReportingName 'WARN'

            }       
        }
        else{
            $displayname=$userdetais.DisplayName
            O365-WriteLog -writString  "User $userprincipleName  is already existing" -LogPath $logFile -ReportingName 'INFO'
            Write-host "    User $userprincipleName is already existing" -ForegroundColor Green
        }
        if(!$userdetais){
            Write-Host "Unable to create user $userprincipleName $Error" -ForegroundColor Red 
            O365-WriteLog -writString  "Unable to create user $userprincipleName $Error" -LogPath $logFile -ReportingName 'ERROR'
            exit
        }

        #Assigning user roles
        try{
            Write-host "    Assigning user roles to $userprincipleName... " -ForegroundColor Magenta        
            $existeduserroles=(Get-MsolUserRole -UserPrincipalName $userprincipleName | select Name).Name
            foreach($Usrrole in $assgingUserRoles){
                $Usrrole=$Usrrole.ToString().trim()
                if($existeduserroles){
                    if(!$existeduserroles.contains($Usrrole)){
                        Add-MsolRoleMember -RoleName $Usrrole -RoleMemberEmailAddress $userprincipleName
                        Write-host "    '$Usrrole' user role is assigned to $userprincipleName!" -ForegroundColor Green
                        O365-WriteLog -writString  "'$Usrrole' user role is assigned to $userprincipleName!" -LogPath $logFile -ReportingName 'INFO'
                    }
                }
                else{
                    Add-MsolRoleMember -RoleName $Usrrole -RoleMemberEmailAddress $userprincipleName   
                    Write-host "    '$Usrrole' user role is assigned to $userprincipleName!" -ForegroundColor Green
                    O365-WriteLog -writString  "'$Usrrole' user role is assigned to $userprincipleName!" -LogPath $logFile -ReportingName 'INFO'
                }
            }
        }catch{
            $message= $_.Exception.Message + $_.ScriptStackTrace 
            Write-Host -Message "Error while assigning the user roles $message." -ForegroundColor Red 
            O365-WriteLog -writString "Error while assigning the user roles -> $message " -LogPath $logFile -ReportingName 'EXCEPTION'    
        }

        #Creating role group and assinging roles
                                                                                                                                                                                                                                                                try{
        Write-host "    Checking if user $userprincipleName exists or not..." -ForegroundColor Green
        O365-WriteLog -writString  "Working on role group  and assigning roles..." -LogPath $logFile -ReportingName 'INFO'
        $existedrolegroups=Get-RoleGroup | select Members,Roles,Identity
        if($grp){         
            $rolegroupdetails=$existedrolegroups | Where-Object {($_.Identity) -eq $grp} | select *
            if($rolegroupdetails){
                Write-host "$grp Role group already exists!"
                O365-WriteLog -writString  "$grp Role Group already exists!" -LogPath $logFile -ReportingName 'INFO'
                $existedroleslist=$rolegroupdetails.Roles
                foreach($role in $roleslist){
                    if(!$existedroleslist.contains($role)){
                        New-ManagementRoleAssignment -Role $role -SecurityGroup $grp
                        O365-WriteLog -writString  "Added role $role to role group $grp." -LogPath $logFile -ReportingName 'INFO'
                        Write-host "    Added role $role to role group $grp." -ForegroundColor Green
                    }
                }
                $existedmembers=$rolegroupdetails.Members
                if(!$existedmembers.contains($displayname)){
                    $Error.clear()
                    Start-sleep -Seconds 60
                    Add-RoleGroupMember $grp -Member $userprincipleName 
                    $count=0
                    while($Error){
                        Write-Host 'Sleeping for 30 seconds for adding role group member (Add-RoleGroupMember)' # to make user available for commandlets
                        Start-sleep -Seconds 30
                        $Error.clear()
                        Add-RoleGroupMember $grp -Member $userprincipleName 
                        $count++
                        if($count -gt 10){
                            Write-host "    Failed to add $userprincipleName as member to role group $grp, please re-run the script with same inputs." -ForegroundColor Green
                            O365-WriteLog -writString  "Failed to add $userprincipleName as member to role group $grp, please re-run the script with same inputs." -LogPath $logFile -ReportingName 'ERROR'
                            exit
                        }
                    }
                    O365-WriteLog -writString  "Added $userprincipleName as member to role group $grp" -LogPath $logFile -ReportingName 'INFO'
                    Write-host "    Added $userprincipleName as member to role group $grp" -ForegroundColor Green
                }
            }
            else{
                Start-sleep -Seconds 60
                $breaklimit=10
                Try{
                    $result=New-RoleGroup -Name $grp -Roles $roleslist -Members $userprincipleName -ManagedBy $AdminuserName -ErrorAction SilentlyContinue 
                }Catch{}
                while(!$result){
                    Write-Host 'sleep for 30 seconds for working on New-RoleGroup' # to make user available for commandlets
                    Start-sleep -Seconds 30
                    Try{
                        $result=New-RoleGroup -Name $grp -Roles $roleslist -Members $userprincipleName -ManagedBy $AdminuserName -ErrorAction SilentlyContinue 
                    }Catch{}
                    $result
                    $breaklimit--
                    if($breaklimit -lt 1){
                        break
                    }  
                }
                Write-host "    Created $grp role group with roles $roleslist!" -ForegroundColor Green
                O365-WriteLog -writString  "Created $grp role group with roles $roleslist!" -LogPath $logFile -ReportingName 'INFO'
            }
        }
    }
            catch{
                $message= $_.Exception.Message + $_.ScriptStackTrace 
                Write-Error -Message "Error while creating or assigining the role group and roles $message." 
                O365-WriteLog -writString "Error while creating or assigning the role group and roles -> $message." -LogPath $logFile -ReportingName 'EXCEPTION'    
            }
            $an='~'+$mn+':751:'+$pn
            O365-WriteLog -writString  "All permissions are set successfully for user $userprincipleName" -LogPath $logFile -ReportingName 'DONE'
            Write-host "All permissions are set successfully for user $userprincipleName"


            #TESTING
            Write-host  "checking user $userprincipleName existed or not..." 
            O365-WriteLog -writString  "checking user $userprincipleName existing or not" -LogPath $logFile -ReportingName 'TESTING'

            $chkAcc=$false
            $userdetais=Get-MsolUser -UserPrincipalName $userprincipleName -ErrorAction SilentlyContinue | select *    
                                                                                                                                                                                                                                                                                                                                                    if($userdetais){
            $chkAcc=$true
            $displayname=$userdetais.DisplayName   
            try{                    
                $existeduserroles=(Get-MsolUserRole -UserPrincipalName $userprincipleName | select Name).Name
                if($existeduserroles){

                    foreach($requirerole in $assgingUserRoles)
                    {
                       if(!$existeduserroles.contains($requirerole)){
                            Write-Host "'$requirerole' user role is not assigned to $userprincipleName." -ForegroundColor Red
                            O365-WriteLog -writString  "'$requirerole' user role is not assigned to $userprincipleName." -LogPath $logFile -ReportingName 'WARN'
                       }else{
                            Write-Host "    '$requirerole' user role assigned to $userprincipleName." -ForegroundColor Magenta
                            O365-WriteLog -writString  "'$requirerole' user role is assigned to $userprincipleName." -LogPath $logFile -ReportingName 'INFO'
                       }
                    }
                    Write-Host "Assigned user roles for $userprincipleName is $existeduserroles "
                    O365-WriteLog -writString  "Assigned user roles for $userprincipleName is $existeduserroles " -LogPath $logFile -ReportingName 'INFO'
                }
                else{
                    Write-Host "No user roles assigned for $userprincipleName" -ForegroundColor Red
                    O365-WriteLog -writString  "No user roles assigned for $userprincipleName , re-run the script " -LogPath $logFile -ReportingName 'WARN'
                }
            }
            catch{
                $message= $_.Exception.Message + $_.ScriptStackTrace 
                Write-Error -Message "Error while getting the user roles $message."
                O365-WriteLog -writString  "Error while getting the user roles $message." -LogPath $logFile -ReportingName 'ERROR'
            }

            try{

                $existedrolegroups=Get-RoleGroup | select Members,Roles,Identity
                $rolegroupdetails=$existedrolegroups | Where-Object {($_.Identity) -eq $grp} | select *  
            
                if($rolegroupdetails){
                    $existedroleslist=$rolegroupdetails.Roles
                    foreach($role in $roleslist){
                        if(!$existedroleslist.contains($role)){
                            O365-WriteLog -writString  "role '$role' is not available in  $grp role group." -LogPath $logFile -ReportingName 'WARN'
                            Write-host "role '$role' is not available in $grp role group." -ForegroundColor Red
                        }else{
                            O365-WriteLog -writString  "role '$role' is available in $grp role group!" -LogPath $logFile -ReportingName 'INFO'
                            Write-host "    role '$role' is available in $grp role group!" -ForegroundColor Magenta
                        }
                    }

                    $existedmembers=$rolegroupdetails.Members
                    $chkNam=$userprincipleName.Split('@')[0]
                    if(!$existedmembers.contains($chkNam)){
                            O365-WriteLog -writString  " $userprincipleName user is not a member in $grp rol group." -LogPath $logFile -ReportingName 'WARN'
                            Write-host "$userprincipleName user is not a member in $grp rol group." -ForegroundColor Red
                    }else{
                            O365-WriteLog -writString  " $userprincipleName user is a member in $grp role group!" -LogPath $logFile -ReportingName 'INFO'
                            Write-host "    $userprincipleName user is a member in $grp role group!" -ForegroundColor Magenta
                    }

                    Write-Host "Assigned roles for $grp group  is "
                    $writRoles=([String]$rolegroupdetails.Roles)
                    O365-WriteLog -writString  "Assigned roles for $grp group --> $writRoles " -LogPath $logFile -ReportingName 'INFO'
                    $rolegroupdetails.Roles
                }
                else{
                    write-host "Role $grp group does not exist-ForegroundColor Red"
                    O365-WriteLog -writString  "Role $grp group does not exist,re-run the script" -LogPath $logFile -ReportingName 'TESTING'
                }
            }
            catch{
                $message= $_.Exception.Message + $_.ScriptStackTrace 
                Write-Error -Message "Error while checking the assiged roles for the $grp group $message."
                O365-WriteLog -writString  "Error while checking the assiged roles for the $grp group $message." -LogPath $logFile -ReportingName 'ERROR'

            } 
    
            if($chkAcc){
                if($monitorPassword -ne $null -and $monitorPassword -ne ''){
                    $encPasswrd=O365-Enc -str $monitorPassword  
                }    
                if($runningManually){
                    #"["+$applicationName+"-"+$domain+"]"| Add-Content $filePath
                    #'Username~'+$monitorUser | Add-Content $filePath
                    #'password~'+$encPasswrd | Add-Content $filePath
                    #O365-WriteLog -writString  $an -LogPath $logFile -ReportingName 'INFO'
                }
                Write-Host '**Username~'$monitorUser
                Write-Host '**password~'$encPasswrd
                O365-WriteLog -writString  $an -LogPath $logFile -ReportingName 'INFO'
                #O365-WriteLog -writString  "Username is $monitorUser" -LogPath $logFile -ReportingName 'INFO'
                #O365-WriteLog -writString  "Password is $encPasswrd" -LogPath $logFile -ReportingName 'INFO'
            }             
        }
            else{
                O365-WriteLog -writString  "Unable to create user $userprincipleName, please re-run the script" -LogPath $logFile -ReportingName 'WARN'
                Write-host " Unable to create user $userprincipleName, please re-run the script " -ForegroundColor Red
                exit
            }

            #Get-PSSession | Remove-PSSession -Confirm:$false
            $getSession=Get-PSSession -ErrorAction SilentlyContinue
            if($getSession -ne $null -and $getSession -ne ''){
	            Disconnect-ExchangeOnline -Confirm:$false
            }
    }

    # 3.GRAPH API - GENERATING CILENTID AND SECRECT AND SET APP, DELEGATE PERMISSIONS

    #Get TenantId
    $azureAD=Connect-AzureAD -Credential $credential -AzureEnvironmentName $azureCloudArr[0] |select *
    $tenantId=$azureAD.TenantId

    $startDate = (Get-Date).AddDays(-1)
    $endDate = $startDate.AddMonths(24)
    $spArr=[System.Collections.ArrayList]@()
    O365-WriteLog -writString  "GRAPH API - started" -LogPath $logFile -ReportingName 'INFO'
    Connect-AzureAd  -AzureEnvironment $azureCloudArr[0] -Credential $credential
    $existingapp = $null
    $existingapp = get-azureadapplication -Filter "DisplayName eq '$applicationName'"
    if ($existingapp) {
        Remove-Azureadapplication -ObjectId $existingApp.objectId
    }
    $requiredResourcesAccess = New-Object System.Collections.Generic.List[Microsoft.Open.AzureAD.Model.RequiredResourceAccess]

    foreach($str in $srchStrArr){
        $srchStr=$str -split('#')
        $appArray = [System.Collections.ArrayList]@()
        $delArray = [System.Collections.ArrayList]@()
        $svcPrincipal=Get-AzureADServicePrincipal -SearchString $srchStr[1] | Where-Object {$_.DisplayName -eq $srchStr[1]}

        $spArr.Add($svcPrincipal)
        for($i=0;$i -lt $reqPermissionArr.Length;$i++ ){
            if($reqPermissionArr[$i].StartsWith($srchStr[0])){
                $grStr=$srchStr[0].ToString().Length
                $tmpnam=$srchStr[0]
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('App')){
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $appArray.Add($displayNam) 
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                while($true){
                    if($reqPermissionArr[$i].StartsWith($tmpnam) -and $reqPermissionArr[$i].EndsWith('Del')){     
                        $displayNam=$reqPermissionArr[$i].Substring($grStr)
                        $appIdx=$displayNam.Length-3
                        $displayNam=$displayNam.Substring(0,$appIdx)
                        $delArray.Add($displayNam)
                        if($i -lt $reqPermissionArr.Length-1){
                            $i++
                        }else{break;}
                    }else{
                        break;
                    }
                }
                $appValue=$svcPrincipal.AppRoles | Where-Object{$_.DisplayName -in $appArray}
                $delValue=$svcPrincipal.Oauth2Permissions | Where-Object{$_.AdminConsentDisplayName -in $delArray}
                $azureAppPermissions = GetRequiredPermissions -reqsp $svcPrincipal -requiredApplicationPermissions $appValue -requiredDelegatedPermissions $delValue
                $requiredResourcesAccess.Add($azureAppPermissions)
            }
        }
    }

    #create new Application
    $aadApplication = New-AzureADApplication -DisplayName $applicationName -ReplyUrls $replyUrl -RequiredResourceAccess $requiredResourcesAccess #-IdentifierUris $identyUri
    $null=Get-AzureADOAuth2PermissionGrant -All $true
    O365-WriteLog -writString  "New Application created" -LogPath $logFile -ReportingName 'INFO'

    #set the secret key for application
    $tmpCreVal=New-AzureADApplicationPasswordCredential -ObjectId $aadApplication.ObjectId -StartDate $startDate -EndDate $endDate -CustomKeyIdentifier $KeyDesc
    O365-WriteLog -writString  "Secret key generated" -LogPath $logFile -ReportingName 'INFO'

    #Assign application permissions to the application
    $servicePrincipal = New-AzureADServicePrincipal -AppId $aadApplication.AppId      
    foreach ($app in $requiredResourcesAccess){
        
        $reqAppSP = $spArr | Where-Object {$_.appid -contains $app.ResourceAppId}
        #Write-Host "Assigning Application permissions for $($reqAppSP.displayName)" -ForegroundColor DarkYellow 
         
        foreach ($resource in $app.ResourceAccess) {
            if ($resource.Type -match "Role") {
                New-AzureADServiceAppRoleAssignment -ObjectId $serviceprincipal.ObjectId -PrincipalId $serviceprincipal.ObjectId -ResourceId $reqAppSP.ObjectId -Id $resource.Id
            }
        }      
    }
    O365-WriteLog -writString  "App or Delegate permissions assigned" -LogPath $logFile -ReportingName 'INFO'

    #grant oauth2permissions
    Get-AzureADOAuth2PermissionGrant -All $true
    O365-WriteLog -writString  "App or Delegate permissions granted" -LogPath $logFile -ReportingName 'INFO'

    $client_id=$aadApplication.AppId
    $client_secret=$tmpCreVal.Value
    $tenantName=$domain #(Get-AzureADTenantDetail).VerifiedDomains.Name
    $authority = "https://login.microsoftonline.com/"
    $resource = "https://graph.microsoft.com"

    if($client_id -ne $null -and $client_id -ne ''){
        if($runningManually){
            if($client_id -ne $null -and $client_id -ne '' -and $client_secret -ne $null -and $client_secret -ne ''){
                O365-WriteLog -writString  "applicationName~$applicationName" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "client_id~$client_id" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "client_secret~$client_secret" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "TenantName~$tenantName" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "Authority~$authority" -LogPath $logFile -ReportingName 'INFO'
                O365-WriteLog -writString  "Resource~$resource" -LogPath $logFile -ReportingName 'INFO'
            }
        }
        else{
            $keyFileNam='\GraphDetailsKey.dat'
                    $keyPath=$writGDir+$keyFileNam
                    $unProtFile=$writGDir+'\GraphDetails.dat'
                    if(Test-Path $unProtFile -PathType Leaf){
                        $unProtPath=$writGDir+'\GraphDetails.dat'
                        $kvalue=Get-Content -Path $keyPath
                        Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.txt'
                    }

                    $chkNam="-"+$tenantName+"]"
                    $writPath=$writGDir+'\GraphDetails.txt'
                    if(Test-Path $writPath -PathType Leaf){
                        $dtls=Get-Content -Path $writPath
                        $j=0
                        $wpath1=$writGDir+'\GraphDetails1.txt'
                        for($i=0;$i -lt $dtls.Length;$i++){
                            if($dtls[$i] -match $chkNam){
                                $cnt=$i+7
                                if($dtls[$cnt].StartsWith('TenantId~')){
                                        $i=$i+9 
                                }else{
                                    $i=$i+8
                                }
                            }
                            Add-Content -Path $wpath1 -Value $dtls[$i]
                        }
                        Remove-Item $writPath
                        if(Test-Path $wpath1 -PathType Leaf){
                            Rename-Item $wpath1 'GraphDetails.txt'
                        }
                    }

                    '['+$applicationName+'-'+$tenantName+']'| Add-Content $writPath -PassThru
                    'client_id~'+$client_id| Add-Content $writPath -PassThru
                    'client_secret~'+$client_secret| Add-Content $writPath -PassThru
                    'TenantName~'+$tenantName| Add-Content $writPath -PassThru
                    'Authority~'+$authority| Add-Content $writPath -PassThru
                    'Resource~'+$resource| Add-Content $writPath -PassThru
                    'TenantId~'+$tenantId| Add-Content $writPath -PassThru
                    "`n"| Add-Content $writPath

                    $key=Get-CryptoKey -FileDir $writGDir -FileName $keyFileNam
                    $null=Protect-File $writPath -Algorithm AES -KeyAsPlainText $key -RemoveSource

                    Write-Host 'Permissions provided successfully'
                    Write-Host 'Graph API Permissions provided successfully'
                    O365-WriteLog -writString  "Graph API APP registered and Permissions provided successfully" -LogPath $logFile -ReportingName 'INFO'
        }
    }else{
        Write-Host 'Client ID is null or empty'
        O365-WriteLog -writString  "Client ID is null or empty" -LogPath $logFile -ReportingName 'INFO'
    }
    }
    else{
        if($ismbroleUser -ne $null -and $ismbroleUser -ne ''){
            if($ismbroleUser.Contains('@')){
                $mbroleNam='eGMBImportExport'
                Connect-MsolService -Credential $Credential -AzureEnvironment AzureCloud
                $mbUserDtls=Get-MsolUser -UserPrincipalName $ismbroleUser | select *
                $curMemNam=($mbUserDtls.DisplayName).Replace(' ','')
                Try{
                    Connect-ExchangeOnline  -ExchangeEnvironmentName $azureCloudArr[2] -ConnectionUri $azureCloudArr[1] -Credential $credential -PSSessionOption $sessionOption	-WarningAction SilentlyContinue -InformationAction SilentlyContinue -ShowBanner:$false -ErrorAction Stop
                }Catch{
                    $message= $_.Exception.Message + $_.ScriptStackTrace 
                    Write-Error -Message "[MBImportExport role] Exception occurred in Connect-ExchangeOnline - $message."
                    O365-WriteLog -writString  "[MBImportExport role] Exception occurred in Connect-ExchangeOnline - $message." -LogPath $logFile -ReportingName 'ERROR'
                }

                $mbRoleGrpDtls=Get-RoleGroup | Where-Object {($_.Identity) -eq $mbroleNam} | select *
                if($mbRoleGrpDtls){
                    $existedMembrs=$mbRoleGrpDtls.Members
                    if($existedMembrs -match $curMemNam){
                        Write-host "[MBImportExport role] $ismbroleUser member is existed in $mbroleNam role"
                        O365-WriteLog -writString  "[MBImportExport role] $ismbroleUser member is existed in $mbroleNam role" -LogPath $logFile -ReportingName 'INFO' 
                    }else{
                        Add-RoleGroupMember $mbroleNam -Member $ismbroleUser
                        $mbAddRoleGrpDtls=Get-RoleGroup | Where-Object {($_.Identity) -eq $mbroleNam} | select *
                        $chkMembrs=$mbAddRoleGrpDtls.Members
                        if($chkMembrs -match $curMemNam){
                            Write-host "[MBImportExport role] $ismbroleUser member is added in $mbroleNam role"
                            O365-WriteLog -writString  "[MBImportExport role] $ismbroleUser member is added in $mbroleNam role" -LogPath $logFile -ReportingName 'INFO'
                        }else{
                            Write-host "[MBImportExport role] Error occurred while adding $ismbroleUser member in $mbroleNam role"
                            O365-WriteLog -writString  "[MBImportExport role] Error occurred while adding $ismbroleUser member in $mbroleNam role" -LogPath $logFile -ReportingName 'ERROR'
                        }
                    }  
                }else{
                    Try{
                        New-RoleGroup -Name $mbroleNam -Roles 'Mailbox Import Export' -Members $ismbroleUser -ManagedBy $AdminuserName -ErrorAction Stop
                        Write-host "[MBImportExport role] $mbroleNam role created and $ismbroleUser member is added in $mbroleNam role"
                        O365-WriteLog -writString  "[MBImportExport role] $mbroleNam role created and $ismbroleUser member is added in $mbroleNam role" -LogPath $logFile -ReportingName 'INFO'
                    }Catch{
                        $message= $_.Exception.Message + $_.ScriptStackTrace 
                        Write-Error -Message "[MBImportExport role] Exception occurred while adding MailBox ImportExport Role - $message."
                        O365-WriteLog -writString  "[MBImportExport role] Exception occurred while adding MailBox ImportExport Role - $message." -LogPath $logFile -ReportingName 'ERROR' 
                    }
                }
                $getSession=Get-PSSession -ErrorAction SilentlyContinue
                if($getSession -ne $null -and $getSession -ne ''){
	                Disconnect-ExchangeOnline -Confirm:$false
                }
            }else{
                Write-Host 'Please provide MBImportExport role user name with domain... for example:xyz@domain.com'
                O365-WriteLog -writString  "Please provide MBImportExport role user name with domain... for example:xyz@domain.com" -LogPath $logFile -ReportingName 'ERROR'
            }
        }else{
            Write-Host 'Please enter the MBImportExport role user name'
            O365-WriteLog -writString  "Please enter the MBImportExport role user name" -LogPath $logFile -ReportingName 'ERROR'
        }
    }
}
else{
    Write-Host 'Given O365 Account is invalid or does not have Global Administrator role'
    O365-WriteLog -writString  "Given O365 Account is invalid or does not have Global Administrator role" -LogPath $logFile -ReportingName 'ERROR'
}

if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

$edTim3=Get-Date
O365-WriteLog -writString "O365SetRolesAndpermissions ended at $edTim3" -LogPath $logFile -ReportingName 'INFO'
O365-WriteLog -writString '************************************************************************************************' -LogPath $logFile -ReportingName 'INFO'




# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUyI6gotWJGQtjHVUIqakm1L0M
# KDCggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFNKE0o05
# q0X527YftXaZnZu2Qa7GMA0GCSqGSIb3DQEBAQUABIICAMQXuZbvAq3Sy/G9untF
# Z1GkRJZHocUy0KRAMfIR7yUC050JAhgC8UeMdoCtCDRaf6RqpeupMMdhKh06A5Ap
# skgq8XQ5NY5TGjWzG+eU4+2ZP7v69904jGZxuZ0bKN6LTuO/0MTz0b52nBIFOVjd
# Fmy/ni+dhuONFEmSBrdm3ZGCck1Rj+zsB95bKI0j3XLN8iIEtcqtIN3eA0+QfNR5
# 9a0dS9/GSse2dnpJRoOnLMo/Lp3v2pdiA/3KNpQ8ADii4EGWoC9BsucTxh+ZuziY
# Z+995jFztdh5Bw2st11X0tFRyOxJV2vG2SMvNGIIYU5deq5Aa2tbc6HaCk4qyAPR
# qbUtrhtDWahOZ1tnGkaaCxItpz2kA11I3w8PFKUqQmpxvOh02cQuCHzMjV9AUdar
# +ZC43Wv2JSBlo8ppRtx92uM34eXnH5WIUWQnPgVrx8/1+X+3lCyGAtKdFujz+UVO
# FDW/PcRjlhQ/58u6FYOEunElQHJUWHub4HS5nmzpa45ys7f3UT7tpsZXroQzDUyt
# +OSnS6xLtY84WjM3//0Mj4nKq68Jd/yXO7R39UZtjW9KxMYizFrKVOwxCDtAg7HH
# dtG0Smf0FOwUOli9SuaNpnXJaI43WdczK5ql4dz3vfS+lbVBkdtE3hmS8+w15G9a
# 1oTXPfwSKFaev+KDqEjcjTavoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDgyMzExMDEy
# OFowLwYJKoZIhvcNAQkEMSIEIM8ro0AbCGPdrRKuDpK9HiEWtXhpzlYWVlLzuvle
# 94beMA0GCSqGSIb3DQEBAQUABIICAAEP8icnj6JCkcE36+o8c/tkAJbuMEAcvFd2
# J3FonJSjzM5syqLPQPF/ucJqIqAX4S89hAQ3ON24kHFy9h6Ez9KhG3Z0Ugxpjq6q
# qkuR0ckmPMDHGnpgWfsQj19EsmeZm92GyedLgP+yA5zasZ0l5+uTOCaSdlGBdPVs
# JT+311LsqQjEnUSlkiJafgu1fsQxgfSaor9hXVR2GfCsKEnUPKvXg8Zeij5YrTLJ
# u1rL09FWzINxqaUIPdkIR9M+RMYnmOJ8YXkWzMckoYZ9jvijT+FmskPj5g/ENFjs
# 0YEdvesH+qmEgxI05JLqS3XtByjEq83CN5+cU3IAknU/LQ55P1VgA9zW+e6p5gRT
# pejX7F+ANoyDhhDDoJLEDPO4hzn2QTLJRn1bHXcVRSmqFZKsyhNyFoCq73SIyRa9
# ItiE4s9kclbram18Hfome7yUwTXKoyEbleC20MyyYOyGwhpecXtXBXMhMcQVcWjj
# a+9KLDdOIPiED1JGj0yCBxZZSJzUd+5uyRMEBqwZRs6LjT46iyT5pZSSvaa77FYG
# NcYxMxZQn6Mhi3FlOwGnprDdcbVehbLL3H4v4CvwpBeRDleNKGA/DEsQRpp3dI0G
# 1ivhHHb1SnhWmfa/ogMuMLQdxLBoV8N3ExjTenU3dlHKt3NiSmoJavbC6rj4WJOC
# LIcjBcST
# SIG # End signature block
