﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
#<#
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rptTopNDD=[int]$testargs[4]
$otherdetails=$testargs[5]
$details=$otherdetails.split("#")
$toHideAdminTrfic=$details[0]
$reportingname='EXO/'+$details[1]
$proxyserverip=($details[2]).ToString().trim()
$ExcludeMails=$details[3]
$rptNamFrMT=$details[1]
$appDetails=$testargs[6]
#>

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
$proxyserver='http://'+$proxyserverip

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$filepath=$egurkhaPath+'/agent/'+$reportingname+'/'
try{
    $filereaded=Get-ChildItem -Path $filepath |Where-Object {$_.Name -like 'msgs*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -First 2 
    if($filereaded.Length -eq 2){
        if($filereaded[0].Length -lt 100 -and $filereaded[1].Length -ge 100){
            $fileName=([String]$filereaded[0].Name).Trim()
            if([System.IO.File]::Exists(($filepath+$fileName)) -eq 'True'){
                Remove-Item $filepath$fileName
            }
        }
    }  
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "msgs" -keyFileName "kmsgs" -EgPath $egurkhaPath
    if($readfiles1 -ne $null -and [System.IO.File]::Exists($readfiles1[1]) -eq 'True'){
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]
        $MessageTracetemp= import-csv $csvfile1 -Encoding $encTyp  
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'msgs' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kmsgs' -InputFile $readfiles1[4]
        Write-Host 'ReadFile:'$readfiles1[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
[System.GC]::GetTotalMemory($true) | out-null
if ( Test-Path $filepath -PathType Container ) {
    if($rptNamFrMT -match '_exd'){
        $alldomainnames=@()
        $dhash=@{}
        $dmnshash=Eg-O635Domains -username $userName -password $Password -rptNam $rptNamFrMT -proxyserverip $proxyserver -proxyUsr $proxyUsr -proxyPass $proxyPass -appDetails $appDetails
        $arr=$dmnshash[$rptNamFrMT].split('~')
        $dhash.Add('SupersetName',$arr[1])
        $dhash.Add($arr[0],$rptNamFrMT)
    	foreach($h in $dhash.Keys){
	        if($dhash[$h] -match $rptNamFrMT){
                if($h.IndexOf(',') -ne -1){
                    $dmarr=$h.split(',')
                    foreach($ele in $dmarr){
                        $alldomainnames+=$ele
                    }
                }
                else{
                    $alldomainnames+=$h
                }		                
	        }
	    }
    }else{
        $alldomainnames=Eg-GetDomain -userName $username -Password $Password -proxyUsr $proxyUsr -proxyPass $proxyPass -proxyserver $proxyserver -appDetails $appDetails
    }
	$remvedmails=New-Object System.Collections.ArrayList
    if($toHideAdminTrfic -eq $true){           
        [void]$remvedmails.Add($username)   
    }
    try{
        if($ExcludeMails.Contains(',')){        
            $ExcludeMails=$ExcludeMails.Split(',')      
        }
    }catch{  $ExcludeMails=" "}

    foreach( $ExcludeMail in  $ExcludeMails){        
       [void] $remvedmails.Add($ExcludeMail)
    }
    #each domain process
    foreach($domainname in $alldomainnames){  
        $tmpdomainname = "@"+$domainname 
        if($MessageTracetemp.SenderAddress -match $tmpdomainname -or $MessageTracetemp.RecipientAddress -match $tmpdomainname){
            $domainname=$domainname.ToString().ToLower() 
            Write-host 'gettingmeasuresofSpecificDomains#' $domainname
            $unqSendersHT = New-Object System.Collections.Hashtable
            $unqRecepientsHT = New-Object System.Collections.Hashtable
            $FmIPHT = New-Object System.Collections.Hashtable       
            $Pending=0
            $None=0
            $Failed=0
            $Delivered=0
            $Expanded=0
            $Resolved=0
            $GettingStatus=0
            $Quarantined=0
            $Unknown=0
            $FilteredAsSpam=0
            $interMailSent=0
            $sizeinterMailSent=0
            $exterMailSent=0
            $sizeexterMailSent=0
            $interMailRevd=0
            $sizeinterMailRevd=0
            $exterMailRevd=0
            $sizeexterMailRevd=0
            $InboundMailitemsNsize = @{} 
            $OutboundMailitemsNsize = @{} 
            $MailExternalSent=@{}
            $MailExternalReceived=@{}
            $MailInternalSent=@{}
            $MailInternalReceived=@{}
            $UniqueInboundDomains=@{}
            $UniqueOutboundDomains=@{}
            $delstatuscnt=0

            #for each domain the data will be processed in this loop
            foreach($Message in $MessageTracetemp){ 
                if($Message.SenderAddress -match $remvedmails -and $Message.RecipientAddress -match $remvedmails -and $remvedmails -match " " -and $remvedmails -match $null){}
                else{        
                    $sendersDomain = "" 
                    $RecipientDomain=""
                    try{$sendersDomain=(($Message.SenderAddress).split('@')[1]).ToString().ToLower()}catch{$sendersDomain=""}
                    try{$RecipientDomain=(($Message.RecipientAddress).split('@')[1]).ToString().ToLower()}catch{$RecipientDomain=""}                
                    if(($sendersDomain-ne "" -and $domainname -eq $sendersDomain) -or ($RecipientDomain -ne "" -and $domainname -eq $RecipientDomain)) {
                        try{$unqSendersHT.Add($Message.SenderAddress,$Message.SenderAddress)}catch{} 
                        try{$unqRecepientsHT.Add($Message.RecipientAddress,$Message.RecipientAddress)}catch{}
                        try{$FmIPHT.Add($Message.FromIP,$Message.FromIP)}catch{}
                               
                        ## message delivery status
                        $Status = $Message.Status
                        if($Status -eq 'Delivered' -and $Status -ne $null){$Delivered++} 
                        elseif($Status -eq 'Expanded' -and $Status -ne $null){$Expanded++}
                        elseif($Status -eq 'Resolved' -and $Status -ne $null){$Resolved++}
                        elseif($Status -eq 'Pending' -and $Status -ne $null){$Pending++}   
                        elseif($Status -eq 'Failed' -and $Status -ne $null){$Failed++}
                        elseif($Status -eq 'GettingStatus' -and $Status -ne $null){$GettingStatus++}
                        elseif($Status -eq 'Quarantined' -and $Status -ne $null){$Quarantined++}
                        elseif($Status -eq 'Unknown' -and $Status -ne $null){$Unknown++}
                        elseif($Status -eq 'None' -and $Status -ne $null){$None++} 
                        elseif($Status -eq 'FilteredAsSpam' -and $Status -ne $null){$FilteredAsSpam++}

                        #Read each message tracking entry and add it to a hash table
                        $MessageSenderAddress=$Message.SenderAddress+'#'+$Message.FromIP
                        $MessageRecipientAddress=$Message.RecipientAddress+'#'+$Message.ToIP

                           ## Mails sent to external and other internal tenant domains 
	                    if ($Message.RecipientAddress -ne $null -and $RecipientDomain -ne $domainname) {

		                    if ($OutboundMailitemsNsize.ContainsKey($MessageSenderAddress)) { 
		                        $OutboundMailitemsNsize[$MessageSenderAddress]['Outbound']++ 
		                        $OutboundMailitemsNsize[$MessageSenderAddress]['OutboundSize'] += [int]$Message.Size
    	                    }
                            else{
                                $OutboundMailitemsNsize[$MessageSenderAddress] = @{}
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['Outbound']= 1
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['Inbound']=0
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['InboundSize']=0
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
                            }
	                    }
                        
                            ## Mails received from the external and other internal tenant domains
                        if ($Message.SenderAddress -ne $null -and $sendersDomain -ne $domainname) {
		                    if ($InboundMailitemsNsize.ContainsKey($MessageRecipientAddress)){ 
			                    $InboundMailitemsNsize[$MessageRecipientAddress]['Inbound']++ 
			                    $InboundMailitemsNsize[$MessageRecipientAddress]['InboundSize'] += [int]$Message.Size
		                    }
                            else{
                                $InboundMailitemsNsize[$MessageRecipientAddress] = @{}
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['Outbound']= 0
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['Inbound']=1
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['InboundSize']= [int]$Message.Size
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['OutboundSize']= 0
                            }     
	                    }
  
		                if( $sendersDomain -eq $domainname -and $RecipientDomain -eq $domainname){
                                ## Mails sent within the current domain
			                $interMailSent++
			                $sizeinterMailSent=$sizeinterMailSent+$Message.Size

		                    if($MailInternalSent.ContainsKey($MessageSenderAddress)){
			                    $MailInternalSent[$MessageSenderAddress]['Outbound']++
			                    $MailInternalSent[$MessageSenderAddress]['OutboundSize'] +=[int]$Message.Size
		                    }
		                    else{
			                    $MailInternalSent[$MessageSenderAddress]=@{}
			                    $MailInternalSent[$MessageSenderAddress]['Inbound']=0
			                    $MailInternalSent[$MessageSenderAddress]['InboundSize']=0
			                    $MailInternalSent[$MessageSenderAddress]['Outbound']=1
			                    $MailInternalSent[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
		                    }   
		    
		                        ## Mails received within the current domain
		                    if($Message.Status -eq 'Delivered' -or $Message.Status -eq 'Expanded' -or $Message.Status -eq 'Resolved' -or $Message.Status -eq 'Quarantined' -or $Message.Status -eq 'FilteredAsSpam'){         
			                    $interMailRevd++
			                    $sizeinterMailRevd=$sizeinterMailRevd+$Message.Size
		                        if($MailInternalReceived.ContainsKey($Message.RecipientAddress)){
			                        $MailInternalReceived[$Message.RecipientAddress]['Inbound']++
			                        $MailInternalReceived[$Message.RecipientAddress]['InboundSize'] +=[int]$Message.Size
		                        }
		                        else{
			                        $MailInternalReceived[$Message.RecipientAddress]=@{}
			                        $MailInternalReceived[$Message.RecipientAddress]['Inbound']=1
			                        $MailInternalReceived[$Message.RecipientAddress]['InboundSize']=[int]$Message.Size
			                        $MailInternalReceived[$Message.RecipientAddress]['Outbound']=0
			                        $MailInternalReceived[$Message.RecipientAddress]['OutboundSize']=0
		                        }
		                    }           
		                }

                            #Mails sent outside the tenant domain and sender should be in the current domain
                        elseif( $sendersDomain -eq $domainname -and !($alldomainnames -match $RecipientDomain)){
                            $exterMailSent++           
                            $sizeexterMailSent=$sizeexterMailSent+$Message.Size
                            if($MailExternalSent.ContainsKey($Message.RecipientAddress)){
                                $MailExternalSent[$Message.RecipientAddress]['Outbound']++
                                $MailExternalSent[$Message.RecipientAddress]['OutboundSize'] +=[int]$Message.Size
                            }
                            else{
                                $MailExternalSent[$Message.RecipientAddress]=@{}
                                $MailExternalSent[$Message.RecipientAddress]['Inbound']=0
                                $MailExternalSent[$Message.RecipientAddress]['InboundSize']=0
                                $MailExternalSent[$Message.RecipientAddress]['Outbound']=1
                                $MailExternalSent[$Message.RecipientAddress]['OutboundSize']=[int]$Message.Size
                            }
                        }
                            #Mails received from outside the tenant domain and receiver should be in the current domain
		                elseif( $RecipientDomain -eq $domainname -and !($alldomainnames -match $sendersDomain)){
			                $exterMailRevd++
			                $sizeexterMailRevd=$sizeexterMailRevd+$Message.Size

		                    if($MailExternalReceived.ContainsKey($Message.SenderAddress)){
			                    $MailExternalReceived[$Message.SenderAddress]['Inbound']++
			                    $MailExternalReceived[$Message.SenderAddress]['InboundSize'] +=[int]$Message.Size
		                    }
		                    else{
			                    $MailExternalReceived[$Message.SenderAddress]=@{}
			                    $MailExternalReceived[$Message.SenderAddress]['Inbound']=1
			                    $MailExternalReceived[$Message.SenderAddress]['InboundSize']=[int]$Message.Size
			                    $MailExternalReceived[$Message.SenderAddress]['Outbound']=0
			                    $MailExternalReceived[$Message.SenderAddress]['OutboundSize']=0
		                    }
		                }

		                ###Message Status DD
                        $msgSub=[String]$Message.Subject
                        if($msgSub.Length -gt 1999){
                            $msgSub=$msgSub.Substring(0,1995+'...')
                        }
                        if($delstatuscnt -lt $rptTopNDD -and ($Message.Status -eq 'None' -or $Message.Status -eq 'Failed' -or $Message.Status -eq 'Pending' -or $Message.Status -eq 'Unknown' -or $Message.Status -eq 'Quarantined') ){
		                    $size=(($Message.Size)/1024).tostring("#.##").replace(',','.')
	                        Write-Host '#delstatusdd'$Message.Status $Message.Received '~!~'$Message.SenderAddress '~!~' $Message.RecipientAddress '~!~' $msgSub '~!~' $size '~!~' $Message.FromIP                    		    
                            $delstatuscnt++;
                        }elseif($FilteredAsSpam -lt $rptTopNDD -and $Message.Status -eq 'FilteredAsSpam'){                    
		                    $size=(($Message.Size)/1024).tostring("#.##").replace(',','.')
                            Write-Host "#delstatusdd Spam" $Message.Received'~!~'$Message.SenderAddress'~!~'$Message.RecipientAddress'~!~'$msgSub'~!~'$size '~!~'$Message.FromIP           
                        }

                           ## Mails sent to other internal and external domains
                        if($RecipientDomain -ne $null -and $RecipientDomain -ne "" -and $RecipientDomain -ne $domainname ){
                            if($UniqueOutboundDomains.ContainsKey($RecipientDomain)){
			                    $UniqueOutboundDomains[$RecipientDomain]['Outbound']++
			                    $UniqueOutboundDomains[$RecipientDomain]['OutboundSize']+=[int]$Message.Size                   
                            }
                            else{
				                $UniqueOutboundDomains[$RecipientDomain]=@{}
			                    $UniqueOutboundDomains[$RecipientDomain]['Inbound']=0
			                    $UniqueOutboundDomains[$RecipientDomain]['InboundSize']=0
			                    $UniqueOutboundDomains[$RecipientDomain]['Outbound']=1
			                    $UniqueOutboundDomains[$RecipientDomain]['OutboundSize']=[int]$Message.Size
                            }
                        }
                          ##  Mails received from other internal and external domains
                        if($sendersDomain -ne $null -and $sendersDomain -ne "" -and $sendersDomain -ne $domainname){
                            if($UniqueInboundDomains.ContainsKey($sendersDomain)){
			                    $UniqueInboundDomains[$sendersDomain]['Inbound']++
			                    $UniqueInboundDomains[$sendersDomain]['InboundSize']+=[int]$Message.Size                   
                            }
                            else{
				                $UniqueInboundDomains[$sendersDomain]=@{}
			                    $UniqueInboundDomains[$sendersDomain]['Inbound']=1
			                    $UniqueInboundDomains[$sendersDomain]['InboundSize']=[int]$Message.Size
			                    $UniqueInboundDomains[$sendersDomain]['Outbound']=0
			                    $UniqueInboundDomains[$sendersDomain]['OutboundSize']=0
                            }
                        }                           
                    }            
                }        
            }

            write-host 'SenderAddress' $unqSendersHT.Keys.Count"#@!"
            write-host 'RecipientAddress' $unqRecepientsHT.Keys.Count"#@!"
            write-host 'FromIP' $FmIPHT.Keys.Count"#@!"

            ## message delivery status measures
	        Write-Host '#statusMeasure' $None' ~' $Failed' ~' $Pending' ~'  $Delivered '~' $Expanded '~' $Resolved  '~' $FilteredAsSpam '~' $GettingStatus '~' $Quarantined '~' $Unknown 	          

	        #Build a table to format the results 
	        $table = New-Object system.Data.DataTable "DetailedMessageStats" 
	        $col2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $table.columns.add($col2) 
	        $col3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $table.columns.add($col3) 
	        $col4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $table.columns.add($col4)
	        $col5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $table.columns.add($col5) 
	        $col6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $table.columns.add($col6) 

	        $intable=New-Object system.Data.DataTable "DetailedMessageStats" #table for out emails
	        $incol2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $intable.columns.add($incol2) 
	        $incol3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $intable.columns.add($incol3) 
	        $incol4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $intable.columns.add($incol4) 
	        $incol5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $intable.columns.add($incol5) 
	        $incol6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $intable.columns.add($incol6) 

	        $outtable=New-Object system.Data.DataTable "DetailedMessageStats" #table for out emails
	        $tcol2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $outtable.columns.add($tcol2) 
	        $tcol3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $outtable.columns.add($tcol3) 
	        $tcol4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $outtable.columns.add($tcol4) 
	        $tcol5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $outtable.columns.add($tcol5) 
	        $tcol6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $outtable.columns.add($tcol6) 

	        $Inbunddomainstab=New-Object system.Data.DataTable "Detailed Sender Domains Stats" #table for out emails
	        $tcol1 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $Inbunddomainstab.columns.add($tcol1) 
	        $tcol2 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $Inbunddomainstab.columns.add($tcol2)  
	        $tcol3 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $Inbunddomainstab.columns.add($tcol3) 

	        $Outbunddomainstab=New-Object system.Data.DataTable "Detailed Recipents Domains Stats" #table for out emails
	        $tcol1 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $Outbunddomainstab.columns.add($tcol1) 
	        $tcol2 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $Outbunddomainstab.columns.add($tcol2) 
	        $tcol3 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $Outbunddomainstab.columns.add($tcol3) 
 
	        #Transpose hashtable to datatable 
	        $TotalInboundSize=0 
	        $TotalOutboundSize=0
	        $TotalInboundItems=0
	        $TotalOutboundItems=0
    
  	        ForEach ($Recipient in $InboundMailitemsNsize.keys){ 
	            $RecipientName = $Recipient 
	            $row = $table.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $InboundMailitemsNsize[$RecipientName].Inbound 
		        $row.Outbound = $InboundMailitemsNsize[$RecipientName].Outbound 
		        $row.InboundSize = ($InboundMailitemsNsize[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($InboundMailitemsNsize[$RecipientName].OutboundSize)/1024
		        $table.Rows.Add($row)     
		        $TotalInboundSize = $TotalInboundSize + $InboundMailitemsNsize[$RecipientName].InboundSize
		        $TotalInboundItems = $TotalInboundItems + $InboundMailitemsNsize[$RecipientName].Inbound

	        } 
	        #Export data to CSV and Screen 
              
	        #"*******Top 10 Recipients by Inbound size*******" 
	        $InSize=$table  | sort InboundSize -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
	
   	        foreach($s in $InSize){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'InboundSize ' $mailIPadress[0] ','$s.Item(2)','$s.Item(1)','$outboundsize','$inbundsize',' $mailIPadress[1]
	        }
            #"*******Top 10 Recipients by Inbound items*******" 
	        $InItems=$table | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
   	        foreach($s in $InItems){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
                Write-Host  'InboundItems ' $mailIPadress[0] ','$s.Item(2)','$s.Item(1)','$outboundsize','$inbundsize',' $mailIPadress[1]
	        }
   	        $table.Rows.Clear()  # clearing all rows of the outable 
    
   	        ForEach ($Recipient in $OutboundMailitemsNsize.keys){ 
	            $RecipientName = $Recipient 
	            $row = $table.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $OutboundMailitemsNsize[$RecipientName].Inbound 
		        $row.Outbound = $OutboundMailitemsNsize[$RecipientName].Outbound 
		        $row.InboundSize = ($OutboundMailitemsNsize[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($OutboundMailitemsNsize[$RecipientName].OutboundSize)/1024
		        $table.Rows.Add($row)   
		        $TotalOutboundSize = $TotalOutboundSize + $OutboundMailitemsNsize[$RecipientName].OutboundSize
		        $TotalOutboundItems = $TotalOutboundItems + $OutboundMailitemsNsize[$RecipientName].Outbound
	        }
   	        #"*******Top 10 Senders by Outbound size*******" 
	        $outSize=$table | sort OutboundSize -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
  	        foreach($s in $outSize){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'OutboundSize ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        } 
   	            #"*******Top 10 Senders by Outbound items*******" 
	            $outitems = $table | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
	        foreach($s in $outitems){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'OutboundItems ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
   
	        #"*******Totals*******"
	        $TotalItems=$TotalInboundItems+$TotalOutboundItems
	        $TotalSize=$TotalInboundSize+$TotalOutboundSize 
            $TotalInboundSize=if([math]::round($TotalInboundSize /1Gb, 4) -gt 0){ ([math]::round($TotalInboundSize /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
            $TotalOutboundSize=if([math]::round($TotalOutboundSize /1Gb, 4) -gt 0){ ([math]::round($TotalOutboundSize /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
            $TotalSize=if([math]::round($TotalSize /1Gb, 4) -gt 0){ ([math]::round($TotalSize /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        write-host "Totals "$TotalInboundSize ~ $TotalOutboundSize ~ $TotalInboundItems ~ $TotalOutboundItems ~ $TotalItems ~ $TotalSize"#@!" 

	        #$table | sort Date,Recipient,Inbound,Outbound, InboundSize, OutboundSize -desc | Out-GridView -Title "Messages Sent By User"
	        $sizeinterMailSent=if([math]::round($sizeinterMailSent /1Gb, 4) -gt 0){ ([math]::round($sizeinterMailSent /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        $sizeinterMailRevd=if([math]::round($sizeinterMailRevd /1Gb, 4) -gt 0){ ([math]::round($sizeinterMailRevd /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        $sizeexterMailSent=if([math]::round($sizeexterMailSent /1Gb, 4) -gt 0){ ([math]::round($sizeexterMailSent /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        $sizeexterMailRevd=if([math]::round($sizeexterMailRevd /1Gb, 4) -gt 0){ ([math]::round($sizeexterMailRevd /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }    
	        Write-Host  'emailsCountAndSize##' $interMailSent ~ $sizeinterMailSent  ~ $interMailRevd ~ $sizeinterMailRevd ~ $exterMailSent ~ $sizeexterMailSent ~ $exterMailRevd ~ $sizeexterMailRevd
   
            ForEach ($Recipient in $MailExternalSent.keys) { 
	            $RecipientName = $Recipient 	     
		        $row = $outtable.NewRow() 
		        #$row.Date = $Date 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailExternalSent[$RecipientName].Inbound 
		        $row.Outbound = $MailExternalSent[$RecipientName].Outbound 
		        $row.InboundSize = ($MailExternalSent[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailExternalSent[$RecipientName].OutboundSize)/1024
		        $outtable.Rows.Add($row)     
	        }
   	        # $exterMailRevd++           #external mail recived an mail from our domain inbound
	        # $exterMailSent++           #External mail sent an mail to our domain  outbound
	        #"*******Top 10 External Recipients by Outbound items*******" 
	        $Externalemailsent = $outtable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
   	        foreach($s in $Externalemailsent){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	           Write-Host  'Externalemailsent ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }

            $outtable.Rows.Clear()  # clearing all rows of the outable 

   	        ForEach ($Recipient in $MailExternalReceived.keys) { 
	            $RecipientName = $Recipient 	     
		        $row = $outtable.NewRow() 
		        #$row.Date = $Date 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailExternalReceived[$RecipientName].Inbound 
		        $row.Outbound = $MailExternalReceived[$RecipientName].Outbound
		        $row.InboundSize = ($MailExternalReceived[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailExternalReceived[$RecipientName].OutboundSize)/1024
		        $outtable.Rows.Add($row)     
	        }
   	        #"*******Top 10 External Recipients by Inbound items*******" 
	        $Externalemailrecived = $outtable | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
  	        foreach($s in $Externalemailrecived){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')      
	          Write-Host  'Externalemailrecived' $mailIPadress[0] ',' $s.Item(2) ',' $s.Item(1) ',' $outboundsize ',' $inbundsize  ',' $mailIPadress[1]
	        }
         
 	        ForEach ($Recipient in $MailInternalSent.keys){ 
	            $RecipientName = $Recipient 	     
		        $row = $intable.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInternalSent[$RecipientName].Inbound 
		        $row.Outbound = $MailInternalSent[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInternalSent[$RecipientName].InboundSize)/1024 
		        $row.OutboundSize = ($MailInternalSent[$RecipientName].OutboundSize)/1024
		        $intable.Rows.Add($row)     
	        }
  
	        #"*******Top 10 Internal Recipients by Outbound items*******" 
	        $Internalemailsent = $intable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
 	        foreach($s in $Internalemailsent){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	          Write-Host  'Internalemailsent ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }

            $intable.Rows.Clear()  # clearing all rows of the intable 

 	        ForEach ($Recipient in $MailInternalReceived.keys){ 
	            $RecipientName = $Recipient 	     
		        $row = $intable.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInternalReceived[$RecipientName].Inbound 
		        $row.Outbound = $MailInternalReceived[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInternalReceived[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailInternalReceived[$RecipientName].OutboundSize)/1024
		        $intable.Rows.Add($row)     
	        }
	        #"*******Top 10 Internal Recipients by Inbound items*******" 
	        $Internalemailreceving = $intable | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
 	        foreach($s in $Internalemailreceving){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	          Write-Host  'Internalemailreceving ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
              ## ADDING ROWS TO TABLE
            $sendercount=0
    
            ForEach ($Recipient in $UniqueInboundDomains.keys){ 
	            $RecipientName = $Recipient 
	            $sendercount++
		        $row = $Inbunddomainstab.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $UniqueInboundDomains[$RecipientName].Inbound 
		        $row.InboundSize = ($UniqueInboundDomains[$RecipientName].InboundSize)/1024
		        $Inbunddomainstab.Rows.Add($row)     
	        }
 	        #"*******Top 10 Sender Domains by Outbound items*******" 
	        $unquesendrdoms = $Inbunddomainstab | sort Inbound -Descending #| select -first 10 | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
            $uniqueRecipentDomainsCnt = 0
            foreach($s in $unquesendrdoms){
               $inbundsize=if($s.Item(2) -gt 0){ ($s.Item(2)).tostring("#.##").replace(',','.') } else { 0 }
               if($uniqueRecipentDomainsCnt -lt $rptTopNDD){
	                Write-Host  'uniqueRecipentDomains ' $s.Item(0)','$s.Item(1)','$inbundsize #for Inbound domains measure here sender is others and reciver ours domain
                    $uniqueRecipentDomainsCnt++
                }
	        }
  
            ## ADDING ROWS TO TABLE
            $recipncount=0
            ForEach ($Recipient in $UniqueOutboundDomains.keys){ 
	            $RecipientName = $Recipient 
                $recipncount++
		        $row = $Outbunddomainstab.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Outbound = $UniqueOutboundDomains[$RecipientName].Outbound
		        $row.OutboundSize = ($UniqueOutboundDomains[$RecipientName].OutboundSize)/1024
		        $Outbunddomainstab.Rows.Add($row)     
	        }
   
	        #"*******Top 10 Recipents Domains by Outbound items*******" 
	        $unqueOutdoms = $Outbunddomainstab | sort Outbound -Descending # | select -first 10  | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
            $uniqueSenderDomainsCnt = 0
            foreach($s in $unqueOutdoms){
                $outboundsize=if($s.Item(2) -gt 0){ ($s.Item(2)).tostring("#.##").replace(',','.') } else { 0 }
	            if($uniqueSenderDomainsCnt -lt $rptTopNDD){
                    Write-Host  'uniqueSenderDomains' $s.Item(0)','$s.Item(1)',' $outboundsize   ## for outbound domains measure dd and here we are getting domains where sender is ours and recevers in other
                    $uniqueSenderDomainsCnt++
                }
	        }
            Write-Host 'uniquesdominascount'  $UniqueOutboundDomains.Count '~'  $UniqueInboundDomains.count   
            Write-Host 'donewithMeasuresofdomain#'$domainname    
        }            
    }            
}
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUuwffqxBo7tVMrrAOKwogq9Tf
# cYKggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFCMV8chl
# TMGh/guPKhSE2F/j1Y1DMA0GCSqGSIb3DQEBAQUABIICAA0JTLAMN/oue3IGUJAR
# wu/Y/PRU6y2igKrrAQGwryKmzeplh1RJ0fQs9iSfEU/9M00pY1+Cm41Q+tFdfuME
# mpgjYRCa0FcEAYTf/1EPDATFidBkaQpeDeTPWi+ZTL9ln4b2T1Mh5qJfBTnChYku
# ta+3FIOPXHSUcZL0INfG2QjyS++4O1OJC888xqlB8kf0WEGXcFf5gcsElI4cgRVx
# NdzBwNGrNP9RT5RZiP4ric3/RXEoC9OohqHL2SMAhdOTQGyCUMI6+uIsjou8/8oE
# rI2Gv9eue88CE1ZZ3TBueV0pnV8U+3X/+OtZ5NbFZhH8czy9DL0MfecUopQDIBcb
# QFUKr9LwPYW3TMuD/R0EpQzjAfwTT5XYAStlRHRRGhpInLu8z+YlKKWg2DUo8eb+
# 47+GFnJh6KC7VIeIdfMP6LD6WSXq/k/0TFn5vqQtfbMshkLbbjA6oge/V1MtLg3k
# ue3FGLBLKAmSelkkfC/H/sy54Mks5giDx9yvmTFZXb7uNKWKTIPqzLBarFWHhiFK
# CqfeEyKZ63lMf/Y6E2OcLk1f5VmNutu3NtnNYlBM3uHI3tg/S97y0SWCzIS1nCUf
# jvV1fy2X/5Obiy0NnDR5SJ14QFnZ3sxRyRfa/3Q78trhW8iyaIyAxx6EZAAVqK1n
# rF0NDik3BMDhzHD3f2iaV9mIoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MDk0
# N1owLwYJKoZIhvcNAQkEMSIEIHKKT6WOx1fc5+JOAsPIDcbXWHnTHNRB90SNraCv
# S32uMA0GCSqGSIb3DQEBAQUABIICAHEOxRDS3Jtu3zMJHbFhhZZQyg/msHlqg0lt
# tpvdzXRFDD7KQxe3KT5mMVBeL54XvA+aLMSeCtd5rUvg4OiiFi3ohvbLpyrUSkVl
# N8df4QxTwWbQpv5KUGusLreK+26mSphsV7nI4etbsW8e9NAYlJSIpDkgfcqfLsSD
# CtypMM7smKRmD7hF5D/NdIe1I20m2ZkLrCRsFMfHmfW3pcUtQlkNTN6wEj+u3hg1
# CYng93UMbbsrRPj6Z1hzMCBLKKrF7Y2T70mNVhSWKGfToptXRkm5DiZZS3GeKA63
# GqbPSvYp1WbDXPVRwmZkrgyYQtbTwiOx/m2gkjQnDzAej/0MJ39J+vvyRcmZbwrs
# sqUuozm7lB6+IbrxeQeZb+oV40br5YvKDIXVYUQo2ERA2Oaz28dK25avKEsXq7t2
# cAjUa7yjRIDqTloso3WjGCPOdwBkLMFZlq56rrYVzoiUQ/T7Pv58l/zPMUE1WnQM
# h8f3tA9dq3R4AK2kM9L6Tec15whCq9zrpsKufBSFjM58FlcGCg/NngnmSy2+mE50
# C9IbPMwC5dZPFVAJikpFjDXQzmK8tYM4pWYX6IgycG6qPjpODJKTI9POkut68ZoT
# FzxuVc8aBu0OSi7Mau99+YZ48mhSSbUPLjz+Migrs8sSgwoIFNwuK+sZweOR5ZKv
# sXZyP87I
# SIG # End signature block
