/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import java.io.Serializable;

public final class Sample
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long sampleStartTime = -1L;
    private StackTraceElement[] stackTraceElement = null;
    private transient boolean discard = false;
    private int sampleId;

    public Sample() {
        this.discard = true;
    }

    public Sample(long l2, StackTraceElement[] stackTraceElementArray) {
        this.sampleStartTime = l2;
        this.stackTraceElement = stackTraceElementArray;
        if (stackTraceElementArray == null) {
            this.discard = true;
        }
    }

    public int getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(int n2) {
        this.sampleId = n2;
    }

    public long getSampleStartTime() {
        return this.sampleStartTime;
    }

    public StackTraceElement[] getStackTraceElement() {
        return this.stackTraceElement;
    }

    public int getStackTraceElementDepth() {
        if (this.stackTraceElement != null) {
            return this.stackTraceElement.length;
        }
        return 0;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sample sample = (Sample)object;
        return this.sampleStartTime == sample.getSampleStartTime() && this.sampleId == sample.getSampleId();
    }

    public int hashCode() {
        return (int)(this.sampleStartTime / 10000L);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sampleId).append("#").append(this.sampleStartTime).append("#");
        if (this.stackTraceElement == null) {
            stringBuilder.append("0");
        } else {
            stringBuilder.append(this.stackTraceElement.length);
        }
        return stringBuilder.toString();
    }
}

