/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.EntityType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.AdminServiceLinkType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServiceLink
extends VcloudResource<AdminServiceLinkType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminServiceRef;

    AdminServiceLink(VcloudClient client, AdminServiceLinkType serviceLinkResource) {
        super(client, serviceLinkResource);
        this.sortAdminServiceLinkRefs();
    }

    private void sortAdminServiceLinkRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((AdminServiceLinkType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.service+xml")) continue;
                this.adminServiceRef = link;
            }
        }
    }

    public static AdminServiceLink getAdminServiceLinkByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminServiceLink(client, (AdminServiceLinkType)AdminServiceLink.getResourceByReference(client, reference));
    }

    public static AdminServiceLink getAdminServiceLinkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/entity" + "/" + vCloudId);
        EntityType entityType = (EntityType)SdkUtil.get(client, client.getVcloudApiURL() + "/entity" + "/" + vCloudId, 200);
        for (LinkType link : entityType.getLink()) {
            if (!link.getType().equals("application/vnd.vmware.admin.serviceLink+xml")) continue;
            return new AdminServiceLink(client, (AdminServiceLinkType)SdkUtil.get(client, link.getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getAdminServiceReference() throws VCloudException {
        if (this.adminServiceRef != null) {
            return this.adminServiceRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

