/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VendorServicesType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.VMWNetworkPoolType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMWNetworkPool
extends VcloudEntity<VMWNetworkPoolType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    VMWNetworkPool(VcloudClient client, VMWNetworkPoolType vmwNetworkPoolType_v1_5) {
        super(client, vmwNetworkPoolType_v1_5);
    }

    public static VMWNetworkPool getVMWNetworkPoolByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new VMWNetworkPool(client, (VMWNetworkPoolType)VMWNetworkPool.getResourceByReference(client, reference));
    }

    public static VMWNetworkPool getVMWNetworkPoolById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VMWNetworkPool(client, (VMWNetworkPoolType)VMWNetworkPool.getEntityById(client, vCloudId, "application/vnd.vmware.admin.networkPool+xml"));
    }

    public VMWNetworkPool updateVMWNetworkPool(VMWNetworkPoolType vmwNetworkPoolType) throws VCloudException {
        ObjectFactory ofFactory = new ObjectFactory();
        String vmwNetworkPoolUpdateUrl = this.getReference().getHref();
        String vmwNetworkPoolUpdateRequest = JAXBUtil.marshal(ofFactory.createVMWNetworkPool(vmwNetworkPoolType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmwNetworkPoolUpdateUrl);
        return new VMWNetworkPool(this.getVcloudClient(), (VMWNetworkPoolType)SdkUtil.put(this.getVcloudClient(), vmwNetworkPoolUpdateUrl, vmwNetworkPoolUpdateRequest, "application/vnd.vmware.admin.networkPool+xml", 200));
    }

    public Task delete() throws VCloudException {
        String vmwNetworkPoolUrl = this.getReference().getHref();
        return VMWNetworkPool.deleteVMWNetworkPool(this.getVcloudClient(), vmwNetworkPoolUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType vmwNetworkPoolRef) throws VCloudException {
        return VMWNetworkPool.deleteVMWNetworkPool(client, vmwNetworkPoolRef.getHref());
    }

    private static Task deleteVMWNetworkPool(VcloudClient client, String vmwNetworkPoolUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, vmwNetworkPoolUrl, 202));
    }

    public VendorServicesType getVMWVendorServices() throws VCloudException {
        String vendorServicesUrl = this.getReference().getHref() + "/vendorServices";
        return (VendorServicesType)SdkUtil.get(this.getVcloudClient(), vendorServicesUrl, 200);
    }
}

