/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ovf.CimUnsignedLong;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.api.rest.schema.ovf.vmware.CoresPerSocketType;
import com.vmware.vcloud.sdk.HardwareItem;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.math.BigInteger;
import javax.xml.bind.JAXBElement;

public class VirtualCpu
extends HardwareItem {
    VirtualCpu(RASDType item) {
        super(item);
    }

    public int getNoOfCpus() {
        return this.getItemResource().getVirtualQuantity().getValue().intValue();
    }

    public void setNoOfCpus(int cpuCount) {
        CimUnsignedLong cpu = new CimUnsignedLong();
        cpu.setValue(BigInteger.valueOf(cpuCount));
        this.getItemResource().setVirtualQuantity(cpu);
    }

    public int getCoresPerSocket() throws VCloudException {
        for (Object jaxbObject : this.getItemResource().getAny()) {
            if (!(((JAXBElement)jaxbObject).getValue() instanceof CoresPerSocketType)) continue;
            return (int)((CoresPerSocketType)((JAXBElement)jaxbObject).getValue()).getValue();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public void setCoresPerSocket(int coresPerSocket) {
        for (Object jaxbObject : this.getItemResource().getAny()) {
            if (!(((JAXBElement)jaxbObject).getValue() instanceof CoresPerSocketType)) continue;
            CoresPerSocketType coresPerSocketType = (CoresPerSocketType)((JAXBElement)jaxbObject).getValue();
            coresPerSocketType.setValue((long)coresPerSocket);
            ((JAXBElement)jaxbObject).setValue((Object)coresPerSocketType);
        }
    }
}

