/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.CustomizationSectionType;
import com.vmware.vcloud.api.rest.schema.FileType;
import com.vmware.vcloud.api.rest.schema.FilesListType;
import com.vmware.vcloud.api.rest.schema.GuestCustomizationSectionType;
import com.vmware.vcloud.api.rest.schema.LeaseSettingsSectionType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.NetworkConfigSectionType;
import com.vmware.vcloud.api.rest.schema.NetworkConnectionSectionType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ProductSectionListType;
import com.vmware.vcloud.api.rest.schema.RasdItemsListType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.api.rest.schema.RelocateParamsType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VAppTemplateChildrenType;
import com.vmware.vcloud.api.rest.schema.VAppTemplateType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.api.rest.schema.extension.VmVimInfoType;
import com.vmware.vcloud.api.rest.schema.ovf.EnvelopeType;
import com.vmware.vcloud.api.rest.schema.ovf.NetworkSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.ProductSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.api.rest.schema.ovf.SectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualHardwareSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualSystemCollectionType;
import com.vmware.vcloud.api.rest.schema.ovf.VirtualSystemType;
import com.vmware.vcloud.sdk.CatalogItem;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.VirtualCpu;
import com.vmware.vcloud.sdk.VirtualDisk;
import com.vmware.vcloud.sdk.VirtualMedia;
import com.vmware.vcloud.sdk.VirtualMemory;
import com.vmware.vcloud.sdk.VirtualNetworkCard;
import com.vmware.vcloud.sdk.constants.EntityType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VappTemplateStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VappTemplate
extends VcloudEntity<VAppTemplateType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private NetworkSectionType networkSection;
    private List<ProductSectionType> productSections;
    private List<VappTemplate> childrenvAppTemplates;
    private HashMap<String, FileType> uploadFileMap;
    private HashMap<String, FileType> uploadedFileMap;
    private NetworkConnectionSectionType networkConnectionSection;
    private NetworkConfigSectionType networkConfigSection;
    private LeaseSettingsSectionType leaseSettingsSection;
    private CustomizationSectionType customizationSection;
    private GuestCustomizationSectionType guestCustomizationSection;
    private ReferenceType vdcReference;
    private ReferenceType catalogItemReference;
    private ReferenceType parentVappTemplateReference;
    private ReferenceType storageProfileRef;
    private VmVimInfoType vmVimInfoType;
    private VirtualHardwareSectionType virtualHardwareSection;
    private VirtualCpu virtualCpu;
    private List<VirtualDisk> virtualDisks;
    private List<VirtualMedia> media;
    private VirtualMemory virtualMemory;
    private List<VirtualNetworkCard> networkCards;

    public VappTemplate(VcloudClient client, VAppTemplateType vAppTemplateType_v1_5) {
        super(client, vAppTemplateType_v1_5);
        this.sortVAppTemplateFiles_v1_5();
        this.sortOvfSectionAndReferences_v1_5();
    }

    public Boolean isVm() {
        return this.getReference().getType().equals("application/vnd.vmware.vcloud.vm+xml");
    }

    public List<VappTemplate> getChildren() {
        if (this.childrenvAppTemplates == null) {
            this.childrenvAppTemplates = new ArrayList<VappTemplate>();
            if (((VAppTemplateType)this.getResource()).getChildren() != null) {
                VAppTemplateChildrenType vAppTemplChildrenType = ((VAppTemplateType)this.getResource()).getChildren();
                List vAppTypeList = vAppTemplChildrenType.getVm();
                for (VAppTemplateType vAppTemplType : vAppTypeList) {
                    this.childrenvAppTemplates.add(new VappTemplate(this.getVcloudClient(), vAppTemplType));
                }
            }
        }
        return this.childrenvAppTemplates;
    }

    public static VappTemplate getVappTemplateByReference(VcloudClient client, ReferenceType vappTemplRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vappTemplRef.getHref());
        return new VappTemplate(client, (VAppTemplateType)VappTemplate.getResourceByReference(client, vappTemplRef));
    }

    public static VappTemplate getVappTemplateById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        if (vCloudId.contains(EntityType.VM.value())) {
            return new VappTemplate(client, (VAppTemplateType)VappTemplate.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.vm+xml"));
        }
        return new VappTemplate(client, (VAppTemplateType)VappTemplate.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.vAppTemplate+xml"));
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getVdcStorageProfileReference() throws VCloudException {
        if (this.storageProfileRef != null) {
            return this.storageProfileRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getCatalogItemReference() throws VCloudException {
        if (this.catalogItemReference != null) {
            return this.catalogItemReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getParentVappTemplateReference() throws VCloudException {
        if (this.parentVappTemplateReference != null) {
            return this.parentVappTemplateReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public VimObjectRefType getVMDatastoreVimRef() throws VCloudException {
        if (this.vmVimInfoType != null && this.vmVimInfoType.getDatastoreVimObjectRef() != null) {
            return this.vmVimInfoType.getDatastoreVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public VimObjectRefType getVMHostVimRef() throws VCloudException {
        if (this.vmVimInfoType != null && this.vmVimInfoType.getHostVimObjectRef() != null) {
            return this.vmVimInfoType.getHostVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public Integer getVMDiskChainLength() throws VCloudException {
        if (this.vmVimInfoType != null) {
            return this.vmVimInfoType.getVirtualDisksMaxChainLength();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public VimObjectRefType getVMVimRef() throws VCloudException {
        if (this.vmVimInfoType != null && this.vmVimInfoType.getVmVimObjectRef() != null) {
            return this.vmVimInfoType.getVmVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    private void sortOvfSectionAndReferences_v1_5() {
        this.productSections = new ArrayList<ProductSectionType>();
        List sections = ((VAppTemplateType)this.getResource()).getSection();
        for (JAXBElement sec : sections) {
            if (sec.getValue() instanceof NetworkConfigSectionType) {
                this.networkConfigSection = (NetworkConfigSectionType)sec.getValue();
            } else if (sec.getValue() instanceof NetworkSectionType) {
                this.networkSection = (NetworkSectionType)sec.getValue();
            } else if (sec.getValue() instanceof NetworkConnectionSectionType) {
                this.networkConnectionSection = (NetworkConnectionSectionType)sec.getValue();
            } else if (sec.getValue() instanceof LeaseSettingsSectionType) {
                this.leaseSettingsSection = (LeaseSettingsSectionType)sec.getValue();
            } else if (sec.getValue() instanceof CustomizationSectionType) {
                this.customizationSection = (CustomizationSectionType)sec.getValue();
            } else if (sec.getValue() instanceof GuestCustomizationSectionType) {
                this.guestCustomizationSection = (GuestCustomizationSectionType)sec.getValue();
            } else if (sec.getValue() instanceof ProductSectionType) {
                this.productSections.add((ProductSectionType)sec.getValue());
            } else if (sec.getValue() instanceof VirtualHardwareSectionType) {
                this.virtualHardwareSection = (VirtualHardwareSectionType)sec.getValue();
            }
            logger.info(((SectionType)sec.getValue()).getClass().getName());
        }
        for (LinkType vAppTemplateLink : ((VAppTemplateType)this.getResource()).getLink()) {
            if (vAppTemplateLink.getRel().equals("up") && vAppTemplateLink.getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) {
                this.parentVappTemplateReference = vAppTemplateLink;
                continue;
            }
            if (vAppTemplateLink.getRel().equals("catalogItem") && vAppTemplateLink.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml")) {
                this.catalogItemReference = vAppTemplateLink;
                continue;
            }
            if (vAppTemplateLink.getRel().equals("up") && vAppTemplateLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) {
                this.vdcReference = vAppTemplateLink;
                continue;
            }
            if (!vAppTemplateLink.getRel().equals("storageProfile") || !vAppTemplateLink.getType().equals("application/vnd.vmware.vcloud.vdcStorageProfile+xml")) continue;
            this.storageProfileRef = vAppTemplateLink;
        }
        block2: for (VCloudExtensionType vcloudExtension : ((VAppTemplateType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VmVimInfoType)) continue;
                this.vmVimInfoType = (VmVimInfoType)((JAXBElement)jaxbObject).getValue();
                continue block2;
            }
        }
    }

    public ReferenceType getOwner() throws VCloudException {
        return ((VAppTemplateType)this.getResource()).getOwner().getUser();
    }

    public VappTemplateStatus getVappTemplateStatus() {
        return VappTemplateStatus.fromValue(((VAppTemplateType)this.getResource()).getStatus());
    }

    public static EnvelopeType getOvf(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return VappTemplate.getOvf(client, vappTemplateRef.getHref() + "/ovf");
    }

    public EnvelopeType getOvf() throws VCloudException {
        return VappTemplate.getOvf(this.getVcloudClient(), this.getReference().getHref() + "/ovf");
    }

    public static EnvelopeType getOvf(VcloudClient client, String vAppTemplateOvfUrl) throws VCloudException {
        return (EnvelopeType)SdkUtil.get(client, vAppTemplateOvfUrl, 200);
    }

    private EnvelopeType downloadOvfEnvelope() throws VCloudException {
        for (LinkType link : ((VAppTemplateType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return (EnvelopeType)JAXBUtil.unmarshallResource(RestUtil.downloadFile(this.getVcloudClient(), link.getHref()));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public Task delete() throws VCloudException {
        String vAppTemplateUrl = this.getReference().getHref();
        return VappTemplate.deletevAppTemplate(this.getVcloudClient(), vAppTemplateUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType vAppTemplateRef) throws VCloudException {
        return VappTemplate.deletevAppTemplate(client, vAppTemplateRef.getHref());
    }

    private static Task deletevAppTemplate(VcloudClient client, String vAppTemplateUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, vAppTemplateUrl, 202));
    }

    public Task deleteVappTemplate() throws VCloudException {
        String vAppTemplateUrl = this.getReference().getHref();
        if (this.isPartOfCatalogItem()) {
            CatalogItem.delete(this.getVcloudClient(), this.getCatalogItemReference());
        }
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), vAppTemplateUrl, 202));
    }

    public static Task deleteVappTemplate(VcloudClient client, ReferenceType vAppTemplateRef) throws VCloudException {
        return VappTemplate.deleteVappTemplateWithCatalogItem(client, vAppTemplateRef);
    }

    private static Task deleteVappTemplateWithCatalogItem(VcloudClient client, ReferenceType vappTemplRef) throws VCloudException {
        VappTemplate vappTemplate = VappTemplate.getVappTemplateByReference(client, vappTemplRef);
        String vappTemplateUrl = vappTemplate.getReference().getHref();
        if (vappTemplate.isPartOfCatalogItem()) {
            CatalogItem.delete(client, vappTemplate.getCatalogItemReference());
        }
        return new Task(client, (TaskType)SdkUtil.delete(client, vappTemplateUrl, 202));
    }

    public void disableDownload() throws VCloudException {
        String vAppTemplateDisableDownloadURL = this.getReference().getHref() + "/action/disableDownload";
        SdkUtil.post(this.getVcloudClient(), vAppTemplateDisableDownloadURL, null, null, 204);
    }

    public static void disableDownload(VcloudClient client, ReferenceType vAppTemplateRef) throws VCloudException {
        String vAppTemplateEnableDownloadURL = vAppTemplateRef.getHref() + "/action/disableDownload";
        SdkUtil.post(client, vAppTemplateEnableDownloadURL, null, null, 204);
    }

    public Task enableDownload() throws VCloudException {
        String vAppTemplateEnableDownloadURL = this.getReference().getHref() + "/action/enableDownload";
        return VappTemplate.executeVappTemplateAction(this.getVcloudClient(), vAppTemplateEnableDownloadURL, null, null, 202);
    }

    public static Task relocate(VcloudClient client, ReferenceType vmRef, ReferenceType datastoreReference) throws VCloudException {
        RelocateParamsType paramsType = new RelocateParamsType();
        paramsType.setDatastore(datastoreReference);
        String request = JAXBUtil.marshal(new ObjectFactory().createRelocateParams(paramsType));
        return new Task(client, (TaskType)SdkUtil.post(client, vmRef.getHref() + "/action/relocate", request, "application/vnd.vmware.vcloud.relocateVmParams+xml", 202));
    }

    public Task relocate(ReferenceType datastoreReference) throws VCloudException {
        RelocateParamsType paramsType = new RelocateParamsType();
        paramsType.setDatastore(datastoreReference);
        String request = JAXBUtil.marshal(new ObjectFactory().createRelocateParams(paramsType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/relocate", request, "application/vnd.vmware.vcloud.relocateVmParams+xml", 202));
    }

    public Task consolidate() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/consolidate", null, null, 202));
    }

    public static Task consolidate(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vappTemplateVmRef.getHref() + "/action/consolidate", null, null, 202));
    }

    public static Task enableDownload(VcloudClient client, ReferenceType vAppTemplateRef) throws VCloudException {
        String vAppTemplateEnableDownloadURL = vAppTemplateRef.getHref() + "/action/enableDownload";
        return VappTemplate.executeVappTemplateAction(client, vAppTemplateEnableDownloadURL, null, null, 202);
    }

    private static Task executeVappTemplateAction(VcloudClient client, String vappTemplateActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, vappTemplateActionUrl, content, contentType, statusCode));
    }

    public Set<String> getUploadFileNames() throws VCloudException {
        if (!((VAppTemplateType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_NOT_UPLOADED_NO_FILES_MSG));
        }
        return this.uploadFileMap.keySet();
    }

    public Set<String> getUploadedFileNames() throws VCloudException {
        return this.uploadedFileMap.keySet();
    }

    public void uploadOVFFile(InputStream is, long size) throws VCloudException {
        if (((VAppTemplateType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_ALREADY_UPLOADED_MSG));
        }
        if (this.uploadFileMap.size() != 1) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.INVALID_NO_FILES_MSG) + " - " + this.uploadFileMap.size());
        }
        Set<String> keys = this.uploadFileMap.keySet();
        String fileName = keys.iterator().next();
        FileType file = this.uploadFileMap.get(fileName);
        RestUtil.uploadFile(this.getVcloudClient(), file, is, size, 0L, 0L);
    }

    public void uploadFile(String fileName, InputStream is, long size) throws VCloudException {
        if (!((VAppTemplateType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_NOT_UPLOADED_MSG));
        }
        if (this.uploadFileMap.isEmpty()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_FILES_TO_UPLOAD_MSG));
        }
        FileType file = this.uploadFileMap.get(fileName);
        if (file == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        RestUtil.uploadFile(this.getVcloudClient(), file, is, size, 0L, 0L);
    }

    public void uploadFile(String fileName, InputStream is, long startByte, long endByte) throws VCloudException {
        if (!((VAppTemplateType)this.getResource()).isOvfDescriptorUploaded().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OVF_DESCRIPTOR_NOT_UPLOADED_MSG));
        }
        if (this.uploadFileMap.isEmpty()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_FILES_TO_UPLOAD_MSG));
        }
        FileType file = this.uploadFileMap.get(fileName);
        if (file == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        RestUtil.uploadFile(this.getVcloudClient(), file, is, file.getSize(), startByte, endByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String downloadLocation, String fileName, InputStream inputStream) throws VCloudException {
        File file = new File(downloadLocation + "/" + fileName);
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
                inputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
    }

    public void downloadVappTemplate(String downloadLocation) throws VCloudException {
        Set<String> downloadFileNames = this.getDownloadFileNames().keySet();
        InputStream ovfInputStream = this.downloadOVFFile();
        this.writeToFile(downloadLocation, "descriptor.ovf", ovfInputStream);
        for (String fileName : downloadFileNames) {
            InputStream vmdkInputStream = this.downloadFile(fileName);
            this.writeToFile(downloadLocation, fileName, vmdkInputStream);
        }
    }

    public InputStream downloadOVFFile() throws VCloudException {
        for (LinkType link : ((VAppTemplateType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return RestUtil.downloadFile(this.getVcloudClient(), link.getHref());
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public String getOVFDownloadURL() throws VCloudException {
        for (LinkType link : ((VAppTemplateType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return link.getHref();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType> getDownloadFileNames() throws VCloudException {
        HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType> downloadFileMap = new HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType>();
        com.vmware.vcloud.api.rest.schema.ovf.ReferencesType fileReferences = this.downloadOvfEnvelope().getReferences();
        if (fileReferences != null) {
            List files = fileReferences.getFile();
            for (com.vmware.vcloud.api.rest.schema.ovf.FileType file : files) {
                if (downloadFileMap.containsKey(file.getHref())) continue;
                downloadFileMap.put(file.getHref(), file);
            }
        }
        return downloadFileMap;
    }

    public InputStream downloadFile(String fileName) throws VCloudException {
        for (LinkType link : ((VAppTemplateType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:default")) continue;
            return this.downloadFile(fileName, link.getHref());
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    private InputStream downloadFile(String fileName, String href) throws VCloudException {
        HashMap<String, com.vmware.vcloud.api.rest.schema.ovf.FileType> downloadFiles = this.getDownloadFileNames();
        if (!downloadFiles.containsKey(fileName)) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        return RestUtil.downloadFile(this.getVcloudClient(), href.replaceAll("descriptor.ovf", fileName));
    }

    public HashMap<String, FileType> monitorUpload() throws VCloudException {
        HashMap<String, FileType> filesStatusMap = new HashMap<String, FileType>();
        VappTemplate vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), this.getReference());
        if (((VAppTemplateType)vappTemplate.getResource()).getFiles() != null) {
            FilesListType filesType = ((VAppTemplateType)vappTemplate.getResource()).getFiles();
            List files = filesType.getFile();
            for (FileType file : files) {
                filesStatusMap.put(file.getName(), file);
            }
        }
        return filesStatusMap;
    }

    public Task updateVappTemplate(VAppTemplateType vappTemplateType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String vappTemplateUpdateUrl = this.getReference().getHref();
        String vappTemplateRequestXmlString = JAXBUtil.marshal(of.createVAppTemplate(vappTemplateType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vappTemplateUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), vappTemplateUpdateUrl, vappTemplateRequestXmlString, "application/vnd.vmware.vcloud.vAppTemplate+xml", 202));
    }

    public List<ProductSectionType> getProductSections() throws VCloudException {
        return this.productSections;
    }

    public static List<ProductSectionType> getProductSections(VcloudClient client, ReferenceType vappRef) throws VCloudException {
        ProductSectionListType productSectionListType = (ProductSectionListType)SdkUtil.get(client, vappRef.getHref() + "/productSections/", 200);
        return productSectionListType.getProductSection();
    }

    public NetworkSectionType getNetworkSection() {
        return this.networkSection;
    }

    public static NetworkSectionType getNetworkSection(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return (NetworkSectionType)SdkUtil.get(client, vappTemplateRef.getHref() + "/networkSection/", 200);
    }

    public NetworkConfigSectionType getNetworkConfigSection() {
        return this.networkConfigSection;
    }

    public static NetworkConfigSectionType getNetworkConfigSection(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return (NetworkConfigSectionType)SdkUtil.get(client, vappTemplateRef.getHref() + "/networkConfigSection/", 200);
    }

    public LeaseSettingsSectionType getLeaseSettingsSection() {
        return this.leaseSettingsSection;
    }

    public static LeaseSettingsSectionType getLeaseSettingsSection(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return (LeaseSettingsSectionType)SdkUtil.get(client, vappTemplateRef.getHref() + "/leaseSettingsSection/", 200);
    }

    public NetworkConnectionSectionType getNetworkConnectionSection() {
        return this.networkConnectionSection;
    }

    public static NetworkConnectionSectionType getNetworkConnectionSection(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return (NetworkConnectionSectionType)SdkUtil.get(client, vappTemplateRef.getHref() + "/networkConnectionSection/", 200);
    }

    public GuestCustomizationSectionType getGuestCustomizationSection() {
        return this.guestCustomizationSection;
    }

    public static GuestCustomizationSectionType getGuestCustomizationSection(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return (GuestCustomizationSectionType)SdkUtil.get(client, vappTemplateRef.getHref() + "/guestCustomizationSection/", 200);
    }

    public CustomizationSectionType getCustomizationSection() {
        return this.customizationSection;
    }

    public static CustomizationSectionType getCustomizationSection(VcloudClient client, ReferenceType vappTemplateRef) throws VCloudException {
        return (CustomizationSectionType)SdkUtil.get(client, vappTemplateRef.getHref() + "/customizationSection/", 200);
    }

    public Task updateSection(SectionType sectionType) throws VCloudException {
        String sectionUrl = this.getReference().getHref();
        String sectionContentType = null;
        String sectionRequestString = null;
        ObjectFactory vCloudObjectFactory = new ObjectFactory();
        if (sectionType instanceof LeaseSettingsSectionType) {
            JAXBElement section = vCloudObjectFactory.createLeaseSettingsSection((LeaseSettingsSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/leaseSettingsSection/";
            sectionContentType = "application/vnd.vmware.vcloud.leaseSettingsSection+xml";
        } else if (sectionType instanceof GuestCustomizationSectionType) {
            JAXBElement section = vCloudObjectFactory.createGuestCustomizationSection((GuestCustomizationSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/guestCustomizationSection/";
            sectionContentType = "application/vnd.vmware.vcloud.guestCustomizationSection+xml";
        } else if (sectionType instanceof CustomizationSectionType) {
            JAXBElement section = vCloudObjectFactory.createCustomizationSection((CustomizationSectionType)sectionType);
            sectionRequestString = JAXBUtil.marshal(section);
            sectionUrl = sectionUrl + "/customizationSection/";
            sectionContentType = "application/vnd.vmware.vcloud.customizationSection+xml";
        } else {
            logger.info(sectionType.getClass().getName() + " - " + SdkUtil.getI18nString(SdkMessage.NOT_VALID_SECTION_MSG));
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_VALID_SECTION_MSG));
        }
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), sectionUrl, sectionRequestString, sectionContentType, 202));
    }

    private void sortVAppTemplateFiles_v1_5() {
        this.uploadFileMap = new HashMap();
        this.uploadedFileMap = new HashMap();
        if (this.getResource() instanceof VAppTemplateType) {
            FilesListType fileList = ((VAppTemplateType)this.getResource()).getFiles();
            if (fileList == null) {
                return;
            }
            List files = fileList.getFile();
            for (FileType file : files) {
                String fileName = file.getName();
                if (file.getSize().compareTo(file.getBytesTransferred()) == 0) {
                    this.uploadedFileMap.put(fileName, file);
                    continue;
                }
                this.uploadFileMap.put(fileName, file);
            }
        }
    }

    private static BigInteger getVmSize(VirtualSystemType virtualSystemType) throws VCloudException {
        BigInteger vAppTemplateVmSize = BigInteger.ZERO;
        for (JAXBElement section : virtualSystemType.getSection()) {
            if (!(section.getValue() instanceof VirtualHardwareSectionType)) continue;
            VirtualHardwareSectionType virtualHardwareSection = (VirtualHardwareSectionType)section.getValue();
            List items = virtualHardwareSection.getItem();
            for (RASDType item : items) {
                VirtualDisk disk;
                if (!item.getResourceType().getValue().equals("17") || (disk = new VirtualDisk(item)).getHardDiskSize() == null) continue;
                vAppTemplateVmSize = vAppTemplateVmSize.add(disk.getHardDiskSize());
            }
        }
        return vAppTemplateVmSize;
    }

    public BigInteger getVappTemplateSize() throws VCloudException {
        BigInteger vAppTemplateSize = BigInteger.ZERO;
        EnvelopeType ovf = null;
        if (this.getReference().getType().equals("application/vnd.vmware.vcloud.vm+xml")) {
            VappTemplate vappTemplate = VappTemplate.getVappTemplateByReference(this.getVcloudClient(), this.getParentVappTemplateReference());
            ovf = vappTemplate.getOvf();
            if (ovf.getContent() != null) {
                if (ovf.getContent().getValue() instanceof VirtualSystemCollectionType) {
                    VirtualSystemCollectionType virtualSystemCollection = (VirtualSystemCollectionType)ovf.getContent().getValue();
                    for (JAXBElement virtualSystems : virtualSystemCollection.getContent()) {
                        VirtualSystemType virtualSystem = (VirtualSystemType)virtualSystems.getValue();
                        if (!virtualSystem.getId().equals(this.getReference().getName())) continue;
                        vAppTemplateSize = vAppTemplateSize.add(VappTemplate.getVmSize(virtualSystem));
                    }
                } else if (ovf.getContent().getValue() instanceof VirtualSystemType) {
                    vAppTemplateSize = vAppTemplateSize.add(VappTemplate.getVmSize((VirtualSystemType)ovf.getContent().getValue()));
                }
            }
        } else {
            ovf = this.getOvf();
            if (ovf.getContent() != null) {
                if (ovf.getContent().getValue() instanceof VirtualSystemCollectionType) {
                    VirtualSystemCollectionType virtualSystemCollection = (VirtualSystemCollectionType)ovf.getContent().getValue();
                    for (JAXBElement virtualSystems : virtualSystemCollection.getContent()) {
                        vAppTemplateSize = vAppTemplateSize.add(VappTemplate.getVmSize((VirtualSystemType)virtualSystems.getValue()));
                    }
                } else if (ovf.getContent().getValue() instanceof VirtualSystemType) {
                    vAppTemplateSize = vAppTemplateSize.add(VappTemplate.getVmSize((VirtualSystemType)ovf.getContent().getValue()));
                }
            }
        }
        return vAppTemplateSize;
    }

    public Collection<ReferenceType> getShadowVmReferences() throws VCloudException {
        if (!this.isVm().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.OPERATION_NOT_SUPPORTED));
        }
        String shadowVmsUrl = this.getReference().getHref() + "/shadowVms";
        ReferencesType shadowVmReferencesType = (ReferencesType)SdkUtil.get(this.getVcloudClient(), shadowVmsUrl, 200);
        ArrayList<ReferenceType> shadowVmReferences = new ArrayList<ReferenceType>();
        for (JAXBElement shadowVmReferenceType : shadowVmReferencesType.getReference()) {
            shadowVmReferences.add((ReferenceType)shadowVmReferenceType.getValue());
        }
        return shadowVmReferences;
    }

    public Task updateGoldMaster(Boolean goldMasterFlag) throws VCloudException {
        ((VAppTemplateType)this.getResource()).setGoldMaster(goldMasterFlag);
        return this.updateVappTemplate((VAppTemplateType)this.getResource());
    }

    public boolean isPartOfCatalogItem() throws VCloudException {
        return this.catalogItemReference != null;
    }

    public InputStream downloadLosslessOVF() throws VCloudException {
        for (LinkType link : ((VAppTemplateType)this.getResource()).getLink()) {
            if (!link.getRel().equals("download:identity")) continue;
            return RestUtil.downloadFile(this.getVcloudClient(), link.getHref());
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_DOWNLOAD_LINK_MSG));
    }

    public VirtualHardwareSectionType getVirtualHardwareSection() throws VCloudException {
        if (this.virtualHardwareSection == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return this.virtualHardwareSection;
    }

    public static VirtualHardwareSectionType getVirtualHardwareSection(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        return (VirtualHardwareSectionType)SdkUtil.get(client, vappTemplateVmRef.getHref() + "/virtualHardwareSection/", 200);
    }

    public VirtualCpu getCpu() throws VCloudException {
        List items;
        if (this.virtualCpu == null && this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
            for (RASDType item : items) {
                String itemResourceType = item.getResourceType().getValue();
                if (!itemResourceType.equals("3")) continue;
                this.virtualCpu = new VirtualCpu(item);
            }
        }
        if (this.virtualCpu != null) {
            return this.virtualCpu;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_VIRTUAL_CPU_MSG));
    }

    public static VirtualCpu getCpu(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        String url = vappTemplateVmRef.getHref() + "/virtualHardwareSection/cpu";
        VirtualCpu virtualCpu = VappTemplate.getCpuByUrl(client, url);
        return virtualCpu;
    }

    private static VirtualCpu getCpuByUrl(VcloudClient client, String url) throws VCloudException {
        return new VirtualCpu((RASDType)SdkUtil.get(client, url, 200));
    }

    public List<VirtualDisk> getDisks() throws VCloudException {
        if (this.virtualDisks == null) {
            List items;
            this.virtualDisks = new ArrayList<VirtualDisk>();
            if (this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
                for (RASDType item : items) {
                    String itemResourceType = item.getResourceType().getValue();
                    if (!itemResourceType.equals("17") && !itemResourceType.equals("6") && !itemResourceType.equals("5")) continue;
                    this.virtualDisks.add(new VirtualDisk(item));
                }
            }
        }
        return this.virtualDisks;
    }

    public static List<VirtualDisk> getDisks(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        String url = vappTemplateVmRef.getHref() + "/virtualHardwareSection/disks";
        return VappTemplate.getDisksByUrl(client, url);
    }

    private static List<VirtualDisk> getDisksByUrl(VcloudClient client, String url) throws VCloudException {
        ArrayList<VirtualDisk> hardwareItems = new ArrayList<VirtualDisk>();
        RasdItemsListType rasdItems = (RasdItemsListType)SdkUtil.get(client, url, 200);
        if (rasdItems != null) {
            for (RASDType item : rasdItems.getItem()) {
                hardwareItems.add(new VirtualDisk(item));
            }
        }
        return hardwareItems;
    }

    public List<VirtualMedia> getMedia() throws VCloudException {
        if (this.media == null) {
            List items;
            this.media = new ArrayList<VirtualMedia>();
            if (this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
                for (RASDType item : items) {
                    String itemResourceType = item.getResourceType().getValue();
                    if (!itemResourceType.equals("14") && !itemResourceType.equals("15") && !itemResourceType.equals("5")) continue;
                    this.media.add(new VirtualMedia(item));
                }
            }
        }
        return this.media;
    }

    public static List<VirtualMedia> getMedia(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        String url = vappTemplateVmRef.getHref() + "/virtualHardwareSection/media";
        return VappTemplate.getMediaByUrl(client, url);
    }

    private static List<VirtualMedia> getMediaByUrl(VcloudClient client, String url) throws VCloudException {
        ArrayList<VirtualMedia> hardwareItems = new ArrayList<VirtualMedia>();
        RasdItemsListType rasdItems = (RasdItemsListType)SdkUtil.get(client, url, 200);
        if (rasdItems != null) {
            for (RASDType item : rasdItems.getItem()) {
                hardwareItems.add(new VirtualMedia(item));
            }
        }
        return hardwareItems;
    }

    public VirtualMemory getMemory() throws VCloudException {
        List items;
        if (this.virtualMemory == null && this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
            for (RASDType item : items) {
                String itemResourceType = item.getResourceType().getValue();
                if (!itemResourceType.equals("4")) continue;
                this.virtualMemory = new VirtualMemory(item);
            }
        }
        if (this.virtualMemory != null) {
            return this.virtualMemory;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_VIRTUAL_MEMORY_MSG));
    }

    public static VirtualMemory getMemory(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        String url = vappTemplateVmRef.getHref() + "/virtualHardwareSection/memory";
        VirtualMemory virtualMemory = VappTemplate.getMemoryByUrl(client, url);
        return virtualMemory;
    }

    private static VirtualMemory getMemoryByUrl(VcloudClient client, String url) throws VCloudException {
        return new VirtualMemory((RASDType)SdkUtil.get(client, url, 200));
    }

    public List<VirtualNetworkCard> getNetworkCards() throws VCloudException {
        if (this.networkCards == null) {
            List items;
            this.networkCards = new ArrayList<VirtualNetworkCard>();
            if (this.virtualHardwareSection != null && (items = this.virtualHardwareSection.getItem()) != null) {
                for (RASDType item : items) {
                    String itemResourceType = item.getResourceType().getValue();
                    if (!itemResourceType.equals("10")) continue;
                    this.networkCards.add(new VirtualNetworkCard(item));
                }
            }
        }
        return this.networkCards;
    }

    public static List<VirtualNetworkCard> getNetworkCards(VcloudClient client, ReferenceType vappTemplateVmRef) throws VCloudException {
        String url = vappTemplateVmRef.getHref() + "/virtualHardwareSection/networkCards";
        return VappTemplate.getNetworkCardsByUrl(client, url);
    }

    private static List<VirtualNetworkCard> getNetworkCardsByUrl(VcloudClient client, String url) throws VCloudException {
        ArrayList<VirtualNetworkCard> hardwareItems = new ArrayList<VirtualNetworkCard>();
        RasdItemsListType rasdItems = (RasdItemsListType)SdkUtil.get(client, url, 200);
        if (rasdItems != null) {
            for (RASDType item : rasdItems.getItem()) {
                hardwareItems.add(new VirtualNetworkCard(item));
            }
        }
        return hardwareItems;
    }
}

