/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.DiskType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OwnerType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VmsType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.BusSubType;
import com.vmware.vcloud.sdk.constants.BusType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Disk
extends VcloudEntity<DiskType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType vdcReference;

    Disk(VcloudClient client, DiskType diskType) {
        super(client, diskType);
        this.sortDiskFilesAndReferences();
    }

    public static Disk getDiskByReference(VcloudClient client, ReferenceType diskRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + diskRef.getHref());
        return new Disk(client, (DiskType)Disk.getResourceByReference(client, diskRef));
    }

    public static Disk getDiskById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Disk(client, (DiskType)Disk.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.disk+xml"));
    }

    public Task updateDisk(String name, String description, ReferenceType storageProfileRef) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String diskUpdateUrl = this.getReference().getHref();
        if (name != null) {
            ((DiskType)this.getResource()).setName(name);
        }
        if (description != null) {
            ((DiskType)this.getResource()).setDescription(description);
        }
        if (storageProfileRef != null) {
            ((DiskType)this.getResource()).setStorageProfile(storageProfileRef);
        }
        String diskRequestXmlString = JAXBUtil.marshal(of.createDisk((DiskType)this.getResource()));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + diskUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), diskUpdateUrl, diskRequestXmlString, "application/vnd.vmware.vcloud.disk+xml", 202));
    }

    public Task delete() throws VCloudException {
        String diskUrl = this.getReference().getHref();
        return Disk.deleteDisk(this.getVcloudClient(), diskUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType diskRef) throws VCloudException {
        return Disk.deleteDisk(client, diskRef.getHref());
    }

    private static Task deleteDisk(VcloudClient client, String DiskUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, DiskUrl, 202));
    }

    private void sortDiskFilesAndReferences() {
        for (LinkType diskLink : ((DiskType)this.getResource()).getLink()) {
            if (!diskLink.getRel().equals("up") || !diskLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) continue;
            this.vdcReference = diskLink;
        }
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getOwner() throws VCloudException {
        return ((DiskType)this.getResource()).getOwner().getUser();
    }

    public BusType getBus() {
        return BusType.fromValue(((DiskType)this.getResource()).getBusType());
    }

    public BusSubType getBusSub() {
        return BusSubType.fromValue(((DiskType)this.getResource()).getBusSubType());
    }

    public static void changeOwner(VcloudClient client, ReferenceType diskRef, ReferenceType userReference) throws VCloudException {
        String url = diskRef.getHref() + "/owner";
        Disk.changeOwner(url, userReference, client);
    }

    public void changeOwner(ReferenceType userReference) throws VCloudException {
        String url = this.getReference().getHref() + "/owner";
        Disk.changeOwner(url, userReference, this.getVcloudClient());
    }

    private static void changeOwner(String url, ReferenceType userReference, VcloudClient client) throws VCloudException {
        String requestXML = null;
        ObjectFactory objectFactory = new ObjectFactory();
        OwnerType ownerType = new OwnerType();
        ownerType.setUser(userReference);
        JAXBElement changeOwnerParams = objectFactory.createOwner(ownerType);
        requestXML = JAXBUtil.marshal(changeOwnerParams);
        SdkUtil.put(client, url, requestXML, "application/vnd.vmware.vcloud.owner+xml", 204);
    }

    public List<ReferenceType> getAttachedVms() throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + this.getReference().getHref() + "/attachedVms");
        VmsType vmsType = (VmsType)SdkUtil.get(this.getVcloudClient(), this.getReference().getHref() + "/attachedVms", 200);
        ArrayList<ReferenceType> vmRefs = new ArrayList<ReferenceType>();
        for (ReferenceType vmRef : vmsType.getVmReference()) {
            vmRefs.add(vmRef);
        }
        return vmRefs;
    }
}

