/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AllocatedIpAddressType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;

public class AllocatedIpAddress
extends VcloudResource<AllocatedIpAddressType> {
    private ReferenceType vappRef;
    private ReferenceType vmRef;
    private ReferenceType orgVdcNetworkRef;
    private ReferenceType orgRef;

    public AllocatedIpAddress(VcloudClient client, AllocatedIpAddressType resourceType) {
        super(client, resourceType);
        this.sortRefs();
    }

    private void sortRefs() {
        for (LinkType allocatedIpAddressLink : ((AllocatedIpAddressType)this.getResource()).getLink()) {
            if (allocatedIpAddressLink.getRel().equals("up") && allocatedIpAddressLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) {
                this.orgRef = allocatedIpAddressLink;
            }
            if (allocatedIpAddressLink.getRel().equals("up") && allocatedIpAddressLink.getType().equals("application/vnd.vmware.vcloud.orgVdcNetwork+xml")) {
                this.orgVdcNetworkRef = allocatedIpAddressLink;
            }
            if (allocatedIpAddressLink.getRel().equals("down") && allocatedIpAddressLink.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) {
                this.vappRef = allocatedIpAddressLink;
            }
            if (!allocatedIpAddressLink.getRel().equals("down") || !allocatedIpAddressLink.getType().equals("application/vnd.vmware.vcloud.vm+xml")) continue;
            this.vmRef = allocatedIpAddressLink;
        }
    }

    public ReferenceType getOrgVdcNetworkReference() throws VCloudException {
        if (this.orgVdcNetworkRef == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        return this.orgVdcNetworkRef;
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgRef == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        return this.orgRef;
    }

    public ReferenceType getVappReference() throws VCloudException {
        if (this.vappRef == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        return this.vappRef;
    }

    public ReferenceType getVMReference() throws VCloudException {
        if (this.vmRef == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        return this.vmRef;
    }
}

