/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpEncodingException;
import com.ireasoning.protocol.snmp.h;
import java.math.BigInteger;

public class SnmpCounter64
implements SnmpDataType {
    boolean a = false;
    public static final SnmpCounter64 MAX_VALUE = new SnmpCounter64();
    BigInteger b;

    public SnmpCounter64() {
        this.b = BigInteger.valueOf(0L);
        this.b.clearBit(65);
    }

    public SnmpCounter64(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative number");
        }
        this.b = BigInteger.valueOf(l2 & Long.MAX_VALUE);
        this.b.clearBit(65);
    }

    public SnmpCounter64(BigInteger bigInteger) {
        this.b = bigInteger;
        if (this.b.compareTo(BigInteger.valueOf(0L)) < 0) {
            throw new IllegalArgumentException("Negative number: " + bigInteger);
        }
        if (this.b.compareTo(SnmpCounter64.MAX_VALUE.b) > 0) {
            throw new IllegalArgumentException("Too big: " + bigInteger);
        }
        this.b.clearBit(65);
    }

    public SnmpCounter64(String string) {
        this(new BigInteger(string));
    }

    public SnmpCounter64(SnmpCounter64 snmpCounter64) {
        this.b = new BigInteger(snmpCounter64.b.toByteArray());
        this.b.clearBit(65);
    }

    public BigInteger getValue() {
        return this.b;
    }

    public void inc(long l2) {
        if (this.a) {
            throw new UnsupportedOperationException("This method is not supported for SnmpCounter64.MAX_VALUE");
        }
        BigInteger bigInteger = BigInteger.valueOf(l2 & Long.MAX_VALUE);
        this.b = this.b.add(bigInteger);
        if (this.b.compareTo(SnmpCounter64.MAX_VALUE.b) > 0) {
            this.b = BigInteger.ZERO;
        }
        this.b.clearBit(65);
    }

    public void inc() {
        if (this.a) {
            throw new UnsupportedOperationException("This method is not supported for SnmpCounter64.MAX_VALUE");
        }
        this.b = this.b.add(BigInteger.ONE);
        if (this.b.compareTo(SnmpCounter64.MAX_VALUE.b) > 0) {
            this.b = BigInteger.ZERO;
        }
        this.b.clearBit(65);
    }

    public void setValue(long l2) {
        if (this.a) {
            throw new UnsupportedOperationException("This method is not supported for SnmpCounter64.MAX_VALUE");
        }
        this.b = BigInteger.valueOf(l2 & Long.MAX_VALUE);
        this.b.clearBit(65);
    }

    public void setValue(BigInteger bigInteger) {
        if (this.a) {
            throw new UnsupportedOperationException("This method is not supported for SnmpCounter64.MAX_VALUE");
        }
        this.b = new BigInteger(bigInteger.toByteArray());
        this.b.clearBit(65);
    }

    public String toString() {
        return "" + this.getValue();
    }

    public int getType() {
        return 70;
    }

    public String getTypeString() {
        return "Counter64";
    }

    public SnmpDataType copy() {
        return new SnmpCounter64(this);
    }

    public int encode(h h2) throws SnmpEncodingException {
        return h2.a(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof SnmpCounter64)) {
            return false;
        }
        return this.b.equals(this.b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    static {
        SnmpCounter64.MAX_VALUE.b = new BigInteger("18446744073709551615");
        SnmpCounter64.MAX_VALUE.a = true;
    }
}

