/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.core.jmx;

import com.ireasoning.core.jmx.AdaptorServer;
import com.ireasoning.core.jmx.AdaptorServerMBean;
import com.ireasoning.core.jmx.c;
import com.ireasoning.util.Logger;
import com.ireasoning.util.config.ConfigFileManager;
import com.ireasoning.util.config.LoggerConfigManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class BaseAgent {
    protected MBeanServer _mbeanServer = null;
    boolean a = false;

    public BaseAgent() {
        this.a(null);
    }

    public BaseAgent(MBeanServer mBeanServer) {
        this.a(mBeanServer);
    }

    private void a(MBeanServer mBeanServer) {
        boolean bl;
        boolean bl2 = bl = System.getProperty("ibm.websphere.internalClassAccessMode") != null;
        if (bl) {
            ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
            if (arrayList.size() > 0) {
                Logger.info("Websphere. Use internal MBeanServer.");
                this._mbeanServer = arrayList.get(0);
            }
        } else {
            if (mBeanServer == null) {
                mBeanServer = c.getInstance().getMBeanServer();
            }
            if (mBeanServer == null) {
                Logger.info("Start MBeanServer.");
                String string = System.getProperty("useInternalMBeanServer");
                if (string != null) {
                    ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
                    if (arrayList.size() > 0) {
                        Logger.info("Use internal MBeanServer.");
                        this._mbeanServer = arrayList.get(0);
                    } else {
                        Logger.warn("Internal MBeanServer not found.");
                        this._mbeanServer = MBeanServerFactory.createMBeanServer();
                    }
                } else {
                    this._mbeanServer = MBeanServerFactory.createMBeanServer();
                }
            } else {
                this._mbeanServer = mBeanServer;
            }
        }
        c.getInstance().setMBeanServer(this._mbeanServer);
        this.registerHelperMBeans();
    }

    protected void registerHelperMBeans() {
        if (this.a) {
            return;
        }
        try {
            Object object;
            c c2 = c.getInstance();
            if (!c2.isRegistered(ConfigFileManager.OBJECT_NAME)) {
                Logger.info("Start ConfigFileManager MBean.");
                object = new ConfigFileManager();
                c2.registerMBean(object, ConfigFileManager.OBJECT_NAME);
            }
            if (!c2.isRegistered(LoggerConfigManager.OBJECT_NAME)) {
                Logger.info("Start LoggerConfigManager MBean.");
                object = new LoggerConfigManager();
                c2.registerMBean(object, LoggerConfigManager.OBJECT_NAME);
            }
            this.a = true;
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    protected void unregisterHelperMBeans() {
        try {
            c c2 = c.getInstance();
            if (c2.isRegistered(ConfigFileManager.OBJECT_NAME)) {
                Logger.info("Unregister config MBean");
                c2.unregisterMBean(ConfigFileManager.OBJECT_NAME);
            }
            if (c2.isRegistered(LoggerConfigManager.OBJECT_NAME)) {
                Logger.info("Unregister logger MBean");
                c2.unregisterMBean(LoggerConfigManager.OBJECT_NAME);
                this.a = false;
            }
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
    }

    protected void startAdaptorServer(AdaptorServerMBean adaptorServerMBean, String string, int n2) throws Exception {
        this.startAdaptorServer(adaptorServerMBean, string, n2, null);
    }

    protected void startAdaptorServer(AdaptorServerMBean adaptorServerMBean, String string, int n2, InetAddress inetAddress) throws Exception {
        try {
            InetAddress inetAddress2 = inetAddress;
            if (inetAddress == null) {
                try {
                    inetAddress2 = InetAddress.getByName(null);
                }
                catch (UnknownHostException unknownHostException) {
                    Logger.error("Unknow local host", unknownHostException);
                }
            }
            ObjectName objectName = new ObjectName(AdaptorServer.getObjectName(string, inetAddress2, n2));
            Logger.info("Start AdaptorServer, ObjectName [" + objectName + "]");
            c c2 = c.getInstance();
            c2.registerMBean(adaptorServerMBean, objectName);
            Attribute attribute = new Attribute("Port", new Integer(n2));
            c2.setAttribute(objectName, attribute);
            attribute = new Attribute("IpAddress", inetAddress);
            c2.setAttribute(objectName, attribute);
            c2.invoke(objectName, "startService", null, null);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException.getTargetException();
        }
    }

    protected void stopAdaptorServer(String string, int n2) throws Exception {
        this.stopAdaptorServer(string, n2, null);
    }

    protected void stopAdaptorServer(String string, int n2, InetAddress inetAddress) throws Exception {
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress == null) {
            try {
                inetAddress2 = InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                Logger.error("Unknow local host", unknownHostException);
            }
        }
        ObjectName objectName = new ObjectName(AdaptorServer.getObjectName(string, inetAddress2, n2));
        Logger.info("Stop AdaptorServer, ObjectName [" + objectName + "]");
        c c2 = c.getInstance();
        if (c2.isRegistered(objectName)) {
            try {
                c2.invoke(objectName, "stopService", null, null);
            }
            catch (MBeanException mBeanException) {
                throw mBeanException.getTargetException();
            }
            c2.unregisterMBean(objectName);
        }
    }

    public MBeanServer getMBeanServer() throws Exception {
        return this._mbeanServer;
    }
}

