/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.sblim.wbem.http.AuthInfo;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.Challenge;
import org.sblim.wbem.http.HttpClientMethod;
import org.sblim.wbem.http.HttpClientPool;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpParseException;
import org.sblim.wbem.http.HttpSocketFactory;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.http.io.BoundedInputStream;
import org.sblim.wbem.http.io.ChunkedInputStream;
import org.sblim.wbem.http.io.KeepAliveInputStream;
import org.sblim.wbem.http.io.PersistentInputStream;
import org.sblim.wbem.util.SessionProperties;

public class HttpClient
implements HandshakeCompletedListener {
    private static final String CLASSNAME = "org.sblim.wbem.http.HttpClient";
    private static String iEncoding;
    private boolean iConnected = false;
    private HttpClientPool iHttpClientPool = new HttpClientPool();
    private AuthorizationHandler iAuth_handler;
    private Logger iLogger = SessionProperties.getGlobalProperties().getLogger();
    private SSLSession iSession;
    private InputStream iIStream;
    private boolean iUseHttp11 = true;
    private boolean iKeepAlive = true;
    private HttpClientMethod iMethod;
    private OutputStream iOStream;
    private AuthInfo iPrevAuthInfo;
    private AuthInfo iPrevProxy;
    private HttpHeader iRequestHeaders = new HttpHeader();
    private String iRequestMethod = "POST";
    private boolean iReset = true;
    private HttpClientMethod iResponse;
    private HttpHeader iResponseHeaders = new HttpHeader();
    private InputStream iServerInput;
    private ByteArrayOutputStream iServerOutput;
    private Socket iSocket;
    private URI iUrl;
    static /* synthetic */ Class class$javax$net$ssl$SSLSocket;

    public static String convertToHexString(byte[] digest) {
        char[] hexDigit = "0123456789abcdef".toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(hexDigit[b >> 4 & 0xF]);
            buf.append(hexDigit[b & 0xF]);
        }
        return buf.toString();
    }

    public static HttpClient getClient(URI url, HttpClientPool clientPool, AuthorizationHandler auth_handler) {
        return clientPool.retrieveAvailableConnectionFromPool(url, auth_handler);
    }

    protected static String dequote(String str) {
        int len = str.length();
        if (len > 1 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
            return str.substring(1, len - 1);
        }
        return str;
    }

    protected static void handleRsp(String authInfo, AuthInfo prevAuthInfo) throws IOException {
        if (authInfo != null) {
            HttpHeader params = HttpHeader.parse(authInfo);
            String nonce = params.getField("nextnonce");
            if (nonce != null) {
                prevAuthInfo.setNonce(nonce);
                prevAuthInfo.setNc(0L);
            } else {
                nonce = prevAuthInfo.getNonce();
            }
            String qop = params.getField("qop");
            if (qop != null) {
                if (!"auth".equalsIgnoreCase(qop) && !"auth-int".equalsIgnoreCase(qop)) {
                    throw new IOException("Authentication Digest with integrity check not supported");
                }
                String rspauthStr = HttpClient.dequote(params.getField("rspauth"));
                if (rspauthStr != null) {
                    byte[] rspauth = HttpClient.parseHex(rspauthStr);
                    String cnonce = HttpClient.dequote(params.getField("cnonce"));
                    if (cnonce != null && !cnonce.equals(prevAuthInfo.getCnonce())) {
                        throw new IOException("Digest authentication: Invalid nonce counter");
                    }
                    String ncStr = params.getField("nc");
                    if (ncStr != null) {
                        try {
                            long nc = Long.parseLong(ncStr, 16);
                            if (nc != prevAuthInfo.getNc()) {
                                throw new IOException();
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("Digest authentication: Invalid nonce counter");
                        }
                    }
                    try {
                        MessageDigest md5 = MessageDigest.getInstance("MD5");
                        md5.reset();
                        byte[] bytes = prevAuthInfo.getA1().getBytes("ASCII");
                        md5.update(bytes);
                        String HA1 = HttpClient.convertToHexString(md5.digest());
                        if ("MD5-sess".equalsIgnoreCase(params.getField("algorithm"))) {
                            md5.reset();
                            md5.update((HA1 + ":" + nonce + ":" + cnonce).getBytes("ASCII"));
                            HA1 = HttpClient.convertToHexString(md5.digest());
                        }
                        String HA2 = ":" + prevAuthInfo.getURI();
                        if ("auth-int".equalsIgnoreCase(qop)) {
                            md5.reset();
                            md5.update(new byte[0]);
                            HA2 = HA2 + ":" + HttpClient.convertToHexString(md5.digest());
                        }
                        md5.reset();
                        md5.update(HA2.getBytes("ASCII"));
                        HA2 = HttpClient.convertToHexString(md5.digest());
                        md5.reset();
                        md5.update((HA1 + ":" + nonce + ":" + ncStr + ":" + cnonce + ":" + qop + ":" + HA2).getBytes("ASCII"));
                        String hsh = HttpClient.convertToHexString(md5.digest());
                        byte[] hash = HttpClient.parseHex(hsh);
                        if (!Arrays.equals(hash, rspauth)) {
                            throw new IOException("Digest Authentication failed!");
                        }
                    }
                    catch (NoSuchAlgorithmException e1) {
                        throw new IOException("Unable to validate Authentication response: NoSuchAlgorithmException");
                    }
                }
            }
        }
    }

    protected static byte[] parseHex(String hex) {
        byte[] value = new byte[hex.length() >> 1];
        int n = 0;
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)(0xFF & Integer.parseInt(hex.substring(n, n + 1), 16));
            n += 2;
        }
        return value;
    }

    private static boolean isASCIISuperset(String charset) throws Exception {
        String asciiSuperSet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] abyte0 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        byte[] convertedArray = asciiSuperSet.getBytes(charset);
        return Arrays.equals(convertedArray, abyte0);
    }

    public HttpClient(URI url, HttpClientPool clientPool, AuthorizationHandler auth_handler) {
        this.iUrl = url;
        this.iAuth_handler = auth_handler;
        this.iHttpClientPool = clientPool;
    }

    public void connect() throws IOException {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "connect()");
        }
        this.iReset = true;
        this.iResponse = null;
        this.iConnected = true;
        this.iServerOutput = null;
        this.resetSocket();
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "connect()");
        }
    }

    public synchronized void disconnect() {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "disconnect()");
        }
        this.iConnected = false;
        if (this.iSocket != null) {
            block5: {
                try {
                    this.iSocket.close();
                }
                catch (IOException e) {
                    if (!this.iLogger.isLoggable(Level.WARNING)) break block5;
                    this.iLogger.log(Level.WARNING, "Unexpected exception while closing the socket", e);
                }
            }
            this.iSocket = null;
            this.iServerInput = null;
            this.iReset = true;
            this.iResponse = null;
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "disconnect()");
        }
    }

    public void finalize() {
        String methodName = "finalize()";
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, methodName);
        }
        this.disconnect();
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, methodName);
        }
    }

    public String getCipherSuite() {
        return null;
    }

    public synchronized String getHeaderField(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return this.iResponse.toString();
        }
        Iterator iterator = this.iResponseHeaders.iterator();
        while (iterator.hasNext() && --index >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (index != 0) continue;
            return entry.getValue().toString();
        }
        return null;
    }

    public synchronized String getHeaderField(String name) {
        return this.iResponseHeaders.getField(name);
    }

    public synchronized String getHeaderFieldKey(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return null;
        }
        Iterator iterator = this.iResponseHeaders.iterator();
        while (iterator.hasNext() && --index >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (index != 0) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.getResponseCode() < 500 && this.iResponse != null && this.iServerInput != null) {
            return this.iServerInput;
        }
        throw new IOException("Failed to open an input stream from server: HTTPResponse " + this.getResponseCode());
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.iServerOutput == null) {
            this.iServerOutput = new ByteArrayOutputStream();
        }
        return this.iServerOutput;
    }

    public String getRequestMethod() {
        return this.iRequestMethod;
    }

    public String getRequestProperty(String key) {
        return this.iRequestHeaders.getField(key);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized int getResponseCode() throws IOException {
        block53: {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.entering("org.sblim.wbem.http.HttpClient", "getResponseCode()");
            }
            delayedException /* !! */  = null;
            if (!this.iReset || this.iResponse != null) break block53;
            authFailed = false;
            IoRetry = 1;
            AuthentificationRetry = 1;
            block17: do {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Attempting request.. retry counters:" + IoRetry + "/" + AuthentificationRetry);
                }
                this.resetSocket();
                this.iReset = false;
                try {
                    block52: {
                        out = (ASCIIPrintStream)this.iOStream;
                        if (out == null) {
                            throw new IOException("could not open output stream");
                        }
                        file = this.iUrl.getPath();
                        if (file == null || file.length() == 0) {
                            file = "/";
                        }
                        if ((query = this.iUrl.getQuery()) != null) {
                            file = file + '?' + query;
                        }
                        this.iMethod = new HttpClientMethod(this.iRequestMethod, this.iUrl.getPath(), 1, this.iUseHttp11 != false ? 1 : 0);
                        if (this.iLogger.isLoggable(Level.FINER)) {
                            this.iLogger.log(Level.FINER, "HTTP Operation= " + this.iMethod);
                        }
                        this.iMethod.write(out);
                        this.iRequestHeaders.addField("Host", this.iUrl.getHost());
                        if (this.iServerOutput != null) {
                            this.iRequestHeaders.addField("Content-length", "" + this.iServerOutput.size());
                        } else {
                            this.iRequestHeaders.addField("Content-length", "0");
                        }
                        this.iRequestHeaders.addField("Connection", "Keep-alive");
                        if (this.iPrevAuthInfo == null) {
                            authInfo = this.iAuth_handler.getAuthorizationInfo(0);
                            if (authInfo.isSentOnFirstRequest()) {
                                this.iRequestHeaders.addField(authInfo.getHeaderFieldName(), authInfo.toString());
                            }
                        } else {
                            this.iRequestHeaders.addField(this.iPrevAuthInfo.getHeaderFieldName(), this.iPrevAuthInfo.toString());
                        }
                        if (this.iPrevProxy != null) {
                            this.iRequestHeaders.addField("Proxy-authorization", this.iPrevProxy.toString());
                        }
                        this.iRequestHeaders.write(out);
                        if (this.iLogger.isLoggable(Level.FINER)) {
                            this.iLogger.log(Level.FINER, "HTTP Headers= " + this.iRequestHeaders);
                        }
                        if (out.checkError() != null) {
                            delayedException /* !! */  = out.checkError();
                            if (this.iLogger.isLoggable(Level.FINER)) {
                                this.iLogger.log(Level.FINER, "Got exception while writting to the output stream", delayedException /* !! */ );
                            }
                            if (this.iSocket != null && !this.iSocket.isClosed()) {
                                try {
                                    this.iSocket.close();
                                }
                                catch (IOException e) {
                                    this.iLogger.log(Level.FINER, "Got exception while closing socket", e);
                                }
                            }
                            this.iSocket = null;
                            this.iReset = true;
                            continue;
                        }
                        if (this.iServerOutput != null) {
                            this.iServerOutput.writeTo(out);
                        }
                        out.flush();
                        if (this.iLogger.isLoggable(Level.FINER)) {
                            this.iLogger.log(Level.FINER, "Retrieving response...");
                        }
                        this.iResponse = new HttpClientMethod(this.iIStream);
                        if (this.iLogger.isLoggable(Level.FINER)) {
                            this.iLogger.log(Level.FINER, "HTTP Response= " + this.iResponse);
                        }
                        this.iResponseHeaders = new HttpHeader(this.iIStream);
                        this.iKeepAlive = false;
                        if ("Keep-alive".equalsIgnoreCase(this.iResponseHeaders.getField("Connection")) || this.iResponse.getMajorVersion() == 1 && this.iResponse.getMinorVersion() == 1 || this.iResponseHeaders.getField("Keep-alive") != null) {
                            this.iKeepAlive = true;
                        }
                        this.iServerInput = new PersistentInputStream(this.iIStream);
                        contentLength = this.iResponseHeaders.getField("Content-length");
                        length = -1L;
                        try {
                            if (contentLength != null && contentLength.length() > 0) {
                                length = Long.parseLong(contentLength);
                            }
                        }
                        catch (Exception e) {
                            if (!this.iLogger.isLoggable(Level.WARNING)) break block52;
                            this.iLogger.log(Level.WARNING, "exception while parsing the content length of the response", e);
                        }
                    }
                    this.iKeepAlive = length >= 0L || this.iResponse.getStatus() == 304 || this.iResponse.getStatus() == 204;
                    transferEncoding = this.iResponseHeaders.getField("Transfer-encoding");
                    if (transferEncoding != null && transferEncoding.toLowerCase().endsWith("chunked")) {
                        this.iServerInput = new ChunkedInputStream(this.iServerInput);
                        this.iKeepAlive = true;
                    }
                    this.iServerInput = new BoundedInputStream(this.iServerInput, length);
                    if (this.iLogger.isLoggable(Level.FINER)) {
                        this.iLogger.log(Level.FINER, "KeepAlive", new Boolean(this.iKeepAlive));
                    }
                    if (this.iKeepAlive) {
                        this.iServerInput = new KeepAliveInputStream(this.iServerInput, this);
                    }
                    switch (this.iResponse.getStatus()) {
                        case 100: {
                            continue block17;
                        }
                        case 200: {
                            authInfo = this.iResponseHeaders.getField("Authentication-Info");
                            HttpClient.handleRsp(authInfo, this.iPrevAuthInfo);
                            authInfo = this.iResponseHeaders.getField("Authentication-Proxy");
                            HttpClient.handleRsp(authInfo, this.iPrevProxy);
                            if (this.iServerOutput != null) {
                                this.iServerOutput = null;
                            }
                            return 200;
                        }
                        case 401: {
                            --AuthentificationRetry;
                            authenticate = this.iResponseHeaders.getField("WWW-Authenticate");
                            try {
                                this.iPrevAuthInfo = this.getAuthentication(false, this.iPrevAuthInfo, authenticate);
                                if (this.iPrevAuthInfo != null) {
                                    this.iRequestHeaders.addField(this.iPrevAuthInfo.getHeaderFieldName(), this.iPrevAuthInfo.toString());
                                }
                            }
                            catch (NoSuchAlgorithmException e) {
                                if (!this.iLogger.isLoggable(Level.SEVERE)) ** GOTO lbl111
                                this.iLogger.log(Level.SEVERE, "error unable to find digest algorithm", e);
                            }
lbl111:
                            // 3 sources

                            if (!authFailed) {
                                authFailed = true;
                                if (this.iLogger.isLoggable(Level.INFO)) {
                                    this.iLogger.log(Level.INFO, "Authorization failed, retring with authorization info..");
                                }
                            }
                            if (!this.iPrevAuthInfo.isKeptAlive()) continue block17;
                            this.iKeepAlive = true;
                            break;
                        }
                        case 407: {
                            if (!this.iLogger.isLoggable(Level.SEVERE)) continue block17;
                            this.iLogger.log(Level.SEVERE, "Proxy authentication required, but not supported");
                            break;
                        }
                        default: {
                            if (!this.iKeepAlive) {
                                this.closeConnection();
                            } else {
                                this.iServerInput.close();
                            }
                            return this.iResponse.getStatus();
                        }
                    }
                }
                catch (SocketTimeoutException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (this.iLogger.isLoggable(Level.WARNING)) {
                        this.iLogger.log(Level.WARNING, "exception while connection to server", e);
                    }
                    delayedException /* !! */  = e;
                    if (this.iSocket != null && !this.iSocket.isClosed()) {
                        try {
                            this.iSocket.close();
                        }
                        catch (IOException e2) {
                            this.iLogger.log(Level.FINER, "exception while closing socket", e2);
                        }
                    }
                    this.iSocket = null;
                    this.iReset = true;
                    --IoRetry;
                }
            } while (AuthentificationRetry >= 0 && IoRetry >= 0);
        }
        if (this.iResponse != null) {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.exiting("org.sblim.wbem.http.HttpClient", "getResponseCode()", new Integer(this.iResponse.getStatus()));
            }
            return this.iResponse.getStatus();
        }
        throw (IOException)delayedException /* !! */ ;
    }

    public String getResponseMessage() {
        if (this.iResponse != null) {
            return this.iResponse.getResponseMessage();
        }
        return null;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.log(Level.FINER, "handshake completed... getting session");
        }
        this.iSession = event.getSession();
    }

    public void reset() {
        this.iRequestHeaders.clear();
        this.iResponseHeaders.clear();
        this.iResponse = null;
        this.iReset = true;
    }

    public void setRequestMethod(String method) {
        this.iRequestMethod = method;
    }

    public void setRequestProperty(String key, String value) {
        this.iRequestHeaders.addField(key, value);
    }

    public void streamFinished() {
        this.streamFinished(true);
    }

    public void streamFinished(boolean keep) {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "streamFinished(boolean)", new Boolean(keep));
        }
        HostPortPair hpp = new HostPortPair(this.iUrl);
        if (keep) {
            this.iHttpClientPool.returnAvailableConnectionToPool(this);
        } else {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "[disconnecting:" + hpp + "]");
            }
            this.iHttpClientPool.removeConnectionFromPool(this);
            this.disconnect();
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "streamFinished(boolean)");
        }
    }

    public void useHttp11(boolean bool) {
        this.iUseHttp11 = bool;
    }

    public boolean usingProxy() {
        return false;
    }

    protected AuthInfo getAuthentication(boolean proxy, AuthInfo prevAuthInfo, String authenticate) throws HttpParseException, NoSuchAlgorithmException {
        Challenge[] challenges = Challenge.parseChallenge(authenticate);
        prevAuthInfo = null;
        for (int cntr = 0; prevAuthInfo == null && cntr < challenges.length; ++cntr) {
            Challenge challenge = challenges[cntr];
            prevAuthInfo = this.iAuth_handler.getAuthorizationInfo(this.iHttpClientPool.getSessionProperties().getHttpAuthenticationModule(), proxy ? Boolean.TRUE : Boolean.FALSE, this.iUrl.getHost(), this.iUrl.getPort(), this.iUrl.getScheme(), challenge.getRealm(), challenge.getScheme());
            if (prevAuthInfo == null) continue;
            prevAuthInfo.updateAuthenticationInfo(challenge, authenticate, this.iUrl, this.iRequestMethod);
            return prevAuthInfo;
        }
        return null;
    }

    private void closeConnection() throws IOException {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "closeConnection()");
        }
        if (this.iSocket != null) {
            block5: {
                try {
                    this.iSocket.close();
                }
                catch (IOException e) {
                    if (!this.iLogger.isLoggable(Level.WARNING)) break block5;
                    this.iLogger.log(Level.WARNING, "Unexpected exception while closing the socket", e);
                }
            }
            this.iSocket = null;
            this.iServerInput = null;
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "closeConnection()");
        }
    }

    private String[] parseProperty(String propertyName) {
        String[] as;
        String s = (String)AccessController.doPrivileged(new GetProperty(propertyName));
        if (s == null || s.length() == 0) {
            as = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringtokenizer = new StringTokenizer(s, ",");
            while (stringtokenizer.hasMoreElements()) {
                vector.addElement(stringtokenizer.nextElement());
            }
            as = new String[vector.size()];
            for (int i1 = 0; i1 < as.length; ++i1) {
                as[i1] = (String)vector.elementAt(i1);
            }
        }
        return as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSocket() throws IOException {
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.entering(CLASSNAME, "resetSocket()");
        }
        if (!this.iKeepAlive) {
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "KeepAlive=false, closing connection...");
            }
            this.closeConnection();
        }
        if (this.iSocket == null) {
            SocketFactory factory;
            SecurityManager sm;
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "Socket=null, creating socket...");
            }
            if ((sm = System.getSecurityManager()) != null) {
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Checking for permisions to connect to:" + this.iUrl.getHost() + ":" + this.iUrl.getPort());
                }
                sm.checkConnect(this.iUrl.getHost(), this.iUrl.getPort());
            }
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "Retrieving socket factory for scheme:" + this.iUrl.getScheme());
            }
            if ((factory = HttpSocketFactory.getInstance().getSocketFactory(this.iUrl.getScheme(), this.iHttpClientPool.getSessionProperties())) == null) {
                throw new IllegalStateException("Unable to load socket socket factory:" + this.iUrl.getScheme());
            }
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "creating new socket connecting to: " + this.iUrl.getHost() + ":" + this.iUrl.getPort());
            }
            this.iSocket = factory.createSocket(this.iUrl.getHost(), this.iUrl.getPort());
            this.iSocket.setTcpNoDelay(true);
            this.iSocket.setKeepAlive(true);
            if (this.iSocket instanceof SSLSocket) {
                String[] ciphersuites;
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Got instance of SSLSocket...");
                }
                SSLSocket sk = (SSLSocket)this.iSocket;
                String[] protocols = this.parseProperty("https.protocols");
                if (protocols != null) {
                    if (this.iLogger.isLoggable(Level.FINER)) {
                        this.iLogger.log(Level.FINER, "Setting SSLSocket.setEnabledProtocols() from \"https.protocols\"=" + new Vector<String>(Arrays.asList(protocols)));
                    }
                    sk.setEnabledProtocols(protocols);
                }
                if ((ciphersuites = this.parseProperty("https.cipherSuites")) != null) {
                    if (this.iLogger.isLoggable(Level.FINER)) {
                        this.iLogger.log(Level.FINER, "Setting SSLSocket.setEnableCipheSuites() from \"httpscipherSuites\"=" + new Vector<String>(Arrays.asList(ciphersuites)));
                    }
                    sk.setEnabledCipherSuites(ciphersuites);
                }
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Starting handshake...");
                }
                sk.addHandshakeCompletedListener(this);
                Class clazz = class$javax$net$ssl$SSLSocket == null ? (class$javax$net$ssl$SSLSocket = HttpClient.class$("javax.net.ssl.SSLSocket")) : class$javax$net$ssl$SSLSocket;
                synchronized (clazz) {
                    sk.startHandshake();
                }
            }
            int timeout = this.iHttpClientPool.getSessionProperties().getHttpTimeOut();
            if (this.iLogger.isLoggable(Level.FINER)) {
                this.iLogger.log(Level.FINER, "setting Socket.setSoTimeout(" + timeout + ")");
            }
            this.iSocket.setSoTimeout(timeout);
            this.iIStream = new BufferedInputStream(this.iSocket.getInputStream());
            this.iOStream = new ASCIIPrintStream(new BufferedOutputStream(this.iSocket.getOutputStream(), 1024), false, iEncoding);
            this.iServerInput = null;
        } else {
            if (this.iServerInput != null && !(this.iServerInput instanceof KeepAliveInputStream)) {
                long total;
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "Socket!=null, flushing the stream...");
                }
                long totalBytes = 0L;
                while ((total = (long)this.iServerInput.available()) > 0L) {
                    this.iServerInput.skip(total);
                    totalBytes += total;
                }
                if (this.iLogger.isLoggable(Level.FINER)) {
                    this.iLogger.log(Level.FINER, "total bytes on the stream=" + totalBytes);
                }
            }
            int timeout = this.iHttpClientPool.getSessionProperties().getHttpTimeOut();
            this.iSocket.setSoTimeout(timeout);
        }
        if (this.iLogger.isLoggable(Level.FINER)) {
            this.iLogger.exiting(CLASSNAME, "resetSocket()");
        }
    }

    public boolean isConnected() {
        return this.iConnected;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            iEncoding = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("file.encoding", "ISO8859_1");
                }
            });
            if (!HttpClient.isASCIISuperset(iEncoding)) {
                iEncoding = "ISO8859_1";
            }
        }
        catch (Exception exception) {
            iEncoding = "ISO8859_1";
        }
    }

    private class GetProperty
    implements PrivilegedAction {
        String iPropertyName;

        GetProperty(String propertyName) {
            this.iPropertyName = propertyName;
        }

        public Object run() {
            return System.getProperty(this.iPropertyName);
        }
    }

    static class HostPortPair {
        String iHostport;

        public HostPortPair(URI url) {
            this.iHostport = url.getScheme().toLowerCase() + ':' + url.getHost().toLowerCase() + ':' + url.getPort();
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostPortPair)) {
                return false;
            }
            return this.iHostport.equals(((HostPortPair)o).iHostport);
        }

        public int hashCode() {
            return this.iHostport.hashCode();
        }

        public String toString() {
            return "HostPortPair=[+" + this.iHostport + "]";
        }
    }
}

