/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.util.CharUtils;

public class CIMValue
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1019257998440613738L;
    private Object iValue;
    private CIMDataType iType;
    public static final CIMValue FALSE = new CIMValue(Boolean.FALSE);
    public static final CIMValue TRUE = new CIMValue(Boolean.TRUE);

    public CIMValue(Object pValue) {
        if (pValue instanceof Object[]) {
            pValue = new Vector<Object>(Arrays.asList((Object[])pValue));
        }
        if (pValue instanceof Vector) {
            int dataType = CIMDataType.findType((Object)pValue);
            this.iType = CIMDataType.getPredefinedType(dataType);
            Vector<Object> newValue = pValue;
            Iterator<Object> iter = newValue.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (dataType == CIMDataType.findArrayType(CIMDataType.findType(obj))) continue;
                throw new IllegalArgumentException("Invalid data type. The array contains elements that do not match arrays type");
            }
            this.iValue = newValue;
        } else {
            int dataType = CIMDataType.findType((Object)pValue);
            this.iType = dataType == 14 ? new CIMDataType(((CIMObjectPath)((Object)pValue)).getObjectName()) : new CIMDataType(dataType);
            this.iValue = pValue;
        }
    }

    public CIMValue(Object pValue, CIMDataType pDataType) {
        if (pValue instanceof Object[]) {
            if ((pValue = new Vector<Object>(Arrays.asList((Object[])pValue))) != null) {
                if (!(pDataType == null || pDataType.isArrayType() && pDataType.getType() != -1)) {
                    throw new IllegalArgumentException("Invalid argument type. Array type expected");
                }
                Iterator<Object> iter = pValue.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    int elementType = CIMDataType.findArrayType(CIMDataType.findType(obj));
                    if (CIMDataType.isTypeCompatible(obj, pDataType) || elementType == 32) continue;
                    throw new IllegalArgumentException("Invalid element type. One of the elements of the array does not match the data type or a compatible data type of the array");
                }
                this.iValue = pValue;
            }
        } else {
            if (pValue != null && (pValue instanceof Vector || pDataType != null && pDataType.isArrayType())) {
                throw new IllegalArgumentException("value type does not match the specified data type");
            }
            if (!(pDataType == null || pValue == null || CIMDataType.isTypeCompatible(pValue, pDataType) && pDataType.getType() != -1)) {
                throw new IllegalArgumentException("Invalid argument type. The value contains an element that does not match the data type or a compatible data type.\ndata type:" + pDataType.toString() + "\nclassName of value:" + pValue.getClass().getName());
            }
            this.iValue = pValue;
        }
        this.iType = pDataType;
    }

    public CIMValue(Vector pValue, CIMDataType pDataType) {
        if (!(pValue == null || pDataType != null && pDataType.isArrayType())) {
            throw new IllegalArgumentException("Array data type expected");
        }
        if (pValue != null) {
            if (!(pDataType == null || pDataType.isArrayType() && pDataType.getType() != -1)) {
                throw new IllegalArgumentException("Invalid argument type. Array type expected");
            }
            Vector newValue = pValue;
            Iterator iter = newValue.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                int elementType = CIMDataType.findArrayType(CIMDataType.findType(obj));
                if (CIMDataType.isTypeCompatible(obj, pDataType) || elementType == 32) continue;
                throw new IllegalArgumentException("Invalid element type. One of the elements of the array does not match the data type or a compatible data type of the array");
            }
            this.iValue = newValue;
        }
        this.iType = pDataType;
    }

    protected CIMValue() {
    }

    public Object clone() {
        CIMValue that = new CIMValue();
        that.iValue = this.iValue instanceof Vector ? ((Vector)this.iValue).clone() : this.iValue;
        if (this.iType != null) {
            that.iType = (CIMDataType)this.iType.clone();
        }
        return that;
    }

    public boolean contains(Object pValue) {
        if (pValue == null) {
            return false;
        }
        if (this.iValue != null) {
            if (this.iValue instanceof Vector) {
                return ((Vector)this.iValue).contains(pValue);
            }
            return this.iValue.equals(pValue);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.iValue == null && this.iType != null;
    }

    public boolean isNull() {
        return this.iValue == null;
    }

    public boolean isNullValue() {
        return this.isNull();
    }

    public int getSize() {
        if (this.iValue instanceof Vector) {
            return ((Vector)this.iValue).size();
        }
        if (this.iType != null) {
            return this.iType.getSize();
        }
        return -1;
    }

    public int size() {
        return this.getSize();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIMValue)) {
            return false;
        }
        CIMValue that = (CIMValue)obj;
        if (!(this.iType != null ? this.iType.equals(that.iType) : that.iType == null)) {
            return false;
        }
        return this.iValue == null ? that.iValue == null : this.iValue.equals(that.iValue);
    }

    public int hashCode() {
        return (this.iValue != null ? this.iValue.hashCode() : 0) << 16 + (this.iType != null ? this.iType.hashCode() : 0);
    }

    public CIMDataType getType() {
        return this.iType;
    }

    public Object getValue() {
        return this.iValue;
    }

    public boolean isArrayValue() {
        return this.iValue instanceof Vector || this.iType.isArrayType();
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (this.iValue != null) {
            if (this.iType != null && this.iType.isArrayType()) {
                buf.append(CIMElement.vectorToMOFString((Vector)this.iValue, false, 1));
            } else if (this.iValue instanceof String || this.iValue instanceof CIMObjectPath) {
                buf.append('\"');
                buf.append(CharUtils.escape(this.iValue.toString()));
                buf.append('\"');
            } else if (this.iValue instanceof Character) {
                buf.append('\'');
                buf.append(CharUtils.escape(this.iValue.toString()));
                buf.append('\'');
            } else {
                buf.append(String.valueOf(this.iValue));
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
        CIMValue value1 = new CIMValue((Object)null, CIMDataType.getPredefinedType(13));
        CIMValue value2 = new CIMValue("string");
        System.out.println(value1);
        System.out.println(value2);
        System.out.println("equals() = " + value1.equals(value2));
        String[] strArray = new String[]{"hello", "bye"};
        CIMValue value3 = new CIMValue(strArray, CIMDataType.getPredefinedType(24));
        System.out.println(value3);
    }
}

