/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.database.DatabaseConnection;
import com.ibm.jtopenlite.database.DatabaseLOBDataCallback;
import com.ibm.jtopenlite.database.DatabaseRetrieveLOBDataAttributes;
import com.ibm.jtopenlite.database.jdbc.JDBCBlobLocatorInputStream;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public final class JDBCBlobLocator
implements Blob,
DatabaseLOBDataCallback {
    private final DatabaseConnection conn_;
    private final DatabaseRetrieveLOBDataAttributes attribs_;
    private long length_ = -1L;
    private byte[] currentBuffer_ = new byte[8192];
    private ByteArrayOutputStream tempOutput_;

    public JDBCBlobLocator(DatabaseConnection databaseConnection, DatabaseRetrieveLOBDataAttributes databaseRetrieveLOBDataAttributes) {
        this.conn_ = databaseConnection;
        this.attribs_ = databaseRetrieveLOBDataAttributes;
    }

    public void newLOBLength(long l) {
        this.length_ = l;
    }

    public void newLOBData(int n, int n2) {
    }

    public byte[] getLOBBuffer() {
        return this.currentBuffer_;
    }

    public void setLOBBuffer(byte[] byArray) {
        this.currentBuffer_ = byArray;
    }

    public void newLOBSegment(byte[] byArray, int n, int n2) {
        if (this.tempOutput_ != null) {
            this.tempOutput_.write(byArray, n, n2);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new JDBCBlobLocatorInputStream(this.conn_, this.attribs_, this.length_);
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        JDBCError.throwSQLException("IM001");
        return null;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n2 = (int)(l & Integer.MAX_VALUE);
        this.attribs_.setStartOffset(n2 - 1);
        this.attribs_.setRequestedSize(n);
        this.attribs_.setReturnCurrentLengthIndicator(241);
        try {
            this.tempOutput_ = new ByteArrayOutputStream();
            this.conn_.retrieveLOBData(this.attribs_, this);
            this.tempOutput_.flush();
            this.tempOutput_.close();
            return this.tempOutput_.toByteArray();
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.toString());
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    public void refreshLength() throws SQLException {
        this.length_ = -1L;
        this.length();
    }

    public long length() throws SQLException {
        if (this.length_ == -1L) {
            this.attribs_.setStartOffset(0);
            this.attribs_.setRequestedSize(0);
            this.attribs_.setReturnCurrentLengthIndicator(241);
            try {
                this.length_ = -1L;
                this.conn_.retrieveLOBData(this.attribs_, this);
                if (this.length_ == -1L) {
                    throw new IOException("LOB length not retrieved.");
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.toString());
                sQLException.initCause(iOException);
                throw sQLException;
            }
        }
        return this.length_;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad start: " + l);
        }
        throw new NotImplementedException();
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad start: " + l);
        }
        throw new NotImplementedException();
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        throw new NotImplementedException();
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        throw new NotImplementedException();
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        throw new NotImplementedException();
    }

    public void truncate(long l) throws SQLException {
        throw new NotImplementedException();
    }

    public void free() throws SQLException {
    }
}

