/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database;

import com.ibm.jtopenlite.DataStreamException;

public class DatabaseException
extends DataStreamException {
    private static final long serialVersionUID = -8481404420909977054L;
    private int class_;
    private int returnCode_;

    DatabaseException(String string, int n, int n2) {
        super("Bad return code", string, n << 16 | n2 & 0xFFFF);
        this.class_ = n;
        this.returnCode_ = n2;
    }

    public int getReturnCode() {
        return this.returnCode_;
    }

    public int getReturnCodeClass() {
        return this.class_;
    }

    public static String getReturnCodeString(int n, int n2) {
        if (n == 2) {
            int n3 = n2 & 0xFFFF;
            switch (n3) {
                case 64933: {
                    return "Descriptor handle expected";
                }
                case 64934: {
                    return "Parameter marker data expected";
                }
                case 64935: {
                    return "Descriptor and parameter marker data do not match";
                }
                case 65335: {
                    return "Statement name not valid";
                }
                case 65433: {
                    return "Cursor name required for operation";
                }
                case 65435: {
                    return "Statement name required for operation";
                }
            }
        } else if (n == 7) {
            int n4 = n2 & 0xFFFF;
            switch (n4) {
                case 64834: {
                    return "Cannot find the descriptor for the specified handle";
                }
                case 65130: {
                    return "RPB to create, already exists";
                }
                case 65133: {
                    return "Cannot do this function on the default RPB";
                }
                case 65135: {
                    return "Specified RPB not found";
                }
                case 65434: {
                    return "Unexpected error, processing can continue";
                }
                case 65435: {
                    return "Unexpected error, no more processing can continue";
                }
            }
        } else if (n == 8) {
            int n5 = n2 & 0xFFFF;
            switch (n5) {
                case 65435: {
                    return "User exit program rejected request";
                }
            }
        }
        return "Unknown error";
    }

    public String getReturnCodeString() {
        return DatabaseException.getReturnCodeString(this.class_, this.returnCode_);
    }

    public String toString() {
        return super.toString() + ": " + this.getReturnCodeString();
    }
}

