/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program.security;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.Program;
import com.ibm.jtopenlite.command.program.security.RetrieveAuthorizedUsersListener;

public class RetrieveAuthorizedUsers
implements Program {
    private static final byte[] ZERO = new byte[4];
    public static final int FORMAT_AUTU0100 = 0;
    public static final int FORMAT_AUTU0150 = 1;
    public static final int FORMAT_AUTU0200 = 2;
    public static final int FORMAT_AUTU0250 = 3;
    public static final String SELECTION_ALL = "*ALL";
    public static final String SELECTION_USER = "*USER";
    public static final String SELECTION_GROUP = "*GROUP";
    public static final String SELECTION_MEMBER = "*MEMBER";
    public static final String STARTING_PROFILE_FIRST = "*FIRST";
    public static final String GROUP_NONE = "*NONE";
    public static final String GROUP_NO_GROUP = "*NOGROUP";
    public static final String ENDING_PROFILE_LAST = "*LAST";
    private int inputFormat_;
    private int inputLength_;
    private String inputSelection_;
    private String inputStart_;
    private boolean inputIncludeStart_;
    private String inputGroup_;
    private String inputEnd_;
    private int bytesReturned_;
    private int bytesAvailable_;
    private int numberOfProfileNames_;
    private RetrieveAuthorizedUsersListener listener_;
    private byte[] tempData_;

    public RetrieveAuthorizedUsers(int n, int n2, String string, String string2, boolean bl, String string3, String string4) {
        this.inputFormat_ = n;
        this.inputLength_ = n2 <= 0 ? 1 : n2;
        this.inputSelection_ = string == null ? SELECTION_ALL : string;
        this.inputStart_ = string2 == null ? STARTING_PROFILE_FIRST : string2;
        this.inputIncludeStart_ = bl;
        this.inputGroup_ = string3 == null ? GROUP_NONE : string3;
        this.inputEnd_ = string4;
    }

    public final byte[] getTempDataBuffer() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfParameters(); ++i) {
            int n2 = this.getParameterOutputLength(i);
            if (n2 > n) {
                n = n2;
            }
            if ((n2 = this.getParameterInputLength(i)) <= n) continue;
            n = n2;
        }
        if (this.tempData_ == null || this.tempData_.length < n) {
            this.tempData_ = new byte[n];
        }
        return this.tempData_;
    }

    public String getProgramName() {
        return "QSYRAUTU";
    }

    public String getProgramLibrary() {
        return "QSYS";
    }

    public int getNumberOfParameters() {
        return this.inputEnd_ == null ? 9 : 10;
    }

    public void newCall() {
        this.bytesReturned_ = 0;
        this.bytesAvailable_ = 0;
        this.numberOfProfileNames_ = 0;
    }

    public void setFormat(int n) {
        this.inputFormat_ = n;
    }

    public int getFormat() {
        return this.inputFormat_;
    }

    public int getLengthOfReceiverVariable() {
        return this.inputLength_;
    }

    public void setLengthOfReceiverVariable(int n) {
        this.inputLength_ = n <= 0 ? 1 : n;
    }

    public int getBytesReturned() {
        return this.bytesReturned_;
    }

    public int getBytesAvailable() {
        return this.bytesAvailable_;
    }

    public int getNumberOfProfileNames() {
        return this.numberOfProfileNames_;
    }

    public int getParameterInputLength(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 10;
            }
        }
        return 0;
    }

    public int getParameterOutputLength(int n) {
        switch (n) {
            case 0: {
                return this.inputLength_;
            }
            case 2: {
                return 16;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    private String getFormatName() {
        switch (this.inputFormat_) {
            case 0: {
                return "AUTU0100";
            }
            case 1: {
                return "AUTU0150";
            }
            case 2: {
                return "AUTU0200";
            }
            case 3: {
                return "AUTU0250";
            }
        }
        return null;
    }

    public int getParameterType(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return 1;
    }

    public byte[] getParameterInputData(int n) {
        byte[] byArray = this.getTempDataBuffer();
        switch (n) {
            case 1: {
                Conv.intToByteArray(this.inputLength_, byArray, 0);
                return byArray;
            }
            case 3: {
                Conv.stringToEBCDICByteArray37(this.getFormatName(), byArray, 0);
                return byArray;
            }
            case 4: {
                Conv.stringToBlankPadEBCDICByteArray(this.inputSelection_, byArray, 0, 10);
                return byArray;
            }
            case 5: {
                Conv.stringToBlankPadEBCDICByteArray(this.inputStart_, byArray, 0, 10);
                return byArray;
            }
            case 6: {
                byArray[0] = this.inputIncludeStart_ ? -15 : -16;
                return byArray;
            }
            case 7: {
                Conv.stringToBlankPadEBCDICByteArray(this.inputGroup_, byArray, 0, 10);
                return byArray;
            }
            case 8: {
                return ZERO;
            }
            case 9: {
                Conv.stringToBlankPadEBCDICByteArray(this.inputEnd_, byArray, 0, 10);
                return byArray;
            }
        }
        return null;
    }

    public void setListener(RetrieveAuthorizedUsersListener retrieveAuthorizedUsersListener) {
        this.listener_ = retrieveAuthorizedUsersListener;
    }

    public void setParameterOutputData(int n, byte[] byArray, int n2) {
        switch (n) {
            case 2: {
                this.bytesReturned_ = Conv.byteArrayToInt(byArray, 0);
                this.bytesAvailable_ = Conv.byteArrayToInt(byArray, 4);
                this.numberOfProfileNames_ = Conv.byteArrayToInt(byArray, 8);
                break;
            }
            case 0: {
                if (this.listener_ == null) {
                    return;
                }
                int n3 = 0;
                char[] cArray = new char[50];
                block10: while (n3 < n2) {
                    int n4 = n2 - n3;
                    switch (this.inputFormat_) {
                        case 0: {
                            int n5;
                            int n6;
                            String string2;
                            if (n4 >= 12) {
                                string2 = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                n3 += 10;
                                n6 = byArray[n3++] & 0xFF;
                                n5 = byArray[n3++] & 0xFF;
                                this.listener_.newEntry(string2, n6 == 241, n5 == 241, null, null);
                                continue block10;
                            }
                            n3 += n4;
                            continue block10;
                        }
                        case 1: {
                            String string;
                            int n5;
                            int n6;
                            String string2;
                            if (n4 >= 62) {
                                string2 = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                n3 += 10;
                                n6 = byArray[n3++] & 0xFF;
                                n5 = byArray[n3++] & 0xFF;
                                string = Conv.ebcdicByteArrayToString(byArray, n3, 50, cArray);
                                n3 += 50;
                                this.listener_.newEntry(string2, n6 == 241, n5 == 241, string, null);
                                continue block10;
                            }
                            n3 += n4;
                            continue block10;
                        }
                        case 2: {
                            int n5;
                            int n6;
                            String string2;
                            if (n4 >= 176) {
                                string2 = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                n3 += 10;
                                n6 = byArray[n3++] & 0xFF;
                                n5 = byArray[n3++] & 0xFF;
                                int n7 = Conv.byteArrayToInt(byArray, n3);
                                n3 += 4;
                                String[] stringArray = new String[n7];
                                if (n7 > 0) {
                                    for (int i = 0; i < n7; ++i) {
                                        stringArray[i] = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                        n3 += 10;
                                    }
                                    n3 += 10 * (16 - n7);
                                } else {
                                    n3 += 160;
                                }
                                this.listener_.newEntry(string2, n6 == 241, n5 == 241, null, stringArray);
                                continue block10;
                            }
                            n3 += n4;
                            continue block10;
                        }
                        case 3: {
                            String string;
                            int n5;
                            int n6;
                            String string2;
                            if (n4 >= 228) {
                                string2 = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                n3 += 10;
                                n6 = byArray[n3++] & 0xFF;
                                n5 = byArray[n3++] & 0xFF;
                                string = Conv.ebcdicByteArrayToString(byArray, n3, 50, cArray);
                                n3 += 50;
                                int n8 = Conv.byteArrayToInt(byArray, n3 += 2);
                                n3 += 4;
                                String[] stringArray = new String[n8];
                                if (n8 > 0) {
                                    stringArray = new String[n8];
                                    for (int i = 0; i < n8; ++i) {
                                        stringArray[i] = Conv.ebcdicByteArrayToString(byArray, n3, 10, cArray);
                                        n3 += 10;
                                    }
                                    n3 += 10 * (16 - n8);
                                } else {
                                    n3 += 160;
                                }
                                this.listener_.newEntry(string2, n6 == 241, n5 == 241, string, stringArray);
                                continue block10;
                            }
                            n3 += n4;
                            continue block10;
                        }
                    }
                    n3 += n4;
                }
                break;
            }
        }
    }
}

