/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class EncryptPassword {
    private static final byte[] SHA_SEQUENCE = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
    private static final int[] EPERM = new int[]{32, 1, 2, 3, 4, 5, 4, 5, 6, 7, 8, 9, 8, 9, 10, 11, 12, 13, 12, 13, 14, 15, 16, 17, 16, 17, 18, 19, 20, 21, 20, 21, 22, 23, 24, 25, 24, 25, 26, 27, 28, 29, 28, 29, 30, 31, 32, 1};
    private static final int[] INITPERM = new int[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
    private static final int[] OUTPERM = new int[]{40, 8, 48, 16, 56, 24, 64, 32, 39, 7, 47, 15, 55, 23, 63, 31, 38, 6, 46, 14, 54, 22, 62, 30, 37, 5, 45, 13, 53, 21, 61, 29, 36, 4, 44, 12, 52, 20, 60, 28, 35, 3, 43, 11, 51, 19, 59, 27, 34, 2, 42, 10, 50, 18, 58, 26, 33, 1, 41, 9, 49, 17, 57, 25};
    private static final int[] PPERM = new int[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
    private static final int[] PC1 = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static final int[] PC2 = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static final int[] S1 = new int[]{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13};
    private static final int[] S2 = new int[]{15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9};
    private static final int[] S3 = new int[]{10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12};
    private static final int[] S4 = new int[]{7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14};
    private static final int[] S5 = new int[]{2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3};
    private static final int[] S6 = new int[]{12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13};
    private static final int[] S7 = new int[]{4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12};
    private static final int[] S8 = new int[]{13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11};

    private EncryptPassword() {
    }

    static byte[] encryptPasswordSHA(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            byte[] byArray5 = messageDigest.digest();
            messageDigest.update(byArray5);
            messageDigest.update(byArray4);
            messageDigest.update(byArray3);
            messageDigest.update(byArray);
            messageDigest.update(SHA_SEQUENCE);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException("Error loading SHA encryption: " + noSuchAlgorithmException);
            iOException.initCause(noSuchAlgorithmException);
            throw iOException;
        }
    }

    static byte[] encryptPasswordDES(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] byArray6 = new byte[8];
        byte[] byArray7 = EncryptPassword.generateToken(byArray, byArray2);
        byte[] byArray8 = EncryptPassword.generatePasswordSubstitute(byArray, byArray7, byArray6, byArray5, byArray3, byArray4);
        return byArray8;
    }

    private static byte[] generateToken(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[10];
        byte[] byArray5 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray6 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(byArray, 0, byArray4, 0, 10);
        int n = EncryptPassword.ebcdicStrLen(byArray, 10);
        if (n > 8) {
            byArray4[0] = (byte)(byArray4[0] ^ byArray4[8] & 0xC0);
            byArray4[1] = (byte)(byArray4[1] ^ (byArray4[8] & 0x30) << 2);
            byArray4[2] = (byte)(byArray4[2] ^ (byArray4[8] & 0xC) << 4);
            byArray4[3] = (byte)(byArray4[3] ^ (byArray4[8] & 3) << 6);
            byArray4[4] = (byte)(byArray4[4] ^ byArray4[9] & 0xC0);
            byArray4[5] = (byte)(byArray4[5] ^ (byArray4[9] & 0x30) << 2);
            byArray4[6] = (byte)(byArray4[6] ^ (byArray4[9] & 0xC) << 4);
            byArray4[7] = (byte)(byArray4[7] ^ (byArray4[9] & 3) << 6);
        }
        if ((n = EncryptPassword.ebcdicStrLen(byArray2, 10)) > 8) {
            System.arraycopy(byArray2, 0, byArray5, 0, 8);
            System.arraycopy(byArray2, 8, byArray6, 0, n - 8);
            EncryptPassword.xorWith0x55andLshift(byArray5);
            byArray5 = EncryptPassword.enc_des(byArray5, byArray4);
            EncryptPassword.xorWith0x55andLshift(byArray6);
            byArray6 = EncryptPassword.enc_des(byArray6, byArray4);
            EncryptPassword.xORArray(byArray5, byArray6, byArray3);
        } else {
            System.arraycopy(byArray2, 0, byArray5, 0, n);
            EncryptPassword.xorWith0x55andLshift(byArray5);
            byArray3 = EncryptPassword.enc_des(byArray5, byArray4);
        }
        return byArray3;
    }

    private static void addArray(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            int n3 = (byArray[i] & 0xFF) + (byArray2[i] & 0xFF) + n2;
            n2 = n3 >>> 8;
            byArray3[i] = (byte)n3;
        }
    }

    private static int ebcdicStrLen(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < n && byArray[n2] != 64 && byArray[n2] != 0; ++n2) {
        }
        return n2;
    }

    private static void xORArray(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < 8; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private static void xorWith0x55andLshift(byte[] byArray) {
        byArray[0] = (byte)(byArray[0] ^ 0x55);
        byArray[1] = (byte)(byArray[1] ^ 0x55);
        byArray[2] = (byte)(byArray[2] ^ 0x55);
        byArray[3] = (byte)(byArray[3] ^ 0x55);
        byArray[4] = (byte)(byArray[4] ^ 0x55);
        byArray[5] = (byte)(byArray[5] ^ 0x55);
        byArray[6] = (byte)(byArray[6] ^ 0x55);
        byArray[7] = (byte)(byArray[7] ^ 0x55);
        byArray[0] = (byte)(byArray[0] << 1 | (byArray[1] & 0x80) >>> 7);
        byArray[1] = (byte)(byArray[1] << 1 | (byArray[2] & 0x80) >>> 7);
        byArray[2] = (byte)(byArray[2] << 1 | (byArray[3] & 0x80) >>> 7);
        byArray[3] = (byte)(byArray[3] << 1 | (byArray[4] & 0x80) >>> 7);
        byArray[4] = (byte)(byArray[4] << 1 | (byArray[5] & 0x80) >>> 7);
        byArray[5] = (byte)(byArray[5] << 1 | (byArray[6] & 0x80) >>> 7);
        byArray[6] = (byte)(byArray[6] << 1 | (byArray[7] & 0x80) >>> 7);
        byArray[7] = (byte)(byArray[7] << 1);
    }

    private static byte[] enc_des(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3 = new byte[65];
        byte[] byArray4 = new byte[65];
        for (n = 0; n < 8; ++n) {
            byArray3[8 * n + 1] = (byte)((byArray2[n] & 0x80) == 0 ? 48 : 49);
            byArray3[8 * n + 2] = (byte)((byArray2[n] & 0x40) == 0 ? 48 : 49);
            byArray3[8 * n + 3] = (byte)((byArray2[n] & 0x20) == 0 ? 48 : 49);
            byArray3[8 * n + 4] = (byte)((byArray2[n] & 0x10) == 0 ? 48 : 49);
            byArray3[8 * n + 5] = (byte)((byArray2[n] & 8) == 0 ? 48 : 49);
            byArray3[8 * n + 6] = (byte)((byArray2[n] & 4) == 0 ? 48 : 49);
            byArray3[8 * n + 7] = (byte)((byArray2[n] & 2) == 0 ? 48 : 49);
            byArray3[8 * n + 8] = (byte)((byArray2[n] & 1) == 0 ? 48 : 49);
        }
        for (n = 0; n < 8; ++n) {
            byArray4[8 * n + 1] = (byte)((byArray[n] & 0x80) == 0 ? 48 : 49);
            byArray4[8 * n + 2] = (byte)((byArray[n] & 0x40) == 0 ? 48 : 49);
            byArray4[8 * n + 3] = (byte)((byArray[n] & 0x20) == 0 ? 48 : 49);
            byArray4[8 * n + 4] = (byte)((byArray[n] & 0x10) == 0 ? 48 : 49);
            byArray4[8 * n + 5] = (byte)((byArray[n] & 8) == 0 ? 48 : 49);
            byArray4[8 * n + 6] = (byte)((byArray[n] & 4) == 0 ? 48 : 49);
            byArray4[8 * n + 7] = (byte)((byArray[n] & 2) == 0 ? 48 : 49);
            byArray4[8 * n + 8] = (byte)((byArray[n] & 1) == 0 ? 48 : 49);
        }
        byte[] byArray5 = new byte[65];
        byte[] byArray6 = new byte[58];
        for (int i = 1; i <= 56; ++i) {
            byArray6[i] = byArray4[PC1[i - 1]];
        }
        EncryptPassword.lshift1(byArray6);
        byte[] byArray7 = new byte[49];
        for (int i = 1; i <= 48; ++i) {
            byArray7[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray8 = new byte[49];
        EncryptPassword.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray8[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray9 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray9[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray10 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray10[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray11 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray11[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray12 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray12[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray13 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray13[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray14 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray14[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray15 = new byte[49];
        EncryptPassword.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray15[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray16 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray16[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray17 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray17[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray18 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray18[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray19 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray19[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray20 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray20[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray21 = new byte[49];
        EncryptPassword.lshift2(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray21[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray22 = new byte[49];
        EncryptPassword.lshift1(byArray6);
        for (int i = 1; i <= 48; ++i) {
            byArray22[i] = byArray6[PC2[i - 1]];
        }
        byte[] byArray23 = new byte[33];
        byte[] byArray24 = new byte[33];
        for (int i = 1; i <= 32; ++i) {
            byArray23[i] = byArray3[INITPERM[i - 1]];
            byArray24[i] = byArray3[INITPERM[i + 31]];
        }
        EncryptPassword.cipher(byArray7, byArray23, byArray24);
        EncryptPassword.cipher(byArray8, byArray23, byArray24);
        EncryptPassword.cipher(byArray9, byArray23, byArray24);
        EncryptPassword.cipher(byArray10, byArray23, byArray24);
        EncryptPassword.cipher(byArray11, byArray23, byArray24);
        EncryptPassword.cipher(byArray12, byArray23, byArray24);
        EncryptPassword.cipher(byArray13, byArray23, byArray24);
        EncryptPassword.cipher(byArray14, byArray23, byArray24);
        EncryptPassword.cipher(byArray15, byArray23, byArray24);
        EncryptPassword.cipher(byArray16, byArray23, byArray24);
        EncryptPassword.cipher(byArray17, byArray23, byArray24);
        EncryptPassword.cipher(byArray18, byArray23, byArray24);
        EncryptPassword.cipher(byArray19, byArray23, byArray24);
        EncryptPassword.cipher(byArray20, byArray23, byArray24);
        EncryptPassword.cipher(byArray21, byArray23, byArray24);
        EncryptPassword.cipher(byArray22, byArray23, byArray24);
        System.arraycopy(byArray24, 1, byArray5, 1, 32);
        System.arraycopy(byArray23, 1, byArray5, 33, 32);
        byte[] byArray25 = new byte[65];
        for (int i = 1; i <= 64; ++i) {
            byArray25[i] = byArray5[OUTPERM[i - 1]];
        }
        byte[] byArray26 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            if (byArray25[8 * i + 1] == 49) {
                int n2 = i;
                byArray26[n2] = (byte)(byArray26[n2] | 0x80);
            }
            if (byArray25[8 * i + 2] == 49) {
                int n3 = i;
                byArray26[n3] = (byte)(byArray26[n3] | 0x40);
            }
            if (byArray25[8 * i + 3] == 49) {
                int n4 = i;
                byArray26[n4] = (byte)(byArray26[n4] | 0x20);
            }
            if (byArray25[8 * i + 4] == 49) {
                int n5 = i;
                byArray26[n5] = (byte)(byArray26[n5] | 0x10);
            }
            if (byArray25[8 * i + 5] == 49) {
                int n6 = i;
                byArray26[n6] = (byte)(byArray26[n6] | 8);
            }
            if (byArray25[8 * i + 6] == 49) {
                int n7 = i;
                byArray26[n7] = (byte)(byArray26[n7] | 4);
            }
            if (byArray25[8 * i + 7] == 49) {
                int n8 = i;
                byArray26[n8] = (byte)(byArray26[n8] | 2);
            }
            if (byArray25[8 * i + 8] != 49) continue;
            int n9 = i;
            byArray26[n9] = (byte)(byArray26[n9] | 1);
        }
        return byArray26;
    }

    private static void cipher(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[49];
        byte[] byArray5 = new byte[49];
        byte[] byArray6 = new byte[33];
        byte[] byArray7 = new byte[33];
        int[] nArray = new int[9];
        int[] nArray2 = new int[9];
        for (n = 1; n <= 48; ++n) {
            byArray4[n] = byArray3[EPERM[n - 1]];
        }
        for (n = 1; n <= 48; ++n) {
            byArray5[n] = byArray4[n] != byArray[n] ? 49 : 48;
        }
        nArray[1] = (byArray5[1] == 49 ? 32 : 0) | (byArray5[6] == 49 ? 16 : 0) | (byArray5[2] == 49 ? 8 : 0) | (byArray5[3] == 49 ? 4 : 0) | (byArray5[4] == 49 ? 2 : 0) | (byArray5[5] == 49 ? 1 : 0);
        nArray[2] = (byArray5[7] == 49 ? 32 : 0) | (byArray5[12] == 49 ? 16 : 0) | (byArray5[8] == 49 ? 8 : 0) | (byArray5[9] == 49 ? 4 : 0) | (byArray5[10] == 49 ? 2 : 0) | (byArray5[11] == 49 ? 1 : 0);
        nArray[3] = (byArray5[13] == 49 ? 32 : 0) | (byArray5[18] == 49 ? 16 : 0) | (byArray5[14] == 49 ? 8 : 0) | (byArray5[15] == 49 ? 4 : 0) | (byArray5[16] == 49 ? 2 : 0) | (byArray5[17] == 49 ? 1 : 0);
        nArray[4] = (byArray5[19] == 49 ? 32 : 0) | (byArray5[24] == 49 ? 16 : 0) | (byArray5[20] == 49 ? 8 : 0) | (byArray5[21] == 49 ? 4 : 0) | (byArray5[22] == 49 ? 2 : 0) | (byArray5[23] == 49 ? 1 : 0);
        nArray[5] = (byArray5[25] == 49 ? 32 : 0) | (byArray5[30] == 49 ? 16 : 0) | (byArray5[26] == 49 ? 8 : 0) | (byArray5[27] == 49 ? 4 : 0) | (byArray5[28] == 49 ? 2 : 0) | (byArray5[29] == 49 ? 1 : 0);
        nArray[6] = (byArray5[31] == 49 ? 32 : 0) | (byArray5[36] == 49 ? 16 : 0) | (byArray5[32] == 49 ? 8 : 0) | (byArray5[33] == 49 ? 4 : 0) | (byArray5[34] == 49 ? 2 : 0) | (byArray5[35] == 49 ? 1 : 0);
        nArray[7] = (byArray5[37] == 49 ? 32 : 0) | (byArray5[42] == 49 ? 16 : 0) | (byArray5[38] == 49 ? 8 : 0) | (byArray5[39] == 49 ? 4 : 0) | (byArray5[40] == 49 ? 2 : 0) | (byArray5[41] == 49 ? 1 : 0);
        nArray[8] = (byArray5[43] == 49 ? 32 : 0) | (byArray5[48] == 49 ? 16 : 0) | (byArray5[44] == 49 ? 8 : 0) | (byArray5[45] == 49 ? 4 : 0) | (byArray5[46] == 49 ? 2 : 0) | (byArray5[47] == 49 ? 1 : 0);
        nArray2[1] = S1[nArray[1]];
        nArray2[2] = S2[nArray[2]];
        nArray2[3] = S3[nArray[3]];
        nArray2[4] = S4[nArray[4]];
        nArray2[5] = S5[nArray[5]];
        nArray2[6] = S6[nArray[6]];
        nArray2[7] = S7[nArray[7]];
        nArray2[8] = S8[nArray[8]];
        EncryptPassword.dectobin(nArray2[1], byArray6, 1);
        EncryptPassword.dectobin(nArray2[2], byArray6, 5);
        EncryptPassword.dectobin(nArray2[3], byArray6, 9);
        EncryptPassword.dectobin(nArray2[4], byArray6, 13);
        EncryptPassword.dectobin(nArray2[5], byArray6, 17);
        EncryptPassword.dectobin(nArray2[6], byArray6, 21);
        EncryptPassword.dectobin(nArray2[7], byArray6, 25);
        EncryptPassword.dectobin(nArray2[8], byArray6, 29);
        for (n = 1; n <= 32; ++n) {
            byArray7[n] = byArray6[PPERM[n - 1]];
        }
        byte[] byArray8 = new byte[33];
        System.arraycopy(byArray3, 1, byArray8, 1, 32);
        for (int i = 1; i <= 32; ++i) {
            byArray3[i] = byArray2[i] == byArray7[i] ? 48 : 49;
        }
        System.arraycopy(byArray8, 1, byArray2, 1, 32);
    }

    private static void dectobin(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 8) != 0 ? 49 : 48);
        byArray[n2 + 1] = (byte)((n & 4) != 0 ? 49 : 48);
        byArray[n2 + 2] = (byte)((n & 2) != 0 ? 49 : 48);
        byArray[n2 + 3] = (byte)((n & 1) != 0 ? 49 : 48);
    }

    private static void lshift1(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[29]};
        System.arraycopy(byArray, 2, byArray, 1, 27);
        System.arraycopy(byArray, 30, byArray, 29, 27);
        byArray[28] = byArray2[0];
        byArray[56] = byArray2[1];
    }

    private static void lshift2(byte[] byArray) {
        byte[] byArray2 = new byte[]{byArray[1], byArray[2], byArray[29], byArray[30]};
        System.arraycopy(byArray, 3, byArray, 1, 27);
        System.arraycopy(byArray, 31, byArray, 29, 27);
        byArray[27] = byArray2[0];
        byArray[28] = byArray2[1];
        byArray[55] = byArray2[2];
        byArray[56] = byArray2[3];
    }

    private static byte[] generatePasswordSubstitute(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        byte[] byArray7 = new byte[8];
        byte[] byArray8 = new byte[8];
        byte[] byArray9 = new byte[8];
        EncryptPassword.addArray(byArray4, byArray6, byArray7, 8);
        byArray9 = EncryptPassword.enc_des(byArray2, byArray7);
        EncryptPassword.xORArray(byArray9, byArray5, byArray8);
        byArray9 = EncryptPassword.enc_des(byArray2, byArray8);
        System.arraycopy(byArray9, 0, byArray3, 0, 8);
        EncryptPassword.xORArray(byArray, byArray7, byArray8);
        EncryptPassword.xORArray(byArray8, byArray9, byArray8);
        byArray9 = EncryptPassword.enc_des(byArray2, byArray8);
        for (int i = 0; i < 8; ++i) {
            byArray8[i] = 64;
        }
        byArray8[0] = byArray[8];
        byArray8[1] = byArray[9];
        EncryptPassword.xORArray(byArray7, byArray8, byArray8);
        EncryptPassword.xORArray(byArray8, byArray9, byArray8);
        byArray9 = EncryptPassword.enc_des(byArray2, byArray8);
        EncryptPassword.xORArray(byArray4, byArray9, byArray8);
        return EncryptPassword.enc_des(byArray2, byArray8);
    }
}

