/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import com.ibm.jtopenlite.Message;
import java.io.IOException;
import java.util.ArrayList;

public class DataStreamException
extends IOException {
    private static final long serialVersionUID = -3804731342532950986L;
    public static final String BAD_RETURN_CODE = "Bad return code";
    public static final String BAD_LENGTH = "Bad length";
    public static final String BAD_REPLY = "Bad reply";
    public static final String ERROR_MESSAGE = "Error message";
    private String type_;
    private String dataStreamName_;
    private int value_;
    private ArrayList<Message> messages_ = new ArrayList();

    protected DataStreamException(String string, String string2, int n) {
        super(string + " on " + string2 + ": " + (BAD_RETURN_CODE.equals(string) || BAD_REPLY.equals(string) ? "0x" + Integer.toHexString(n) : "" + n));
        this.type_ = string;
        this.dataStreamName_ = string2;
        this.value_ = n;
    }

    private DataStreamException(String string, Message message) {
        super("Error message on " + string + ": " + message);
        this.type_ = ERROR_MESSAGE;
        this.dataStreamName_ = string;
        this.value_ = message.getSeverity();
        this.messages_.add(message);
    }

    public String getType() {
        return this.type_;
    }

    public String getDataStreamName() {
        return this.dataStreamName_;
    }

    public int getValue() {
        return this.value_;
    }

    public Message getErrorMessage() {
        return this.messages_.size() == 0 ? null : this.messages_.get(0);
    }

    public void addMessage(Message message) {
        this.messages_.add(message);
    }

    public Message[] getErrorMessages() {
        Message[] messageArray = new Message[this.messages_.size()];
        this.messages_.toArray(messageArray);
        return messageArray;
    }

    public static DataStreamException badReturnCode(String string, int n) {
        return new DataStreamException(BAD_RETURN_CODE, string, n);
    }

    public static DataStreamException badLength(String string, int n) {
        return new DataStreamException(BAD_LENGTH, string, n);
    }

    public static DataStreamException badReply(String string, int n) {
        return new DataStreamException(BAD_REPLY, string, n);
    }

    public static DataStreamException errorMessage(String string, Message message) {
        return new DataStreamException(string, message);
    }
}

