/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.module;

import com.eg.agent.module.IJavaModuleBootUtil;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdk.internal.module.Modules;

public class JavaModuleUtil
implements IJavaModuleBootUtil {
    private final Module thisModule;
    private final Module baseModule;
    private Instrumentation instrumentation;

    public JavaModuleUtil(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.thisModule = JavaModuleUtil.class.getModule();
        this.baseModule = Object.class.getModule();
    }

    @Override
    public Object getThisModule() {
        return this.thisModule;
    }

    @Override
    public Object getBaseModule() {
        return this.baseModule;
    }

    @Override
    public boolean startup() {
        HashMap<String, Set<Module>> extraExports = new HashMap<String, Set<Module>>();
        HashMap<String, Set<Module>> extraOpens = new HashMap<String, Set<Module>>();
        HashMap extraProvides = new HashMap();
        HashSet<Module> extraReads = new HashSet<Module>();
        HashSet extraUses = new HashSet();
        HashSet<Module> moduleSet = new HashSet<Module>();
        moduleSet.add(this.thisModule);
        extraExports.put("jdk.internal.misc", moduleSet);
        extraExports.put("jdk.internal.module", moduleSet);
        extraOpens.put("java.lang.reflect", moduleSet);
        Module baseModule = (Module)this.getBaseModule();
        this.instrumentation.redefineModule(baseModule, extraReads, extraExports, extraOpens, extraUses, extraProvides);
        return true;
    }

    @Override
    public Object getModuleForClass(Class<?> clazz) {
        return clazz.getModule();
    }

    @Override
    public boolean addExportsAndOpens(Object module, Map<String, Set<Object>> exports, Map<String, Set<Object>> opens) {
        Module currentModule = (Module)module;
        Map<String, Set<Module>> exportMap = exports;
        Map<String, Set<Module>> openMap = opens;
        HashSet<Module> extraReads = new HashSet<Module>();
        HashSet extraUses = new HashSet();
        HashMap extraProvides = new HashMap();
        this.instrumentation.redefineModule(currentModule, extraReads, exportMap, openMap, extraUses, extraProvides);
        return true;
    }

    @Override
    public ClassLoader getPlatformClassLoader() {
        return ClassLoader.getPlatformClassLoader();
    }

    @Override
    public String getModuleName(Object module) {
        return ((Module)module).getName();
    }

    @Override
    public boolean addReads(Object fromModule, Object toModule) {
        HashSet<Module> toSet = new HashSet<Module>();
        toSet.add((Module)toModule);
        HashMap<String, Set<Module>> extraExports = new HashMap<String, Set<Module>>();
        HashMap<String, Set<Module>> extraOpens = new HashMap<String, Set<Module>>();
        HashSet extraUses = new HashSet();
        HashMap extraProvides = new HashMap();
        this.instrumentation.redefineModule((Module)fromModule, toSet, extraExports, extraOpens, extraUses, extraProvides);
        return true;
    }

    @Override
    public Object locateModuleByName(String moduleName) {
        Module module = Modules.loadModule(moduleName);
        return module;
    }
}

