/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.solcache;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.CacheLiveDataAction;
import com.solacesystems.jcsmp.CacheRequestListener;
import com.solacesystems.jcsmp.CacheRequestResult;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.flow.LiveMessageController;
import com.solacesystems.jcsmp.impl.flow.LiveTopicListener;
import com.solacesystems.jcsmp.impl.solcache.CacheClusterRequest;
import com.solacesystems.jcsmp.impl.solcache.CacheClusterRequestListener;
import com.solacesystems.jcsmp.impl.solcache.CacheCompleteNotification;
import com.solacesystems.jcsmp.impl.solcache.CacheEventMessageImpl;
import com.solacesystems.jcsmp.impl.solcache.CacheGetResult;
import com.solacesystems.jcsmp.impl.solcache.CacheRequestProperties;
import com.solacesystems.jcsmp.impl.solcache.CacheSessionImpl;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.smf.SMFWireMessageHandler;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import com.solacesystems.jcsmp.statistics.StatType;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheRequest
implements CacheClusterRequestListener,
LiveTopicListener {
    private static final Log Trace = LogFactory.getLog(CacheRequest.class);
    private static final ThreadLocal<SMFWireMessageHandler> SMFHandler = new ThreadLocal<SMFWireMessageHandler>(){

        @Override
        protected SMFWireMessageHandler initialValue() {
            return new SMFWireMessageHandler();
        }
    };
    private static long ID = 0L;
    public static int MinimumQueueThreshold = 10000;
    public static final String CACHE_WARNING_PREAMBLE = "Cache Queue Threshold Reached";
    private CacheRequestProperties mProps;
    private ArrayList<JCSMPXMLMessage> mQueuedMsgs;
    private HashSet<Long> mOutstandingClusters;
    private boolean mResultFinal;
    private boolean mIsSuccessful;
    private boolean mNoData;
    private boolean mIsSuspect;
    private boolean mIsLive;
    private JCSMPException mException;
    private int mThreshold;
    private Object mLock;
    private long mId;
    private Object mOutstandingRequestsLock;

    private static SMFWireMessageHandler getSMFHandler() {
        return SMFHandler.get();
    }

    private static synchronized long getNextId() {
        return ID++;
    }

    public CacheRequest(CacheRequestProperties props) {
        this.mProps = props;
        this.mQueuedMsgs = null;
        this.mOutstandingClusters = new HashSet();
        this.mResultFinal = false;
        this.mIsSuccessful = true;
        this.mNoData = true;
        this.mIsSuspect = false;
        this.mIsLive = false;
        this.mException = null;
        this.mThreshold = MinimumQueueThreshold;
        this.mLock = new Object();
        this.mId = CacheRequest.getNextId();
        this.mOutstandingRequestsLock = ((CacheSessionImpl)this.mProps.getSession()).getOutstandingRequestsLock();
    }

    public long getId() {
        return this.mId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.mOutstandingRequestsLock;
        synchronized (object) {
            HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (hashMap) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    if (!this.mResultFinal) {
                        this.setError(new JCSMPInterruptedException("Cache request cancelled"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheClusterRequest prepareSend() throws JCSMPException {
        CacheClusterRequest request;
        Object object = this.mOutstandingRequestsLock;
        synchronized (object) {
            HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (hashMap) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    Topic topic = this.mProps.getSession().getProperties().getCacheTopic();
                    request = new CacheClusterRequest(this.mProps, topic, true, this);
                    this.mOutstandingClusters.add(request.getId());
                    this.mProps.getLiveMessageController().addLiveTopicAction(this.mProps.getLiveDataAction(), this.mProps.getTopic(), this);
                }
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupRequest() {
        Object object = this.mOutstandingRequestsLock;
        synchronized (object) {
            HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (hashMap) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.cleanup();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(CacheClusterRequest request) throws JCSMPException {
        try {
            request.send();
            this.mProps.getSession().getJCSMPSession().getSessionStats().incStat(StatType.CACHE_REQUESTS_SENT);
        }
        catch (JCSMPException e) {
            Object object = this.mOutstandingRequestsLock;
            synchronized (object) {
                HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
                synchronized (hashMap) {
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        this.cleanup();
                    }
                }
            }
            throw e;
        }
    }

    public CacheRequestResult waitForResponse() throws JCSMPException {
        try {
            Object obj = this.mProps.getQueue().take();
            if (obj instanceof JCSMPException) {
                throw (JCSMPException)((Object)obj);
            }
            return (CacheRequestResult)((Object)obj);
        }
        catch (InterruptedException e) {
            throw new JCSMPInterruptedException("Interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetResult(Topic cluster, CacheGetResult result) {
        HashMap<String, LiveTopicListener> hashMap;
        Object object;
        boolean clusterRequestsSent = false;
        boolean cacheMessagesInjected = false;
        boolean resultFinal = true;
        Object object2 = this.mOutstandingRequestsLock;
        synchronized (object2) {
            object = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (object) {
                hashMap = this.mLock;
                synchronized (hashMap) {
                    resultFinal = this.mResultFinal;
                    if (!this.mResultFinal) {
                        if (result.getStatus().equals((Object)CacheGetResult.GetRequestStatus.Completed)) {
                            if (result.getResponse().getMessages() != null && result.getResponse().getMessages().hasRemaining()) {
                                this.mNoData = false;
                            }
                            if (result.getResponse().isSuspect().booleanValue()) {
                                this.mIsSuspect = true;
                            }
                        } else {
                            this.setError(result.getException());
                        }
                    } else if (this.mIsLive && result.getStatus().equals((Object)CacheGetResult.GetRequestStatus.Completed)) {
                        this.mProps.getSession().getJCSMPSession().getSessionStats().incStat(StatType.CACHE_FULFILL_REPLIES_DISCARDED);
                    } else if (result.getStatus().equals((Object)CacheGetResult.GetRequestStatus.Completed)) {
                        this.mProps.getSession().getJCSMPSession().getSessionStats().incStat(StatType.REPLIES_DISCARDED);
                    }
                }
            }
        }
        if (!resultFinal && result.getStatus().equals((Object)CacheGetResult.GetRequestStatus.Completed)) {
            Object object3;
            try {
                this.sendClusterRequests(result);
                clusterRequestsSent = true;
            }
            catch (JCSMPException e) {
                object = this.mOutstandingRequestsLock;
                synchronized (object) {
                    hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
                    synchronized (hashMap) {
                        object3 = this.mLock;
                        synchronized (object3) {
                            this.setError(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                object = this.mOutstandingRequestsLock;
                synchronized (object) {
                    hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
                    synchronized (hashMap) {
                        object3 = this.mLock;
                        synchronized (object3) {
                            this.setError(new JCSMPException("Error sending cache requests", e));
                        }
                    }
                }
            }
            try {
                this.injectCacheMessages(result);
                cacheMessagesInjected = true;
            }
            catch (JCSMPException e) {
                object = this.mOutstandingRequestsLock;
                synchronized (object) {
                    hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
                    synchronized (hashMap) {
                        object3 = this.mLock;
                        synchronized (object3) {
                            this.setError(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                object = this.mOutstandingRequestsLock;
                synchronized (object) {
                    hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
                    synchronized (hashMap) {
                        object3 = this.mLock;
                        synchronized (object3) {
                            this.setError(new JCSMPException("Error injecting cache messages", e));
                        }
                    }
                }
            }
        }
        return clusterRequestsSent && cacheMessagesInjected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClusterResult(Topic cluster, long id) {
        this.mOutstandingClusters.remove(id);
        Object object = this.mOutstandingRequestsLock;
        synchronized (object) {
            HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (hashMap) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    if (!this.mResultFinal) {
                        this.mResultFinal = this.mOutstandingClusters.isEmpty();
                        if (this.mResultFinal) {
                            this.cleanup();
                            this.injectQueuedMessages();
                            this.notifyApp();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLiveException(LiveMessageController controller, JCSMPException e) {
        Object object = this.mOutstandingRequestsLock;
        synchronized (object) {
            HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (hashMap) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    if (!this.mResultFinal) {
                        this.setError(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onLiveTopic(LiveMessageController controller, JCSMPXMLMessage message) {
        Object object = this.mOutstandingRequestsLock;
        synchronized (object) {
            HashMap<String, LiveTopicListener> hashMap = this.mProps.getLiveMessageController().getLiveTopicMap();
            synchronized (hashMap) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    HashMap<String, LiveTopicListener> liveTopicMap = this.mProps.getLiveMessageController().getLiveTopicMap();
                    if (liveTopicMap.get(message.getDestination().getName()) != this) {
                        return false;
                    }
                    if (this.mProps.getLiveDataAction().equals((Object)CacheLiveDataAction.FULFILL)) {
                        if (!this.mResultFinal) {
                            this.mIsLive = true;
                            this.mProps.getSession().getJCSMPSession().getSessionStats().incStat(StatType.CACHE_REQUESTS_FULFILLED);
                            this.mResultFinal = true;
                            this.cleanup();
                            this.notifyApp();
                        }
                        controller.injectMessage(message);
                    } else if (this.mProps.getLiveDataAction().equals((Object)CacheLiveDataAction.QUEUE)) {
                        if (this.mQueuedMsgs == null) {
                            this.mQueuedMsgs = new ArrayList();
                        }
                        this.mQueuedMsgs.add(message);
                        if (this.mQueuedMsgs.size() == this.mThreshold) {
                            if (Trace.isWarnEnabled()) {
                                Trace.warn((Object)("Cache Queue Threshold Reached(" + this.mThreshold + ")"));
                            }
                            this.mThreshold = this.mThreshold < 0x3FFFFFFF ? (this.mThreshold *= 2) : Integer.MAX_VALUE;
                        }
                    }
                }
            }
        }
        return true;
    }

    private void injectQueuedMessages() {
        LiveMessageController ctrller = this.mProps.getLiveMessageController();
        if (this.mQueuedMsgs != null) {
            for (int j = 0; j < this.mQueuedMsgs.size(); ++j) {
                ctrller.injectMessage(this.mQueuedMsgs.get(j));
            }
        }
    }

    private void injectCacheMessages(CacheGetResult result) throws Exception {
        LiveMessageController ctrller = this.mProps.getLiveMessageController();
        SDTStream messages = result.getResponse().getMessages();
        if (messages != null) {
            while (messages.hasRemaining()) {
                ByteArray ba = messages.readMessage().getData();
                ByteArrayInputStream bais = new ByteArrayInputStream(ba.getBuffer(), ba.getOffset(), ba.getLength());
                WireMessage wm = WireMessageFactory.create();
                CacheRequest.getSMFHandler().readMessage(bais, wm);
                JCSMPXMLMessage cacheMsg = TcpClientChannel.parse(null, wm, TcpClientChannel.ChannelMode.CLIENT);
                cacheMsg.setReadOnly();
                cacheMsg.setCacheMessage();
                cacheMsg.setCacheRequestId(this.mProps.getRequestId());
                if (result.getResponse().isSuspect().booleanValue()) {
                    cacheMsg.setSuspect();
                }
                this.mProps.getSession().getJCSMPSession().getSessionStats().incStat(StatType.CACHED_MSGS_RECVED);
                ctrller.injectMessage(cacheMsg);
            }
        }
    }

    private void sendClusterRequests(CacheGetResult result) throws Exception {
        SDTStream clusters = result.getResponse().getClusterNames();
        if (clusters != null) {
            while (clusters.hasRemaining()) {
                String clusterName = clusters.readString();
                Topic topic = JCSMPFactory.onlyInstance().createTopic("#P2P/CACHEINST/" + clusterName);
                CacheClusterRequest request = new CacheClusterRequest(this.mProps, topic, false, this);
                this.mOutstandingClusters.add(request.getId());
                try {
                    request.send();
                }
                catch (JCSMPException e) {
                    this.mOutstandingClusters.remove(request.getId());
                    throw e;
                }
            }
        }
    }

    private void notifyApp() {
        LiveMessageController ctrller = this.mProps.getLiveMessageController();
        CacheEventMessageImpl evtMsg = null;
        if (this.mProps.isBlocking()) {
            Object retObj = null;
            if (this.mIsSuccessful) {
                CacheRequestResult result = this.getResult();
                retObj = result;
                evtMsg = new CacheEventMessageImpl(this.mProps.getRequestId(), this.mProps.getTopic(), result);
            } else {
                retObj = this.mException;
                evtMsg = new CacheEventMessageImpl(this.mProps.getRequestId(), this.mProps.getTopic(), this.mException);
            }
            try {
                this.mProps.getQueue().put(retObj);
            }
            catch (InterruptedException e) {
                if (Trace.isErrorEnabled()) {
                    Trace.error((Object)e);
                }
            }
        } else {
            CacheRequestListener listener = this.mProps.getListener();
            if (this.mIsSuccessful) {
                CacheRequestResult result = this.getResult();
                ctrller.injectNotification(new CacheCompleteNotification(listener, this.mProps.getRequestId(), this.mProps.getTopic(), result));
                evtMsg = new CacheEventMessageImpl(this.mProps.getRequestId(), this.mProps.getTopic(), result);
            } else {
                ctrller.injectNotification(new CacheCompleteNotification(listener, this.mProps.getRequestId(), this.mProps.getTopic(), this.mException));
                evtMsg = new CacheEventMessageImpl(this.mProps.getRequestId(), this.mProps.getTopic(), this.mException);
            }
        }
        if (this.mProps.getSession().getProperties().deliverEvtsThruBlockingRecv()) {
            ctrller.injectCacheEvent(evtMsg);
        }
    }

    private void setError(JCSMPException e) {
        this.mIsSuccessful = Boolean.FALSE;
        this.mException = e;
        this.mResultFinal = true;
        this.cleanup();
        this.injectQueuedMessages();
        this.notifyApp();
    }

    private void cleanup() {
        this.mProps.getLiveMessageController().removeLiveTopicAction(this.mProps.getLiveDataAction(), this.mProps.getTopic());
        ((CacheSessionImpl)this.mProps.getSession()).removeCacheRequest(this);
    }

    private CacheRequestResult getResult() {
        if (this.mIsSuspect) {
            return CacheRequestResult.SUSPECT_DATA;
        }
        if (this.mIsLive) {
            return CacheRequestResult.OK;
        }
        if (this.mNoData) {
            return CacheRequestResult.NO_DATA;
        }
        return CacheRequestResult.OK;
    }
}

