/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.About;
import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.MessageException;
import com.ibm.jtopenlite.SystemInfo;
import com.ibm.jtopenlite.database.DatabaseChangeDescriptorAttributes;
import com.ibm.jtopenlite.database.DatabaseConnection;
import com.ibm.jtopenlite.database.DatabaseDescribeCallback;
import com.ibm.jtopenlite.database.DatabaseRequestAttributes;
import com.ibm.jtopenlite.database.DatabaseServerAttributes;
import com.ibm.jtopenlite.database.DatabaseWarningCallback;
import com.ibm.jtopenlite.database.jdbc.JDBCCallableStatement;
import com.ibm.jtopenlite.database.jdbc.JDBCDatabaseMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.JDBCParameterMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCPreparedStatement;
import com.ibm.jtopenlite.database.jdbc.JDBCStatement;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class JDBCConnection
implements Connection,
DatabaseWarningCallback {
    private DatabaseConnection conn_;
    private int statementCounter_ = 0;
    private int cursorCounter_ = 0;
    private int descriptorCounter_ = 0;
    private final char[] statementName_ = new char[]{'S', 'T', 'M', 'T', '0', '0', '0', '0', '0', '0', '0', '0'};
    private final char[] cursorName_ = new char[]{'C', 'R', 'S', 'R', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int lastWarningClass_;
    private int lastWarningReturnCode_;
    private String lastWarningMessageID_;
    private String lastWarningMessageText_;
    private String lastWarningSecondLevelText_;
    private String catalog_ = null;
    private int serverVersion_;
    private String serverJobIdentifier_;
    private boolean autoCommit_ = true;
    private int transactionIsolation_ = 0;
    private final boolean[] usedRPBs_ = new boolean[32768];
    private final Calendar calendar_ = Calendar.getInstance();
    private String userName_;
    private Vector freeStatements_ = new Vector();
    private Vector freeCursors_ = new Vector();

    private JDBCConnection(DatabaseConnection databaseConnection) {
        this.conn_ = databaseConnection;
    }

    Calendar getCalendar() {
        return this.calendar_;
    }

    synchronized String getNextStatementName() {
        int n = this.freeStatements_.size();
        if (n > 0) {
            return (String)this.freeStatements_.remove(n - 1);
        }
        int n2 = this.statementCounter_ = this.statementCounter_ == Integer.MAX_VALUE ? 1 : this.statementCounter_ + 1;
        for (int i = 11; i >= 4; --i) {
            this.statementName_[i] = CHARS[n2 & 0xF];
            n2 >>= 4;
        }
        return new String(this.statementName_);
    }

    synchronized void freeStatementAndCursorNames(String string, String string2) throws SQLException {
        if (string != null) {
            this.freeStatements_.addElement(string);
        }
        if (string2 != null) {
            this.freeCursors_.addElement(string2);
        }
    }

    synchronized String getNextCursorName() {
        int n = this.freeCursors_.size();
        if (n > 0) {
            return (String)this.freeCursors_.remove(n - 1);
        }
        int n2 = this.cursorCounter_ = this.cursorCounter_ == Integer.MAX_VALUE ? 1 : this.cursorCounter_ + 1;
        for (int i = 11; i >= 4; --i) {
            this.cursorName_[i] = CHARS[n2 & 0xF];
            n2 >>= 4;
        }
        return new String(this.cursorName_);
    }

    int getNextDescriptorHandle() {
        this.descriptorCounter_ = this.descriptorCounter_ == Short.MAX_VALUE ? 1 : this.descriptorCounter_ + 1;
        return this.descriptorCounter_;
    }

    synchronized int getNextRPBID() {
        for (int i = 1; i < this.usedRPBs_.length; ++i) {
            if (this.usedRPBs_[i]) continue;
            this.usedRPBs_[i] = true;
            return i;
        }
        return -1;
    }

    synchronized void freeRPBID(int n) {
        this.usedRPBs_[n] = false;
    }

    public void newWarning(int n, int n2) {
        this.lastWarningClass_ = n;
        this.lastWarningReturnCode_ = n2;
    }

    public void noWarnings() {
        this.lastWarningClass_ = 0;
        this.lastWarningReturnCode_ = 0;
        this.lastWarningMessageID_ = null;
        this.lastWarningMessageText_ = null;
        this.lastWarningSecondLevelText_ = null;
    }

    public void newMessageID(String string) {
        this.lastWarningMessageID_ = string;
    }

    public void newMessageText(String string) {
        this.lastWarningMessageText_ = string;
    }

    public void newSecondLevelText(String string) {
        this.lastWarningSecondLevelText_ = string;
    }

    int getLastWarningClass() {
        return this.lastWarningClass_;
    }

    int getLastWarningReturnCode() {
        return this.lastWarningReturnCode_;
    }

    Message getLastWarningMessage() {
        if (this.lastWarningMessageID_ != null) {
            return new Message(this.lastWarningMessageID_, this.lastWarningMessageText_);
        }
        return null;
    }

    public static JDBCConnection getConnection(String string, String string2, String string3, boolean bl) throws SQLException {
        return JDBCConnection.getConnection(false, string, string2, string3, bl);
    }

    public static JDBCConnection getConnection(boolean bl, String string, String string2, String string3, boolean bl2) throws SQLException {
        try {
            DatabaseConnection databaseConnection = DatabaseConnection.getConnection(bl, string, string2, string3);
            databaseConnection.setMessageInfoReturned(true);
            databaseConnection.setDebug(bl2);
            DatabaseServerAttributes databaseServerAttributes = new DatabaseServerAttributes();
            databaseServerAttributes.setNamingConventionParserOption(0);
            databaseServerAttributes.setUseExtendedFormats(242);
            databaseServerAttributes.setDefaultClientCCSID(13488);
            databaseServerAttributes.setDateFormatParserOption(5);
            databaseServerAttributes.setLOBFieldThreshold(0x100000);
            databaseServerAttributes.setClientSupportInformation(0x40000000);
            databaseServerAttributes.setInterfaceType("JDBC");
            databaseServerAttributes.setInterfaceName(About.INTERFACE_NAME);
            databaseServerAttributes.setInterfaceLevel(About.INTERFACE_LEVEL);
            databaseConnection.setServerAttributes(databaseServerAttributes);
            JDBCConnection jDBCConnection = new JDBCConnection(databaseConnection);
            databaseConnection.setWarningCallback(jDBCConnection);
            jDBCConnection.serverJobIdentifier_ = databaseServerAttributes.getServerJobName() + databaseServerAttributes.getServerJobUser() + databaseServerAttributes.getServerJobNumber();
            return jDBCConnection;
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    DatabaseConnection getDatabaseConnection() {
        return this.conn_;
    }

    static SQLException convertException(IOException iOException) {
        return JDBCConnection.convertException(iOException, -99999, "");
    }

    static SQLException convertException(IOException iOException, int n, String string) {
        SQLException sQLException = null;
        if (iOException instanceof MessageException) {
            MessageException messageException = (MessageException)iOException;
            Message[] messageArray = messageException.getMessages();
            String string2 = messageArray[0].toString();
            sQLException = new SQLException(string2, string, n);
            sQLException.initCause(iOException);
        } else {
            String string3 = iOException.toString();
            sQLException = new SQLException(string3, string, n);
            sQLException.initCause(iOException);
        }
        return sQLException;
    }

    public void clearWarnings() throws SQLException {
        this.noWarnings();
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.conn_.close();
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw JDBCError.getSQLException("08003");
        }
    }

    public void commit() throws SQLException {
        try {
            this.conn_.commit();
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    public Statement createStatement() throws SQLException {
        String string = this.getNextStatementName();
        int n = this.getNextRPBID();
        String string2 = this.getNextCursorName();
        return new JDBCStatement(this, string, string2, n);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (n == 1003 && n2 == 1007) {
            return this.createStatement();
        }
        throw new NotImplementedException();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1003 && n2 == 1007 && n3 == 1) {
            return this.createStatement();
        }
        throw new NotImplementedException();
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit_;
    }

    public String getCatalog() throws SQLException {
        if (this.catalog_ == null) {
            JDBCStatement jDBCStatement = (JDBCStatement)this.createStatement();
            jDBCStatement.setCatalog("LOCAL");
            ResultSet resultSet = jDBCStatement.executeQuery("select CATALOG_NAME from qsys2.syscatalogs where RDBTYPE='LOCAL'");
            resultSet.next();
            this.catalog_ = resultSet.getString(1);
            resultSet.close();
            jDBCStatement.close();
        }
        return this.catalog_;
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new JDBCDatabaseMetaData(this);
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.transactionIsolation_ == 0) {
            return 1;
        }
        return this.transactionIsolation_;
    }

    public Map getTypeMap() throws SQLException {
        throw new NotImplementedException();
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean isClosed() throws SQLException {
        return this.conn_.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        throw new NotImplementedException();
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        String string2 = this.getNextStatementName();
        int n = this.getNextRPBID();
        String string3 = this.getNextCursorName();
        JDBCCallableStatement jDBCCallableStatement = new JDBCCallableStatement(this, string, this.calendar_, string2, string3, n);
        jDBCCallableStatement.setCursorNameInternal(string3);
        return jDBCCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (n == 1003 && n2 == 1007) {
            return this.prepareCall(string);
        }
        throw new NotImplementedException();
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (n == 1003 && n2 == 1007) {
            return this.prepareCall(string);
        }
        throw new NotImplementedException();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 2);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        String string2 = this.getNextStatementName();
        int n2 = this.getNextRPBID();
        String string3 = this.getNextCursorName();
        JDBCPreparedStatement jDBCPreparedStatement = new JDBCPreparedStatement(this, string, this.calendar_, string2, string3, n2);
        jDBCPreparedStatement.setCursorNameInternal(string3);
        switch (n) {
            case 2: {
                jDBCPreparedStatement.setReturnGeneratedKeys(false);
                break;
            }
            case 1: {
                jDBCPreparedStatement.setReturnGeneratedKeys(true);
                break;
            }
            default: {
                throw new SQLException("Bad value for autoGeneratedKeys parameter");
            }
        }
        return jDBCPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new NotImplementedException();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (n == 1003 && n2 == 1007) {
            return this.prepareStatement(string);
        }
        throw new NotImplementedException();
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n == 1003 && n2 == 1007 && n3 == 1) {
            return this.prepareStatement(string);
        }
        throw new NotImplementedException();
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new NotImplementedException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new NotImplementedException();
    }

    public void rollback() throws SQLException {
        try {
            this.conn_.rollback();
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new NotImplementedException();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        if (bl) {
            if (!this.autoCommit_) {
                this.commit();
                this.transactionIsolation_ = 0;
                this.updateServerTransactionAttributes();
                this.autoCommit_ = true;
            }
        } else if (this.autoCommit_) {
            if (this.transactionIsolation_ == 0) {
                this.transactionIsolation_ = 1;
            }
            this.updateServerTransactionAttributes();
            this.autoCommit_ = false;
        }
    }

    private void updateServerTransactionAttributes() throws SQLException {
        try {
            DatabaseServerAttributes databaseServerAttributes = new DatabaseServerAttributes();
            int n = this.getLipiTransactionOption();
            databaseServerAttributes.setCommitmentControlLevelParserOption(n);
            if (n == 0) {
                databaseServerAttributes.setTrueAutoCommitIndicator(213);
            } else if (this.autoCommit_) {
                databaseServerAttributes.setTrueAutoCommitIndicator(232);
            } else {
                databaseServerAttributes.setTrueAutoCommitIndicator(213);
            }
            this.conn_.setServerAttributes(databaseServerAttributes);
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    private int getLipiTransactionOption() throws SQLException {
        switch (this.transactionIsolation_) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 3;
            }
        }
        throw JDBCError.getSQLException("HY024");
    }

    public void setCatalog(String string) throws SQLException {
        throw new NotImplementedException();
    }

    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        if (n != 1) {
            throw new NotImplementedException();
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        if (bl) {
            throw new NotImplementedException();
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new NotImplementedException();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new NotImplementedException();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.transactionIsolation_ = n;
                this.updateServerTransactionAttributes();
                return;
            }
        }
        throw JDBCError.getSQLException("HY024");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new NotImplementedException();
    }

    protected int getServerVersion() throws SQLException {
        this.checkOpen();
        if (this.serverVersion_ == 0) {
            this.serverVersion_ = this.conn_.getInfo().getServerVersion();
        }
        return this.serverVersion_;
    }

    public String getUserName() throws SQLException {
        this.checkOpen();
        if (this.userName_ == null) {
            this.userName_ = this.conn_.getUser();
        }
        return this.userName_;
    }

    public String getURL() throws SQLException {
        this.checkOpen();
        return "jdbc:jtopenlite://" + this.conn_.getInfo().getSystem();
    }

    public String getServerJobIdentifier() {
        return this.serverJobIdentifier_;
    }

    void createRequestParameterBlock(DatabaseRequestAttributes databaseRequestAttributes, int n) throws SQLException {
        try {
            this.conn_.createRequestParameterBlock(databaseRequestAttributes, n);
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    void prepareAndDescribe(DatabaseRequestAttributes databaseRequestAttributes, DatabaseDescribeCallback databaseDescribeCallback, JDBCParameterMetaData jDBCParameterMetaData) throws SQLException {
        try {
            this.conn_.prepareAndDescribe(databaseRequestAttributes, databaseDescribeCallback, jDBCParameterMetaData);
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    void changeDescriptor(DatabaseChangeDescriptorAttributes databaseChangeDescriptorAttributes, int n) throws SQLException {
        try {
            this.conn_.changeDescriptor(databaseChangeDescriptorAttributes, n);
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException);
        }
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new NotImplementedException();
    }

    public Blob createBlob() throws SQLException {
        throw new NotImplementedException();
    }

    public Clob createClob() throws SQLException {
        throw new NotImplementedException();
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new NotImplementedException();
    }

    public Properties getClientInfo() throws SQLException {
        throw new NotImplementedException();
    }

    public String getClientInfo(String string) throws SQLException {
        throw new NotImplementedException();
    }

    public boolean isValid(int n) throws SQLException {
        throw new NotImplementedException();
    }

    SystemInfo getDatabaseInfo() {
        return this.conn_.getInfo();
    }
}

