/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.Conv;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class JDBCClob
implements Clob {
    private final byte[] data_;
    private final int offset_;
    private int length_;
    private final int ccsid_;

    public JDBCClob(byte[] byArray, int n, int n2, int n3) {
        this.data_ = byArray;
        this.offset_ = n;
        this.length_ = n2;
        this.ccsid_ = n3;
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(Conv.ebcdicByteArrayToString(this.data_, this.offset_, this.length_, this.ccsid_).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            return new StringReader(Conv.ebcdicByteArrayToString(this.data_, this.offset_, this.length_, this.ccsid_));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public String getSubString(long l, int n) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n2 = (int)(l & Integer.MAX_VALUE);
        int n3 = this.length_ - n2 + 1;
        if (n3 > n) {
            n3 = n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.data_, this.offset_ + n2 - 1, byArray, 0, n3);
        try {
            return Conv.ebcdicByteArrayToString(this.data_, this.offset_ + n2 - 1, n3, this.ccsid_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public long length() throws SQLException {
        return this.length_;
    }

    public long position(Clob clob, long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad start: " + l);
        }
        String string = clob.getSubString(0L, (int)(clob.length() & Integer.MAX_VALUE));
        return this.position(string, l);
    }

    public long position(String string, long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad start: " + l);
        }
        try {
            byte[] byArray = Conv.stringToEBCDICByteArray(string, this.ccsid_);
            for (int i = (int)(l & Integer.MAX_VALUE) + this.offset_ - 1; i < this.offset_ + this.length_; ++i) {
                boolean bl = true;
                for (int j = 0; bl && j < byArray.length; ++j) {
                    if (this.data_[i] == byArray[j]) continue;
                    bl = false;
                }
                if (!bl) continue;
                return i - this.offset_;
            }
            return -1L;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n = (int)(l & Integer.MAX_VALUE);
        return new JDBCClobOutputStream(this, n - 1);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n = (int)(l & Integer.MAX_VALUE);
        return new JDBCClobWriter(this, n - 1);
    }

    public int setString(long l, String string) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n3 = (int)(l & Integer.MAX_VALUE);
        int n4 = this.length_ - n3 + 1;
        if (n4 > n2) {
            n4 = n2;
        }
        try {
            byte[] byArray = Conv.stringToEBCDICByteArray(string, this.ccsid_);
            System.arraycopy(byArray, n, this.data_, this.offset_ + n3 - 1, n4);
            return n4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public void truncate(long l) throws SQLException {
        this.length_ = l < 0L ? 0 : (int)(l & Integer.MAX_VALUE);
    }

    private static final class JDBCClobWriter
    extends Writer {
        private final JDBCClob clob_;
        private int next_;

        JDBCClobWriter(JDBCClob jDBCClob, int n) {
            this.clob_ = jDBCClob;
            this.next_ = n + this.clob_.offset_;
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = n; i < n + n2; ++i) {
                if (this.next_ >= this.clob_.offset_ + this.clob_.length_) continue;
                ((JDBCClob)this.clob_).data_[this.next_++] = (byte)cArray[i];
            }
        }
    }

    private static final class JDBCClobOutputStream
    extends OutputStream {
        private final JDBCClob clob_;
        private int next_;

        JDBCClobOutputStream(JDBCClob jDBCClob, int n) {
            this.clob_ = jDBCClob;
            this.next_ = n + this.clob_.offset_;
        }

        public void write(int n) throws IOException {
            if (this.next_ < this.clob_.offset_ + this.clob_.length_) {
                ((JDBCClob)this.clob_).data_[this.next_++] = (byte)n;
            }
        }
    }
}

